/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import dagr.DataAnonymizer;
import dagr.DataAnonymizer$ChooseRandomly$;
import dagr.DataAnonymizer$GeneratePersonCode$;
import dagr.DataAnonymizer$Mask$;
import dagr.DataAnonymizer$Noise$;
import dagr.DataAnonymizer$Round$;
import dagr.DataAnonymizer$Rules$;
import dagr.DataAnonymizer$Shuffle$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.mojoz.metadata.in.YamlMd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public class YamlAnonymizerRulesLoader {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(YamlAnonymizerRulesLoader.class.getDeclaredField("nameToRules$lzy1"));
    private final Seq<YamlMd> yamlMd;
    private final Regex anonymizerPattern;
    private final Logger logger;
    private volatile Object nameToRules$lzy1;

    public YamlAnonymizerRulesLoader(Seq<YamlMd> yamlMd) {
        this.yamlMd = yamlMd;
        this.anonymizerPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(^|\\n)\\s*\\{?\\s*['\\\"]?anonymizer['\\\"]?\\s*:"));
        this.logger = LoggerFactory.getLogger("dagr.anonymizer");
    }

    public Seq<YamlMd> yamlMd() {
        return this.yamlMd;
    }

    private boolean isAnonymizer(YamlMd d) {
        return this.anonymizerPattern.findFirstIn(d.body()).isDefined();
    }

    public String get(Map<String, ?> m, String name) {
        Seq<String> seq = this.getStringSeq(m, name);
        if (seq == null) {
            return null;
        }
        if (((Object)Nil$.MODULE$).equals(seq)) {
            return "";
        }
        Seq<String> x = seq;
        return x.mkString("");
    }

    public Seq<String> getStringSeq(Map<String, ?> m, String name) {
        return (Seq)Option$.MODULE$.apply(this.getSeq(m, name)).map((Function1<Seq, Seq> & Serializable)_$9 -> (Seq)_$9.map((Function1<Object, String> & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof String) {
                String s2 = (String)object;
                return s2;
            }
            if (object instanceof Map) {
                Map m = (Map)object;
                if (m.size() == 1) {
                    return ((Map.Entry)CollectionConverters$.MODULE$.SetHasAsScala(m.entrySet()).asScala().toList().apply(0)).getKey().toString();
                }
                return m.toString();
            }
            Object x = object;
            return x.toString();
        })).orNull($less$colon$less$.MODULE$.refl());
    }

    public Seq<?> getSeq(Map<String, ?> m, String name) {
        Option option = CollectionConverters$.MODULE$.MapHasAsScala(m).asScala().get(name.toString());
        if (option instanceof Some) {
            Object a = ((Some)option).value();
            if (a instanceof String) {
                String s2 = (String)a;
                return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)s2), Nil$.MODULE$));
            }
            if (a instanceof ArrayList) {
                ArrayList a2 = (ArrayList)a;
                return CollectionConverters$.MODULE$.ListHasAsScala(a2).asScala().toList().filter((Function1<Object, boolean> & Serializable)_$10 -> _$10 != null);
            }
            if (a == null) {
                return Nil$.MODULE$;
            }
            Object x = a;
            return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)x, Nil$.MODULE$));
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError(option);
    }

    public scala.collection.immutable.Map<String, Map<String, ?>> rawDefs() {
        String defName = "anonymizer";
        Seq sources = (Seq)this.yamlMd().filter((Function1<YamlMd, boolean> & Serializable)d -> this.isAnonymizer((YamlMd)d));
        Seq ds = (Seq)sources.flatMap((Function1<YamlMd, IterableOnce> & Serializable)d -> {
            Seq seq;
            try {
                seq = this.loadYamlRawDef$1(defName, d.body(), d.filename(), d.line());
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuilder(49).append("Failed to load anonymizer definition from ").append(d.filename()).append(", line ").append(d.line()).toString(), e);
            }
            return seq;
        });
        Iterable duplicateNames = ((MapOps)((IterableOps)ds.map((Function1<Tuple2, String> & Serializable)_$13 -> (String)_$13._1())).groupBy((Function1<String, String> & Serializable)x -> Predef$.MODULE$.identity(x)).filter((Function1<Tuple2, boolean> & Serializable)_$14 -> ((SeqOps)_$14._2()).size() > 1)).keys();
        Predef$.MODULE$.require(duplicateNames.isEmpty(), () -> YamlAnonymizerRulesLoader.rawDefs$$anonfun$1(duplicateNames));
        return ds.toMap($less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<String, DataAnonymizer.Rules> nameToRules() {
        Object object = this.nameToRules$lzy1;
        if (object instanceof scala.collection.immutable.Map) {
            return (scala.collection.immutable.Map)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Map)this.nameToRules$lzyINIT1();
    }

    private Object nameToRules$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.nameToRules$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    scala.collection.immutable.Map map = null;
                    try {
                        map = (scala.collection.immutable.Map)this.rawDefs().transform((Function2<String, Map, DataAnonymizer.Rules> & Serializable)(name, rawDef) -> {
                            Nil$ nil$;
                            long l;
                            Object V1 = CollectionConverters$.MODULE$.MapHasAsScala(rawDef).asScala().getOrElse("limit", YamlAnonymizerRulesLoader::$anonfun$13);
                            if (V1 instanceof Integer) {
                                int n = BoxesRunTime.unboxToInt(V1);
                                l = n;
                            } else if (V1 instanceof Long) {
                                long n;
                                l = n = BoxesRunTime.unboxToLong(V1);
                            } else {
                                Object x = V1;
                                throw scala.sys.package$.MODULE$.error(new StringBuilder(52).append("Unexpected class for limit: ").append(x.getClass()).append(". Expecting int or long.").toString());
                            }
                            long limit = l;
                            Object V12 = CollectionConverters$.MODULE$.MapHasAsScala(rawDef).asScala().getOrElse("min-batch-size", YamlAnonymizerRulesLoader::$anonfun$14);
                            if (!(V12 instanceof Integer)) {
                                Object x = V12;
                                throw scala.sys.package$.MODULE$.error(new StringBuilder(53).append("Unexpected class for min-batch-size: ").append(x.getClass()).append(". Expecting int.").toString());
                            }
                            int i = BoxesRunTime.unboxToInt(V12);
                            int min_batch_size = i;
                            Nil$ nil$2 = this.getSeq((Map<String, ?>)rawDef, "rules");
                            if (nil$2 == null) {
                                this.logger.warn(new StringBuilder(24).append("No rules for anonymizer ").append((String)name).toString());
                                nil$ = Nil$.MODULE$;
                            } else {
                                Nil$ rulesSeq;
                                nil$ = rulesSeq = nil$2;
                            }
                            Nil$ rulesSeq = nil$;
                            Seq rules = (Seq)rulesSeq.flatMap((Function1<Object, IterableOnce> & Serializable)_$19 -> this.getRules$1(_$19, Nil$.MODULE$));
                            return DataAnonymizer$Rules$.MODULE$.apply(limit, min_batch_size, rules);
                        });
                        object2 = map == null ? LazyVals$NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.nameToRules$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final String $anonfun$7(String defName$2) {
        return defName$2;
    }

    private final Seq loadYamlRawDef$1(String defName$1, String defString, String labelOrFilename, int lineNumber) {
        Seq<String> seq;
        String lineNumberCorrection;
        LoadSettings loaderSettings = LoadSettings.builder().setLabel((String)Option$.MODULE$.apply(labelOrFilename).getOrElse(() -> YamlAnonymizerRulesLoader.$anonfun$7(defName$1))).setAllowDuplicateKeys(false).build();
        Object object = new Load(loaderSettings).loadFromString(new StringBuilder(0).append(lineNumberCorrection = lineNumber > 1 ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\n"), lineNumber - 1) : "").append(defString).toString());
        if (!(object instanceof Map)) {
            Object x = object;
            throw scala.sys.package$.MODULE$.error(new StringBuilder(18).append("Unexpected class: ").append(Option$.MODULE$.apply(x).map((Function1<Object, Class> & Serializable)_$11 -> _$11.getClass()).orNull($less$colon$less$.MODULE$.refl())).toString());
        }
        Map m = (Map)object;
        Map defMap = m;
        Seq<String> seq2 = this.getStringSeq(defMap, defName$1);
        if (((Object)Nil$.MODULE$).equals(seq2) || seq2 == null) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(13).append("Missing ").append(defName$1).append(" name").toString());
        }
        Seq<String> names = seq = seq2;
        return (Seq)names.map((Function1<String, Tuple2> & Serializable)_$12 -> {
            String string2 = Predef$.MODULE$.ArrowAssoc(_$12);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, defMap);
        });
    }

    private static final String loadYamlRawDef$default$2$1() {
        return null;
    }

    private static final int loadYamlRawDef$default$3$1() {
        return 0;
    }

    private static final Object rawDefs$$anonfun$1(Iterable duplicateNames$1) {
        return new StringBuilder(34).append("Duplicate anonymizer definitions: ").append(duplicateNames$1.mkString(", ")).toString();
    }

    private static final Object $anonfun$13() {
        return BoxesRunTime.boxToLong(Long.MAX_VALUE);
    }

    private static final Object $anonfun$14() {
        return BoxesRunTime.boxToInteger(1);
    }

    private static final Seq fullPath$7(Seq path$5, String fullName) {
        Object object = Predef$.MODULE$.refArrayOps(fullName.split("\\.", -1));
        return (Seq)path$5.$plus$plus(ArrayOps$.MODULE$.toSeq$extension(object));
    }

    private static final String fullPathString$1(Seq path$11, String fullName) {
        return new StringBuilder(2).append("'").append(YamlAnonymizerRulesLoader.fullPath$7(path$11, fullName).mkString(".")).append("'").toString();
    }

    private static final String pathString$lzyINIT1$1(LazyRef pathString$lzy1$1, Seq path$6) {
        String string2;
        LazyRef lazyRef = pathString$lzy1$1;
        synchronized (lazyRef) {
            string2 = (String)(pathString$lzy1$1.initialized() ? pathString$lzy1$1.value() : pathString$lzy1$1.initialize(new StringBuilder(2).append("'").append(path$6.mkString(".")).append("'").toString()));
        }
        return string2;
    }

    private static final String pathString$1(LazyRef pathString$lzy1$2, Seq path$7) {
        return (String)(pathString$lzy1$2.initialized() ? pathString$lzy1$2.value() : YamlAnonymizerRulesLoader.pathString$lzyINIT1$1(pathString$lzy1$2, path$7));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Seq getRules$1(Object ruleDef, Seq path) {
        Tuple2 tuple2;
        Object T1;
        LazyRef lazyRef = new LazyRef();
        Object object = ruleDef;
        if (object instanceof Tuple2 && (T1 = (tuple2 = (Tuple2)object)._1()) instanceof String) {
            String f = (String)T1;
            if (tuple2._2() == null) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(29).append("Null rule not allowed, field ").append(YamlAnonymizerRulesLoader.fullPathString$1(path, f)).toString());
            }
        }
        if (object == null) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(28).append("Null rule not allowed, path ").append(YamlAnonymizerRulesLoader.pathString$1(lazyRef, path)).toString());
        }
        if (object instanceof Tuple2) {
            Tuple2 tuple22 = (Tuple2)object;
            Object T12 = tuple22._1();
            Object T2 = tuple22._2();
            if (T12 instanceof String) {
                String string2;
                String f = string2 = (String)T12;
                if (T2 instanceof String) {
                    Seq seq;
                    String string3;
                    String r = (String)T2;
                    try {
                        string3 = r;
                        if ("shuffle".equals(string3)) {
                            seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$Shuffle$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f))), Nil$.MODULE$));
                            return seq;
                        }
                        String n = string3;
                        if (n.startsWith("add noise ")) {
                            Object object2 = Predef$.MODULE$.refArrayOps(r.substring(9).trim().split(" "));
                            Seq seq2 = ArrayOps$.MODULE$.toSeq$extension(object2);
                            if (seq2 != null) {
                                SeqOps seqOps = Seq$.MODULE$.unapplySeq(seq2);
                                if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0) {
                                    String string4;
                                    String n2 = string4 = (String)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                                    seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$Noise$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f), BigDecimal$.MODULE$.long2bigDecimal(scala.math.package$.MODULE$.min(-StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(n2)), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(n2)))), BigDecimal$.MODULE$.long2bigDecimal(scala.math.package$.MODULE$.max(-StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(n2)), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(n2)))))), Nil$.MODULE$));
                                    return seq;
                                }
                                if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 2) == 0) {
                                    String string5 = (String)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                                    String string6 = (String)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                                    String a = string5;
                                    String b = string6;
                                    seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$Noise$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f), BigDecimal$.MODULE$.long2bigDecimal(scala.math.package$.MODULE$.min(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(a)), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(b)))), BigDecimal$.MODULE$.long2bigDecimal(scala.math.package$.MODULE$.max(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(a)), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(b)))))), Nil$.MODULE$));
                                    return seq;
                                }
                            }
                            Seq x = seq2;
                            throw scala.sys.package$.MODULE$.error(new StringBuilder(49).append("Expecting 1 or 2 parameters for 'add noise', got ").append(x.size()).toString());
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 == null) throw throwable;
                        Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable3);
                        if (option.isEmpty()) throw throwable;
                        Throwable ex = throwable2 = option.get();
                        throw new RuntimeException(new StringBuilder(27).append("Failed to read rule ").append(r).append(", path ").append(YamlAnonymizerRulesLoader.fullPath$7(path, f)).toString(), ex);
                    }
                    {
                        switch (string3 == null ? 0 : string3.hashCode()) {
                            case 108704142: {
                                if (!"round".equals(string3)) break;
                                seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$Round$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f), BigDecimal$.MODULE$.int2bigDecimal(1))), Nil$.MODULE$));
                                return seq;
                            }
                            case 607513673: {
                                if (!"generate short person code".equals(string3)) break;
                                seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$GeneratePersonCode$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f), true)), Nil$.MODULE$));
                                return seq;
                            }
                            case 1789528493: {
                                if (!"generate person code".equals(string3)) break;
                                seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$GeneratePersonCode$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f), false)), Nil$.MODULE$));
                                return seq;
                            }
                        }
                        String r2 = string3;
                        if (r2.startsWith("round ")) {
                            seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$Round$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f), package$.MODULE$.BigDecimal().apply(r2.substring(5).trim()))), Nil$.MODULE$));
                            return seq;
                        }
                        String m = string3;
                        if (m.startsWith("mask ")) {
                            seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$Mask$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f), m.substring(4).trim())), Nil$.MODULE$));
                            return seq;
                        }
                        if ("".equals(string3)) {
                            seq = Nil$.MODULE$;
                            return seq;
                        }
                        String x = string3;
                        throw scala.sys.package$.MODULE$.error(new StringBuilder(14).append("Unknown rule: ").append(x).toString());
                    }
                }
                String f2 = string2;
                if (T2 instanceof ArrayList) {
                    ArrayList r = (ArrayList)T2;
                    return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DataAnonymizer$ChooseRandomly$.MODULE$.apply(YamlAnonymizerRulesLoader.fullPath$7(path, f2), (Seq)CollectionConverters$.MODULE$.ListHasAsScala(r).asScala().toSeq().map((Function1<Object, String> & Serializable)_$15 -> _$15.toString()))), Nil$.MODULE$));
                }
            }
        }
        if (!(object instanceof Map)) {
            Object x = object;
            throw scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Unknown rule of class ").append(x.getClass().getName()).append(" (path ").append(YamlAnonymizerRulesLoader.pathString$1(lazyRef, path)).append("): ").append(x).toString());
        }
        Map m = (Map)object;
        int n = m.size();
        switch (n) {
            case 0: {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(31).append("Unknown rule - empty map, path ").append(YamlAnonymizerRulesLoader.pathString$1(lazyRef, path)).toString());
            }
            case 1: {
                return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(m).asScala().flatMap((Function1<Tuple2, Seq> & Serializable)_$16 -> this.getRules$1(_$16, path))).toSeq();
            }
            case 2: {
                return (Seq)((Seq)Option$.MODULE$.option2Iterable(CollectionConverters$.MODULE$.MapHasAsScala(m).asScala().headOption()).toSeq().flatMap((Function1<Tuple2, IterableOnce> & Serializable)_$17 -> this.getRules$1(_$17, path))).toSeq().$plus$plus((IterableOnce)this.getSeq(m, "rules").flatMap((Function1<Object, IterableOnce> & Serializable)_$18 -> this.getRules$1(_$18, (Seq)path.appended(((String)((Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(m).asScala().head())._1()).toString()))));
            }
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(41).append("Unknown rule of class ").append(m.getClass().getName()).append(" of size ").append(m.size()).append(" (path ").append(YamlAnonymizerRulesLoader.pathString$1(lazyRef, path)).append("): ").append(m).toString());
    }
}

