/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.JsonAnyValueDecoder$;
import dagr.Record;
import dagr.Reporter$;
import java.io.Serializable;
import org.apache.pekko.util.ByteString$;
import org.mojoz.metadata.FieldDef_;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.ViewDef_;
import org.mojoz.querease.Querease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public class Validator {
    private final Querease qe;
    private final Logger logger;
    private final boolean enabled;
    private final boolean enforced;
    private final JsonAnyValueDecoder$ decoder;
    private final Map<String, ViewDef_<FieldDef_<Type>>> nameToValidationView;
    private final int maxValLength;

    public Validator(Config config, Querease qe) {
        String string2;
        this.qe = qe;
        this.logger = LoggerFactory.getLogger("dagr.validator");
        String vldModeParameter = "data.validation";
        ListSet vldModeValidValues = (ListSet)ListSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"enforced", "enabled", "off"}));
        String vldMode = config.getString(vldModeParameter);
        if (!vldModeValidValues.contains(vldMode)) {
            this.logger.warn(new StringBuilder(51).append("Unexpected value '").append(vldMode).append("' for configuration parameter '").append(vldModeParameter).append("'.").append(new StringBuilder(19).append(" Expecting one of: ").append(vldModeValidValues.mkString(", ")).toString()).toString());
            string2 = "enforced";
        } else {
            string2 = vldMode;
        }
        String vldMode2 = string2;
        this.enabled = ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"enabled", "enforced"}))).contains(vldMode2);
        this.enforced = "enforced".equals(vldMode2);
        this.decoder = JsonAnyValueDecoder$.MODULE$;
        ObjectRef<Object> processed = ObjectRef.create(Predef$.MODULE$.Map().empty());
        qe.nameToViewDef().keys().foreach((Function1<String, Option> & Serializable)viewName -> this.validationViewOpt$1(qe, processed, (String)viewName));
        this.nameToValidationView = (Map)((Map)processed.elem).filter((Function1<Tuple2, boolean> & Serializable)_$3 -> ((ViewDef_)_$3._2()).fields().nonEmpty());
        this.maxValLength = 50;
    }

    public boolean isValidationEnabled(String datasetName) {
        return this.enabled && this.nameToValidationView.contains(datasetName);
    }

    public void validate(String datasetName, Record record) {
        if (record.value() != null) {
            try {
                this.validate$1(datasetName, this.decoder.decodeToMap(ByteString$.MODULE$.apply(record.value()), this.decoder.decodeToMap$default$2(), this.decoder.decodeToMap$default$3(), ClassTag$.MODULE$.apply(Map.class)));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = option.get();
                    throw new RuntimeException(new StringBuilder(50).append("Datu kvalit\u0101tes probl\u0113ma ierakstam ar atsl\u0113gu '").append(record.key()).append("': ").append(ex.getMessage()).toString(), ex);
                }
                throw throwable;
            }
            return;
        }
    }

    public void validateAndReport(String datasetName, Record record) {
        try {
            this.validate(datasetName, record);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                if (!this.enforced) {
                    this.logger.warn(ex.getMessage());
                    Reporter$.MODULE$.reportProblem(datasetName, ex.getMessage(), false);
                }
            }
            throw throwable;
        }
    }

    private static final /* synthetic */ boolean validationViewOpt$1$$anonfun$1(boolean x) {
        return BoxesRunTime.unboxToBoolean(Predef$.MODULE$.identity(BoxesRunTime.boxToBoolean(x)));
    }

    private static final Object $anonfun$1$$anonfun$1() {
        return null;
    }

    private static final Object $anonfun$1$$anonfun$2$$anonfun$1() {
        return null;
    }

    private static final Object $anonfun$2$$anonfun$1() {
        return null;
    }

    private final Option validationViewOpt$1(Querease qe$1, ObjectRef processed$1, String viewName) {
        return Option$.MODULE$.apply(BoxesRunTime.boxToBoolean(this.enabled)).filter((Function1<Boolean, Object>)(Function1<Object, boolean> & Serializable)x -> Validator.validationViewOpt$1$$anonfun$1(BoxesRunTime.unboxToBoolean(x))).flatMap((Function1<Object, Option> & Serializable)_$1 -> qe$1.viewDefOption(viewName)).map((Function1<ViewDef_, ViewDef_> & Serializable)viewDef -> {
            Seq seq = (Seq)((IterableOps)viewDef.fields().filter((Function1<FieldDef_, boolean> & Serializable)f2 -> {
                if (!f2.nullable()) return true;
                if (f2.enum_() != null) {
                    if (f2.enum_().nonEmpty()) return true;
                }
                if (f2.extras() != null) {
                    if (f2.extras().getOrElse("pattern", Validator::$anonfun$1$$anonfun$1) != null) return true;
                }
                if (((Type)f2.type_()).isComplexType() && ((Map)processed$3.elem).contains(((Type)f2.type_()).name())) {
                    if (((ViewDef_)((Map)processed$3.elem).apply(((Type)f2.type_()).name())).fields().nonEmpty()) return true;
                }
                String string2 = ((Type)f2.type_()).name();
                String string3 = viewDef.name();
                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                    if (this.validationViewOpt$1(qe$1, processed$1, ((Type)f2.type_()).name()).nonEmpty()) return true;
                }
                String string4 = ((Type)f2.type_()).name();
                String string5 = viewDef.name();
                if (string4 == null) {
                    if (string5 != null) {
                        return false;
                    }
                } else if (!string4.equals(string5)) return false;
                if (!viewDef.fields().exists((Function1<FieldDef_, boolean> & Serializable)f -> !f.nullable() || f.enum_() != null && f.enum_().nonEmpty() || f.extras() != null && f.extras().getOrElse("pattern", Validator::$anonfun$1$$anonfun$2$$anonfun$1) != null || ((Type)f.type_()).isComplexType() && ((Map)processed$4.elem).contains(((Type)f.type_()).name()) && ((ViewDef_)((Map)processed$4.elem).apply(((Type)f.type_()).name())).fields().nonEmpty())) return false;
                return true;
            })).map((Function1<FieldDef_, FieldDef_> & Serializable)f -> {
                if (f.extras() != null && f.extras().getOrElse("pattern", Validator::$anonfun$2$$anonfun$1) != null) {
                    String string2 = Predef$.MODULE$.ArrowAssoc("regex");
                    Map map = (Map)f.extras().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(f.extras().apply("pattern").toString()))));
                    String string3 = f.copy$default$1();
                    String string4 = f.copy$default$2();
                    String string5 = f.copy$default$3();
                    String string6 = f.copy$default$4();
                    String string7 = f.copy$default$5();
                    boolean bl = f.copy$default$6();
                    boolean bl2 = f.copy$default$7();
                    boolean bl3 = f.copy$default$8();
                    String string8 = f.copy$default$9();
                    String string9 = f.copy$default$10();
                    String string10 = f.copy$default$11();
                    boolean bl4 = f.copy$default$12();
                    Type type2 = (Type)f.copy$default$13();
                    Seq<String> seq = f.copy$default$14();
                    String string11 = f.copy$default$15();
                    String string12 = f.copy$default$16();
                    String string13 = f.copy$default$17();
                    return f.copy(string3, string4, string5, string6, string7, bl, bl2, bl3, string8, string9, string10, bl4, type2, seq, string11, string12, string13, map);
                }
                return f;
            });
            String string2 = viewDef.copy$default$1();
            String string3 = viewDef.copy$default$2();
            String string4 = viewDef.copy$default$3();
            String string5 = viewDef.copy$default$4();
            String string6 = viewDef.copy$default$5();
            String string7 = viewDef.copy$default$6();
            Seq<String> seq2 = viewDef.copy$default$7();
            Seq<String> seq3 = viewDef.copy$default$8();
            Seq<String> seq4 = viewDef.copy$default$9();
            Seq<String> seq5 = viewDef.copy$default$10();
            Seq<String> seq6 = viewDef.copy$default$11();
            String string8 = viewDef.copy$default$12();
            String string9 = viewDef.copy$default$13();
            Seq<String> seq7 = viewDef.copy$default$15();
            Map<String, Object> map = viewDef.copy$default$16();
            ViewDef_ clean = viewDef.copy(string2, string3, string4, string5, string6, string7, seq2, seq3, seq4, seq5, seq6, string8, string9, seq, seq7, map);
            String string10 = Predef$.MODULE$.ArrowAssoc(viewDef.name());
            processed$2.elem = (Map)((Map)processed$2.elem).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string10, clean));
            return clean;
        }).filter((Function1<ViewDef_, boolean> & Serializable)_$2 -> _$2.fields().nonEmpty());
    }

    private final String v$lzyINIT1$1(LazyRef v$lzy1$1, Object value$1) {
        String string2;
        LazyRef lazyRef = v$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (v$lzy1$1.initialized()) {
                object = v$lzy1$1.value();
            } else {
                String string3;
                Object object2 = value$1;
                if (object2 == null) {
                    string3 = "null";
                } else {
                    Object x = object2;
                    String s2 = x.toString();
                    string3 = new StringBuilder(2).append("'").append(s2.length() <= this.maxValLength ? s2 : new StringBuilder(5).append("'").append(s2.substring(0, this.maxValLength)).append("...'").toString()).append("'").toString();
                }
                object = v$lzy1$1.initialize(string3);
            }
            string2 = (String)object;
        }
        return string2;
    }

    private final String v$1(LazyRef v$lzy1$2, Object value$2) {
        return (String)(v$lzy1$2.initialized() ? v$lzy1$2.value() : this.v$lzyINIT1$1(v$lzy1$2, value$2));
    }

    private static final Object validate_$1$$anonfun$1() {
        return null;
    }

    private final void validate_$1(FieldDef_ f$1, Object value) {
        LazyRef lazyRef = new LazyRef();
        if (f$1.enum_() != null && f$1.enum_().nonEmpty() && !f$1.enum_().contains(value)) {
            throw package$.MODULE$.error(new StringBuilder(56).append("Lauka '").append(f$1.fieldName()).append("' v\u0113rt\u012bba ").append(this.v$1(lazyRef, value)).append(" neatbilst at\u013cauto v\u0113rt\u012bbu sarakstam (").append(f$1.enum_().mkString(", ")).append(")").toString());
        }
        if (f$1.extras() != null && f$1.extras().getOrElse("regex", Validator::validate_$1$$anonfun$1) != null && !((Regex)f$1.extras().apply("regex")).matches(value.toString())) {
            throw package$.MODULE$.error(new StringBuilder(39).append("Lauka '").append(f$1.fieldName()).append("' v\u0113rt\u012bba ").append(this.v$1(lazyRef, value)).append(" neatbilst \u0161ablonam '").append(f$1.extras().apply("regex")).append("'").toString());
        }
        if (((Type)f$1.type_()).isComplexType()) {
            Object object = value;
            if (object instanceof Map) {
                Map m = (Map)object;
                this.validate$1(((Type)f$1.type_()).name(), m);
                return;
            }
            Object x = object;
            throw package$.MODULE$.error(new StringBuilder(39).append("Lauka '").append(f$1.fieldName()).append("' v\u0113rt\u012bba ").append(this.v$1(lazyRef, value)).append(" neatbilst strukt\u016brai.").append(new StringBuilder(43).append(" Tika sagaid\u012bts objekts, bet sa\u0146emta klase ").append(x.getClass().getName()).toString()).toString());
        }
    }

    private final void validate$1(String viewName, Map map) {
        ((ViewDef_)this.nameToValidationView.apply(viewName)).fields().foreach(f -> {
            Option valueOpt = map.get(f.fieldName());
            if (!f.nullable() && !valueOpt.exists((Function1<Object, boolean> & Serializable)_$4 -> _$4 != null)) {
                throw package$.MODULE$.error(new StringBuilder(63).append("Lauka '").append(f.fieldName()).append("' v\u0113rt\u012bba ir oblig\u0101ta, bet lauks nav atrasts vai ir null").toString());
            }
            valueOpt.filter((Function1<Object, boolean> & Serializable)_$5 -> _$5 != null).foreach(value2 -> {
                if (f.isCollection()) {
                    Object object = value2;
                    if (object instanceof Seq) {
                        Seq s2 = (Seq)object;
                        s2.foreach(value -> this.validate_$1((FieldDef_)f, value));
                        return;
                    }
                    Object x = object;
                    throw package$.MODULE$.error(new StringBuilder(38).append("Lauka '").append(f.fieldName()).append("' v\u0113rt\u012bba neatbilst strukt\u016brai.").append(new StringBuilder(52).append(" Tika sagaid\u012bts v\u0113rt\u012bbu saraksts, bet sa\u0146emta klase ").append(x.getClass().getName()).toString()).toString());
                }
                this.validate_$1((FieldDef_)f, value2);
            });
        });
    }
}

