/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.HttpClient;
import dagr.Record;
import dagr.SecurityTokenServiceClient;
import dagr.Token;
import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import spray.json.JsString$;

public class Updater {
    private final HttpClient http;
    private final SecurityTokenServiceClient tokenS;
    public final Function1<Record, BoxedUnit> dagr$Updater$$onBatchSuccess;
    private final ExecutionContext ec;
    private final boolean do_connection_test;
    private final long connection_test_interval_ms;
    private boolean doingUpdates;
    private Option<Record> lastRecord;
    private long lastUpdate;
    private final Future<BoxedUnit> futureSuccessful;
    private final HttpRequest requestTemplate;

    public Updater(Config config, HttpClient http, SecurityTokenServiceClient tokenS, String dataset_full_name, Function1<Record, BoxedUnit> onBatchSuccess, ActorSystem system, ExecutionContext ec) {
        String string2;
        String dataset_name;
        String string3;
        this.http = http;
        this.tokenS = tokenS;
        this.dagr$Updater$$onBatchSuccess = onBatchSuccess;
        this.ec = ec;
        if (dataset_full_name.startsWith("sandbox/")) {
            Object object = Predef$.MODULE$.refArrayOps(dataset_full_name.split("/"));
            string3 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.drop$extension(object, 2)).mkString("/");
        } else {
            string3 = dataset_name = dataset_full_name;
        }
        if (dataset_full_name.startsWith("sandbox/")) {
            Object object = Predef$.MODULE$.refArrayOps(dataset_full_name.split("/"));
            string2 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object, 2)).mkString("/", "/", "");
        } else {
            string2 = "";
        }
        String maybe_sandbox = string2;
        String target_server_uri = new StringBuilder(0).append(config.getString("target_server_uri")).append(maybe_sandbox).toString();
        this.do_connection_test = config.getBoolean("do_connection_test");
        this.connection_test_interval_ms = config.getDuration("connection_test_interval").toMillis();
        this.doingUpdates = false;
        this.lastRecord = None$.MODULE$;
        this.lastUpdate = 0L;
        this.futureSuccessful = Future$.MODULE$.successful(BoxedUnit.UNIT);
        HttpMethod httpMethod = HttpMethods$.MODULE$.PUT();
        Uri uri = Uri$.MODULE$.apply(new StringBuilder(8).append(target_server_uri).append("/update/").append(dataset_name).toString());
        HttpEntity.Strict strict = HttpEntity$.MODULE$.apply((ContentType)ContentTypes$.MODULE$.application$divjson(), ByteString$.MODULE$.apply("[]"));
        Seq<HttpHeader> seq = HttpRequest$.MODULE$.apply$default$3();
        HttpProtocol httpProtocol = HttpRequest$.MODULE$.apply$default$5();
        this.requestTemplate = HttpRequest$.MODULE$.apply(httpMethod, uri, seq, strict, httpProtocol);
    }

    private void setDoingUpdates() {
        Updater updater = this;
        synchronized (updater) {
            this.doingUpdates = true;
        }
    }

    public void dagr$Updater$$setUpdatesSuccess() {
        Updater updater = this;
        synchronized (updater) {
            this.doingUpdates = false;
        }
    }

    private void setLastRecord(Option<Record> last) {
        Updater updater = this;
        synchronized (updater) {
            this.lastRecord = last;
        }
    }

    public Option<Record> dagr$Updater$$getLastRecord() {
        Option<Record> option;
        Updater updater = this;
        synchronized (updater) {
            option = this.lastRecord;
        }
        return option;
    }

    private void setLastUpdate(long epochMs) {
        Updater updater = this;
        synchronized (updater) {
            this.lastUpdate = epochMs;
        }
    }

    private long getLastUpdate() {
        long l;
        Updater updater = this;
        synchronized (updater) {
            l = this.lastUpdate;
        }
        return l;
    }

    public boolean incompleteOrFailedUpdates() {
        boolean bl;
        Updater updater = this;
        synchronized (updater) {
            bl = this.doingUpdates;
        }
        return bl;
    }

    private Seq<Authorization> headers(String access_token) {
        return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(access_token))), Nil$.MODULE$));
    }

    public Future<HttpResponse> update(Source<Record, NotUsed> source) {
        return this.tokenS.getToken().flatMap((Function1<Token, Future> & Serializable)token -> {
            Future<Object> future;
            if (this.do_connection_test) {
                long now = System.currentTimeMillis();
                long lastUpdate = this.getLastUpdate();
                this.setLastUpdate(now);
                future = lastUpdate + this.connection_test_interval_ms < now ? this.http.doRequest((HttpRequest)this.requestTemplate.withHeaders(this.headers(token.access_token())), this.http.doRequest$default$2(), this.http.doRequest$default$3(), this.http.doRequest$default$4()) : this.futureSuccessful;
            } else {
                future = this.futureSuccessful;
            }
            return future.flatMap((Function1<Object, Future> & Serializable)x$1 -> {
                Object object = x$1;
                this.setDoingUpdates();
                return this.http.doRequest(((HttpRequest)this.requestTemplate.withHeaders(this.headers(token.access_token()))).withEntity(HttpEntity$.MODULE$.apply((ContentType)ContentTypes$.MODULE$.application$divjson(), (Source)source.statefulMap((Function0<Option> & Serializable)() -> None$.MODULE$, (Function2<Option, Record, Tuple2> & Serializable)(last, record) -> {
                    String jsKey = JsString$.MODULE$.apply(String.valueOf(record.key())).compactPrint();
                    String jsTs = record.timestamp() == null ? null : JsString$.MODULE$.apply(String.valueOf(record.timestamp())).compactPrint();
                    String jsValue = record.value() == null ? null : JsString$.MODULE$.apply(String.valueOf(record.value())).compactPrint();
                    return Tuple2$.MODULE$.apply(Option$.MODULE$.apply(record), ByteString$.MODULE$.apply(new StringBuilder(35).append("{\"key\": ").append(jsKey).append(", \"timestamp\": ").append(jsTs).append(", \"value\": ").append(jsValue).append("}").toString()));
                }, (Function1<Option, Option> & Serializable)last -> {
                    this.setLastRecord((Option<Record>)last);
                    return None$.MODULE$;
                }).intersperse(ByteString$.MODULE$.apply("["), ByteString$.MODULE$.apply(",\n"), ByteString$.MODULE$.apply("]\n")))), this.http.doRequest$default$2(), this.http.doRequest$default$3(), this.http.doRequest$default$4()).andThen(new Serializable(this){
                    private final /* synthetic */ Updater $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Try x) {
                        Try try_ = x;
                        if (try_ instanceof Success) {
                            return true;
                        }
                        return try_ instanceof Failure;
                    }

                    public final Object applyOrElse(Try x, Function1 function1) {
                        Try try_ = x;
                        if (try_ instanceof Success) {
                            this.$outer.dagr$Updater$$setUpdatesSuccess();
                            this.$outer.dagr$Updater$$getLastRecord().foreach(this.$outer.dagr$Updater$$onBatchSuccess);
                            return BoxedUnit.UNIT;
                        }
                        if (try_ instanceof Failure) {
                            return BoxedUnit.UNIT;
                        }
                        return function1.apply(x);
                    }
                }, this.ec).map((Function1<HttpResponse, HttpResponse> & Serializable)update -> update, this.ec);
            }, this.ec);
        }, this.ec);
    }
}

