/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.HttpClient;
import dagr.SecurityTokenServiceClient$CachedToken$;
import dagr.Token;
import dagr.Token$;
import io.bullet.borer.Decoder;
import io.bullet.borer.InputReader;
import io.bullet.borer.Reader;
import io.bullet.borer.compat.pekkoHttp$;
import io.bullet.borer.derivation.helpers.package$package$;
import java.io.FileReader;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Base64;
import java.util.UUID;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.headers.Accept$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.stream.Materializer$;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pdi.jwt.Jwt$;
import pdi.jwt.JwtAlgorithm$RS256$;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtClaim$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public class SecurityTokenServiceClient {
    private final Config config;
    private final String role;
    private final HttpClient http;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private final Logger logger;
    private final PrivateKey privateKey;
    private final String client_id;
    private final String token_service_uri;
    private final String jwtPayloadAudience;
    private final Map<String, String> jwtScope;
    private final List<Host> withHostHeader;
    public final SecurityTokenServiceClient$CachedToken$ CachedToken$lzy1;
    private CachedToken cachedToken;
    private final Decoder<Token> tokenDecoder;

    public SecurityTokenServiceClient(Config config, String role, HttpClient http, ActorSystem system, ExecutionContext ec) {
        this.config = config;
        this.role = role;
        this.http = http;
        this.system = system;
        this.ec = ec;
        this.CachedToken$lzy1 = new SecurityTokenServiceClient$CachedToken$(this);
        this.logger = LoggerFactory.getLogger("dagr.token");
        Security.addProvider(new BouncyCastleProvider());
        this.privateKey = (PrivateKey)Option$.MODULE$.apply(new StringBuilder(9).append(role).append(".key.path").toString()).filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> config.hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> config.getString((String)x$0)).map((Function1<String, PrivateKey> & Serializable)privateKeyPath -> {
            this.logger.debug(new StringBuilder(33).append("Obtaining private key from file: ").append((String)privateKeyPath).toString());
            PemReader pemReader = new PemReader(new FileReader((String)privateKeyPath));
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pemReader.readPemObject().getContent());
            pemReader.close();
            return KeyFactory.getInstance("RSA", "BC").generatePrivate(privateKeySpec);
        }).getOrElse(() -> this.$init$$$anonfun$4(role, config));
        if (this.privateKey == null) {
            this.logger.warn(new StringBuilder(74).append("Empty private key for JWT token encoding - data synchronization may fail. ").append(new StringBuilder(86).append("Please set '").append(role).append(".key' or '").append(role).append(".key.path' configuration value for this connector appropriately.").toString()).toString());
        }
        this.client_id = config.getString(new StringBuilder(10).append(role).append(".client_id").toString());
        this.token_service_uri = config.getString("jwt.service.uri");
        this.jwtPayloadAudience = config.getString("jwt.payload-audience");
        this.jwtScope = (Map)Option$.MODULE$.apply("jwt.scope").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> config.hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> config.getString((String)x$0)).map((Function1<String, Map> & Serializable)s2 -> {
            Tuple2[] tuple2Array = new Tuple2[1];
            String string2 = Predef$.MODULE$.ArrowAssoc("scope");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, URLEncoder.encode(s2, StandardCharsets.UTF_8));
            return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        }).getOrElse(SecurityTokenServiceClient::$init$$$anonfun$8);
        this.withHostHeader = (List)Option$.MODULE$.apply("jwt.service.with-host-header").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> config.hasPath((String)x$0)).map((Function1<String, List> & Serializable)x$1 -> {
            String string2 = x$1;
            String s2 = string2;
            if (config.getBoolean(s2)) {
                return (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Host$.MODULE$.apply(Uri$.MODULE$.apply(this.token_service_uri).authority().host(), Host$.MODULE$.$lessinit$greater$default$2())), Nil$.MODULE$));
            }
            return (List)((Object)Nil$.MODULE$);
        }).getOrElse(SecurityTokenServiceClient::$init$$$anonfun$11);
        this.cachedToken = null;
        Decoder<Token> decoder$proxy1 = r -> {
            if (r.tryReadMapStart()) {
                return SecurityTokenServiceClient.readObject$1(r, -1);
            }
            if (r.hasMapHeader()) {
                long mapLength = r.readMapHeader();
                if (mapLength > Integer.MAX_VALUE) {
                    throw r.overflow("Maps with more than 2^31 entries are not supported");
                }
                return SecurityTokenServiceClient.readObject$1(r, (int)mapLength);
            }
            throw r.unexpectedDataItem("Map Start or Map Header for decoding an instance of type `Token`");
        };
        this.tokenDecoder = decoder$proxy1;
    }

    public HttpClient http() {
        return this.http;
    }

    private final SecurityTokenServiceClient$CachedToken$ CachedToken() {
        return this.CachedToken$lzy1;
    }

    private CachedToken getCachedToken() {
        CachedToken cachedToken;
        SecurityTokenServiceClient securityTokenServiceClient = this;
        synchronized (securityTokenServiceClient) {
            cachedToken = this.cachedToken;
        }
        CachedToken ct = cachedToken;
        if (ct != null && this.getInstantNowInMillisAtUTC() + 2000L < ct.validTo()) {
            return ct;
        }
        return null;
    }

    private void setCachedToken(CachedToken ct) {
        SecurityTokenServiceClient securityTokenServiceClient = this;
        synchronized (securityTokenServiceClient) {
            this.cachedToken = ct;
        }
    }

    private long getInstantNowInMillisAtUTC() {
        return Clock.fixed(Instant.now(), ZoneId.of("UTC")).millis();
    }

    public Decoder<Token> tokenDecoder() {
        return this.tokenDecoder;
    }

    public Future<Token> getToken() {
        Future<Token> future;
        CachedToken ct = this.getCachedToken();
        if (ct != null) {
            this.logger.debug(new StringBuilder(21).append("get cached token: ").append(ct.token().access_token().length() > 5 ? StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(ct.token().access_token()), 5) : "???").append("...").toString());
            return Future$.MODULE$.successful(ct.token());
        }
        try {
            this.logger.debug("Preparing jwt claim");
            long start_time_ms = this.getInstantNowInMillisAtUTC();
            long startTime = start_time_ms / 1000L;
            Some<String> some = Some$.MODULE$.apply(this.client_id);
            Some<String> some2 = Some$.MODULE$.apply(this.client_id);
            Some<Object> some3 = Some$.MODULE$.apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{this.jwtPayloadAudience})));
            Some<Object> some4 = Some$.MODULE$.apply(BoxesRunTime.boxToLong(startTime + 900L));
            Some<Object> some5 = Some$.MODULE$.apply(BoxesRunTime.boxToLong(startTime));
            Some<Object> some6 = Some$.MODULE$.apply(BoxesRunTime.boxToLong(startTime));
            Some<String> some7 = Some$.MODULE$.apply(UUID.randomUUID().toString());
            String string2 = JwtClaim$.MODULE$.apply$default$1();
            JwtClaim jwtClaim = JwtClaim$.MODULE$.apply(string2, some, some2, some3, some4, some5, some6, some7);
            String jwtToken = Jwt$.MODULE$.encode(jwtClaim, this.privateKey, (JwtAsymmetricAlgorithm)JwtAlgorithm$RS256$.MODULE$);
            Tuple2[] tuple2Array = new Tuple2[4];
            String string3 = Predef$.MODULE$.ArrowAssoc("grant_type");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, "client_credentials");
            String string4 = Predef$.MODULE$.ArrowAssoc("client_assertion_type");
            tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            String string5 = Predef$.MODULE$.ArrowAssoc("client_id");
            tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, this.client_id);
            String string6 = Predef$.MODULE$.ArrowAssoc("client_assertion");
            tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string6, jwtToken);
            String queryString = Uri$Query$.MODULE$.apply((Map)((MapOps)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).$plus$plus(this.jwtScope)).toString();
            this.logger.debug("jwt claim prepared");
            future = this.getToken(start_time_ms, queryString);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                this.logger.error("Failed to request security token", ex);
                throw ex;
            }
            throw throwable;
        }
        return future;
    }

    private Future<Token> getToken(long start_time_ms, String queryString) {
        this.logger.debug(new StringBuilder(28).append("Getting security token from ").append(this.token_service_uri).toString());
        return this.http().doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.POST(), Uri$.MODULE$.apply(this.token_service_uri), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), Nil$.MODULE$)).$plus$plus(this.withHostHeader), HttpEntity$.MODULE$.apply(ContentTypes$.MODULE$.application$divx$minuswww$minusform$minusurlencoded(), queryString), HttpRequest$.MODULE$.apply$default$5()), this.http().doRequest$default$2(), this.http().doRequest$default$3(), this.http().doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)_$5 -> Unmarshal$.MODULE$.apply(_$5).to(pekkoHttp$.MODULE$.borerFromMessageUnmarshaller((Decoder)this.tokenDecoder()), this.ec, Materializer$.MODULE$.matFromSystem(this.system)), this.ec).map((Function1<Token, Token> & Serializable)token -> {
            this.logger.debug(new StringBuilder(23).append("set cached token: ").append(token.access_token().length() > 5 ? StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(token.access_token()), 5) : "???").append("..., ").append(new StringBuilder(15).append("start time - ").append(Instant.ofEpochMilli(start_time_ms)).append(", ").toString()).append(new StringBuilder(13).append("expires at - ").append(Instant.ofEpochMilli(start_time_ms + (long)token.expires_in() * 1000L)).toString()).toString());
            this.setCachedToken(this.CachedToken().apply((Token)token, start_time_ms + (long)token.expires_in() * 1000L));
            return token;
        }, this.ec).recover(new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = option.get();
                    throw new RuntimeException("Failed to get security token", ex);
                }
                return function1.apply(x);
            }
        }, this.ec);
    }

    private final PrivateKey $init$$$anonfun$4(String role$1, Config config$3) {
        return (PrivateKey)Option$.MODULE$.apply(new StringBuilder(4).append(role$1).append(".key").toString()).filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> config$3.hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> config$3.getString((String)x$0)).map((Function1<String, String> & Serializable)_$1 -> Source$.MODULE$.fromString((String)_$1).getLines().filterNot((Function1<String, Object>)(Function1<String, boolean> & Serializable)_$2 -> {
            String string2 = _$2;
            String string3 = "-----BEGIN PRIVATE KEY-----";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }).filterNot((Function1<String, Object>)(Function1<String, boolean> & Serializable)_$3 -> {
            String string2 = _$3;
            String string3 = "-----END PRIVATE KEY-----";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }).toSeq().mkString()).map((Function1<String, PrivateKey> & Serializable)key2 -> {
            Object object = Predef$.MODULE$.byteArrayOps(MessageDigest.getInstance("SHA-256").digest(key2.getBytes("UTF-8")));
            String privateKeyShaString = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<Object, String> & Serializable)_$4 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToByte(BoxesRunTime.unboxToByte(_$4))})), ClassTag$.MODULE$.apply(String.class))).mkString();
            this.logger.debug(new StringBuilder(50).append("Obtaining private key from ").append(role$1).append(".key setting. SHA-256: ").append(privateKeyShaString).toString());
            return KeyFactory.getInstance("RSA", "BC").generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode((String)key2)));
        }).orNull($less$colon$less$.MODULE$.refl());
    }

    private static final Map $init$$$anonfun$8() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
    }

    private static final List $init$$$anonfun$11() {
        return (List)((Object)Nil$.MODULE$);
    }

    private static final void read$2(InputReader r$3, IntRef mask$2, ObjectRef x$5, IntRef x$6) {
        int cmp = r$3.tryReadStringCompare("expires_in");
        if (cmp < 0) {
            if (r$3.tryReadStringCompare("access_token") == 0) {
                if ((mask$2.elem & 1) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$3, "access_token", "Token");
                }
                x$5.elem = r$3.readString();
                mask$2.elem |= 1;
                return;
            }
            InputReader InputReader_this = r$3;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if (cmp > 0) {
            InputReader InputReader_this = r$3;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if ((mask$2.elem & 2) != 0) {
            throw package$package$.MODULE$.failDuplicateMapKey(r$3, "expires_in", "Token");
        }
        x$6.elem = r$3.readInt();
        mask$2.elem |= 2;
    }

    private static final void read$1(InputReader r$2, IntRef mask$1, ObjectRef x$1, IntRef x$2, ObjectRef x$3, ObjectRef x$4) {
        int cmp = r$2.tryReadStringCompare("scope");
        if (cmp < 0) {
            SecurityTokenServiceClient.read$2(r$2, mask$1, x$1, x$2);
            return;
        }
        if (cmp > 0) {
            if (r$2.tryReadStringCompare("token_type") == 0) {
                if ((mask$1.elem & 4) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$2, "token_type", "Token");
                }
                x$3.elem = r$2.readString();
                mask$1.elem |= 4;
                return;
            }
            InputReader InputReader_this = r$2;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if ((mask$1.elem & 8) != 0) {
            throw package$package$.MODULE$.failDuplicateMapKey(r$2, "scope", "Token");
        }
        x$4.elem = r$2.readString();
        mask$1.elem |= 8;
    }

    private static final Nothing$ failMissing$1(InputReader r$4, int testMask$1) {
        return package$package$.MODULE$.failMissing((InputReader<? extends Reader.Config>)r$4, "Token", testMask$1, (List<String>)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"access_token"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"expires_in"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"token_type"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"scope"), Nil$.MODULE$)))))));
    }

    private static final Token readObject$1(InputReader r$1, int count) {
        String string2;
        String string3;
        int n;
        String string4;
        int rem = count;
        IntRef mask = IntRef.create(0);
        if (rem != 0 && r$1.tryReadString("access_token")) {
            mask.elem |= 1;
            --rem;
            string4 = r$1.readString();
        } else {
            string4 = null;
        }
        ObjectRef<Object> x = ObjectRef.create(string4);
        if (rem != 0 && r$1.tryReadString("expires_in")) {
            mask.elem |= 2;
            --rem;
            n = r$1.readInt();
        } else {
            n = BoxesRunTime.unboxToInt(null);
        }
        IntRef x2 = IntRef.create(n);
        if (rem != 0 && r$1.tryReadString("token_type")) {
            mask.elem |= 4;
            --rem;
            string3 = r$1.readString();
        } else {
            string3 = null;
        }
        ObjectRef<Object> x3 = ObjectRef.create(string3);
        if (rem != 0 && r$1.tryReadString("scope")) {
            mask.elem |= 8;
            --rem;
            string2 = r$1.readString();
        } else {
            string2 = null;
        }
        ObjectRef<Object> x4 = ObjectRef.create(string2);
        while (rem > 0 || rem < 0 && !r$1.tryReadBreak()) {
            Object object;
            if (mask.elem != 15) {
                SecurityTokenServiceClient.read$1(r$1, mask, x, x2, x3, x4);
                object = BoxedUnit.UNIT;
            } else {
                InputReader InputReader_this = r$1;
                object = InputReader_this.skipElement().skipElement();
            }
            --rem;
        }
        int testMask = mask.elem | 0xFFFFFFF0;
        if (testMask == -1) {
            return Token$.MODULE$.apply((String)x.elem, x2.elem, (String)x3.elem, (String)x4.elem);
        }
        throw SecurityTokenServiceClient.failMissing$1(r$1, testMask);
    }

    public class CachedToken
    implements Product,
    Serializable {
        private final Token token;
        private final long validTo;
        private final /* synthetic */ SecurityTokenServiceClient $outer;

        public CachedToken(SecurityTokenServiceClient $outer, Token token, long validTo) {
            this.token = token;
            this.validTo = validTo;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.token()));
            n = Statics.mix(n, Statics.longHash(this.validTo()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CachedToken)) return false;
            if (((CachedToken)object).dagr$SecurityTokenServiceClient$CachedToken$$$outer() != this.$outer) return false;
            CachedToken cachedToken = (CachedToken)object;
            if (this.validTo() != cachedToken.validTo()) return false;
            Token token = this.token();
            Token token2 = cachedToken.token();
            if (token == null) {
                if (token2 != null) {
                    return false;
                }
            } else if (!((Object)token).equals(token2)) return false;
            if (!cachedToken.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof CachedToken;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "CachedToken";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "token";
            }
            if (1 == n2) {
                return "validTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Token token() {
            return this.token;
        }

        public long validTo() {
            return this.validTo;
        }

        public CachedToken copy(Token token, long validTo) {
            return new CachedToken(this.$outer, token, validTo);
        }

        public Token copy$default$1() {
            return this.token();
        }

        public long copy$default$2() {
            return this.validTo();
        }

        public Token _1() {
            return this.token();
        }

        public long _2() {
            return this.validTo();
        }

        public final /* synthetic */ SecurityTokenServiceClient dagr$SecurityTokenServiceClient$CachedToken$$$outer() {
            return this.$outer;
        }
    }
}

