/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import dagr.Connector$;
import dagr.Reporter;
import dagr.Reporter$DatasetReportingStatus$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Ordering$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class Reporter$
implements Serializable {
    private static final Duration minInterval;
    private static final boolean reportProblems;
    private static final Duration reportProblemsInterval;
    private static final ZoneId zoneId;
    public static final Reporter$DatasetReportingStatus$ DatasetReportingStatus;
    private static final int maxProblems;
    private static final Map<String, Reporter.DatasetReportingStatus> statuses;
    public static final Reporter$ MODULE$;

    private Reporter$() {
    }

    static {
        MODULE$ = new Reporter$();
        Config config = ConfigFactory.load();
        minInterval = Duration.ofMinutes(10L);
        reportProblems = config.getBoolean("report_problems.by_email");
        Duration configProblemsInterval = config.getDuration("report_problems.interval");
        String reportProblemsTimezone = config.getString("report_problems.timezone");
        reportProblemsInterval = (Duration)Option$.MODULE$.apply(configProblemsInterval).filter((Function1<Duration, Object>)(Function1<Duration, boolean> & Serializable)_$1 -> _$1.compareTo(minInterval) > 0).getOrElse(MODULE$::$init$$$anonfun$2);
        zoneId = ZoneId.of(reportProblemsTimezone);
        maxProblems = 25;
        statuses = (Map)Map$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Reporter$.class);
    }

    public ZoneId zoneId() {
        return zoneId;
    }

    private String format(Instant dt) {
        return dt.atZone(this.zoneId()).toOffsetDateTime().truncatedTo(ChronoUnit.MILLIS).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME).replace("T", " ");
    }

    public String summary(Reporter.DatasetReportingStatus status) {
        return ((IterableOnceOps)((IterableOps)((SeqOps)((IterableOps)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)status.firstErrorTimestamp().map((Function1<Instant, Tuple2> & Serializable)dt -> Tuple2$.MODULE$.apply(dt, new StringBuilder(14).append(MODULE$.format((Instant)dt)).append(" - pirm\u0101 k\u013c\u016bda").append(((IterableOnceOps)status.problems().map((Function1<Tuple2, String> & Serializable)x$1 -> {
            String string2 = (String)x$1._1();
            long l = BoxesRunTime.unboxToLong(x$1._2());
            return new StringBuilder(12).append("\n\n- [k\u013c\u016bda] ").append(string2.trim()).append(l > 1L ? new StringBuilder(4).append(" (\u00d7").append(l).append(")").toString() : "").toString();
        })).mkString("")).toString()))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)status.lastErrorTimestamp().map((Function1<Instant, Tuple2> & Serializable)dt -> Tuple2$.MODULE$.apply(dt, new StringBuilder(15).append(MODULE$.format((Instant)dt)).append(" - p\u0113d\u0113j\u0101 k\u013c\u016bda").toString())).filterNot((Function1<Tuple2, boolean> & Serializable)dt_msg -> status.firstErrorTimestamp().exists((Function1<Instant, Object>)(Function1<Instant, boolean> & Serializable)_$2 -> {
            Instant instant = _$2;
            Object T1 = dt_msg._1();
            return !(instant != null ? !((Object)instant).equals(T1) : T1 != null);
        }))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)status.successTimestamp().map((Function1<Instant, Tuple2> & Serializable)dt -> Tuple2$.MODULE$.apply(dt, new StringBuilder(37).append(MODULE$.format((Instant)dt)).append(" - p\u0113d\u0113j\u0101 veiksm\u012bg\u0101 sinhroniz\u0101cija").append("\n- ").append(status.successMessage()).toString()))), Nil$.MODULE$)))).filter((Function1<Option, boolean> & Serializable)_$3 -> _$3.nonEmpty())).map((Function1<Option, Tuple2> & Serializable)_$4 -> (Tuple2)_$4.get())).sorted(Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), Ordering$String$.MODULE$))).map((Function1<Tuple2, String> & Serializable)_$5 -> (String)_$5._2())).mkString("\n\n");
    }

    public Future<BoxedUnit> reportSuccess(String datasetName, String stats) {
        if (reportProblems) {
            None$ none$;
            Instant now = Instant.now();
            Reporter$ reporter$ = this;
            synchronized (reporter$) {
                Reporter.DatasetReportingStatus datasetReportingStatus;
                Option oldOpt = statuses.get(datasetName);
                Reporter.DatasetReportingStatus template = (Reporter.DatasetReportingStatus)oldOpt.orElse(Reporter$::$anonfun$1).get();
                boolean shouldSend = template.errorsReported() || template.problems().nonEmpty() && template.lastReport().nonEmpty() && template.lastReport().get().plus(reportProblemsInterval).isBefore(now);
                Some<Instant> some = Some$.MODULE$.apply(now);
                ListMap<String, Object> listMap = template.copy$default$1();
                Option<Instant> option = template.copy$default$2();
                Option<Instant> option2 = template.copy$default$3();
                boolean bl = template.copy$default$4();
                Option<Instant> option3 = template.copy$default$7();
                Reporter.DatasetReportingStatus statsStatus = template.copy(listMap, option, option2, bl, stats, some, option3);
                if (shouldSend) {
                    Reporter.DatasetReportingStatus datasetReportingStatus2 = Reporter$DatasetReportingStatus$.MODULE$.apply(Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$1(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$2(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$3(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$4(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$5(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$6(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$7());
                    Some<Instant> some2 = Some$.MODULE$.apply(now);
                    Some<Instant> some3 = Some$.MODULE$.apply(now);
                    ListMap<String, Object> listMap2 = datasetReportingStatus2.copy$default$1();
                    Option<Instant> option4 = datasetReportingStatus2.copy$default$2();
                    Option<Instant> option5 = datasetReportingStatus2.copy$default$3();
                    boolean bl2 = datasetReportingStatus2.copy$default$4();
                    datasetReportingStatus = datasetReportingStatus2.copy(listMap2, option4, option5, bl2, stats, some3, some2);
                } else {
                    datasetReportingStatus = statsStatus;
                }
                Reporter.DatasetReportingStatus newStatus = datasetReportingStatus;
                statuses.put(datasetName, newStatus);
                none$ = shouldSend ? Some$.MODULE$.apply(statsStatus) : None$.MODULE$;
            }
            None$ reportableStatusOpt = none$;
            return (Future)reportableStatusOpt.map((Function1<Reporter.DatasetReportingStatus, Future> & Serializable)reportableStatus -> Connector$.MODULE$.infoToDagr().sendMail(new StringBuilder(36).append("Datu kopas ").append(datasetName).append(" sinhroniz\u0101cija veiksm\u012bga").toString(), MODULE$.summary((Reporter.DatasetReportingStatus)reportableStatus))).getOrElse(Reporter$::reportSuccess$$anonfun$2);
        }
        return Future$.MODULE$.successful(BoxedUnit.UNIT);
    }

    public Future<BoxedUnit> reportProblem(String datasetName, String problem, boolean mustSendNow) {
        return this.reportFailure(datasetName, problem, mustSendNow);
    }

    public Future<BoxedUnit> reportFailure(String datasetName, String problem, boolean mustSendNow) {
        if (reportProblems) {
            None$ none$;
            Instant now = Instant.now();
            Reporter$ reporter$ = this;
            synchronized (reporter$) {
                Option oldOpt = statuses.get(datasetName);
                boolean shouldSend = mustSendNow || oldOpt.isEmpty() || oldOpt.exists((Function1<Reporter.DatasetReportingStatus, boolean> & Serializable)old -> old.lastReport().isEmpty() || old.lastReport().get().plus(reportProblemsInterval).isBefore(now));
                Reporter.DatasetReportingStatus template = (Reporter.DatasetReportingStatus)oldOpt.orElse(Reporter$::$anonfun$3).get();
                Option option = shouldSend ? Some$.MODULE$.apply(now) : template.lastReport();
                boolean bl = shouldSend ? true : template.errorsReported();
                ListMap listMap = this.addProblem$1(template.problems(), problem);
                Option<Instant> option2 = template.firstErrorTimestamp().orElse(() -> Reporter$.$anonfun$4(now));
                Some<Instant> some = Some$.MODULE$.apply(now);
                String string2 = template.copy$default$5();
                Option<Instant> option3 = template.copy$default$6();
                Reporter.DatasetReportingStatus newStatus = template.copy(listMap, option2, some, bl, string2, option3, option);
                statuses.put(datasetName, newStatus);
                none$ = shouldSend ? Some$.MODULE$.apply(newStatus) : None$.MODULE$;
            }
            None$ reportableStatusOpt = none$;
            return (Future)reportableStatusOpt.map((Function1<Reporter.DatasetReportingStatus, Future> & Serializable)reportableStatus -> Connector$.MODULE$.infoToDagr().sendMail(new StringBuilder(33).append("Datu kopas ").append(datasetName).append(" sinhroniz\u0101cijas k\u013c\u016bda").toString(), MODULE$.summary((Reporter.DatasetReportingStatus)reportableStatus))).getOrElse(Reporter$::reportFailure$$anonfun$2);
        }
        return Future$.MODULE$.successful(BoxedUnit.UNIT);
    }

    private final Duration $init$$$anonfun$2() {
        return minInterval;
    }

    private static final Option $anonfun$1() {
        return Some$.MODULE$.apply(Reporter$DatasetReportingStatus$.MODULE$.apply(Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$1(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$2(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$3(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$4(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$5(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$6(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$7()));
    }

    private static final Future reportSuccess$$anonfun$2() {
        return Future$.MODULE$.successful(BoxedUnit.UNIT);
    }

    private final ListMap addProblem$1(ListMap problems, String problem) {
        if (problems.contains(problem)) {
            String string2 = Predef$.MODULE$.ArrowAssoc(problem);
            return (ListMap)problems.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToLong(BoxesRunTime.unboxToLong(problems.apply(problem)) + 1L)));
        }
        if (problems.size() < maxProblems) {
            String string3 = Predef$.MODULE$.ArrowAssoc(problem);
            return (ListMap)problems.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToLong(1L)));
        }
        String string4 = Predef$.MODULE$.ArrowAssoc("(citas probl\u0113mas)");
        String string5 = Predef$.MODULE$.ArrowAssoc(problem);
        return (ListMap)((MapOps)problems.take(maxProblems - 2)).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, ((IterableOnceOps)((StrictOptimizedIterableOps)problems.drop(maxProblems - 2)).map((Function1<Tuple2, long> & Serializable)_$6 -> BoxesRunTime.unboxToLong(_$6._2()))).sum(Numeric$LongIsIntegral$.MODULE$))).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, BoxesRunTime.boxToLong(1L)));
    }

    private static final Option $anonfun$3() {
        return Some$.MODULE$.apply(Reporter$DatasetReportingStatus$.MODULE$.apply(Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$1(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$2(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$3(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$4(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$5(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$6(), Reporter$DatasetReportingStatus$.MODULE$.$lessinit$greater$default$7()));
    }

    private static final Option $anonfun$4(Instant now$2) {
        return Some$.MODULE$.apply(now$2);
    }

    private static final Future reportFailure$$anonfun$2() {
        return Future$.MODULE$.successful(BoxedUnit.UNIT);
    }
}

