/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import dagr.Connector$;
import dagr.DataFromFprAnalyzer$;
import dagr.HttpClient;
import dagr.RemoteDataValueStatus;
import dagr.RemoteHasValueInfo;
import dagr.RemoteHasValueInfo$;
import dagr.RemoteRecordInfo;
import dagr.RemoteRecordInfo$;
import dagr.RemoteRecordInfoApplied;
import dagr.RemoteRecordInfoApplied$;
import dagr.RemoteRecordTimestampInfo;
import dagr.RemoteRecordTimestampInfo$;
import dagr.SecurityTokenServiceClient;
import dagr.SyncType;
import dagr.SyncTypeCheckHasValue$;
import dagr.SyncTypeCheckTimestamps$;
import dagr.SyncTypeDiffAll$;
import dagr.SyncTypeDiffAllApplied$;
import dagr.SyncTypeDiffAndTimestamps$;
import dagr.SyncTypeForwardAll$;
import dagr.Token;
import io.bullet.borer.Decoder;
import io.bullet.borer.Decoder$;
import io.bullet.borer.Default$;
import io.bullet.borer.InputReader;
import io.bullet.borer.Nullable$package$Nullable$;
import io.bullet.borer.Reader;
import io.bullet.borer.compat.pekkoHttp$;
import io.bullet.borer.derivation.helpers.package$package$;
import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.common.EntityStreamingSupport;
import org.apache.pekko.http.scaladsl.common.JsonEntityStreamingSupport;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.headers.Accept$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Success;
import scala.util.Try;

public class RemoteDataStatus
implements RemoteDataValueStatus {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RemoteDataStatus.class.getDeclaredField("datasetTypeCount$lzy1"));
    private final Config config;
    private final SyncType syncType;
    private final Decoder<RemoteHasValueInfo> hasValueInfoDecoder;
    private final Decoder<RemoteRecordInfo> recordInfoDecoder;
    private final Decoder<RemoteRecordInfoApplied> recordInfoAppliedDecoder;
    private final Decoder<RemoteRecordTimestampInfo> recordTsInfoDecoder;
    public Status dagr$RemoteDataStatus$$currentStatus;
    private final Logger logger;
    private final Logger progress;
    private final boolean dry_run_full;
    private final String dataset_name;
    private final String target_server_uri;
    private final Set<String> ignorable_unexpected_field_names;
    private volatile Object datasetTypeCount$lzy1;

    public RemoteDataStatus(Config config, String dataset_full_name, SyncType syncType) {
        Set set;
        String string2;
        String string3;
        this.config = config;
        this.syncType = syncType;
        Decoder<RemoteHasValueInfo> decoder$proxy1 = r -> {
            if (r.tryReadMapStart()) {
                return RemoteDataStatus.readObject$1(r, -1);
            }
            if (r.hasMapHeader()) {
                long mapLength = r.readMapHeader();
                if (mapLength > Integer.MAX_VALUE) {
                    throw r.overflow("Maps with more than 2^31 entries are not supported");
                }
                return RemoteDataStatus.readObject$1(r, (int)mapLength);
            }
            throw r.unexpectedDataItem("Map Start or Map Header for decoding an instance of type `RemoteHasValueInfo`");
        };
        this.hasValueInfoDecoder = decoder$proxy1;
        Decoder x = Decoder$.MODULE$.recursive(RemoteDataStatus::$anonfun$2);
        Decoder<RemoteRecordInfo> decoder$proxy2 = r -> {
            if (r.tryReadMapStart()) {
                return RemoteDataStatus.readObject$2(r, x, -1);
            }
            if (r.hasMapHeader()) {
                long mapLength = r.readMapHeader();
                if (mapLength > Integer.MAX_VALUE) {
                    throw r.overflow("Maps with more than 2^31 entries are not supported");
                }
                return RemoteDataStatus.readObject$2(r, x, (int)mapLength);
            }
            throw r.unexpectedDataItem("Map Start or Map Header for decoding an instance of type `RemoteRecordInfo`");
        };
        this.recordInfoDecoder = decoder$proxy2;
        Decoder x2 = Decoder$.MODULE$.recursive(RemoteDataStatus::$anonfun$4);
        Decoder<RemoteRecordInfoApplied> decoder$proxy3 = r -> {
            if (r.tryReadMapStart()) {
                return RemoteDataStatus.readObject$3(r, x2, -1);
            }
            if (r.hasMapHeader()) {
                long mapLength = r.readMapHeader();
                if (mapLength > Integer.MAX_VALUE) {
                    throw r.overflow("Maps with more than 2^31 entries are not supported");
                }
                return RemoteDataStatus.readObject$3(r, x2, (int)mapLength);
            }
            throw r.unexpectedDataItem("Map Start or Map Header for decoding an instance of type `RemoteRecordInfoApplied`");
        };
        this.recordInfoAppliedDecoder = decoder$proxy3;
        Decoder<RemoteRecordTimestampInfo> decoder$proxy4 = r -> {
            if (r.tryReadMapStart()) {
                return RemoteDataStatus.readObject$4(r, -1);
            }
            if (r.hasMapHeader()) {
                long mapLength = r.readMapHeader();
                if (mapLength > Integer.MAX_VALUE) {
                    throw r.overflow("Maps with more than 2^31 entries are not supported");
                }
                return RemoteDataStatus.readObject$4(r, (int)mapLength);
            }
            throw r.unexpectedDataItem("Map Start or Map Header for decoding an instance of type `RemoteRecordTimestampInfo`");
        };
        this.recordTsInfoDecoder = decoder$proxy4;
        this.dagr$RemoteDataStatus$$currentStatus = null;
        this.logger = LoggerFactory.getLogger("dagr.data");
        this.progress = LoggerFactory.getLogger("dagr.progress");
        this.dry_run_full = config.getBoolean("dry_run_full");
        long progress_report_interval_ms = config.getDuration("progress_report_interval").toMillis();
        if (dataset_full_name.startsWith("sandbox/")) {
            Object object = Predef$.MODULE$.refArrayOps(dataset_full_name.split("/"));
            string3 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.drop$extension(object, 2)).mkString("/");
        } else {
            string3 = this.dataset_name = dataset_full_name;
        }
        if (dataset_full_name.startsWith("sandbox/")) {
            Object object = Predef$.MODULE$.refArrayOps(dataset_full_name.split("/"));
            string2 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object, 2)).mkString("/", "/", "");
        } else {
            string2 = "";
        }
        String maybe_sandbox = string2;
        this.target_server_uri = new StringBuilder(0).append(config.getString("target_server_uri")).append(maybe_sandbox).toString();
        if (config.hasPath("ignorable_unexpected_field_names")) {
            ConfigValueType configValueType = config.getValue("ignorable_unexpected_field_names").valueType();
            ConfigValueType configValueType2 = ConfigValueType.STRING;
            set = !(configValueType != null ? !((Object)((Object)configValueType)).equals((Object)configValueType2) : configValueType2 != null) ? (Set)Predef$.MODULE$.wrapRefArray(config.getString("ignorable_unexpected_field_names").split("[\\s,]")).toSet().filter((Function1<String, boolean> & Serializable)_$1 -> {
                String string2 = _$1;
                String string3 = "";
                return string2 == null ? string3 != null : !string2.equals(string3);
            }) : CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList("ignorable_unexpected_field_names")).asScala().toSet();
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        this.ignorable_unexpected_field_names = set;
    }

    public Decoder<RemoteHasValueInfo> hasValueInfoDecoder() {
        return this.hasValueInfoDecoder;
    }

    public Decoder<RemoteRecordInfo> recordInfoDecoder() {
        return this.recordInfoDecoder;
    }

    public Decoder<RemoteRecordInfoApplied> recordInfoAppliedDecoder() {
        return this.recordInfoAppliedDecoder;
    }

    public Decoder<RemoteRecordTimestampInfo> recordTsInfoDecoder() {
        return this.recordTsInfoDecoder;
    }

    public long reportProgress(int count, long reportAt) {
        if (reportAt <= System.currentTimeMillis()) {
            this.progress.info(new StringBuilder(59).append("Remote data status retrieval in progress: received ").append(count).append(" records").toString());
            return Connector$.MODULE$.nextReportAt(reportAt);
        }
        return reportAt;
    }

    public <T> Unmarshaller<HttpEntity, Source<T, NotUsed>> largeFrameJsonStreamUnmarshaller(Decoder<T> evidence$1) {
        return pekkoHttp$.MODULE$.borerStreamUnmarshaller((EntityStreamingSupport)new JsonEntityStreamingSupport(0x800000), (Decoder)evidence$1);
    }

    private int datasetTypeCount() {
        Object object = this.datasetTypeCount$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt(object);
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt(this.datasetTypeCount$lzyINIT1());
    }

    private Object datasetTypeCount$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.datasetTypeCount$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger(DataFromFprAnalyzer$.MODULE$.fieldToIndex().size());
                        serializable = n == null ? LazyVals$NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.datasetTypeCount$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Map<String, byte[]> updatedMapForHasValue(Map<String, byte[]> map, String key2, boolean has_value) {
        Object[] parts = key2.split("/", 2);
        Object object = Predef$.MODULE$.refArrayOps(parts);
        if (ArrayOps$.MODULE$.size$extension(object) != 2) {
            throw package$.MODULE$.error(new StringBuilder(52).append("Unexpected format for key ").append(key2).append(". Expecting code/fieldName").toString());
        }
        Object code = parts[0];
        Object fieldName = parts[1];
        return (Map)DataFromFprAnalyzer$.MODULE$.fieldToIndex().get((String)fieldName).map(arg_0 -> this.updatedMapForHasValue$$anonfun$adapted$1(has_value, map, (String)code, arg_0)).getOrElse(() -> this.updatedMapForHasValue$$anonfun$2((String)fieldName, map));
    }

    public Map<String, byte[]> updatedHashes(Map<String, byte[]> hashes, String key2, String value) {
        SyncType syncType = this.syncType;
        if (this.syncType.doDiff()) {
            throw package$.MODULE$.error("Unexpected sync type for updatedHashes");
        }
        if (SyncTypeCheckHasValue$.MODULE$.equals(syncType)) {
            return this.updatedMapForHasValue(hashes, key2, value != null);
        }
        return hashes;
    }

    @Override
    public boolean hasValue(String key2) {
        SyncType syncType = this.syncType;
        if (SyncTypeCheckHasValue$.MODULE$.equals(syncType)) {
            Object[] parts = key2.split("/", 2);
            Object object = Predef$.MODULE$.refArrayOps(parts);
            if (ArrayOps$.MODULE$.size$extension(object) != 2) {
                throw package$.MODULE$.error(new StringBuilder(52).append("Unexpected format for key ").append(key2).append(". Expecting code/fieldName").toString());
            }
            Object code = parts[0];
            Object fieldName = parts[1];
            return BoxesRunTime.unboxToBoolean(DataFromFprAnalyzer$.MODULE$.fieldToIndex().get((String)fieldName).map(arg_0 -> this.hasValue$$anonfun$1((String)code, arg_0)).getOrElse(() -> this.hasValue$$anonfun$2((String)fieldName)));
        }
        throw package$.MODULE$.error(new StringBuilder(47).append("Unexpected call to hasValue(key) for sync type ").append(this.syncType).toString());
    }

    public Future<Status> apply(HttpClient http, SecurityTokenServiceClient tokenS, ActorSystem system, ExecutionContext ec) {
        Future future;
        Status status;
        RemoteDataStatus remoteDataStatus = this;
        synchronized (remoteDataStatus) {
            status = this.dagr$RemoteDataStatus$$currentStatus;
        }
        Status status2 = status;
        if (status2 != null) {
            return Future$.MODULE$.successful(status2);
        }
        if (this.dry_run_full) {
            Future<Status> future2;
            RemoteDataStatus remoteDataStatus2 = this;
            synchronized (remoteDataStatus2) {
                this.dagr$RemoteDataStatus$$currentStatus = new Status(this, (Map<String, byte[]>)Predef$.MODULE$.Map().empty(), None$.MODULE$);
                future2 = Future$.MODULE$.successful(this.dagr$RemoteDataStatus$$currentStatus);
            }
            return future2;
        }
        SyncType syncType = this.syncType;
        if (SyncTypeDiffAll$.MODULE$.equals(syncType)) {
            future = this.loadRemoteStatus$1(tokenS, http, ec, system);
        } else if (SyncTypeDiffAllApplied$.MODULE$.equals(syncType)) {
            future = this.loadRemoteStatusApplied$1(tokenS, http, ec, system);
        } else if (SyncTypeForwardAll$.MODULE$.equals(syncType)) {
            future = Future$.MODULE$.successful(new Status(this, (Map<String, byte[]>)Predef$.MODULE$.Map().empty(), None$.MODULE$));
        } else if (SyncTypeCheckHasValue$.MODULE$.equals(syncType)) {
            future = this.loadHasValue$1(tokenS, http, ec, system);
        } else if (SyncTypeCheckTimestamps$.MODULE$.equals(syncType)) {
            future = this.loadLastTimestamp$1(tokenS, http, ec, system);
        } else if (SyncTypeDiffAndTimestamps$.MODULE$.equals(syncType)) {
            future = this.loadLastTimestamp$1(tokenS, http, ec, system).flatMap((Function1<Status, Future> & Serializable)ts -> this.loadRemoteStatus$1(tokenS, http, ec, system).map((Function1<Status, Status> & Serializable)rs -> new Status(this, rs.hashes(), ts.timestampInfo()), ec), ec);
        } else {
            throw new MatchError(syncType);
        }
        return future.andThen(new Serializable(this){
            private final /* synthetic */ RemoteDataStatus $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Try x) {
                Try try_ = x;
                if (try_ instanceof Success) {
                    Status status = (Status)((Success)try_).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Try try_ = x;
                if (try_ instanceof Success) {
                    BoxedUnit boxedUnit;
                    Status status = (Status)((Success)try_).value();
                    RemoteDataStatus remoteDataStatus = this.$outer;
                    synchronized (remoteDataStatus) {
                        this.$outer.dagr$RemoteDataStatus$$currentStatus = status;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                return function1.apply(x);
            }
        }, ec);
    }

    public void clear() {
        RemoteDataStatus remoteDataStatus = this;
        synchronized (remoteDataStatus) {
            this.dagr$RemoteDataStatus$$currentStatus = null;
        }
    }

    private static final void read$1(InputReader r$2, IntRef mask$1, BooleanRef x$1, LongRef x$2, ObjectRef x$3) {
        int cmp = r$2.tryReadStringCompare("key");
        if (cmp < 0) {
            if (r$2.tryReadStringCompare("has_value") == 0) {
                if ((mask$1.elem & 4) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$2, "has_value", "RemoteHasValueInfo");
                }
                x$1.elem = r$2.readBoolean();
                mask$1.elem |= 4;
                return;
            }
            InputReader InputReader_this = r$2;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if (cmp > 0) {
            if (r$2.tryReadStringCompare("offset") == 0) {
                if ((mask$1.elem & 2) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$2, "offset", "RemoteHasValueInfo");
                }
                x$2.elem = r$2.readLong();
                mask$1.elem |= 2;
                return;
            }
            InputReader InputReader_this = r$2;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if ((mask$1.elem & 1) != 0) {
            throw package$package$.MODULE$.failDuplicateMapKey(r$2, "key", "RemoteHasValueInfo");
        }
        x$3.elem = r$2.readString();
        mask$1.elem |= 1;
    }

    private static final Nothing$ failMissing$1(InputReader r$3, int testMask$1) {
        return package$package$.MODULE$.failMissing((InputReader<? extends Reader.Config>)r$3, "RemoteHasValueInfo", testMask$1, (List<String>)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"key"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"offset"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"has_value"), Nil$.MODULE$))))));
    }

    private static final RemoteHasValueInfo readObject$1(InputReader r$1, int count) {
        boolean bl;
        long l;
        String string2;
        int rem = count;
        IntRef mask = IntRef.create(0);
        if (rem != 0 && r$1.tryReadString("key")) {
            mask.elem |= 1;
            --rem;
            string2 = r$1.readString();
        } else {
            string2 = null;
        }
        ObjectRef<Object> x = ObjectRef.create(string2);
        if (rem != 0 && r$1.tryReadString("offset")) {
            mask.elem |= 2;
            --rem;
            l = r$1.readLong();
        } else {
            l = BoxesRunTime.unboxToLong(null);
        }
        LongRef x2 = LongRef.create(l);
        if (rem != 0 && r$1.tryReadString("has_value")) {
            mask.elem |= 4;
            --rem;
            bl = r$1.readBoolean();
        } else {
            bl = BoxesRunTime.unboxToBoolean(null);
        }
        BooleanRef x3 = BooleanRef.create(bl);
        while (rem > 0 || rem < 0 && !r$1.tryReadBreak()) {
            Object object;
            if (mask.elem != 7) {
                RemoteDataStatus.read$1(r$1, mask, x3, x2, x);
                object = BoxedUnit.UNIT;
            } else {
                InputReader InputReader_this = r$1;
                object = InputReader_this.skipElement().skipElement();
            }
            --rem;
        }
        int testMask = mask.elem | 0xFFFFFFF8;
        if (testMask == -1) {
            return RemoteHasValueInfo$.MODULE$.apply((String)x.elem, x2.elem, x3.elem);
        }
        throw RemoteDataStatus.failMissing$1(r$1, testMask);
    }

    private static final Decoder $anonfun$2() {
        return Nullable$package$Nullable$.MODULE$.decoder(Decoder$.MODULE$.forString(), Default$.MODULE$.string());
    }

    private static final void read$2(InputReader r$5, IntRef mask$2, ObjectRef x$6, ObjectRef x$7, Decoder x$8, LongRef x$9) {
        int cmp = r$5.tryReadStringCompare("offset");
        if (cmp < 0) {
            if (r$5.tryReadStringCompare("key") == 0) {
                if ((mask$2.elem & 1) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$5, "key", "RemoteRecordInfo");
                }
                x$6.elem = r$5.readString();
                mask$2.elem |= 1;
                return;
            }
            InputReader InputReader_this = r$5;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if (cmp > 0) {
            if (r$5.tryReadStringCompare("sha256") == 0) {
                if ((mask$2.elem & 4) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$5, "sha256", "RemoteRecordInfo");
                }
                InputReader InputReader_this = r$5;
                x$7.elem = (String)x$8.read(InputReader_this);
                mask$2.elem |= 4;
                return;
            }
            InputReader InputReader_this = r$5;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if ((mask$2.elem & 2) != 0) {
            throw package$package$.MODULE$.failDuplicateMapKey(r$5, "offset", "RemoteRecordInfo");
        }
        x$9.elem = r$5.readLong();
        mask$2.elem |= 2;
    }

    private static final Nothing$ failMissing$2(InputReader r$6, int testMask$2) {
        return package$package$.MODULE$.failMissing((InputReader<? extends Reader.Config>)r$6, "RemoteRecordInfo", testMask$2, (List<String>)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"key"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"offset"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"sha256"), Nil$.MODULE$))))));
    }

    private static final RemoteRecordInfo readObject$2(InputReader r$4, Decoder x$4, int count) {
        String string2;
        long l;
        String string3;
        int rem = count;
        IntRef mask = IntRef.create(0);
        if (rem != 0 && r$4.tryReadString("key")) {
            mask.elem |= 1;
            --rem;
            string3 = r$4.readString();
        } else {
            string3 = null;
        }
        ObjectRef<Object> x = ObjectRef.create(string3);
        if (rem != 0 && r$4.tryReadString("offset")) {
            mask.elem |= 2;
            --rem;
            l = r$4.readLong();
        } else {
            l = BoxesRunTime.unboxToLong(null);
        }
        LongRef x2 = LongRef.create(l);
        if (rem != 0 && r$4.tryReadString("sha256")) {
            mask.elem |= 4;
            --rem;
            InputReader InputReader_this = r$4;
            string2 = (String)x$4.read(InputReader_this);
        } else {
            string2 = null;
        }
        ObjectRef<Object> x3 = ObjectRef.create(string2);
        while (rem > 0 || rem < 0 && !r$4.tryReadBreak()) {
            Object object;
            if (mask.elem != 7) {
                RemoteDataStatus.read$2(r$4, mask, x, x3, x$4, x2);
                object = BoxedUnit.UNIT;
            } else {
                InputReader InputReader_this = r$4;
                object = InputReader_this.skipElement().skipElement();
            }
            --rem;
        }
        int testMask = mask.elem | 0xFFFFFFF8;
        if (testMask == -1) {
            return RemoteRecordInfo$.MODULE$.apply((String)x.elem, x2.elem, (String)x3.elem);
        }
        throw RemoteDataStatus.failMissing$2(r$4, testMask);
    }

    private static final Decoder $anonfun$4() {
        return Nullable$package$Nullable$.MODULE$.decoder(Decoder$.MODULE$.forString(), Default$.MODULE$.string());
    }

    private static final void read$3(InputReader r$8, IntRef mask$3, ObjectRef x$12, ObjectRef x$13, Decoder x$14) {
        int cmp = r$8.tryReadStringCompare("sha256");
        if (cmp < 0) {
            if (r$8.tryReadStringCompare("key") == 0) {
                if ((mask$3.elem & 1) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$8, "key", "RemoteRecordInfoApplied");
                }
                x$12.elem = r$8.readString();
                mask$3.elem |= 1;
                return;
            }
            InputReader InputReader_this = r$8;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if (cmp > 0) {
            InputReader InputReader_this = r$8;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if ((mask$3.elem & 2) != 0) {
            throw package$package$.MODULE$.failDuplicateMapKey(r$8, "sha256", "RemoteRecordInfoApplied");
        }
        InputReader InputReader_this = r$8;
        x$13.elem = (String)x$14.read(InputReader_this);
        mask$3.elem |= 2;
    }

    private static final Nothing$ failMissing$3(InputReader r$9, int testMask$3) {
        return package$package$.MODULE$.failMissing((InputReader<? extends Reader.Config>)r$9, "RemoteRecordInfoApplied", testMask$3, (List<String>)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"key"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"sha256"), Nil$.MODULE$)))));
    }

    private static final RemoteRecordInfoApplied readObject$3(InputReader r$7, Decoder x$10, int count) {
        String string2;
        String string3;
        int rem = count;
        IntRef mask = IntRef.create(0);
        if (rem != 0 && r$7.tryReadString("key")) {
            mask.elem |= 1;
            --rem;
            string3 = r$7.readString();
        } else {
            string3 = null;
        }
        ObjectRef<Object> x = ObjectRef.create(string3);
        if (rem != 0 && r$7.tryReadString("sha256")) {
            mask.elem |= 2;
            --rem;
            InputReader InputReader_this = r$7;
            string2 = (String)x$10.read(InputReader_this);
        } else {
            string2 = null;
        }
        ObjectRef<Object> x2 = ObjectRef.create(string2);
        while (rem > 0 || rem < 0 && !r$7.tryReadBreak()) {
            Object object;
            if (mask.elem != 3) {
                RemoteDataStatus.read$3(r$7, mask, x, x2, x$10);
                object = BoxedUnit.UNIT;
            } else {
                InputReader InputReader_this = r$7;
                object = InputReader_this.skipElement().skipElement();
            }
            --rem;
        }
        int testMask = mask.elem | 0xFFFFFFFC;
        if (testMask == -1) {
            return RemoteRecordInfoApplied$.MODULE$.apply((String)x.elem, (String)x2.elem);
        }
        throw RemoteDataStatus.failMissing$3(r$7, testMask);
    }

    private static final void read$4(InputReader r$11, IntRef mask$4, ObjectRef x$15, ObjectRef x$16, LongRef x$17) {
        int cmp = r$11.tryReadStringCompare("offset");
        if (cmp < 0) {
            if (r$11.tryReadStringCompare("key") == 0) {
                if ((mask$4.elem & 1) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$11, "key", "RemoteRecordTimestampInfo");
                }
                x$15.elem = r$11.readString();
                mask$4.elem |= 1;
                return;
            }
            InputReader InputReader_this = r$11;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if (cmp > 0) {
            if (r$11.tryReadStringCompare("timestamp") == 0) {
                if ((mask$4.elem & 4) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$11, "timestamp", "RemoteRecordTimestampInfo");
                }
                x$16.elem = r$11.readString();
                mask$4.elem |= 4;
                return;
            }
            InputReader InputReader_this = r$11;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if ((mask$4.elem & 2) != 0) {
            throw package$package$.MODULE$.failDuplicateMapKey(r$11, "offset", "RemoteRecordTimestampInfo");
        }
        x$17.elem = r$11.readLong();
        mask$4.elem |= 2;
    }

    private static final Nothing$ failMissing$4(InputReader r$12, int testMask$4) {
        return package$package$.MODULE$.failMissing((InputReader<? extends Reader.Config>)r$12, "RemoteRecordTimestampInfo", testMask$4, (List<String>)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"key"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"offset"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"timestamp"), Nil$.MODULE$))))));
    }

    private static final RemoteRecordTimestampInfo readObject$4(InputReader r$10, int count) {
        String string2;
        long l;
        String string3;
        int rem = count;
        IntRef mask = IntRef.create(0);
        if (rem != 0 && r$10.tryReadString("key")) {
            mask.elem |= 1;
            --rem;
            string3 = r$10.readString();
        } else {
            string3 = null;
        }
        ObjectRef<Object> x = ObjectRef.create(string3);
        if (rem != 0 && r$10.tryReadString("offset")) {
            mask.elem |= 2;
            --rem;
            l = r$10.readLong();
        } else {
            l = BoxesRunTime.unboxToLong(null);
        }
        LongRef x2 = LongRef.create(l);
        if (rem != 0 && r$10.tryReadString("timestamp")) {
            mask.elem |= 4;
            --rem;
            string2 = r$10.readString();
        } else {
            string2 = null;
        }
        ObjectRef<Object> x3 = ObjectRef.create(string2);
        while (rem > 0 || rem < 0 && !r$10.tryReadBreak()) {
            Object object;
            if (mask.elem != 7) {
                RemoteDataStatus.read$4(r$10, mask, x, x3, x2);
                object = BoxedUnit.UNIT;
            } else {
                InputReader InputReader_this = r$10;
                object = InputReader_this.skipElement().skipElement();
            }
            --rem;
        }
        int testMask = mask.elem | 0xFFFFFFF8;
        if (testMask == -1) {
            return RemoteRecordTimestampInfo$.MODULE$.apply((String)x.elem, x2.elem, (String)x3.elem);
        }
        throw RemoteDataStatus.failMissing$4(r$10, testMask);
    }

    private static final byte $anonfun$7() {
        return 0;
    }

    private final /* synthetic */ Map updatedMapForHasValue$$anonfun$1(boolean has_value$1, Map map$1, String code$1, int index) {
        int b;
        int n = b = has_value$1 ? -1 : 0;
        if (map$1.contains(code$1)) {
            ((byte[])map$1.apply(code$1))[index] = b;
            return map$1;
        }
        byte[] bytes = (byte[])Array$.MODULE$.fill(this.datasetTypeCount(), RemoteDataStatus::$anonfun$7, ClassTag$.MODULE$.apply(Byte.TYPE));
        bytes[index] = b;
        String string2 = Predef$.MODULE$.ArrowAssoc(code$1);
        return (Map)map$1.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, bytes));
    }

    private final Map updatedMapForHasValue$$anonfun$2(String fieldName$1, Map map$2) {
        if (this.ignorable_unexpected_field_names.contains(fieldName$1)) {
            return map$2;
        }
        throw package$.MODULE$.error(new StringBuilder(22).append("Unexpected fieldName: ").append(fieldName$1).toString());
    }

    private final /* synthetic */ boolean hasValue$$anonfun$1(String code$2, int index) {
        return this.dagr$RemoteDataStatus$$currentStatus.hashes().get(code$2).exists((Function1<byte[], boolean> & Serializable)_$2 -> _$2[index] == -1);
    }

    private final boolean hasValue$$anonfun$2(String fieldName$2) {
        if (this.ignorable_unexpected_field_names.contains(fieldName$2)) {
            return false;
        }
        throw package$.MODULE$.error(new StringBuilder(22).append("Unexpected fieldName: ").append(fieldName$2).toString());
    }

    private static final /* synthetic */ boolean $anonfun$8$$anonfun$1(byte _$5) {
        return _$5 == -1;
    }

    private static final /* synthetic */ long $anonfun$8(long _$3, Tuple2 _$4) {
        Object object = Predef$.MODULE$.byteArrayOps((byte[])_$4._2());
        return _$3 + (long)ArrayOps$.MODULE$.count$extension(object, (Function1<Object, boolean> & Serializable)_$5 -> RemoteDataStatus.$anonfun$8$$anonfun$1(BoxesRunTime.unboxToByte(_$5)));
    }

    private final Future loadHasValue$1(SecurityTokenServiceClient tokenS$1, HttpClient http$1, ExecutionContext ec$1, ActorSystem system$1) {
        this.logger.info(new StringBuilder(44).append("Requesting current data existence from ").append(this.target_server_uri).append(" for ").append(this.dataset_name).toString());
        return tokenS$1.getToken().flatMap((Function1<Token, Future> & Serializable)token -> {
            Tuple2[] tuple2Array = new Tuple2[1];
            String string2 = Predef$.MODULE$.ArrowAssoc("offset");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, "0");
            return http$1.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(new StringBuilder(19).append(this.target_server_uri).append("/updates_has_value/").append(this.dataset_name).toString()).withQuery(Uri$Query$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), http$1.doRequest$default$2(), http$1.doRequest$default$3(), http$1.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)request -> Unmarshal$.MODULE$.apply(request.entity()).to(this.largeFrameJsonStreamUnmarshaller(this.hasValueInfoDecoder()), Predef$.MODULE$.implicitly(ec$1), Predef$.MODULE$.implicitly(Materializer$.MODULE$.matFromSystem(system$1))).flatMap((Function1<Source, Future> & Serializable)records -> ((Source)((Source)records.recover((PartialFunction)((Object)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable e = throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable e = throwable;
                        throw e;
                    }
                    return function1.apply(x);
                }
            }))).named("remote-data-has-value-reader")).runWith(Sink$.MODULE$.fold(Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(0), Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), BoxesRunTime.boxToLong(Connector$.MODULE$.nextReportAt(Connector$.MODULE$.nextReportAt$default$1()))), (Function2<Tuple3, RemoteHasValueInfo, Tuple3> & Serializable)(x$1, x$2) -> {
                Tuple3 tuple3;
                Tuple2<Tuple3, RemoteHasValueInfo> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null && (tuple3 = tuple2._1()) != null) {
                    int count = BoxesRunTime.unboxToInt(tuple3._1());
                    Map map = (Map)tuple3._2();
                    long reportAt = BoxesRunTime.unboxToLong(tuple3._3());
                    RemoteHasValueInfo record = tuple2._2();
                    Map<String, byte[]> updated = this.updatedMapForHasValue(map, record.key(), record.has_value());
                    return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(count + 1), updated, BoxesRunTime.boxToLong(this.reportProgress(count, reportAt)));
                }
                throw new MatchError(tuple2);
            }), Materializer$.MODULE$.matFromSystem(system$1)).map((Function1<Tuple3, Map> & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    int count = BoxesRunTime.unboxToInt(tuple3._1());
                    Map map = (Map)tuple3._2();
                    long datasetCount = BoxesRunTime.unboxToLong(map.foldLeft(BoxesRunTime.boxToLong(0L), (Function2<Object, Object, long> & Serializable)(_$3, _$4) -> RemoteDataStatus.$anonfun$8(BoxesRunTime.unboxToLong(_$3), (Tuple2)_$4)));
                    this.logger.info(new StringBuilder(37).append("Remote data status: received ").append(count).append(" records").append(new StringBuilder(35).append(", compacted to ").append(datasetCount).append(" datasets for ").append(map.size()).append(" codes").toString()).toString());
                    return map;
                }
                throw new MatchError(tuple3);
            }, ec$1).map((Function1<Map, Status> & Serializable)keyToHash -> new Status(this, (Map<String, byte[]>)keyToHash, None$.MODULE$), ec$1), ec$1), ec$1);
        }, ec$1);
    }

    private final Future loadRemoteStatus$1(SecurityTokenServiceClient tokenS$2, HttpClient http$3, ExecutionContext ec$5, ActorSystem system$5) {
        this.logger.info(new StringBuilder(41).append("Requesting current data status from ").append(this.target_server_uri).append(" for ").append(this.dataset_name).toString());
        return tokenS$2.getToken().flatMap((Function1<Token, Future> & Serializable)token -> {
            Tuple2[] tuple2Array = new Tuple2[1];
            String string2 = Predef$.MODULE$.ArrowAssoc("offset");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, "0");
            return http$3.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(new StringBuilder(16).append(this.target_server_uri).append("/updates_sha256/").append(this.dataset_name).toString()).withQuery(Uri$Query$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), http$3.doRequest$default$2(), http$3.doRequest$default$3(), http$3.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)request -> Unmarshal$.MODULE$.apply(request.entity()).to(this.largeFrameJsonStreamUnmarshaller(this.recordInfoDecoder()), Predef$.MODULE$.implicitly(ec$5), Predef$.MODULE$.implicitly(Materializer$.MODULE$.matFromSystem(system$5))).flatMap((Function1<Source, Future> & Serializable)records -> ((Source)((Source)records.recover((PartialFunction)((Object)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable e = throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable e = throwable;
                        throw e;
                    }
                    return function1.apply(x);
                }
            }))).named("remote-data-status-reader")).runWith(Sink$.MODULE$.fold(Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(0), Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), BoxesRunTime.boxToLong(Connector$.MODULE$.nextReportAt(Connector$.MODULE$.nextReportAt$default$1()))), (Function2<Tuple3, RemoteRecordInfo, Tuple3> & Serializable)(x$1, x$2) -> {
                Tuple3 tuple3;
                Tuple2<Tuple3, RemoteRecordInfo> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null && (tuple3 = tuple2._1()) != null) {
                    Map map;
                    int count = BoxesRunTime.unboxToInt(tuple3._1());
                    Map map2 = (Map)tuple3._2();
                    long reportAt = BoxesRunTime.unboxToLong(tuple3._3());
                    RemoteRecordInfo record = tuple2._2();
                    if (record.sha256().isEmpty()) {
                        map = (Map)map2.$minus(record.key());
                    } else {
                        String string2 = Predef$.MODULE$.ArrowAssoc(record.key());
                        map = (Map)map2.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(record.sha256()), 2, 2).map((Function1<String, byte> & Serializable)_$6 -> (byte)Integer.parseInt(_$6, 16)).toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
                    }
                    Map updated = map;
                    return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(count + 1), updated, BoxesRunTime.boxToLong(this.reportProgress(count, reportAt)));
                }
                throw new MatchError(tuple2);
            }), Materializer$.MODULE$.matFromSystem(system$5)).map((Function1<Tuple3, Map> & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    int count = BoxesRunTime.unboxToInt(tuple3._1());
                    Map map = (Map)tuple3._2();
                    this.logger.info(new StringBuilder(37).append("Remote data status: received ").append(count).append(" records").append(count == map.size() ? "" : new StringBuilder(23).append(", compacted to ").append(map.size()).append(" records").toString()).toString());
                    return map;
                }
                throw new MatchError(tuple3);
            }, ec$5).map((Function1<Map, Status> & Serializable)keyToHash -> new Status(this, (Map<String, byte[]>)keyToHash, None$.MODULE$), ec$5), ec$5), ec$5);
        }, ec$5);
    }

    private final Future loadRemoteStatusApplied$1(SecurityTokenServiceClient tokenS$3, HttpClient http$5, ExecutionContext ec$9, ActorSystem system$9) {
        this.logger.info(new StringBuilder(49).append("Requesting current applied data status from ").append(this.target_server_uri).append(" for ").append(this.dataset_name).toString());
        return tokenS$3.getToken().flatMap((Function1<Token, Future> & Serializable)token -> http$5.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(new StringBuilder(24).append(this.target_server_uri).append("/updates_sha256_applied/").append(this.dataset_name).toString()), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), http$5.doRequest$default$2(), http$5.doRequest$default$3(), http$5.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)request -> Unmarshal$.MODULE$.apply(request.entity()).to(this.largeFrameJsonStreamUnmarshaller(this.recordInfoAppliedDecoder()), Predef$.MODULE$.implicitly(ec$9), Predef$.MODULE$.implicitly(Materializer$.MODULE$.matFromSystem(system$9))).flatMap((Function1<Source, Future> & Serializable)records -> ((Source)((Source)records.recover((PartialFunction)((Object)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    throw e;
                }
                return function1.apply(x);
            }
        }))).named("remote-data-status-reader")).runWith(Sink$.MODULE$.fold(Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(0), Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), BoxesRunTime.boxToLong(Connector$.MODULE$.nextReportAt(Connector$.MODULE$.nextReportAt$default$1()))), (Function2<Tuple3, RemoteRecordInfoApplied, Tuple3> & Serializable)(x$1, x$2) -> {
            Tuple3 tuple3;
            Tuple2<Tuple3, RemoteRecordInfoApplied> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null && (tuple3 = tuple2._1()) != null) {
                Map map;
                int count = BoxesRunTime.unboxToInt(tuple3._1());
                Map map2 = (Map)tuple3._2();
                long reportAt = BoxesRunTime.unboxToLong(tuple3._3());
                RemoteRecordInfoApplied record = tuple2._2();
                if (record.sha256().isEmpty()) {
                    map = (Map)map2.$minus(record.key());
                } else {
                    String string2 = Predef$.MODULE$.ArrowAssoc(record.key());
                    map = (Map)map2.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(record.sha256()), 2, 2).map((Function1<String, byte> & Serializable)_$7 -> (byte)Integer.parseInt(_$7, 16)).toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
                }
                Map updated = map;
                return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(count + 1), updated, BoxesRunTime.boxToLong(this.reportProgress(count, reportAt)));
            }
            throw new MatchError(tuple2);
        }), Materializer$.MODULE$.matFromSystem(system$9)).map((Function1<Tuple3, Map> & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int count = BoxesRunTime.unboxToInt(tuple3._1());
                Map map = (Map)tuple3._2();
                this.logger.info(new StringBuilder(37).append("Remote data status: received ").append(count).append(" records").append(count == map.size() ? "" : new StringBuilder(23).append(", compacted to ").append(map.size()).append(" records").toString()).toString());
                return map;
            }
            throw new MatchError(tuple3);
        }, ec$9).map((Function1<Map, Status> & Serializable)keyToHash -> new Status(this, (Map<String, byte[]>)keyToHash, None$.MODULE$), ec$9), ec$9), ec$9), ec$9);
    }

    private final Future loadLastTimestamp$1(SecurityTokenServiceClient tokenS$4, HttpClient http$7, ExecutionContext ec$13, ActorSystem system$13) {
        String target_server_uri = this.config.getString("target_server_uri");
        this.logger.info(new StringBuilder(46).append("Requesting timestamp of last update from ").append(target_server_uri).append(" for ").append(this.dataset_name).toString());
        return tokenS$4.getToken().flatMap((Function1<Token, Future> & Serializable)token -> http$7.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(new StringBuilder(24).append(target_server_uri).append("/updates_last_timestamp/").append(this.dataset_name).toString()), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), http$7.doRequest$default$2(), http$7.doRequest$default$3(), http$7.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)request -> Unmarshal$.MODULE$.apply(request.entity()).to(this.largeFrameJsonStreamUnmarshaller(this.recordTsInfoDecoder()), Predef$.MODULE$.implicitly(ec$13), Predef$.MODULE$.implicitly(Materializer$.MODULE$.matFromSystem(system$13))).flatMap((Function1<Source, Future> & Serializable)records -> ((Source)((Source)records.recover((PartialFunction)((Object)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    throw e;
                }
                return function1.apply(x);
            }
        }))).named("remote-data-status-reader")).runWith(Sink$.MODULE$.headOption(), Materializer$.MODULE$.matFromSystem(system$13)).map((Function1<Option, Option> & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                this.logger.info("Remote data status: no timestamp info received");
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                RemoteRecordTimestampInfo tsInfo = (RemoteRecordTimestampInfo)((Some)option).value();
                this.logger.info(new StringBuilder(60).append("Remote data status: received last record timestamp ").append(tsInfo.timestamp()).append(". Offset ").append(tsInfo.offset()).toString());
                return Some$.MODULE$.apply(tsInfo);
            }
            throw new MatchError(option);
        }, ec$13).map((Function1<Option, Status> & Serializable)tsInfoOpt -> new Status(this, (Map<String, byte[]>)Predef$.MODULE$.Map().empty(), (Option<RemoteRecordTimestampInfo>)tsInfoOpt), ec$13), ec$13), ec$13), ec$13);
    }

    public class Status {
        private Map<String, byte[]> keyToHash;
        private Option<RemoteRecordTimestampInfo> lastTimestamp;
        private final /* synthetic */ RemoteDataStatus $outer;

        public Status(RemoteDataStatus $outer, Map<String, byte[]> keyToHash, Option<RemoteRecordTimestampInfo> lastTimestamp) {
            this.keyToHash = keyToHash;
            this.lastTimestamp = lastTimestamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        private Map<String, byte[]> keyToHash() {
            return this.keyToHash;
        }

        private void keyToHash_$eq(Map<String, byte[]> x$0) {
            this.keyToHash = x$0;
        }

        private Option<RemoteRecordTimestampInfo> lastTimestamp() {
            return this.lastTimestamp;
        }

        private void lastTimestamp_$eq(Option<RemoteRecordTimestampInfo> x$0) {
            this.lastTimestamp = x$0;
        }

        public Map<String, byte[]> hashes() {
            Map<String, byte[]> map;
            Status status = this;
            synchronized (status) {
                map = this.keyToHash();
            }
            return map;
        }

        public Option<RemoteRecordTimestampInfo> timestampInfo() {
            Option<RemoteRecordTimestampInfo> option;
            Status status = this;
            synchronized (status) {
                option = this.lastTimestamp();
            }
            return option;
        }

        public boolean isEmpty() {
            boolean bl;
            Status status = this;
            synchronized (status) {
                bl = this.keyToHash().isEmpty() && this.lastTimestamp().isEmpty();
            }
            return bl;
        }

        public Set<String> keysNotIn(Set<String> otherKeys) {
            Set set;
            Status status = this;
            synchronized (status) {
                set = (Set)this.keyToHash().keySet().$minus$minus(otherKeys);
            }
            return set;
        }

        public void setStatus(Map<String, byte[]> status, Option<RemoteRecordTimestampInfo> tsInfo) {
            Status status2 = this;
            synchronized (status2) {
                this.keyToHash_$eq(status);
                this.lastTimestamp_$eq(tsInfo);
            }
        }

        public final /* synthetic */ RemoteDataStatus dagr$RemoteDataStatus$Status$$$outer() {
            return this.$outer;
        }
    }
}

