/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.HttpClient;
import dagr.JsonAnyValueDecoder$;
import dagr.RemoteDataImportTaskByStatus;
import dagr.RemoteDataImportTaskByStatus$;
import dagr.RemoteDataImportTaskConfig;
import dagr.RemoteDataImportTaskConfig$;
import dagr.RemoteDataImportTaskDetails;
import dagr.RemoteDataImportTaskDetails$;
import dagr.RemoteDatasetDetails;
import dagr.RemoteDatasetDetails$;
import dagr.Renderer;
import dagr.SecurityTokenServiceClient;
import dagr.Token;
import io.bullet.borer.Decoder;
import io.bullet.borer.InputReader;
import io.bullet.borer.Reader;
import io.bullet.borer.compat.pekkoHttp$;
import io.bullet.borer.derivation.helpers.package$package$;
import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.common.EntityStreamingSupport;
import org.apache.pekko.http.scaladsl.common.JsonEntityStreamingSupport;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Accept$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import spray.json.JsString$;

public class RemoteDataImportTask {
    private final Config config;
    private final Decoder<RemoteDataImportTaskByStatus> remoteDataImportTaskByStatusDecoder;
    public final Logger dagr$RemoteDataImportTask$$logger;
    private final String target_server_uri;

    /*
     * WARNING - void declaration
     */
    public RemoteDataImportTask(Config config) {
        void var2_2;
        this.config = config;
        Decoder<RemoteDataImportTaskByStatus> decoder$proxy1 = r -> {
            if (r.tryReadMapStart()) {
                return RemoteDataImportTask.readObject$1(r, -1);
            }
            if (r.hasMapHeader()) {
                long mapLength = r.readMapHeader();
                if (mapLength > Integer.MAX_VALUE) {
                    throw r.overflow("Maps with more than 2^31 entries are not supported");
                }
                return RemoteDataImportTask.readObject$1(r, (int)mapLength);
            }
            throw r.unexpectedDataItem("Map Start or Map Header for decoding an instance of type `RemoteDataImportTaskByStatus`");
        };
        this.remoteDataImportTaskByStatusDecoder = var2_2;
        this.dagr$RemoteDataImportTask$$logger = LoggerFactory.getLogger("dagr.remote_import");
        Renderer renderer = new Renderer(config);
        this.target_server_uri = config.getString("target_server_uri");
    }

    public Decoder<RemoteDataImportTaskByStatus> remoteDataImportTaskByStatusDecoder() {
        return this.remoteDataImportTaskByStatusDecoder;
    }

    public <T> Unmarshaller<HttpEntity, Source<T, NotUsed>> largeFrameJsonStreamUnmarshaller(Decoder<T> evidence$1) {
        return pekkoHttp$.MODULE$.borerStreamUnmarshaller((EntityStreamingSupport)new JsonEntityStreamingSupport(0x800000), (Decoder)evidence$1);
    }

    public Future<Option<RemoteDataImportTaskByStatus>> getNextTask(HttpClient http, SecurityTokenServiceClient tokenS, ActorSystem system, ExecutionContext ec) {
        this.dagr$RemoteDataImportTask$$logger.debug(new StringBuilder(38).append("Requesting next data import task from ").append(this.target_server_uri).toString());
        return tokenS.getToken().flatMap((Function1<Token, Future> & Serializable)token -> http.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(new StringBuilder(46).append(this.target_server_uri).append("/data_import_task_by_status/pievienots?limit=1").toString()), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), http.doRequest$default$2(), http.doRequest$default$3(), http.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)taskRequest -> Unmarshal$.MODULE$.apply(taskRequest.entity()).to(this.largeFrameJsonStreamUnmarshaller(this.remoteDataImportTaskByStatusDecoder()), Predef$.MODULE$.implicitly(ec), Predef$.MODULE$.implicitly(Materializer$.MODULE$.matFromSystem(system))).flatMap((Function1<Source, Future> & Serializable)taskRecords -> ((Source)((Source)taskRecords.recover((PartialFunction)((Object)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    throw e;
                }
                return function1.apply(x);
            }
        }))).named("remote-data-import-task-reader")).runWith(Sink$.MODULE$.headOption(), Materializer$.MODULE$.matFromSystem(system)).map((Function1<Option, Option> & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                this.dagr$RemoteDataImportTask$$logger.debug("Remote data import: no task received");
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                RemoteDataImportTaskByStatus taskInfo = (RemoteDataImportTaskByStatus)((Some)option).value();
                this.dagr$RemoteDataImportTask$$logger.info(new StringBuilder(44).append("Remote data import: received task from ").append(taskInfo.created_at()).append(" for ").append(taskInfo.uid()).toString());
                return Some$.MODULE$.apply(taskInfo);
            }
            throw new MatchError(option);
        }, ec).map((Function1<Option, Option> & Serializable)taskInfoOpt -> taskInfoOpt, ec), ec), ec), ec);
    }

    public Future<Option<RemoteDataImportTaskDetails>> getTaskDetails(HttpClient http, SecurityTokenServiceClient tokenS, RemoteDataImportTaskByStatus task, ActorSystem system, ExecutionContext ec) {
        this.dagr$RemoteDataImportTask$$logger.debug(new StringBuilder(35).append("Requesting task details from ").append(this.target_server_uri).append(" for ").append(task.target_dataset()).append("/").append(task.uid()).toString());
        return tokenS.getToken().flatMap((Function1<Token, Future> & Serializable)token -> http.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(new StringBuilder(19).append(this.target_server_uri).append("/data_import_task/").append(task.target_dataset()).append("/").append(task.uid()).toString()), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), http.doRequest$default$2(), http.doRequest$default$3(), http.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)taskConfResponse -> Unmarshal$.MODULE$.apply(taskConfResponse).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(Unmarshaller$.MODULE$.byteStringUnmarshaller()), ec, Materializer$.MODULE$.matFromSystem(system)).map((Function1<ByteString, Map> & Serializable)taskDetailsByteString -> JsonAnyValueDecoder$.MODULE$.decodeToMap((ByteString)taskDetailsByteString, JsonAnyValueDecoder$.MODULE$.decodeToMap$default$2(), JsonAnyValueDecoder$.MODULE$.decodeToMap$default$3(), ClassTag$.MODULE$.apply(Map.class)), ec).map((Function1<Map, RemoteDataImportTaskConfig> & Serializable)m -> {
            Object object;
            this.dagr$RemoteDataImportTask$$logger.debug(new StringBuilder(46).append("Remote data import: received task details for ").append(task.target_dataset()).toString());
            Object V1 = m.getOrElse("conf", RemoteDataImportTask::$anonfun$2);
            if (V1 instanceof Map) {
                Map cm = (Map)V1;
                object = cm;
            } else {
                object = Predef$.MODULE$.Map().empty();
            }
            Object cm = object;
            return RemoteDataImportTaskConfig$.MODULE$.apply(RemoteDataImportTask.b$1((Map)cm, "fail_on_missing_fields", true), RemoteDataImportTask.b$1((Map)cm, "fail_on_unknown_fields", true), RemoteDataImportTask.b$1((Map)cm, "delete_unpaired_records", this.config.getBoolean("delete_unpaired_records")), RemoteDataImportTask.b$1((Map)cm, "dry_run", this.config.getBoolean("dry_run")), RemoteDataImportTask.b$1((Map)cm, "dry_run_full", this.config.getBoolean("dry_run_full")), RemoteDataImportTask.b$1((Map)cm, "report_duplicates", this.config.getBoolean("report_duplicates")), RemoteDataImportTask.s$1((Map)cm, "data_datetime_truncate_to", this.config.getString("data.datetime.truncate_to")), RemoteDataImportTask.s$1((Map)cm, "data_timezone", this.config.getString("data.timezone")), RemoteDataImportTask.s$1((Map)cm, "data_validation", this.config.getString("data.validation")), RemoteDataImportTask.s$1((Map)cm, "csv_fields_delimiter", this.config.getString("csv.files.fields_delimiter")));
        }, ec).flatMap((Function1<RemoteDataImportTaskConfig, Future> & Serializable)taskConf -> ((Future)Option$.MODULE$.apply(task).map((Function1<RemoteDataImportTaskByStatus, Future> & Serializable)taskInfo -> {
            String dataset_name = taskInfo.target_dataset();
            Uri uri = taskInfo.target_dataset().startsWith("sandbox/") ? Uri$.MODULE$.apply(new StringBuilder(20).append(this.target_server_uri).append("/dataset_in_sandbox/").append(dataset_name.substring(dataset_name.indexOf("/") + 1)).toString()) : Uri$.MODULE$.apply(new StringBuilder(9).append(this.target_server_uri).append("/dataset/").append(dataset_name).toString());
            return http.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), uri, (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), http.doRequest$default$2(), http.doRequest$default$3(), http.doRequest$default$4()).map((Function1<HttpResponse, Some> & Serializable)_$1 -> Some$.MODULE$.apply(_$1), ec);
        }).getOrElse(RemoteDataImportTask::getTaskDetails$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2)).flatMap((Function1<Option, Future> & Serializable)datasetDetailsResponseOpt -> ((Future)datasetDetailsResponseOpt.map((Function1<HttpResponse, Future> & Serializable)datasetDetailsResponse -> Unmarshal$.MODULE$.apply(datasetDetailsResponse).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(Unmarshaller$.MODULE$.byteStringUnmarshaller()), ec, Materializer$.MODULE$.matFromSystem(system)).map((Function1<ByteString, Map> & Serializable)datasetDetailsByteString -> JsonAnyValueDecoder$.MODULE$.decodeToMap((ByteString)datasetDetailsByteString, JsonAnyValueDecoder$.MODULE$.decodeToMap$default$2(), JsonAnyValueDecoder$.MODULE$.decodeToMap$default$3(), ClassTag$.MODULE$.apply(Map.class)), ec).map((Function1<Map, Some> & Serializable)m -> {
            this.dagr$RemoteDataImportTask$$logger.debug(new StringBuilder(49).append("Remote data import: received dataset details for ").append(task.target_dataset()).toString());
            return Some$.MODULE$.apply(RemoteDatasetDetails$.MODULE$.apply(String.valueOf(m.apply("name")), String.valueOf(m.apply("structure"))));
        }, ec)).getOrElse(this::getTaskDetails$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$3$$anonfun$2)).map((Function1<Option, Option> & Serializable)datasetDetailsOpt -> datasetDetailsOpt.map((Function1<RemoteDatasetDetails, RemoteDataImportTaskDetails> & Serializable)datasetDetails -> RemoteDataImportTaskDetails$.MODULE$.apply(task.status(), task.uid(), task.created_at(), task.target_dataset(), (RemoteDataImportTaskConfig)taskConf, datasetDetails.structure())), ec), ec), ec), ec), ec);
    }

    public Future<BoxedUnit> setStatus(HttpClient http, SecurityTokenServiceClient tokenS, Vector<Object> key2, String status, String status_details, ActorSystem system, ExecutionContext ec) {
        String taskKey = key2.mkString("/");
        String jsStatus = JsString$.MODULE$.apply(status).compactPrint();
        String jsDetails = JsString$.MODULE$.apply(status_details).compactPrint();
        return tokenS.getToken().flatMap((Function1<Token, Future> & Serializable)token -> http.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.PUT(), Uri$.MODULE$.apply(new StringBuilder(18).append(this.target_server_uri).append("/data_import_task/").append(taskKey).toString()), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$)), HttpEntity$.MODULE$.apply((ContentType)ContentTypes$.MODULE$.application$divjson(), ByteString$.MODULE$.apply(new StringBuilder(32).append("{\"status\": ").append(jsStatus).append(", \"status_details\": ").append(jsDetails).append("}").toString())), HttpRequest$.MODULE$.apply$default$5()), http.doRequest$default$2(), http.doRequest$default$3(), http.doRequest$default$4()).andThen(new Serializable(jsStatus, jsDetails, this){
            private final String jsStatus$2;
            private final String jsDetails$2;
            private final /* synthetic */ RemoteDataImportTask $outer;
            {
                this.jsStatus$2 = jsStatus$3;
                this.jsDetails$2 = jsDetails$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Try x) {
                Try try_ = x;
                if (try_ instanceof Success) {
                    return true;
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Try try_ = x;
                if (try_ instanceof Success) {
                    this.$outer.dagr$RemoteDataImportTask$$logger.debug(new StringBuilder(20).append("Status reported - ").append(this.jsStatus$2).append(", ").append(this.jsDetails$2).toString());
                    return BoxedUnit.UNIT;
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    this.$outer.dagr$RemoteDataImportTask$$logger.error(new StringBuilder(28).append("Failed to report status - ").append(this.jsStatus$2).append(", ").append(this.jsDetails$2).toString(), ex);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        }, ec).map(response -> {}, ec), ec);
    }

    private static final void read$2(InputReader r$3, IntRef mask$2, ObjectRef x$5, ObjectRef x$6) {
        int cmp = r$3.tryReadStringCompare("status");
        if (cmp < 0) {
            if (r$3.tryReadStringCompare("created_at") == 0) {
                if ((mask$2.elem & 4) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$3, "created_at", "RemoteDataImportTaskByStatus");
                }
                x$5.elem = r$3.readString();
                mask$2.elem |= 4;
                return;
            }
            InputReader InputReader_this = r$3;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if (cmp > 0) {
            InputReader InputReader_this = r$3;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if ((mask$2.elem & 1) != 0) {
            throw package$package$.MODULE$.failDuplicateMapKey(r$3, "status", "RemoteDataImportTaskByStatus");
        }
        x$6.elem = r$3.readString();
        mask$2.elem |= 1;
    }

    private static final void read$1(InputReader r$2, IntRef mask$1, ObjectRef x$1, ObjectRef x$2, ObjectRef x$3, ObjectRef x$4) {
        int cmp = r$2.tryReadStringCompare("target_dataset");
        if (cmp < 0) {
            RemoteDataImportTask.read$2(r$2, mask$1, x$1, x$2);
            return;
        }
        if (cmp > 0) {
            if (r$2.tryReadStringCompare("uid") == 0) {
                if ((mask$1.elem & 2) != 0) {
                    throw package$package$.MODULE$.failDuplicateMapKey(r$2, "uid", "RemoteDataImportTaskByStatus");
                }
                x$3.elem = r$2.readString();
                mask$1.elem |= 2;
                return;
            }
            InputReader InputReader_this = r$2;
            InputReader_this.skipElement().skipElement();
            return;
        }
        if ((mask$1.elem & 8) != 0) {
            throw package$package$.MODULE$.failDuplicateMapKey(r$2, "target_dataset", "RemoteDataImportTaskByStatus");
        }
        x$4.elem = r$2.readString();
        mask$1.elem |= 8;
    }

    private static final Nothing$ failMissing$1(InputReader r$4, int testMask$1) {
        return package$package$.MODULE$.failMissing((InputReader<? extends Reader.Config>)r$4, "RemoteDataImportTaskByStatus", testMask$1, (List<String>)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"status"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"uid"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"created_at"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"target_dataset"), Nil$.MODULE$)))))));
    }

    private static final RemoteDataImportTaskByStatus readObject$1(InputReader r$1, int count) {
        String string2;
        String string3;
        String string4;
        String string5;
        int rem = count;
        IntRef mask = IntRef.create(0);
        if (rem != 0 && r$1.tryReadString("status")) {
            mask.elem |= 1;
            --rem;
            string5 = r$1.readString();
        } else {
            string5 = null;
        }
        ObjectRef<Object> x = ObjectRef.create(string5);
        if (rem != 0 && r$1.tryReadString("uid")) {
            mask.elem |= 2;
            --rem;
            string4 = r$1.readString();
        } else {
            string4 = null;
        }
        ObjectRef<Object> x2 = ObjectRef.create(string4);
        if (rem != 0 && r$1.tryReadString("created_at")) {
            mask.elem |= 4;
            --rem;
            string3 = r$1.readString();
        } else {
            string3 = null;
        }
        ObjectRef<Object> x3 = ObjectRef.create(string3);
        if (rem != 0 && r$1.tryReadString("target_dataset")) {
            mask.elem |= 8;
            --rem;
            string2 = r$1.readString();
        } else {
            string2 = null;
        }
        ObjectRef<Object> x4 = ObjectRef.create(string2);
        while (rem > 0 || rem < 0 && !r$1.tryReadBreak()) {
            Object object;
            if (mask.elem != 15) {
                RemoteDataImportTask.read$1(r$1, mask, x3, x, x2, x4);
                object = BoxedUnit.UNIT;
            } else {
                InputReader InputReader_this = r$1;
                object = InputReader_this.skipElement().skipElement();
            }
            --rem;
        }
        int testMask = mask.elem | 0xFFFFFFF0;
        if (testMask == -1) {
            return RemoteDataImportTaskByStatus$.MODULE$.apply((String)x.elem, (String)x2.elem, (String)x3.elem, (String)x4.elem);
        }
        throw RemoteDataImportTask.failMissing$1(r$1, testMask);
    }

    private static final Object $anonfun$2() {
        return null;
    }

    private static final boolean b$1$$anonfun$2(boolean default$1) {
        return default$1;
    }

    private static final boolean b$1(Map cm$1, String name, boolean bl) {
        return BoxesRunTime.unboxToBoolean(cm$1.get(name).map((Function1<Object, boolean> & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Boolean) {
                boolean b = BoxesRunTime.unboxToBoolean(object);
                return b;
            }
            throw new MatchError(object);
        }).getOrElse(() -> RemoteDataImportTask.b$1$$anonfun$2(bl)));
    }

    private static final String s$1$$anonfun$2(String default$2) {
        return default$2;
    }

    private static final String s$1(Map cm$2, String name, String string2) {
        return (String)cm$2.get(name).map((Function1<Object, String> & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof String) {
                String s2 = (String)object;
                return s2;
            }
            throw new MatchError(object);
        }).getOrElse(() -> RemoteDataImportTask.s$1$$anonfun$2(string2));
    }

    private static final Future getTaskDetails$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2() {
        return Future$.MODULE$.successful(None$.MODULE$);
    }

    private final Future getTaskDetails$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$3$$anonfun$2() {
        this.dagr$RemoteDataImportTask$$logger.warn("Remote data import: no dataset details received");
        return Future$.MODULE$.successful(None$.MODULE$);
    }
}

