/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import dagr.ClientException;
import dagr.HttpsClient;
import dagr.PMLP;
import dagr.PMLP$;
import dagr.PMLP$AsyncRequestInfo$;
import dagr.PMLP$AsyncRequestLock$;
import dagr.PMLP$OldUnknownPmlpRequest$;
import dagr.PMLP$PmlpRequest$;
import dagr.Reporter$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import org.apache.pekko.NotUsed;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.HttpCharsets$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Accept$minusEncoding$;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodingRange;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodingRange$;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodings$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.OverflowStrategy$;
import org.apache.pekko.stream.UniformFanInShape;
import org.apache.pekko.stream.UniformFanOutShape;
import org.apache.pekko.stream.scaladsl.Broadcast$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Framing$;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.GraphDSL$Implicits$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.math.PartialOrdering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public final class PMLP$
implements Serializable {
    private static final ExecutionContext ec;
    private static final Config config;
    private static final String uri;
    private static final int max_batch;
    private static final String client_code;
    private static final FiniteDuration pollInterval;
    private static final String soapTo;
    public static final Logger dagr$PMLP$$$flow_logger;
    public static final Logger dagr$PMLP$$$http_logger;
    private static final ActorSystem system;
    private static final Materializer materializer;
    private static final ContentType contentType;
    private static final List<HttpHeader> headers;
    private static final HttpsClient client;
    private static final Regex ResponseStructureElementNamePattern;
    private static final Seq<String> allClassifierCodes;
    private static final String AllClassifierRecordsRequest;
    public static final PMLP$PmlpRequest$ PmlpRequest;
    public static final PMLP$OldUnknownPmlpRequest$ OldUnknownPmlpRequest;
    public static final PMLP$AsyncRequestInfo$ AsyncRequestInfo;
    private static final Regex OldAsyncRequestId;
    public static final PMLP$AsyncRequestLock$ dagr$PMLP$$$AsyncRequestLock;
    private static final Seq<Tuple2<Object, Function1<Set<String>, PMLP.PmlpRequest>>> personEventCodeToRequestFactorySeq;
    private static final Map<Object, Function1<Set<String>, PMLP.PmlpRequest>> personEventCodeToRequestFactory;
    private static final Map<Object, Object> personEventCodeToSortIndex;
    private static final Ordering<Object> personEventCodeOrdering;
    private static final Seq<Object> allPersonEventRequestCodes;
    private static final int PersonCodeEventRequestCode;
    private static final Seq<Object> PersonOtherEventsRequestCodes;
    public static final String dagr$PMLP$$$GetMonitoringFlags;
    private static final ByteString monitoringRecordDelimiter;
    private static final ByteString monitoringEmptyListTag;
    private static final ByteString monitoringClosingTags;
    private static final int monitoringRecordMaxSize;
    private static final Regex PersonCodeExtractor;
    private static final Regex NilPersonCode;
    private static final Regex MonitoringSetTypeCodeExtractor;
    public static final String dagr$PMLP$$$FeedbackChunkEnd;
    public static final PMLP$ MODULE$;

    private PMLP$() {
    }

    static {
        MODULE$ = new PMLP$();
        ec = ExecutionContext$.MODULE$.global();
        config = ConfigFactory.load();
        uri = MODULE$.config().getString("remote.pmlp.uri");
        max_batch = MODULE$.config().getInt("remote.pmlp.max-batch-size");
        client_code = (String)Option$.MODULE$.apply("remote.pmlp.monitoring-client-code").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> this.config().hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> this.config().getString((String)x$0)).filter((Function1<String, boolean> & Serializable)_$1 -> {
            String string2 = _$1;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        }).orNull($less$colon$less$.MODULE$.refl());
        pollInterval = MODULE$.toFiniteDuration(MODULE$.config().getDuration("remote.pmlp.request-status-poll-interval"));
        soapTo = MODULE$.uri();
        dagr$PMLP$$$flow_logger = LoggerFactory.getLogger("dagr.pmlp.flow");
        dagr$PMLP$$$http_logger = LoggerFactory.getLogger("dagr.pmlp.http");
        system = ActorSystem$.MODULE$.apply("pmlp-system");
        materializer = Materializer$.MODULE$.apply(MODULE$.system());
        contentType = ContentType$.MODULE$.apply((MediaType)MediaTypes$.MODULE$.application$divsoap$plusxml(), (Function0<HttpCharset> & Serializable)() -> HttpCharsets$.MODULE$.UTF$minus8());
        headers = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$minusEncoding$.MODULE$.apply(HttpEncodingRange$.MODULE$.apply(HttpEncodings$.MODULE$.gzip()), ScalaRunTime$.MODULE$.wrapRefArray(new HttpEncodingRange[]{HttpEncodingRange$.MODULE$.apply(HttpEncodings$.MODULE$.deflate())}))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)RawHeader$.MODULE$.apply("SOAPAction", "http://tempuri.org/IService/Execute")), Nil$.MODULE$)));
        client = new HttpsClient(MODULE$.config(), MODULE$.system(), MODULE$.ec());
        ResponseStructureElementNamePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*<(\\w+)ResponseStructure[\\s\\/>].*"));
        allClassifierCodes = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)"CCNT"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"CORD"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"CPAR"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"CPDK"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"CPET"), Nil$.MODULE$))))));
        AllClassifierRecordsRequest = MODULE$.GetClassifierRecordsRequest(MODULE$.allClassifierCodes());
        OldAsyncRequestId = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".* iepriek\u0161 veikt\u0101 (\\w+) piepras\u012bjuma .*"));
        Tuple2[] tuple2Array = new Tuple2[9];
        Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(28));
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, null);
        Integer n2 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(40));
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n2, (Function1<Set, PMLP.PmlpRequest> & Serializable)pks -> this.personsCodeInfoRequest((Set<String>)pks));
        Integer n3 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(41));
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n3, (Function1<Set, PMLP.PmlpRequest> & Serializable)pks -> this.personsNameInfoRequest((Set<String>)pks));
        Integer n4 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(42));
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n4, (Function1<Set, PMLP.PmlpRequest> & Serializable)pks -> this.personsBirthInfoRequest((Set<String>)pks));
        Integer n5 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(43));
        tuple2Array[4] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n5, (Function1<Set, PMLP.PmlpRequest> & Serializable)pks -> this.personsDeathInfoRequest((Set<String>)pks));
        Integer n6 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(44));
        tuple2Array[5] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n6, (Function1<Set, PMLP.PmlpRequest> & Serializable)pks -> this.personsResidenceInfoRequest((Set<String>)pks));
        Integer n7 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(45));
        tuple2Array[6] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n7, (Function1<Set, PMLP.PmlpRequest> & Serializable)pks -> this.personsDocumentInfoRequest((Set<String>)pks));
        Integer n8 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(46));
        tuple2Array[7] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n8, (Function1<Set, PMLP.PmlpRequest> & Serializable)pks -> this.personsCitizenshipInfoRequest((Set<String>)pks));
        Integer n9 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(7));
        tuple2Array[8] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n9, (Function1<Set, PMLP.PmlpRequest> & Serializable)pks -> this.personsStatusFprInfoRequest((Set<String>)pks));
        personEventCodeToRequestFactorySeq = (Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        personEventCodeToRequestFactory = MODULE$.personEventCodeToRequestFactorySeq().toMap($less$colon$less$.MODULE$.refl());
        personEventCodeToSortIndex = ((IterableOnceOps)((IterableOps)MODULE$.personEventCodeToRequestFactorySeq().map((Function1<Tuple2, int> & Serializable)_$14 -> BoxesRunTime.unboxToInt(_$14._1()))).zipWithIndex()).toMap($less$colon$less$.MODULE$.refl());
        personEventCodeOrdering = new Ordering<Object>(){
            {
                PartialOrdering.$init$(this);
                Ordering.$init$(this);
            }

            public int compare(int x, int y) {
                int n = BoxesRunTime.unboxToInt(PMLP$.MODULE$.personEventCodeToSortIndex().getOrElse(BoxesRunTime.boxToInteger(x), PMLP$::dagr$PMLP$$anon$1$$_$compare$$anonfun$1)) - BoxesRunTime.unboxToInt(PMLP$.MODULE$.personEventCodeToSortIndex().getOrElse(BoxesRunTime.boxToInteger(y), PMLP$::dagr$PMLP$$anon$1$$_$compare$$anonfun$2));
                if (0 == n) {
                    return Predef$.MODULE$.int2Integer(x).compareTo(Predef$.MODULE$.int2Integer(y));
                }
                int d = n;
                return d;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{dagr$PMLP$$anon$1$$_$compare$$anonfun$1(), dagr$PMLP$$anon$1$$_$compare$$anonfun$2()}, serializedLambda);
            }
        };
        allPersonEventRequestCodes = (Seq)((MapOps)MODULE$.personEventCodeToRequestFactory().filter((Function1<Tuple2, boolean> & Serializable)_$15 -> _$15._2() != null)).keys().toSeq().sorted(Ordering$Int$.MODULE$);
        PersonCodeEventRequestCode = 40;
        PersonOtherEventsRequestCodes = (Seq)MODULE$.allPersonEventRequestCodes().filter(_$16 -> _$16 != this.PersonCodeEventRequestCode());
        dagr$PMLP$$$GetMonitoringFlags = "GetMonitoringFlags";
        monitoringRecordDelimiter = ByteString$.MODULE$.apply("</MonitoringData>");
        monitoringEmptyListTag = ByteString$.MODULE$.apply("<MonitoringDataList/>");
        monitoringClosingTags = ByteString$.MODULE$.apply("</MonitoringDataList></GetMonitoringFlagsResponseStructure>");
        monitoringRecordMaxSize = 1024;
        PersonCodeExtractor = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*<PersonCode>(\\d+)</PersonCode>.*"));
        NilPersonCode = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*<PersonCode i:nil=\"true\"/>.*"));
        MonitoringSetTypeCodeExtractor = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*<MonitoringSetTypeCode>(\\d+)</MonitoringSetTypeCode>.*"));
        dagr$PMLP$$$FeedbackChunkEnd = "[-FeedbackChunkEnd-]";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PMLP$.class);
    }

    public ExecutionContext ec() {
        return ec;
    }

    public Config config() {
        return config;
    }

    public String uri() {
        return uri;
    }

    public int max_batch() {
        return max_batch;
    }

    public String client_code() {
        return client_code;
    }

    public FiniteDuration pollInterval() {
        return pollInterval;
    }

    public String soapTo() {
        return soapTo;
    }

    private FiniteDuration toFiniteDuration(Duration d) {
        return Duration$.MODULE$.fromNanos(d.toNanos());
    }

    public ActorSystem system() {
        return system;
    }

    public Materializer materializer() {
        return materializer;
    }

    public ContentType contentType() {
        return contentType;
    }

    public List<HttpHeader> headers() {
        return headers;
    }

    public HttpsClient client() {
        return client;
    }

    public String soapEnvelope(String methodName, String request) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(613).append("\n       |<soap:Envelope\n       |    xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\"\n       |    xmlns:a=\"http://www.w3.org/2005/08/addressing\"\n       |    xmlns:tem=\"http://tempuri.org/\"\n       |    xmlns:fpr=\"http://schemas.datacontract.org/2004/07/Fpris.Contracts.Integration\">\n       |  <soap:Header>\n       |    <a:Action>http://tempuri.org/IService/").append(methodName).append("</a:Action>\n       |    <a:To>").append(this.soapTo()).append("</a:To>\n       |  </soap:Header>\n       |  <soap:Body>\n       |    <tem:").append(methodName).append(">\n       |      <tem:request>\n       |        ").append(request).append("\n       |      </tem:request>\n       |    </tem:").append(methodName).append(">\n       |  </soap:Body>\n       |</soap:Envelope>\n       |").toString())).trim();
    }

    public String cdata(String s2) {
        return new StringBuilder(12).append("<![CDATA[").append(s2.replace("]]>", "]]]]><![CDATA[>")).append("]]>").toString();
    }

    public String request(String requestId) {
        return new StringBuilder(31).append("<fpr:RequestId>").append(requestId).append("</fpr:RequestId>").toString();
    }

    public String request(String requestCode, String body) {
        return new StringBuilder(70).append("<fpr:Code>").append(requestCode).append("</fpr:Code><fpr:Data>").append(this.cdata(body)).append("</fpr:Data><fpr:Version>1</fpr:Version>").toString();
    }

    public Future<String> GetAsyncStatus(String requestId) {
        return this.doSyncRequest("GetAsyncStatus", requestId, (Function1<String, Option<Object>>)(Function1<String, Option> & Serializable)response -> MODULE$.requestStatusOption((String)response));
    }

    public Future<String> GetAsyncResponse(String requestId) {
        return this.doSyncRequest("GetAsyncResponse", requestId, this.doSyncRequest$default$3());
    }

    public Future<String> ConfirmAsync(String requestId) {
        return this.doSyncRequest("ConfirmAsync", requestId, this.doSyncRequest$default$3());
    }

    public Seq<String> allClassifierCodes() {
        return allClassifierCodes;
    }

    public String GetClassifierRecordsRequest(Seq<String> classifierCodes) {
        return this.request("GetClassifierRecordsExternal", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(208).append("\n         |<GetClassifierRecordsExternalRequestStructure>\n         |  <ClassifierCodeList>\n         |    ").append(((IterableOnceOps)classifierCodes.map((Function1<String, String> & Serializable)code -> new StringBuilder(33).append("<ClassifierCode>").append((String)code).append("</ClassifierCode>").toString())).mkString()).append("\n         |  </ClassifierCodeList>\n         |</GetClassifierRecordsExternalRequestStructure>\n         |").toString())).trim());
    }

    public String AllClassifierRecordsRequest() {
        return AllClassifierRecordsRequest;
    }

    public Future<String> GetAllClassifierRecords() {
        return this.doRequest("GetClassifierRecordsExternal", this.soapEnvelope("Execute", this.AllClassifierRecordsRequest()), "all classifier records", this.doRequest$default$4());
    }

    public Regex OldAsyncRequestId() {
        return OldAsyncRequestId;
    }

    public Future<String> doSyncRequest(String methodName, String requestId, Function1<String, Option<Object>> responseDescription) {
        return this.doRequest(methodName, this.soapEnvelope(methodName, this.request(requestId)), requestId, responseDescription);
    }

    public Function1<String, Option<Object>> doSyncRequest$default$3() {
        return (Function1<String, Option> & Serializable)_$2 -> None$.MODULE$;
    }

    public Future<BoxedUnit> reportFprWarning(String problem, Throwable ex, boolean mustSendNow) {
        if (ex == null) {
            dagr$PMLP$$$flow_logger.warn(problem);
        } else {
            dagr$PMLP$$$flow_logger.warn(problem, ex);
        }
        return Reporter$.MODULE$.reportProblem("fpr_person", problem, mustSendNow);
    }

    public Throwable reportFprWarning$default$2() {
        return null;
    }

    public boolean reportFprWarning$default$3() {
        return false;
    }

    public String asyncRequestStatusName(int status) {
        int n = status;
        switch (n) {
            case 1: {
                return "Re\u0123istr\u0113ts";
            }
            case 2: {
                return "Apstr\u0101d\u0113";
            }
            case 3: {
                return "Sagatavots";
            }
            case 4: {
                return "Izg\u016bts";
            }
            case 5: {
                return "Apstiprin\u0101ts";
            }
        }
        int x = n;
        return new StringBuilder(6).append("K\u013c\u016bda ").append(x).toString();
    }

    public boolean monitoringOrUnknownRequestFailed() {
        return PMLP$AsyncRequestLock$.MODULE$.getMonitoringOrUnknownRequestFailed();
    }

    public Instant lastSuccessfulMonitoringStartTime() {
        return PMLP$AsyncRequestLock$.MODULE$.getLastSuccessfulMonitoringStartTime();
    }

    public Future<Tuple2<String, Function1<Try<?>, Future<BoxedUnit>>>> doAsyncRequest(PMLP.PmlpRequest request) {
        Future<Tuple2<String, Function1<Try<?>, Future<BoxedUnit>>>> future;
        Instant masterRequestStartTime = Instant.now();
        PMLP$AsyncRequestLock$.MODULE$.enter(request);
        try {
            future = this.doRequest(request, (Function1<String, Option<Object>>)(Function1<String, Option> & Serializable)response -> MODULE$.requestIdOption((String)response)).transformWith((Function1<Try, Future> & Serializable)x$12 -> {
                Future<Boolean> future;
                String oldRequestIdDescription;
                Instant oldRequestStartTime;
                PMLP.PmlpRequest oldRequest;
                String oldRequestId;
                block6: {
                    LazyRef lazyRef;
                    block5: {
                        block4: {
                            String string2;
                            Try try_ = x$12;
                            if (try_ instanceof Success) {
                                String response = (String)((Success)try_).value();
                                String requestId = this.requestIdOrFail$1(response);
                                return this.waitForBody$1(request, requestId, masterRequestStartTime).andThen(this.maybeTrashOnBadBody$1(request, requestId), this.ec()).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
                                    Tuple2 tuple2 = x$1;
                                    if (tuple2 != null) {
                                        String body = (String)tuple2._1();
                                        int requestStatus = BoxesRunTime.unboxToInt(tuple2._2());
                                        return Tuple2$.MODULE$.apply(body, (Function1<Try, Future> & Serializable)consumed -> this.dagr$PMLP$$$_$onSuccessConfirm$1(request, requestId, requestStatus, (Try)consumed));
                                    }
                                    throw new MatchError(tuple2);
                                }, this.ec());
                            }
                            if (!(try_ instanceof Failure)) throw new MatchError(try_);
                            Throwable ex = ((Failure)try_).exception();
                            Throwable throwable = ex;
                            if (!(throwable instanceof ClientException)) throw ex;
                            ClientException cex = (ClientException)throwable;
                            String string3 = cex.responseContent();
                            if (string3 == null) throw ex;
                            Option<List<String>> option = this.OldAsyncRequestId().unapplySeq(string3);
                            if (option.isEmpty()) throw ex;
                            List<String> list = option.get();
                            if (list.lengthCompare(1) != 0) throw ex;
                            oldRequestId = string2 = list.apply(0);
                            lazyRef = new LazyRef();
                            Tuple2<PMLP.PmlpRequest, Instant> tuple2 = PMLP$AsyncRequestLock$.MODULE$.getOldRequestById(oldRequestId);
                            if (tuple2 == null) throw new MatchError(tuple2);
                            PMLP.PmlpRequest oldRequest2 = tuple2._1();
                            Instant oldRequestStartTime2 = tuple2._2();
                            Tuple2<PMLP.PmlpRequest, Instant> tuple22 = Tuple2$.MODULE$.apply(oldRequest2, oldRequestStartTime2);
                            oldRequest = tuple22._1();
                            oldRequestStartTime = tuple22._2();
                            oldRequestIdDescription = new StringBuilder(3).append(oldRequestId).append(" - ").append(oldRequest.fullDescription()).toString();
                            this.reportFprWarning(new StringBuilder(18).append("  old unconfirmed ").append(oldRequestIdDescription).toString(), this.reportFprWarning$default$2(), this.reportFprWarning$default$3());
                            PMLP.PmlpRequest pmlpRequest = oldRequest;
                            PMLP$OldUnknownPmlpRequest$ pMLP$OldUnknownPmlpRequest$ = PMLP$OldUnknownPmlpRequest$.MODULE$;
                            if (!(pmlpRequest == null ? pMLP$OldUnknownPmlpRequest$ != null : !((Object)pmlpRequest).equals(pMLP$OldUnknownPmlpRequest$))) break block4;
                            String string4 = oldRequest.methodName();
                            String string5 = dagr$PMLP$$$GetMonitoringFlags;
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block5;
                        }
                        String string6 = oldRequestId;
                        String string7 = this.requestIdToTrash$1(lazyRef);
                        if (string6 != null ? !string6.equals(string7) : string7 != null) break block6;
                    }
                    String string8 = oldRequestId;
                    String string9 = this.requestIdToTrash$1(lazyRef);
                    this.reportFprWarning(new StringBuilder(9).append("Trashing ").append(!(string8 != null ? !string8.equals(string9) : string9 != null) ? "(as configured) " : "").append(oldRequestIdDescription).toString(), this.reportFprWarning$default$2(), this.reportFprWarning$default$3());
                    future = this.dagr$PMLP$$$_$onSuccessConfirm$1(oldRequest, oldRequestId, 3, Success$.MODULE$.apply(BoxedUnit.UNIT)).transform((Function1<Try, Try> & Serializable)x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Failure) {
                            Throwable ex = ((Failure)try_).exception();
                            this.reportFprWarning(new StringBuilder(32).append("Failed to trash, trying to read ").append(oldRequestIdDescription).toString(), ex, this.reportFprWarning$default$3());
                            return Success$.MODULE$.apply(BoxesRunTime.boxToBoolean(false));
                        }
                        if (try_ instanceof Success) {
                            this.reportFprWarning(new StringBuilder(8).append("Trashed ").append(oldRequestIdDescription).toString(), this.reportFprWarning$default$2(), this.reportFprWarning$default$3());
                            return Success$.MODULE$.apply(BoxesRunTime.boxToBoolean(true));
                        }
                        throw new MatchError(try_);
                    }, this.ec());
                    return future.flatMap((Function1<Object, Future> & Serializable)oldIgnoreDone -> this.doAsyncRequest$$anonfun$2$$anonfun$3(oldRequest, oldRequestId, oldRequestStartTime, request, oldRequestIdDescription, BoxesRunTime.unboxToBoolean(oldIgnoreDone)), this.ec());
                }
                this.reportFprWarning(new StringBuilder(32).append("Must not trash ").append(oldRequest.fullDescription()).append(", trying to read ").append(oldRequestId).toString(), this.reportFprWarning$default$2(), this.reportFprWarning$default$3());
                future = Future$.MODULE$.successful(BoxesRunTime.boxToBoolean(false));
                return future.flatMap((Function1<Object, Future> & Serializable)oldIgnoreDone -> this.doAsyncRequest$$anonfun$2$$anonfun$3(oldRequest, oldRequestId, oldRequestStartTime, request, oldRequestIdDescription, BoxesRunTime.unboxToBoolean(oldIgnoreDone)), this.ec());
            }, this.ec()).andThen(new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    return true;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    PMLP$AsyncRequestLock$.MODULE$.exit();
                    return BoxedUnit.UNIT;
                }
            }, this.ec());
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                PMLP$AsyncRequestLock$.MODULE$.exit();
                throw ex;
            }
            throw throwable;
        }
        return future;
    }

    private String personCodesRequestBody(String requestName, Set<String> pks) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(87).append("\n       |<").append(requestName).append(">\n       |  <PersonCodeList>").append(((IterableOnceOps)pks.map((Function1<String, String> & Serializable)pk -> new StringBuilder(29).append("    <PersonCode>").append((String)pk).append("</PersonCode>").toString())).mkString("\n", "\n", "")).append("\n       |  </PersonCodeList>\n       |</").append(requestName).append(">\n       |").toString()));
    }

    private PMLP.PmlpRequest personInfoRequest(String methodInfix, Set<String> pks) {
        String methodName = new StringBuilder(20).append("GetPersons").append(methodInfix).append("AsinhrDAGR").toString();
        String pksBody = this.personCodesRequestBody(new StringBuilder(16).append(methodName).append("RequestStructure").toString(), pks);
        return PMLP$PmlpRequest$.MODULE$.apply(methodName, pksBody, new StringBuilder(10).append("for ").append(pks.size()).append(" codes").toString());
    }

    private PMLP.PmlpRequest personInfoCommonRequest(String methodInfix, Set<String> pks) {
        String methodName = new StringBuilder(16).append("GetPersons").append(methodInfix).append("Asinhr").toString();
        String pksBody = this.personCodesRequestBody(new StringBuilder(16).append(methodName).append("RequestStructure").toString(), pks);
        return PMLP$PmlpRequest$.MODULE$.apply(methodName, pksBody, new StringBuilder(10).append("for ").append(pks.size()).append(" codes").toString());
    }

    public PMLP.PmlpRequest personsBirthInfoRequest(Set<String> pks) {
        return this.personInfoRequest("Birth", pks);
    }

    public PMLP.PmlpRequest personsCitizenshipInfoRequest(Set<String> pks) {
        return this.personInfoRequest("Citizenship", pks);
    }

    public PMLP.PmlpRequest personsCodeInfoRequest(Set<String> pks) {
        return this.personInfoRequest("Code", pks);
    }

    public PMLP.PmlpRequest personsDeathInfoRequest(Set<String> pks) {
        return this.personInfoRequest("Death", pks);
    }

    public PMLP.PmlpRequest personsDocumentInfoRequest(Set<String> pks) {
        return this.personInfoRequest("Document", pks);
    }

    public PMLP.PmlpRequest personsNameInfoRequest(Set<String> pks) {
        return this.personInfoRequest("Name", pks);
    }

    public PMLP.PmlpRequest personsRepressedInfoRequest(Set<String> pks) {
        return this.personInfoCommonRequest("PoliticallyRepressedStatus", pks);
    }

    public PMLP.PmlpRequest personsResidenceInfoRequest(Set<String> pks) {
        return this.personInfoRequest("Residence", pks);
    }

    public PMLP.PmlpRequest personsResistanceInfoRequest(Set<String> pks) {
        return this.personInfoCommonRequest("ResistanceMemberStatus", pks);
    }

    public PMLP.PmlpRequest personsStatusFprInfoRequest(Set<String> pks) {
        return this.personInfoRequest("StatusFPR", pks);
    }

    public Seq<Tuple2<Object, Function1<Set<String>, PMLP.PmlpRequest>>> personEventCodeToRequestFactorySeq() {
        return personEventCodeToRequestFactorySeq;
    }

    public Map<Object, Function1<Set<String>, PMLP.PmlpRequest>> personEventCodeToRequestFactory() {
        return personEventCodeToRequestFactory;
    }

    public Map<Object, Object> personEventCodeToSortIndex() {
        return personEventCodeToSortIndex;
    }

    public Ordering<Object> personEventCodeOrdering() {
        return personEventCodeOrdering;
    }

    public Seq<Object> allPersonEventRequestCodes() {
        return allPersonEventRequestCodes;
    }

    public int PersonCodeEventRequestCode() {
        return PersonCodeEventRequestCode;
    }

    public Seq<Object> PersonOtherEventsRequestCodes() {
        return PersonOtherEventsRequestCodes;
    }

    public PMLP.PmlpRequest monitoringFlagsRequest(Option<String> since2) {
        String requestBody = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n      |<").append(dagr$PMLP$$$GetMonitoringFlags).append("RequestStructure xmlns=\"urn:pmlp:fpris\">\n      |  <ClientCode>").append(this.client_code()).append("</ClientCode>").append(since2.map((Function1<String, String> & Serializable)since -> new StringBuilder(1).append("\n").append(new StringBuilder(23).append("  <DateFrom>").append((String)since).append("</DateFrom>").toString()).toString()).getOrElse(PMLP$::$anonfun$3)).append("\n      |</").append(dagr$PMLP$$$GetMonitoringFlags).append("RequestStructure>\n      |").toString()));
        return PMLP$PmlpRequest$.MODULE$.apply(dagr$PMLP$$$GetMonitoringFlags, requestBody, new StringBuilder(13).append("client code: ").append(this.client_code()).append(since2.map((Function1<String, String> & Serializable)sc -> new StringBuilder(11).append(", since: '").append((String)sc).append("'").toString()).getOrElse(PMLP$::monitoringFlagsRequest$$anonfun$2)).toString());
    }

    public Option<String> monitoringFlagsRequest$default$1() {
        return None$.MODULE$;
    }

    private Elem parseXml(String xmlString) {
        return (Elem)XML$.MODULE$.loadString(xmlString);
    }

    public Option<String> requestIdOption(String response) {
        return ((IterableOps)((IterableOps)this.parseXml(response).$bslash("Body").$bslash("RequestAsyncResponse").$bslash("RequestAsyncResult").$bslash("RequestId").map((Function1<Node, String> & Serializable)_$17 -> _$17.text())).filter((Function1<String, boolean> & Serializable)_$18 -> {
            String string2 = _$18;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        })).headOption();
    }

    public Option<Object> requestStatusOption(String response) {
        return ((IterableOps)((IterableOps)this.parseXml(response).$bslash("Body").$bslash("GetAsyncStatusResponse").$bslash("GetAsyncStatusResult").$bslash("StatusCode").map((Function1<Node, String> & Serializable)_$19 -> _$19.text())).filter((Function1<String, boolean> & Serializable)_$20 -> {
            String string2 = _$20;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        })).headOption().map((Function1<String, int> & Serializable)_$21 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)_$21)));
    }

    public Option<String> asyncResponseBodyOption(String response) {
        return ((IterableOps)((IterableOps)this.parseXml(response).$bslash("Body").$bslash("GetAsyncResponseResponse").$bslash("GetAsyncResponseResult").$bslash("Data").map((Function1<Node, String> & Serializable)_$22 -> _$22.text())).filter((Function1<String, boolean> & Serializable)_$23 -> {
            String string2 = _$23;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        })).headOption();
    }

    public Option<String> syncResponseBodyOption(String response) {
        return ((IterableOps)((IterableOps)this.parseXml(response).$bslash("Body").$bslash("ExecuteResponse").$bslash("ExecuteResult").$bslash("Data").map((Function1<Node, String> & Serializable)_$24 -> _$24.text())).filter((Function1<String, boolean> & Serializable)_$25 -> {
            String string2 = _$25;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        })).headOption();
    }

    public Source<Tuple3<Object, String, Object>, NotUsed> personEventsSourceFromMonitoringMessage(String monitoringMessage) {
        return (Source)((Source)Source$.MODULE$.single(ByteString$.MODULE$.apply(monitoringMessage)).via(Framing$.MODULE$.delimiter(monitoringRecordDelimiter, monitoringRecordMaxSize, true))).zipWithIndex().filterNot((Function1<Tuple2, boolean> & Serializable)_$26 -> ((SeqOps)_$26._1()).containsSlice(monitoringEmptyListTag)).filterNot((Function1<Tuple2, boolean> & Serializable)_$27 -> {
            Object T1 = _$27._1();
            ByteString byteString = monitoringClosingTags;
            return !(T1 != null ? !T1.equals(byteString) : byteString != null);
        }).mapConcat((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> {
            String string2;
            List<String> list;
            String string3;
            List<String> list2;
            Option<List<String>> option;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError(tuple2);
            ByteString bytes = (ByteString)tuple2._1();
            long recordnum = BoxesRunTime.unboxToLong(tuple2._2());
            String record = bytes.utf8String();
            String string4 = record;
            if (string4 == null || (option = MonitoringSetTypeCodeExtractor.unapplySeq(string4)).isEmpty() || (list2 = option.get()).lengthCompare(1) != 0) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(63).append("Failed to extract MonitoringSetTypeCode from monitoring record ").append(record).toString());
            }
            String code = string3 = list2.apply(0);
            int monitoringSetTypeCode = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(code));
            String string5 = record;
            if (string5 == null) throw scala.sys.package$.MODULE$.error(new StringBuilder(53).append("Failed to extract person code from monitoring record ").append(record).toString());
            Option<List<String>> option2 = NilPersonCode.unapplySeq(string5);
            if (!option2.isEmpty() && (list = option2.get()).lengthCompare(0) == 0) {
                string2 = null;
            } else {
                String string6;
                String pk;
                List<String> list3;
                Option<List<String>> option3 = PersonCodeExtractor.unapplySeq(string5);
                if (option3.isEmpty() || (list3 = option3.get()).lengthCompare(1) != 0) throw scala.sys.package$.MODULE$.error(new StringBuilder(53).append("Failed to extract person code from monitoring record ").append(record).toString());
                string2 = pk = (string6 = list3.apply(0));
            }
            String personCode = string2;
            if (personCode != null) return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(monitoringSetTypeCode), personCode, BoxesRunTime.boxToLong(recordnum))), Nil$.MODULE$));
            return package$.MODULE$.Nil();
        });
    }

    public <R> Flow<Tuple3<Object, String, Object>, R, NotUsed> personEventsFlow(Function3<Set<String>, String, Object, Tuple2<Seq<R>, Seq<Tuple2<Object, String>>>> analyze, boolean advanceSavepoints) {
        Flow eventChecker = (Flow)Flow$.MODULE$.apply().map((Function1<Tuple3, Tuple3> & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int eventCode = BoxesRunTime.unboxToInt(tuple3._1());
                String personCode = (String)tuple3._2();
                long rownum = BoxesRunTime.unboxToLong(tuple3._3());
                if (!MODULE$.personEventCodeToRequestFactory().contains(BoxesRunTime.boxToInteger(eventCode))) {
                    throw scala.sys.package$.MODULE$.error(new StringBuilder(35).append("Unexpected person event type code: ").append(eventCode).toString());
                }
                if (MODULE$.personEventCodeToRequestFactory().apply(BoxesRunTime.boxToInteger(eventCode)) == null) {
                    return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(MODULE$.PersonCodeEventRequestCode()), personCode, BoxesRunTime.boxToLong(rownum));
                }
                return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(eventCode), personCode, BoxesRunTime.boxToLong(rownum));
            }
            throw new MatchError(tuple3);
        });
        Flow consumer = (Flow)Flow$.MODULE$.apply().mapAsync(1, (Function1<Tuple3, Future> & Serializable)x$13 -> {
            Tuple3 tuple3 = x$13;
            if (tuple3 != null) {
                int eventCode = BoxesRunTime.unboxToInt(tuple3._1());
                Set personCodes = (Set)tuple3._2();
                long minRownum = BoxesRunTime.unboxToLong(tuple3._3());
                Function1 requestFactory = (Function1)MODULE$.personEventCodeToRequestFactory().apply(BoxesRunTime.boxToInteger(eventCode));
                Future recordsAndAlsoExploreF = MODULE$.doAsyncRequest((PMLP.PmlpRequest)requestFactory.apply(personCodes)).flatMap((Function1<Tuple2, Future> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String body = (String)tuple2._1();
                        Function1 confirm = (Function1)tuple2._2();
                        Tuple2 analyzed2 = (Tuple2)analyze.apply(personCodes, body, BoxesRunTime.boxToLong(minRownum));
                        return ((Future)confirm.apply(Success$.MODULE$.apply(analyzed2))).map((Function1<BoxedUnit, Tuple2> & Serializable)_$28 -> analyzed2, MODULE$.ec()).map((Function1<Tuple2, Tuple2> & Serializable)analyzed -> analyzed, MODULE$.ec());
                    }
                    throw new MatchError(tuple2);
                }, MODULE$.ec());
                return recordsAndAlsoExploreF.map((Function1<Tuple2, Tuple2> & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        Seq records = (Seq)tuple2._1();
                        Seq alsoExplore = (Seq)tuple2._2();
                        Seq alsoExploreWithRownum = (Seq)alsoExplore.map((Function1<Tuple2, Tuple3> & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                int eventCode = BoxesRunTime.unboxToInt(tuple2._1());
                                String personCode = (String)tuple2._2();
                                return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(eventCode), personCode, BoxesRunTime.boxToLong(minRownum));
                            }
                            throw new MatchError(tuple2);
                        });
                        return Tuple2$.MODULE$.apply(records, alsoExploreWithRownum);
                    }
                    throw new MatchError(tuple2);
                }, MODULE$.ec());
            }
            throw new MatchError(tuple3);
        }).buffer(this.personEventCodeToRequestFactory().size() * 2, OverflowStrategy$.MODULE$.fail()).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq records = (Seq)tuple2._1();
                Seq alsoExplore = (Seq)tuple2._2();
                return Tuple2$.MODULE$.apply(records, alsoExplore.$plus$plus((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(MODULE$.PersonCodeEventRequestCode()), dagr$PMLP$$$FeedbackChunkEnd, BoxesRunTime.boxToLong(0L))), Nil$.MODULE$)));
            }
            throw new MatchError(tuple2);
        });
        Flow toRecordSeqFlow = (Flow)Flow$.MODULE$.apply().map((Function1<Tuple2, Seq> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq records = (Seq)tuple2._1();
                Seq alsoExplore = (Seq)tuple2._2();
                return records;
            }
            throw new MatchError(tuple2);
        });
        Flow toExploreSeqFlow = (Flow)Flow$.MODULE$.apply().map((Function1<Tuple2, Seq> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq records = (Seq)tuple2._1();
                Seq alsoExplore = (Seq)tuple2._2();
                return alsoExplore;
            }
            throw new MatchError(tuple2);
        });
        Flow expander = (Flow)Flow$.MODULE$.apply().mapConcat((Function1<Seq, IterableOnce> & Serializable)x -> x);
        Flow crawler = Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create((Function1<GraphDSL.Builder, FlowShape> & Serializable)b -> {
            FlowShape sanitizer = (FlowShape)b.add(eventChecker);
            UniformFanInShape<Tuple3<Object, String, Object>, Tuple3<Object, Set<String>, Object>> grouper = b.add(new PMLP.FprEventGrouping(MODULE$.max_batch(), advanceSavepoints));
            UniformFanOutShape bcaster = (UniformFanOutShape)b.add(Broadcast$.MODULE$.apply(2, Broadcast$.MODULE$.apply$default$2()));
            FlowShape toRecSeq = (FlowShape)b.add(toRecordSeqFlow);
            FlowShape toExpSeq = (FlowShape)b.add(toExploreSeqFlow);
            GraphDSL$Implicits$.MODULE$.flow2flow(sanitizer, (GraphDSL.Builder<?>)b).$tilde$greater(grouper, (GraphDSL.Builder<?>)b).$tilde$greater(consumer, (GraphDSL.Builder<?>)b).$tilde$greater(bcaster, (GraphDSL.Builder<?>)b).$tilde$greater(toRecSeq, (GraphDSL.Builder<?>)b);
            new GraphDSL.Implicits.FanInOps(GraphDSL$Implicits$.MODULE$.FanInOps(grouper)).$less$tilde((Graph)expander, (GraphDSL.Builder)b).$less$tilde(toExpSeq, (GraphDSL.Builder)b).$less$tilde(bcaster, (GraphDSL.Builder)b);
            return FlowShape$.MODULE$.apply(sanitizer.in(), toRecSeq.out());
        }));
        return ((Flow)((Flow)Flow$.MODULE$.apply().via((Graph)crawler)).mapConcat((Function1<Seq, IterableOnce> & Serializable)x -> x).recover(new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    throw e;
                }
                return function1.apply(x);
            }
        })).named("fpr-person-events-crawler");
    }

    public Future<String> doRequest(String methodName, String body, String description, Function1<String, Option<Object>> responseDescription) {
        dagr$PMLP$$$flow_logger.debug(new StringBuilder(1).append(methodName).append(" ").append(description).toString());
        dagr$PMLP$$$http_logger.debug(new StringBuilder(9).append("REQUEST:\n").append(body).toString());
        HttpEntity.Strict entity = HttpEntity$Strict$.MODULE$.apply(this.contentType(), ByteString$.MODULE$.apply(body));
        Future<HttpResponse> result = this.client().doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.POST(), Uri$.MODULE$.apply(this.uri()), this.headers(), entity, HttpRequest$.MODULE$.apply$default$5()), this.client().doRequest$default$2(), this.client().doRequest$default$3(), this.client().doRequest$default$4());
        return result.flatMap((Function1<HttpResponse, Future> & Serializable)_$32 -> Unmarshal$.MODULE$.apply(_$32).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(Unmarshaller$.MODULE$.stringUnmarshaller()), MODULE$.ec(), MODULE$.materializer()), this.ec()).andThen(new Serializable(responseDescription){
            private final Function1 responseDescription$2;
            {
                this.responseDescription$2 = responseDescription$3;
            }

            public final boolean isDefinedAt(Try x) {
                Try try_ = x;
                return true;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Try try_ = x;
                PMLP$.dagr$PMLP$$$flow_logger.debug(new StringBuilder(2).append("  ").append(x.toOption().flatMap((Function1<String, Option> & Serializable)r -> (Option)Try$.MODULE$.apply(() -> this.applyOrElse$$anonfun$1$$anonfun$1(r)).toOption().getOrElse(PMLP$::dagr$PMLP$$anon$11$$_$applyOrElse$$anonfun$1$$anonfun$2)).getOrElse(PMLP$::dagr$PMLP$$anon$11$$_$applyOrElse$$anonfun$2)).toString());
                PMLP$.dagr$PMLP$$$http_logger.debug(new StringBuilder(10).append("RESPONSE:\n").append(x).toString());
                return BoxedUnit.UNIT;
            }

            private final Option applyOrElse$$anonfun$1$$anonfun$1(String r$1) {
                return (Option)this.responseDescription$2.apply(r$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.String ), dagr$PMLP$$anon$11$$_$applyOrElse$$anonfun$2(), applyOrElse$$anonfun$1$$anonfun$1(java.lang.String ), dagr$PMLP$$anon$11$$_$applyOrElse$$anonfun$1$$anonfun$2()}, serializedLambda);
            }
        }, this.ec());
    }

    public Function1<String, Option<Object>> doRequest$default$4() {
        return (Function1<String, Option> & Serializable)_$31 -> None$.MODULE$;
    }

    public Future<String> doRequest(PMLP.PmlpRequest request, Function1<String, Option<Object>> responseDescription) {
        return this.doRequest(request.methodName(), request.soapEnvelope(), request.description(), responseDescription);
    }

    public static final int dagr$PMLP$$anon$1$$_$compare$$anonfun$1() {
        return 999;
    }

    public static final int dagr$PMLP$$anon$1$$_$compare$$anonfun$2() {
        return 999;
    }

    public static final String dagr$PMLP$AsyncRequestLock$$$_$_$$anonfun$1() {
        return "";
    }

    public static final /* synthetic */ boolean dagr$PMLP$AsyncRequestLock$$$_$getOldRequestById$$anonfun$1(String oldRequestId$1, PMLP.AsyncRequestInfo _$3) {
        String string2 = _$3.requestId();
        String string3 = oldRequestId$1;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ Tuple2 dagr$PMLP$AsyncRequestLock$$$_$getOldRequestById$$anonfun$2(PMLP.AsyncRequestInfo info) {
        return Tuple2$.MODULE$.apply(info.request(), info.requestStartTime());
    }

    public static final Tuple2 dagr$PMLP$AsyncRequestLock$$$_$getOldRequestById$$anonfun$3() {
        return Tuple2$.MODULE$.apply(PMLP$OldUnknownPmlpRequest$.MODULE$, null);
    }

    public static final /* synthetic */ boolean dagr$PMLP$AsyncRequestLock$$$_$confirmSuccess$$anonfun$1(String requestId$1, PMLP.AsyncRequestInfo _$4) {
        String string2 = _$4.requestId();
        String string3 = requestId$1;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean dagr$PMLP$AsyncRequestLock$$$_$confirmSuccess$$anonfun$2(PMLP.AsyncRequestInfo _$5) {
        return _$5.requestStartTime() != null;
    }

    public static final /* synthetic */ void dagr$PMLP$AsyncRequestLock$$$_$confirmSuccess$$anonfun$3(PMLP.AsyncRequestInfo requestInfo) {
        PMLP$AsyncRequestLock$.dagr$PMLP$AsyncRequestLock$$$monitoringOrUnknownRequestFailed = false;
        PMLP$AsyncRequestLock$.dagr$PMLP$AsyncRequestLock$$$lastSuccessfulMonitoringStartTime = requestInfo.requestStartTime();
        dagr$PMLP$$$flow_logger.info(new StringBuilder(47).append("Monitoring requested at ").append(requestInfo.requestStartTime()).append(" processed successfully").toString());
    }

    private static final int waitForBody$1$$anonfun$1$$anonfun$1$$anonfun$1(PMLP.PmlpRequest request$3, String statusResponse$1) {
        throw new RuntimeException(new StringBuilder(43).append("Failed to extract request status for ").append(request$3.fullDescription()).append(" from ").append(statusResponse$1).toString());
    }

    private static final Future waitForBody$1$$anonfun$3$$anonfun$1$$anonfun$2(PMLP.PmlpRequest request$6, String response$1) {
        return Future$.MODULE$.failed(new PMLP.FailedToExtractAsyncResponseBodyException(new StringBuilder(47).append("Failed to extract async response body to ").append(request$6.fullDescription()).append(" from ").append(response$1).toString()));
    }

    private static final /* synthetic */ Future waitForBody$1$$anonfun$3(String requestId$3, PMLP.PmlpRequest request$4, int requestStatus) {
        return (requestStatus < 5 ? MODULE$.GetAsyncResponse(requestId$3) : Future$.MODULE$.failed(new RuntimeException(new StringBuilder(36).append("Unexpected async result status ").append(requestStatus).append(" to ").append(request$4.fullDescription()).append(" ").append(requestId$3).toString()))).flatMap((Function1<String, Future> & Serializable)response -> ((Future)MODULE$.asyncResponseBodyOption((String)response).map((Function1<String, Future> & Serializable)result -> Future$.MODULE$.successful(result)).getOrElse(() -> PMLP$.waitForBody$1$$anonfun$3$$anonfun$1$$anonfun$2(request$4, response))).map((Function1<String, Tuple2> & Serializable)body -> Tuple2$.MODULE$.apply(body, BoxesRunTime.boxToInteger(requestStatus)), MODULE$.ec()), MODULE$.ec());
    }

    private final Future waitForBody$1(PMLP.PmlpRequest request, String requestId, Instant requestStartTime) {
        PMLP$AsyncRequestLock$.MODULE$.setCurrentRequestId(request, requestId, requestStartTime);
        return ((Source)Source$.MODULE$.tick(this.pollInterval(), this.pollInterval(), NotUsed$.MODULE$).mapAsync(1, (Function1<NotUsed$, Future> & Serializable)_$6 -> MODULE$.GetAsyncStatus(requestId).map((Function1<String, int> & Serializable)statusResponse -> PMLP$AsyncRequestLock$.MODULE$.setCurrentRequestStatus(BoxesRunTime.unboxToInt(MODULE$.requestStatusOption((String)statusResponse).getOrElse(() -> PMLP$.waitForBody$1$$anonfun$1$$anonfun$1$$anonfun$1(request, statusResponse)))), MODULE$.ec())).filterNot(_$7 -> _$7 < 3)).runWith(Sink$.MODULE$.head(), this.materializer()).flatMap((Function1<Object, Future> & Serializable)requestStatus -> PMLP$.waitForBody$1$$anonfun$3(requestId, request, BoxesRunTime.unboxToInt(requestStatus)), this.ec());
    }

    public final Future dagr$PMLP$$$_$onSuccessConfirm$1(PMLP.PmlpRequest request, String requestId, int requestStatus, Try consumed) {
        Future<BoxedUnit> future;
        Try try_ = consumed;
        if (try_ instanceof Success) {
            if (requestStatus == 3 || requestStatus == 4) {
                PMLP$AsyncRequestLock$.MODULE$.confirmSuccess(request, requestId);
                future = this.ConfirmAsync(requestId).map(_$8 -> {}, this.ec());
            } else {
                future = Future$.MODULE$.successful(BoxedUnit.UNIT);
            }
        } else if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            future = Future$.MODULE$.failed(ex);
        } else {
            throw new MatchError(try_);
        }
        return future.andThen(new Serializable(){

            public final boolean isDefinedAt(Try x) {
                Try try_ = x;
                return true;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Try try_ = x;
                PMLP$AsyncRequestLock$.MODULE$.setCurrentRequestId(null, null, null);
                return BoxedUnit.UNIT;
            }
        }, this.ec());
    }

    private static final String requestIdOrFail$1$$anonfun$1(String response$2) {
        throw new RuntimeException(new StringBuilder(33).append("Failed to extract requestId from ").append(response$2).toString());
    }

    private final String requestIdOrFail$1(String response) {
        return (String)this.requestIdOption(response).getOrElse(() -> PMLP$.requestIdOrFail$1$$anonfun$1(response));
    }

    private final PartialFunction maybeTrashOnBadBody$1(PMLP.PmlpRequest request, String requestId) {
        return new Serializable(request, requestId){
            public final PMLP.PmlpRequest dagr$PMLP$$anon$3$$request$7;
            public final String dagr$PMLP$$anon$3$$requestId$4;
            {
                this.dagr$PMLP$$anon$3$$request$7 = request$18;
                this.dagr$PMLP$$anon$3$$requestId$4 = requestId$8;
            }

            public final boolean isDefinedAt(Try x) {
                Throwable throwable;
                Try try_ = x;
                if (try_ instanceof Failure && (throwable = ((Failure)try_).exception()) instanceof PMLP.FailedToExtractAsyncResponseBodyException) {
                    PMLP.FailedToExtractAsyncResponseBodyException ex = (PMLP.FailedToExtractAsyncResponseBodyException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Throwable throwable;
                Try try_ = x;
                if (try_ instanceof Failure && (throwable = ((Failure)try_).exception()) instanceof PMLP.FailedToExtractAsyncResponseBodyException) {
                    PMLP.FailedToExtractAsyncResponseBodyException ex = (PMLP.FailedToExtractAsyncResponseBodyException)throwable;
                    PMLP.PmlpRequest pmlpRequest = this.dagr$PMLP$$anon$3$$request$7;
                    PMLP$OldUnknownPmlpRequest$ pMLP$OldUnknownPmlpRequest$ = PMLP$OldUnknownPmlpRequest$.MODULE$;
                    if (pmlpRequest == null ? pMLP$OldUnknownPmlpRequest$ != null : !((Object)pmlpRequest).equals(pMLP$OldUnknownPmlpRequest$)) {
                        String string2 = this.dagr$PMLP$$anon$3$$request$7.methodName();
                        String string3 = PMLP$.dagr$PMLP$$$GetMonitoringFlags;
                        if (string2 == null ? string3 != null : !string2.equals(string3)) {
                            PMLP$.MODULE$.reportFprWarning(new StringBuilder(20).append("Trashing ").append(this.dagr$PMLP$$anon$3$$request$7.fullDescription()).append(" ").append(this.dagr$PMLP$$anon$3$$requestId$4).append(" because: ").append(ex.getMessage()).toString(), PMLP$.MODULE$.reportFprWarning$default$2(), PMLP$.MODULE$.reportFprWarning$default$3());
                            PMLP$.MODULE$.dagr$PMLP$$$_$onSuccessConfirm$1(this.dagr$PMLP$$anon$3$$request$7, this.dagr$PMLP$$anon$3$$requestId$4, 3, Success$.MODULE$.apply(BoxedUnit.UNIT)).andThen(new Serializable(this){
                                private final /* synthetic */ anon.3 $outer;
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }

                                public final boolean isDefinedAt(Try x) {
                                    Try try_ = x;
                                    if (try_ instanceof Failure) {
                                        Throwable ex = ((Failure)try_).exception();
                                        return true;
                                    }
                                    return try_ instanceof Success;
                                }

                                public final Object applyOrElse(Try x, Function1 function1) {
                                    Try try_ = x;
                                    if (try_ instanceof Failure) {
                                        Throwable ex = ((Failure)try_).exception();
                                        return PMLP$.MODULE$.reportFprWarning(new StringBuilder(19).append("Failed to trash ").append(this.$outer.dagr$PMLP$$anon$3$$requestId$4).append(" - ").append(this.$outer.dagr$PMLP$$anon$3$$request$7.fullDescription()).toString(), ex, PMLP$.MODULE$.reportFprWarning$default$3());
                                    }
                                    if (try_ instanceof Success) {
                                        return PMLP$.MODULE$.reportFprWarning(new StringBuilder(11).append("Trashed ").append(this.$outer.dagr$PMLP$$anon$3$$requestId$4).append(" - ").append(this.$outer.dagr$PMLP$$anon$3$$request$7.fullDescription()).toString(), PMLP$.MODULE$.reportFprWarning$default$2(), PMLP$.MODULE$.reportFprWarning$default$3());
                                    }
                                    return function1.apply(x);
                                }
                            }, PMLP$.MODULE$.ec());
                            return BoxedUnit.UNIT;
                        }
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    private final String requestIdToTrash$lzyINIT1$1(LazyRef requestIdToTrash$lzy1$1) {
        String string2;
        LazyRef lazyRef = requestIdToTrash$lzy1$1;
        synchronized (lazyRef) {
            Object t;
            if (requestIdToTrash$lzy1$1.initialized()) {
                t = requestIdToTrash$lzy1$1.value();
            } else {
                String workingDir = this.config().getString("input-files");
                Path fRequestIdToTrash = FileSystems.getDefault().getPath(workingDir, "request-id-to-trash.txt");
                t = requestIdToTrash$lzy1$1.initialize(fRequestIdToTrash.toFile().exists() ? (String)Option$.MODULE$.apply(Files.readString(fRequestIdToTrash, StandardCharsets.UTF_8).trim()).filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)_$10 -> {
                    String string2 = _$10;
                    String string3 = "";
                    return string2 == null ? string3 != null : !string2.equals(string3);
                }).orNull($less$colon$less$.MODULE$.refl()) : null);
            }
            string2 = (String)t;
        }
        return string2;
    }

    private final String requestIdToTrash$1(LazyRef requestIdToTrash$lzy1$2) {
        return (String)(requestIdToTrash$lzy1$2.initialized() ? requestIdToTrash$lzy1$2.value() : this.requestIdToTrash$lzyINIT1$1(requestIdToTrash$lzy1$2));
    }

    private final /* synthetic */ Future doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(boolean oldCanReuse$2, PMLP.PmlpRequest request$15, String oldRequestIdDescription$8, PMLP.PmlpRequest oldRequest$5, String oldRequestId$6, Instant oldRequestStartTime$5, Tuple2 oldResponse$4, boolean oldConfirmDone) {
        Future future;
        if (oldCanReuse$2) {
            this.reportFprWarning(new StringBuilder(21).append("Reusing response to ").append(request$15.methodName()).append(" ").append(oldRequestIdDescription$8).toString(), this.reportFprWarning$default$2(), this.reportFprWarning$default$3());
            future = Future$.MODULE$.successful(Tuple3$.MODULE$.apply(oldRequest$5, oldRequestId$6, oldRequestStartTime$5));
        } else {
            Instant requestStartTime = Instant.now();
            future = this.doRequest(request$15, (Function1<String, Option<Object>>)(Function1<String, Option> & Serializable)response -> MODULE$.requestIdOption((String)response)).map((Function1<String, String> & Serializable)response -> this.requestIdOrFail$1((String)response), this.ec()).map((Function1<String, Tuple3> & Serializable)_$12 -> Tuple3$.MODULE$.apply(request$15, _$12, requestStartTime), this.ec());
        }
        return future.flatMap((Function1<Tuple3, Future> & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                PMLP.PmlpRequest nowRequest = (PMLP.PmlpRequest)tuple3._1();
                String nowRequestId = (String)tuple3._2();
                Instant nowRequestStartTime = (Instant)tuple3._3();
                return (oldCanReuse$2 ? Future$.MODULE$.successful(oldResponse$4) : this.waitForBody$1(nowRequest, nowRequestId, nowRequestStartTime).andThen(this.maybeTrashOnBadBody$1(nowRequest, nowRequestId), this.ec())).map((Function1<Tuple2, Tuple2> & Serializable)nowResponse -> {
                    Tuple2 tuple2 = nowResponse;
                    if (tuple2 != null) {
                        String body = (String)tuple2._1();
                        int requestStatus = BoxesRunTime.unboxToInt(tuple2._2());
                        return Tuple2$.MODULE$.apply(body, (Function1<Try, Future> & Serializable)consumed -> this.dagr$PMLP$$$_$onSuccessConfirm$1(nowRequest, nowRequestId, requestStatus, (Try)consumed));
                    }
                    throw new MatchError(tuple2);
                }, this.ec());
            }
            throw new MatchError(tuple3);
        }, this.ec());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final /* synthetic */ Future doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2(Tuple2 oldResponse$3, String oldRequestIdDescription$6, PMLP.PmlpRequest oldRequest$4, String oldRequestId$5, boolean oldCanReuse$1, PMLP.PmlpRequest request$14, Instant oldRequestStartTime$4, boolean oldCanConfirm) {
        Future<Boolean> future;
        if (oldCanConfirm) {
            String string2;
            List<String> list;
            Option<List<String>> option;
            Tuple2 tuple2 = oldResponse$3;
            if (tuple2 == null) throw new MatchError(tuple2);
            String oldResponse = (String)tuple2._1();
            int oldRequestStatus = BoxesRunTime.unboxToInt(tuple2._2());
            String string3 = oldResponse;
            if (string3 == null || (option = ResponseStructureElementNamePattern.unapplySeq(string3)).isEmpty() || (list = option.get()).lengthCompare(1) != 0) {
                throw new RuntimeException(new StringBuilder(48).append("Failed to extract methodName from old response: ").append(oldResponse).toString());
            }
            String methodName = string2 = list.apply(0);
            String oldResponseMethodName = methodName;
            String responseDescription = new StringBuilder(9).append("response ").append(oldResponseMethodName).toString();
            this.reportFprWarning(new StringBuilder(12).append("Trashing ").append(responseDescription).append(" - ").append(oldRequestIdDescription$6).toString(), this.reportFprWarning$default$2(), this.reportFprWarning$default$3());
            future = this.dagr$PMLP$$$_$onSuccessConfirm$1(oldRequest$4, oldRequestId$5, oldRequestStatus, Success$.MODULE$.apply(BoxedUnit.UNIT)).map((Function1<BoxedUnit, boolean> & Serializable)_$11 -> {
                this.reportFprWarning(new StringBuilder(11).append("Trashed ").append(responseDescription).append(" - ").append(oldRequestIdDescription$6).toString(), this.reportFprWarning$default$2(), this.reportFprWarning$default$3());
                return true;
            }, this.ec());
            return future.flatMap((Function1<Object, Future> & Serializable)oldConfirmDone -> this.doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(oldCanReuse$1, request$14, oldRequestIdDescription$6, oldRequest$4, oldRequestId$5, oldRequestStartTime$4, oldResponse$3, BoxesRunTime.unboxToBoolean(oldConfirmDone)), this.ec());
        } else {
            future = Future$.MODULE$.successful(BoxesRunTime.boxToBoolean(false));
        }
        return future.flatMap((Function1<Object, Future> & Serializable)oldConfirmDone -> this.doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(oldCanReuse$1, request$14, oldRequestIdDescription$6, oldRequest$4, oldRequestId$5, oldRequestStartTime$4, oldResponse$3, BoxesRunTime.unboxToBoolean(oldConfirmDone)), this.ec());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final /* synthetic */ Future doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1(boolean oldIgnoreDone$2, Tuple2 oldResponse$1, String oldRequestIdDescription$4, PMLP.PmlpRequest oldRequest$3, String oldRequestId$4, PMLP.PmlpRequest request$13, Instant oldRequestStartTime$3, boolean oldCanReuse) {
        Future<Boolean> future;
        if (oldIgnoreDone$2 || oldCanReuse) {
            future = Future$.MODULE$.successful(BoxesRunTime.boxToBoolean(false));
            return future.flatMap((Function1<Object, Future> & Serializable)oldCanConfirm -> this.doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2(oldResponse$1, oldRequestIdDescription$4, oldRequest$3, oldRequestId$4, oldCanReuse, request$13, oldRequestStartTime$3, BoxesRunTime.unboxToBoolean(oldCanConfirm)), this.ec());
        } else {
            String string2;
            String methodName;
            List<String> list;
            Option<List<String>> option;
            Tuple2 tuple2 = oldResponse$1;
            if (tuple2 == null) throw new MatchError(tuple2);
            String oldResponse = (String)tuple2._1();
            String string3 = oldResponse;
            if (string3 == null || (option = ResponseStructureElementNamePattern.unapplySeq(string3)).isEmpty() || (list = option.get()).lengthCompare(1) != 0) throw new RuntimeException(new StringBuilder(48).append("Failed to extract methodName from old response: ").append(oldResponse).toString());
            String string4 = methodName = (string2 = list.apply(0));
            String string5 = dagr$PMLP$$$GetMonitoringFlags;
            future = !(string4 != null ? !string4.equals(string5) : string5 != null) ? this.personEventsSourceFromMonitoringMessage(oldResponse).runWith(Sink$.MODULE$.seq(), this.materializer()).map((Function1<Seq, boolean> & Serializable)items -> {
                if (items.isEmpty()) {
                    this.reportFprWarning(new StringBuilder(54).append("Monitoring response seems to be empty, safe to trash: ").append(oldResponse).toString(), this.reportFprWarning$default$2(), this.reportFprWarning$default$3());
                    return true;
                }
                throw new PMLP.UnconfirmedMonitoringResponseException(new StringBuilder(45).append("Must not trash non-empty monitoring response ").append(oldRequestIdDescription$4).toString());
            }, this.ec()) : Future$.MODULE$.successful(BoxesRunTime.boxToBoolean(true));
        }
        return future.flatMap((Function1<Object, Future> & Serializable)oldCanConfirm -> this.doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2(oldResponse$1, oldRequestIdDescription$4, oldRequest$3, oldRequestId$4, oldCanReuse, request$13, oldRequestStartTime$3, BoxesRunTime.unboxToBoolean(oldCanConfirm)), this.ec());
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ Future doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1(boolean oldIgnoreDone$1, PMLP.PmlpRequest request$12, PMLP.PmlpRequest oldRequest$2, String oldRequestIdDescription$3, String oldRequestId$3, Instant oldRequestStartTime$2, Tuple2 oldResponse) {
        block3: {
            block2: {
                if (!oldIgnoreDone$1) break block2;
                v0 = Future$.MODULE$.successful(BoxesRunTime.boxToBoolean(false));
                break block3;
            }
            v1 = request$12.methodName();
            var8_8 = PMLP$.dagr$PMLP$$$GetMonitoringFlags;
            if (v1 != null ? v1.equals(var8_8) == false : var8_8 != null) ** GOTO lbl-1000
            v2 = request$12;
            var9_9 = oldRequest$2;
            if (!(v2 == null ? var9_9 != null : v2.equals(var9_9) == false) || request$12.requestBody().indexOf("<DateFrom>") < 0) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            v0 = Future$.MODULE$.successful(BoxesRunTime.boxToBoolean(v3));
        }
        return v0.flatMap((Function1<Object, Future> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$adapted$1(boolean scala.Tuple2 java.lang.String dagr.PMLP$PmlpRequest java.lang.String dagr.PMLP$PmlpRequest java.time.Instant java.lang.Object ), (Ljava/lang/Object;)Lscala/concurrent/Future;)((PMLP$)this, (boolean)oldIgnoreDone$1, (Tuple2)oldResponse, (String)oldRequestIdDescription$3, (PMLP.PmlpRequest)oldRequest$2, (String)oldRequestId$3, (PMLP.PmlpRequest)request$12, (Instant)oldRequestStartTime$2), this.ec());
    }

    private final /* synthetic */ Future doAsyncRequest$$anonfun$2$$anonfun$3(PMLP.PmlpRequest oldRequest$1, String oldRequestId$2, Instant oldRequestStartTime$1, PMLP.PmlpRequest request$11, String oldRequestIdDescription$2, boolean oldIgnoreDone) {
        return (oldIgnoreDone ? Future$.MODULE$.successful(Tuple2$.MODULE$.apply(null, BoxesRunTime.boxToInteger(0))) : this.waitForBody$1(oldRequest$1, oldRequestId$2, oldRequestStartTime$1)).flatMap(arg_0 -> this.doAsyncRequest$$anonfun$2$$anonfun$3$$anonfun$1(oldIgnoreDone, request$11, oldRequest$1, oldRequestIdDescription$2, oldRequestId$2, oldRequestStartTime$1, arg_0), this.ec());
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final String monitoringFlagsRequest$$anonfun$2() {
        return "";
    }

    public static final /* synthetic */ long dagr$PMLP$FprEventGrouping$$anon$7$$_$_$$anonfun$13(Tuple2 _$29) {
        return BoxesRunTime.unboxToLong(((Tuple2)_$29._2())._2());
    }

    public static final Tuple2 dagr$PMLP$FprEventGrouping$$anon$7$$_$_$$anonfun$14() {
        return Tuple2$.MODULE$.apply(Predef$.MODULE$.Set().empty(), BoxesRunTime.boxToLong(Long.MAX_VALUE));
    }

    public static final /* synthetic */ long dagr$PMLP$FprEventGrouping$$anon$7$$_$_$$anonfun$15(Tuple2 _$30) {
        return BoxesRunTime.unboxToLong(_$30._2());
    }

    public static final Option dagr$PMLP$$anon$11$$_$applyOrElse$$anonfun$1$$anonfun$2() {
        return None$.MODULE$;
    }

    public static final Object dagr$PMLP$$anon$11$$_$applyOrElse$$anonfun$2() {
        return "[done]";
    }
}

