/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import scala.Option;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public class NextRownumPersistence {
    private final File file;
    private final Logger logger;
    private FileChannel channel;

    public NextRownumPersistence(File file, Logger logger) {
        this.file = file;
        this.logger = logger;
        ByteBuffer buffer = ByteBuffer.allocate(256);
    }

    private FileChannel getChannel() {
        if (this.channel == null) {
            if (!Files.exists(this.file.toPath(), new LinkOption[0])) {
                if (!this.file.createNewFile()) {
                    throw package$.MODULE$.error(new StringBuilder(22).append("Failed to create file ").append(this.file).toString());
                }
            } else if (Files.isDirectory(this.file.toPath(), new LinkOption[0])) {
                throw package$.MODULE$.error(new StringBuilder(40).append("Expected regular file, found directory: ").append(this.file).toString());
            }
            this.channel = FileChannel.open(this.file.toPath(), StandardOpenOption.WRITE);
        }
        return this.channel;
    }

    public void saveNextReadPos(long pos) {
        try {
            ByteBuffer record = StandardCharsets.UTF_8.encode(String.valueOf(BoxesRunTime.boxToLong(pos)));
            NextRownumPersistence nextRownumPersistence = this;
            synchronized (nextRownumPersistence) {
                FileChannel ch = this.getChannel();
                ch.position(0L);
                ch.write(record);
                ch.truncate(ch.position());
                ch.force(true);
            }
            this.logger.debug(new StringBuilder(26).append("Next read position saved: ").append(pos).toString());
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                String info = new StringBuilder(39).append("Failed to persist next read position (").append(pos).append(")").toString();
                throw new RuntimeException(info, ex);
            }
            throw throwable;
        }
    }
}

