/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.DagrLogbackEvents;
import dagr.DagrLogbackEvents$;
import dagr.HttpClient;
import dagr.SecurityTokenServiceClient;
import dagr.Token;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric$IntIsIntegral$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import spray.json.JsString$;

public class InfoToDagr {
    private final HttpClient http;
    private final SecurityTokenServiceClient tokenS;
    private final ExecutionContext ec;
    private final String client_id;
    private final String target_server_uri;
    public final Logger dagr$InfoToDagr$$logger;

    public InfoToDagr(Config config, HttpClient http, SecurityTokenServiceClient tokenS, ActorSystem system, ExecutionContext ec) {
        this.http = http;
        this.tokenS = tokenS;
        this.ec = ec;
        this.client_id = config.getString("provider.client_id");
        this.target_server_uri = config.getString("target_server_uri");
        this.dagr$InfoToDagr$$logger = LoggerFactory.getLogger(DagrLogbackEvents$.MODULE$.infoToDagrLoggerName());
    }

    private Future<BoxedUnit> putRequest(ByteString entity, String updUri, String succMsg, String errMsg) {
        return this.tokenS.getToken().flatMap((Function1<Token, Future> & Serializable)token -> this.http.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.PUT(), Uri$.MODULE$.apply(new StringBuilder(2).append(this.target_server_uri).append("/").append(updUri).append("/").append(this.client_id).toString()), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$)), HttpEntity$.MODULE$.apply((ContentType)ContentTypes$.MODULE$.application$divjson(), ByteString$.MODULE$.apply(entity)), HttpRequest$.MODULE$.apply$default$5()), this.http.doRequest$default$2(), this.http.doRequest$default$3(), this.http.doRequest$default$4()).andThen(new Serializable(succMsg, errMsg, this){
            private final String succMsg$2;
            private final String errMsg$2;
            private final /* synthetic */ InfoToDagr $outer;
            {
                this.succMsg$2 = succMsg$3;
                this.errMsg$2 = errMsg$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Try x) {
                Try try_ = x;
                if (try_ instanceof Success) {
                    return true;
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Try try_ = x;
                if (try_ instanceof Success) {
                    this.$outer.dagr$InfoToDagr$$logger.debug(this.succMsg$2);
                    return BoxedUnit.UNIT;
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    this.$outer.dagr$InfoToDagr$$logger.error(this.errMsg$2, ex);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        }, this.ec).map(response -> {}, this.ec), this.ec);
    }

    public Future<BoxedUnit> sendMail(String subject, String content) {
        String jsSubject = JsString$.MODULE$.apply(subject).compactPrint();
        String jsContent = JsString$.MODULE$.apply(content).compactPrint();
        return this.putRequest(ByteString$.MODULE$.apply(new StringBuilder(23).append("{\"subject\": ").append(jsSubject).append(", \"body\": ").append(jsContent).append("}").toString()), "updater_problem", new StringBuilder(21).append("Problem reported - ").append(subject).append(", ").append(content).toString(), new StringBuilder(29).append("Failed to report problem - ").append(subject).append(", ").append(content).toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Future<BoxedUnit> sendLog(boolean printDebug) {
        Seq<DagrLogbackEvents.LogToDagrPackage> logPackages;
        Seq<DagrLogbackEvents.LogToDagrPackage> seq = logPackages = DagrLogbackEvents$.MODULE$.getData();
        Nil$ nil$ = package$.MODULE$.Nil();
        Seq<DagrLogbackEvents.LogToDagrPackage> seq2 = seq;
        if (!(nil$ != null ? !((Object)nil$).equals(seq2) : seq2 != null)) {
            this.dagr$InfoToDagr$$logger.info("no new log packages prepared to send to DAGR");
            return logPackages.foldLeft(Future$.MODULE$.successful(BoxedUnit.UNIT), (Function2<Future, DagrLogbackEvents.LogToDagrPackage, Future> & Serializable)(prevF, logPackage) -> prevF.flatMap((Function1<BoxedUnit, Future> & Serializable)_$2 -> {
                if (logPackage.events().nonEmpty()) {
                    String msg = logPackage.events().mkString("{\"data\":[", ",", "]}");
                    if (printDebug) {
                        this.dagr$InfoToDagr$$logger.debug(new StringBuilder(23).append("log messages to DAGR: \n").append(msg).toString());
                    }
                    return this.putRequest(ByteString$.MODULE$.apply(msg), "updater_connector_logs", "Log batch sent to DAGR", "Failed to send log batch to DAGR").andThen(new Serializable((DagrLogbackEvents.LogToDagrPackage)logPackage, this){
                        private final DagrLogbackEvents.LogToDagrPackage logPackage$2;
                        private final /* synthetic */ InfoToDagr $outer;
                        {
                            this.logPackage$2 = logPackage$3;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Try x) {
                            Try try_ = x;
                            return true;
                        }

                        public final Object applyOrElse(Try x, Function1 function1) {
                            Try try_ = x;
                            this.$outer.dagr$InfoToDagr$$logger.info("log package sent to DAGR, initiate cleanup of old events");
                            DagrLogbackEvents$.MODULE$.clean(this.logPackage$2);
                            return BoxedUnit.UNIT;
                        }
                    }, this.ec);
                }
                return Future$.MODULE$.successful(BoxedUnit.UNIT);
            }, this.ec));
        }
        if (seq instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)seq;
            List list = $colon$colon.next();
            DagrLogbackEvents.LogToDagrPackage p = (DagrLogbackEvents.LogToDagrPackage)$colon$colon.head();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$2 != null ? !((Object)nil$2).equals(list2) : list2 != null)) {
                this.dagr$InfoToDagr$$logger.info(new StringBuilder(61).append("1 log package (with count of events - ").append(p.events().size()).append(") ready to send to DAGR").toString());
                return logPackages.foldLeft(Future$.MODULE$.successful(BoxedUnit.UNIT), (Function2<Future, DagrLogbackEvents.LogToDagrPackage, Future> & Serializable)(prevF, logPackage) -> prevF.flatMap((Function1<BoxedUnit, Future> & Serializable)_$2 -> {
                    if (logPackage.events().nonEmpty()) {
                        String msg = logPackage.events().mkString("{\"data\":[", ",", "]}");
                        if (printDebug) {
                            this.dagr$InfoToDagr$$logger.debug(new StringBuilder(23).append("log messages to DAGR: \n").append(msg).toString());
                        }
                        return this.putRequest(ByteString$.MODULE$.apply(msg), "updater_connector_logs", "Log batch sent to DAGR", "Failed to send log batch to DAGR").andThen(new /* invalid duplicate definition of identical inner class */, this.ec);
                    }
                    return Future$.MODULE$.successful(BoxedUnit.UNIT);
                }, this.ec));
            }
        }
        Seq<DagrLogbackEvents.LogToDagrPackage> p = seq;
        this.dagr$InfoToDagr$$logger.info(new StringBuilder(70).append(logPackages.size()).append(" log packages (with total count of events - ").append(((IterableOnceOps)p.map((Function1<DagrLogbackEvents.LogToDagrPackage, int> & Serializable)_$1 -> _$1.events().size())).sum(Numeric$IntIsIntegral$.MODULE$)).append(") prepared to send to DAGR").toString());
        return logPackages.foldLeft(Future$.MODULE$.successful(BoxedUnit.UNIT), (Function2<Future, DagrLogbackEvents.LogToDagrPackage, Future> & Serializable)(prevF, logPackage) -> prevF.flatMap((Function1<BoxedUnit, Future> & Serializable)_$2 -> {
            if (logPackage.events().nonEmpty()) {
                String msg = logPackage.events().mkString("{\"data\":[", ",", "]}");
                if (printDebug) {
                    this.dagr$InfoToDagr$$logger.debug(new StringBuilder(23).append("log messages to DAGR: \n").append(msg).toString());
                }
                return this.putRequest(ByteString$.MODULE$.apply(msg), "updater_connector_logs", "Log batch sent to DAGR", "Failed to send log batch to DAGR").andThen(new /* invalid duplicate definition of identical inner class */, this.ec);
            }
            return Future$.MODULE$.successful(BoxedUnit.UNIT);
        }, this.ec));
    }
}

