/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import dagr.ClientException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.coding.Coder;
import org.apache.pekko.http.scaladsl.coding.Coders$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpMessage$;
import org.apache.pekko.http.scaladsl.model.HttpMessage$HttpMessageScalaDSLSugar$;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncoding;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodings$;
import org.apache.pekko.http.scaladsl.model.headers.Location;
import org.apache.pekko.http.scaladsl.model.headers.Location$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class HttpClient {
    private final ActorSystem system;
    private final ExecutionContext ec;
    public final Logger dagr$HttpClient$$logger;
    private final Flow<Tuple2<HttpRequest, BoxedUnit>, Tuple2<Try<HttpResponse>, BoxedUnit>, NotUsed> httpFlow;

    public HttpClient(ActorSystem system, ExecutionContext ec) {
        this.system = system;
        this.ec = ec;
        this.dagr$HttpClient$$logger = LoggerFactory.getLogger("dagr.http");
        Extension extension = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        this.httpFlow = ((HttpExt)extension).superPool(((HttpExt)extension).superPool$default$1(), ((HttpExt)extension).superPool$default$2(), ((HttpExt)extension).superPool$default$3());
    }

    public Flow<Tuple2<HttpRequest, BoxedUnit>, Tuple2<Try<HttpResponse>, BoxedUnit>, NotUsed> httpFlow() {
        return this.httpFlow;
    }

    public Future<HttpResponse> doRequest(HttpRequest req, int maxRedirects, UUID uuid, Option<String> debugUriOpt) {
        HttpMessage request = req.withHeaders((Seq)req.headers());
        this.dagr$HttpClient$$logger.debug(new StringBuilder(9).append("[").append(uuid).append("] HTTP ").append(((HttpRequest)request).method().value()).append(" ").append(debugUriOpt.getOrElse(() -> HttpClient.doRequest$$anonfun$1((HttpRequest)request))).toString());
        return ((Source)Source$.MODULE$.single(Tuple2$.MODULE$.apply(request, BoxedUnit.UNIT)).via(this.httpFlow())).runWith(Sink$.MODULE$.head(), Materializer$.MODULE$.matFromSystem(this.system)).recover(new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = option.get();
                    return Tuple2$.MODULE$.apply(Failure$.MODULE$.apply(ex), BoxedUnit.UNIT);
                }
                return function1.apply(x);
            }
        }, this.ec).flatMap(arg_0 -> this.doRequest$$anonfun$2(uuid, (HttpRequest)request, maxRedirects, req, arg_0), this.ec);
    }

    public int doRequest$default$2() {
        return 20;
    }

    public UUID doRequest$default$3() {
        return UUID.randomUUID();
    }

    public Option<String> doRequest$default$4() {
        return None$.MODULE$;
    }

    public Future<HttpResponse> onSuccessHttpResponse(HttpRequest request, HttpResponse response, int maxRedirects, Seq<HttpHeader> originReqHeaders) {
        block11: {
            Tuple2<Integer, Option> tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(response.status().intValue()), response.header(ClassTag$.MODULE$.apply(Location.class)));
            if (tuple2 != null) {
                Location location;
                int n = BoxesRunTime.unboxToInt(tuple2._1());
                Option option = tuple2._2();
                switch (n) {
                    case 200: 
                    case 201: 
                    case 204: 
                    case 206: {
                        return Future$.MODULE$.successful(response);
                    }
                }
                switch (n) {
                    case 301: {
                        break;
                    }
                    case 302: {
                        break;
                    }
                    case 303: {
                        break;
                    }
                    default: {
                        break block11;
                    }
                }
                if (option instanceof Some && (location = (Location)((Some)option).value()) != null) {
                    Uri uri;
                    Location location2 = Location$.MODULE$.unapply(location);
                    Uri uri2 = uri = location2._1();
                    HttpMessage$HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar(response), Materializer$.MODULE$.matFromSystem(this.system));
                    if (maxRedirects > 0) {
                        return this.doRequest(HttpRequest$.MODULE$.apply(HttpRequest$.MODULE$.apply$default$1(), uri2, originReqHeaders, HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), maxRedirects - 1, this.doRequest$default$3(), this.doRequest$default$4()).recover(new Serializable(response, request, this){
                            private final HttpResponse response$1;
                            private final HttpRequest request$3;
                            private final /* synthetic */ HttpClient $outer;
                            {
                                this.response$1 = response$4;
                                this.request$3 = request$5;
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public final boolean isDefinedAt(Throwable x) {
                                Option<Throwable> option;
                                Throwable throwable = x;
                                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                                    Throwable throwable2;
                                    Throwable e = throwable2 = option.get();
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(Throwable x, Function1 function1) {
                                Option<Throwable> option;
                                Throwable throwable = x;
                                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                                    Throwable throwable2;
                                    Throwable e = throwable2 = option.get();
                                    throw this.$outer.dagr$HttpClient$$requestFailed(e.getMessage(), e, this.response$1.status(), null, this.request$3);
                                }
                                return function1.apply(x);
                            }
                        }, this.ec);
                    }
                    throw this.dagr$HttpClient$$requestFailed("Too many http redirects", null, response.status(), uri2.toString(), request);
                }
            }
        }
        return Unmarshal$.MODULE$.apply(this.decodeResponse(response).entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), this.ec, Materializer$.MODULE$.matFromSystem(this.system)).recover(new Serializable(response, this){
            private final HttpResponse response$2;
            private final /* synthetic */ HttpClient $outer;
            {
                this.response$2 = response$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = option.get();
                    this.$outer.dagr$HttpClient$$logger.error(new StringBuilder(51).append("Failed to unmarshal response for unexpected status ").append(this.response$2.status().intValue()).toString(), e);
                    return "";
                }
                return function1.apply(x);
            }
        }, this.ec).flatMap((Function1<String, Future> & Serializable)content -> {
            String exceptionMessage = new StringBuilder(2).append(response.status().value()).append("\n").append(response.status().defaultMessage()).append("\n").append((String)content).toString();
            throw this.dagr$HttpClient$$requestFailed(exceptionMessage, null, response.status(), (String)content, request);
        }, this.ec);
    }

    private HttpResponse decodeResponse(HttpResponse response) {
        Coder coder;
        HttpEncoding httpEncoding = response.encoding();
        HttpEncoding httpEncoding2 = HttpEncodings$.MODULE$.gzip();
        HttpEncoding httpEncoding3 = httpEncoding;
        if (!(httpEncoding2 != null ? !((Object)httpEncoding2).equals(httpEncoding3) : httpEncoding3 != null)) {
            coder = Coders$.MODULE$.Gzip();
        } else {
            HttpEncoding httpEncoding4 = HttpEncodings$.MODULE$.deflate();
            HttpEncoding httpEncoding5 = httpEncoding;
            coder = !(httpEncoding4 != null ? !((Object)httpEncoding4).equals(httpEncoding5) : httpEncoding5 != null) ? Coders$.MODULE$.Deflate() : Coders$.MODULE$.NoCoding();
        }
        Coder decoder = coder;
        return (HttpResponse)decoder.decodeMessage(response);
    }

    public Nothing$ dagr$HttpClient$$requestFailed(String message, Throwable cause, StatusCode status, String content, HttpRequest request) {
        StatusCode causeStatus;
        StatusCode statusCode;
        String verboseMessage = request != null ? new StringBuilder(18).append("Request ").append(Option$.MODULE$.apply(request.method()).map((Function1<HttpMethod, String> & Serializable)_$3 -> _$3.value()).orNull($less$colon$less$.MODULE$.refl())).append(" ").append(request.uri()).append(" failed: ").append(message).toString() : message;
        Throwable throwable = cause;
        if (throwable instanceof ClientException) {
            ClientException ce = (ClientException)throwable;
            statusCode = ce.status();
        } else {
            statusCode = causeStatus = status;
        }
        if (request != null && request.entity().isStrict()) {
            RequestEntity requestEntity = request.entity();
            HttpEntity.Strict strict = HttpEntity$.MODULE$.Empty();
            if (requestEntity == null ? strict != null : !requestEntity.equals(strict)) {
                ContentType contentType = request.entity().contentType();
                ContentType.WithFixedCharset withFixedCharset = ContentTypes$.MODULE$.application$divjson();
                if (!(contentType != null ? !contentType.equals(withFixedCharset) : withFixedCharset != null)) {
                    request.entity().toStrict(new package.DurationInt(package$.MODULE$.DurationInt(1)).second(), Materializer$.MODULE$.matFromSystem(this.system)).onComplete(x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Success) {
                            HttpEntity.Strict strict = (HttpEntity.Strict)((Success)try_).value();
                            this.dagr$HttpClient$$logger.debug(strict.data().utf8String());
                            return;
                        }
                    }, this.ec);
                }
            }
        }
        throw new ClientException(verboseMessage, cause, causeStatus, content, request);
    }

    private static final Serializable doRequest$$anonfun$1(HttpRequest request$1) {
        return request$1.uri();
    }

    private final /* synthetic */ Future doRequest$$anonfun$2(UUID uuid$1, HttpRequest request$2, int maxRedirects$1, HttpRequest req$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Try try_ = (Try)tuple2._1();
            if (try_ instanceof Failure) {
                Throwable error = ((Failure)try_).exception();
                this.dagr$HttpClient$$logger.debug(new StringBuilder(36).append("[").append(uuid$1).append("] error occurred, class ").append(Option$.MODULE$.apply(error).map((Function1<Throwable, String> & Serializable)_$1 -> _$1.getClass().getName()).orNull($less$colon$less$.MODULE$.refl())).append(", message: ").append(Option$.MODULE$.apply(error).map((Function1<Throwable, String> & Serializable)_$2 -> _$2.getMessage()).orNull($less$colon$less$.MODULE$.refl())).toString());
                throw this.dagr$HttpClient$$requestFailed(error.getMessage(), error, null, null, request$2);
            }
            if (try_ instanceof Success) {
                HttpResponse response = (HttpResponse)((Success)try_).value();
                this.dagr$HttpClient$$logger.debug(new StringBuilder(8).append("[").append(uuid$1).append("] HTTP ").append(response.status().intValue()).toString());
                return this.onSuccessHttpResponse(request$2, response, maxRedirects$1, req$1.headers());
            }
        }
        throw new MatchError(tuple2);
    }
}

