/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import java.io.File;
import java.io.Serializable;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.client.RequestBuilding$;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpMessage$;
import org.apache.pekko.http.scaladsl.model.HttpMessage$HttpMessageScalaDSLSugar$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.headers.Last$minusModified;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.IOResult$;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.sys.package$;
import scala.util.Success;
import scala.util.Try;

public class Downloader {
    private final Logger logger = LoggerFactory.getLogger("dagr.download");

    public Logger logger() {
        return this.logger;
    }

    public Future<Option<IOResult>> download(String url, String destDir, String prefix, String suffix, ActorSystem system, ExecutionContext ec) {
        Extension extension = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        return ((HttpExt)extension).singleRequest(RequestBuilding$.MODULE$.Head().apply(url), ((HttpExt)extension).singleRequest$default$2(), ((HttpExt)extension).singleRequest$default$3(), ((HttpExt)extension).singleRequest$default$4()).map((Function1<HttpResponse, Option> & Serializable)headResponse -> {
            String fileName = Downloader.deriveFilename$1(prefix, suffix, url, headResponse);
            File destFile = new File(destDir, fileName);
            if (destFile.exists()) {
                this.logger().info(new StringBuilder(43).append("File already exists, skipping download for ").append(destFile).toString());
                return Some$.MODULE$.apply(IOResult$.MODULE$.apply(destFile.length()));
            }
            if (new File(destDir, new StringBuilder(5).append(fileName).append(".done").toString()).exists()) {
                this.logger().debug(new StringBuilder(46).append("File already processed, skipping download for ").append(destFile).toString());
                return Some$.MODULE$.apply(null);
            }
            return None$.MODULE$;
        }, ec).flatMap((Function1<Option, Future> & Serializable)localIoOpt -> {
            Future<Option<Object>> future;
            if (localIoOpt.isDefined()) {
                future = Future$.MODULE$.successful(localIoOpt);
            } else {
                Extension extension = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
                future = ((HttpExt)extension).singleRequest(RequestBuilding$.MODULE$.Get().apply(url), ((HttpExt)extension).singleRequest$default$2(), ((HttpExt)extension).singleRequest$default$3(), ((HttpExt)extension).singleRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)fileResponse -> {
                    String fileName = Downloader.deriveFilename$1(prefix, suffix, url, fileResponse);
                    File destFile = new File(destDir, fileName);
                    if (destFile.exists()) {
                        this.logger().info(new StringBuilder(43).append("File already exists, ignoring response for ").append(destFile).toString());
                        HttpMessage$HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar((HttpMessage)fileResponse), Materializer$.MODULE$.matFromSystem(system));
                        return Future$.MODULE$.successful(Some$.MODULE$.apply(IOResult$.MODULE$.apply(destFile.length())));
                    }
                    this.logger().info(new StringBuilder(18).append("Downloading file: ").append(destFile).toString());
                    File tmpFile = File.createTempFile(prefix, ".tmp", new File(destDir));
                    return fileResponse.entity().dataBytes().runWith(FileIO$.MODULE$.toPath(tmpFile.toPath(), FileIO$.MODULE$.toPath$default$2()), Materializer$.MODULE$.matFromSystem(system)).map((Function1<IOResult, Some> & Serializable)x$1 -> {
                        IOResult iOResult = x$1;
                        if (iOResult != null) {
                            IOResult iOResult2 = IOResult$.MODULE$.unapply(iOResult);
                            long l = iOResult2._1();
                            Try<Done> try_ = iOResult2._2();
                            long size = l;
                            if (try_ instanceof Success) {
                                IOResult r = iOResult;
                                if (size > 0L) {
                                    this.logger().info(new StringBuilder(35).append("Successfuly downloaded ").append(size).append(" bytes from ").append(url).toString());
                                    tmpFile.renameTo(destFile);
                                    return Some$.MODULE$.apply(r);
                                }
                            }
                        }
                        IOResult x = iOResult;
                        throw new RuntimeException(new StringBuilder(34).append("Failed to download from ").append(url).append(", result: ").append(x).toString());
                    }, ec);
                }, ec);
            }
            return future.map((Function1<Option, Option> & Serializable)ioOpt -> ioOpt.filter((Function1<IOResult, boolean> & Serializable)_$3 -> _$3 != null), ec);
        }, ec);
    }

    private static final String deriveFilename$1$$anonfun$3(String url$2) {
        throw package$.MODULE$.error(new StringBuilder(79).append("Last-Modified header was not found in response for '").append(url$2).append("'. Cannot derive file name.").toString());
    }

    private static final String deriveFilename$1(String prefix$1, String suffix$1, String url$1, HttpResponse resp) {
        return (String)resp.header(ClassTag$.MODULE$.apply(Last$minusModified.class)).map((Function1<Last$minusModified, String> & Serializable)_$1 -> _$1.date().toIsoDateTimeString().replaceAll("[-:]", "_")).map((Function1<String, String> & Serializable)_$2 -> new StringBuilder(0).append(prefix$1).append((String)_$2).append(suffix$1).toString()).getOrElse(() -> Downloader.deriveFilename$1$$anonfun$3(url$1));
    }
}

