/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import dagr.ConnectorData;
import dagr.DataToJdbc$QueryData$;
import dagr.DbAccess;
import dagr.HttpClient;
import dagr.JsonAnyValueDecoder$;
import dagr.Record;
import dagr.Record$;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SecurityTokenServiceClient;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import dagr.SyncType;
import dagr.SyncTypeForwardAll$;
import dagr.Token;
import io.bullet.borer.Decoder;
import io.bullet.borer.compat.pekkoHttp$;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.common.EntityStreamingSupport;
import org.apache.pekko.http.scaladsl.common.JsonEntityStreamingSupport;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.headers.Accept$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.FlowOpsMat;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString$;
import org.mojoz.metadata.FieldDef_;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.ViewDef_;
import org.mojoz.querease.Querease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.math.BigInt;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class DataToJdbc
implements ConnectorData {
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final Querease qe;
    private final String dataset_name;
    private final DbAccess dbAccess;
    private final HttpClient http;
    private final ActorSystem system;
    private final ExecutionContext ec;
    public final DataToJdbc$QueryData$ QueryData$lzy1;
    private final Logger logger;
    private final SecurityTokenServiceClient stsClient;
    private final String consumer_service_uri;
    private final int rootElementsBatchSize;
    private final Map<String, String> initialParams;
    private final Map<String, String> childTableIdSeqQuery;
    private final ConcurrentHashMap<String, PreparedStatement> preparedStatements;
    private final Seq<RawHeader> permission_number_headers;
    private final Renderer valueRenderer;
    private final ViewDef_<FieldDef_<Type>> baseView;
    private final DateTimeFormatter dateFormatter;

    public DataToJdbc(Config config, Querease qe, String dataset_name, DbAccess dbAccess, HttpClient http, ActorSystem system, ExecutionContext ec) {
        this.config = config;
        this.qe = qe;
        this.dataset_name = dataset_name;
        this.dbAccess = dbAccess;
        this.http = http;
        this.system = system;
        this.ec = ec;
        this.QueryData$lzy1 = new DataToJdbc$QueryData$(this);
        ConnectorData.$init$(this);
        this.logger = LoggerFactory.getLogger("dagr.jdbcExport");
        String jdbcUrl = config.getString("jdbc.data.jdbcUrl");
        String target_server_uri = config.getString("target_server_uri");
        Config stsConfig = config.hasPath("consumer") ? config.getConfig("consumer").withFallback(config) : config;
        this.stsClient = new SecurityTokenServiceClient(stsConfig, "consumer", http, system, ec);
        this.consumer_service_uri = config.getString("consumer_service_uri");
        this.rootElementsBatchSize = config.getInt("export.root_elements_batch_size");
        this.initialParams = CollectionConverters$.MODULE$.MapHasAsScala(config.getObject("export.initial_params")).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                ConfigValue v = (ConfigValue)tuple2._2();
                String string2 = Predef$.MODULE$.ArrowAssoc(k);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, v.unwrapped().toString());
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl());
        Map datasetNameMapping = CollectionConverters$.MODULE$.MapHasAsScala(config.getObject("export.dataset_name_mapping")).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                ConfigValue v = (ConfigValue)tuple2._2();
                String string2 = Predef$.MODULE$.ArrowAssoc(k);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, v.unwrapped().toString());
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl());
        this.childTableIdSeqQuery = CollectionConverters$.MODULE$.MapHasAsScala(config.getObject("export.child_table_id_seq_query")).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                ConfigValue v = (ConfigValue)tuple2._2();
                String string2 = Predef$.MODULE$.ArrowAssoc(k);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, v.unwrapped().toString());
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl());
        this.preparedStatements = new ConcurrentHashMap();
        this.permission_number_headers = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply("consumer_permission_number").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> config.hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> config.getString((String)x$0)).map((Function1<String, RawHeader> & Serializable)_$1 -> RawHeader$.MODULE$.apply("X-DAGR-Permission", (String)_$1))).toSeq();
        this.valueRenderer = new Renderer(config);
        this.baseView = qe.viewDef((String)datasetNameMapping.apply(dataset_name));
        this.dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public final DataToJdbc$QueryData$ QueryData() {
        return this.QueryData$lzy1;
    }

    @Override
    public SyncType syncType() {
        return SyncTypeForwardAll$.MODULE$;
    }

    public <T> Unmarshaller<HttpEntity, Source<T, NotUsed>> largeFrameJsonStreamUnmarshaller(Decoder<T> evidence$1) {
        return pekkoHttp$.MODULE$.borerStreamUnmarshaller((EntityStreamingSupport)new JsonEntityStreamingSupport(0x800000), (Decoder)evidence$1);
    }

    public Future<Source<Map<String, Object>, NotUsed>> sourceOfMapsFromChangesService(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        Decoder decoder = JsonAnyValueDecoder$.MODULE$.toMapDecoder((Function0<Map> & Serializable)() -> Predef$.MODULE$.Map().empty(), ClassTag$.MODULE$.apply(Map.class));
        return this.stsClient.getToken().flatMap((Function1<Token, Future> & Serializable)token -> this.http.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(this.consumer_service_uri).withQuery(Uri$Query$.MODULE$.apply(this.initialParams)), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))).$plus$plus(this.permission_number_headers), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), this.http.doRequest$default$2(), this.http.doRequest$default$3(), this.http.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)request -> Unmarshal$.MODULE$.apply(request.entity()).to(this.largeFrameJsonStreamUnmarshaller(decoder), Predef$.MODULE$.implicitly(this.ec), Predef$.MODULE$.implicitly(Materializer$.MODULE$.matFromSystem(this.system))).map((Function1<Source, Source> & Serializable)maps -> ((Source)maps.recover((PartialFunction)((Object)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    throw e;
                }
                return function1.apply(x);
            }
        }))).named(new StringBuilder(14).append("from-dagr-for-").append(this.dataset_name).toString()), this.ec), this.ec), this.ec);
    }

    public Record toRecord(Map<String, Object> record) {
        return Record$.MODULE$.apply(record.apply("key").toString(), (String)record.get("timestamp").filter((Function1<Object, boolean> & Serializable)_$2 -> _$2 != null).map((Function1<Object, String> & Serializable)_$3 -> _$3.toString()).orNull($less$colon$less$.MODULE$.refl()), (String)Option$.MODULE$.apply(record.apply("value")).map((Function1<Object, String> & Serializable)v -> this.valueRenderer.renderValue(v)).orNull($less$colon$less$.MODULE$.refl()), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(record.apply("offset").toString())), Record$.MODULE$.$lessinit$greater$default$5());
    }

    private Seq<QueryData> getViewAndData(Map<String, Object> m, ViewDef_<FieldDef_<Type>> view, long id, long parentId, int level, Map<String, Object> refToParentMap, Connection conn) {
        Tuple2 tuple2 = view.fields().partition((Function1<FieldDef_, boolean> & Serializable)f -> ((Type)f.type_()).isComplexType() && this.qe.viewDefOption(DataToJdbc.childViewName$1(view, f)).isDefined() && m.contains(f.name()) && (m.apply(f.name()) instanceof Map || m.apply(f.name()) instanceof List));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq childViewFields = (Seq)tuple2._1();
        Seq simpleFields = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = Tuple2$.MODULE$.apply(childViewFields, simpleFields);
        Seq childViewFields2 = tuple22._1();
        Seq simpleFields2 = tuple22._2();
        Seq fields = (Seq)simpleFields2.filterNot((Function1<FieldDef_, boolean> & Serializable)_$5 -> ((Type)_$5.type_()).isComplexType());
        Map<String, Object> data = ((IterableOnceOps)fields.map((Function1<FieldDef_, Tuple2> & Serializable)x$1 -> {
            FieldDef_ fieldDef_;
            FieldDef_ f = fieldDef_ = x$1;
            String string2 = f.name();
            String string3 = "id";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null) && !DataToJdbc.isRefField$1(view, f)) {
                String string4 = Predef$.MODULE$.ArrowAssoc(DataToJdbc.fieldName$1(view, f));
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, BoxesRunTime.boxToLong(id));
            }
            FieldDef_ f2 = fieldDef_;
            if (DataToJdbc.isRefField$1(view, f2)) {
                String string5 = Predef$.MODULE$.ArrowAssoc(DataToJdbc.fieldName$1(view, f2));
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, refToParentMap.apply(DataToJdbc.fieldName$1(view, f2)));
            }
            FieldDef_ f3 = fieldDef_;
            String string6 = ((Type)f3.type_()).name();
            String string7 = "date";
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                String string8 = Predef$.MODULE$.ArrowAssoc(DataToJdbc.fieldName$1(view, f3));
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string8, m.get(f3.name()).map((Function1<Object, LocalDate> & Serializable)v -> LocalDate.parse(String.valueOf(v), this.dateFormatter)).orNull($less$colon$less$.MODULE$.refl()));
            }
            FieldDef_ f4 = fieldDef_;
            String string9 = Predef$.MODULE$.ArrowAssoc(DataToJdbc.fieldName$1(view, f4));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string9, m.get(f4.name()).orNull($less$colon$less$.MODULE$.refl()));
        })).toMap($less$colon$less$.MODULE$.refl());
        return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)this.QueryData().apply(level, view.table(), (Seq)fields.map((Function1<FieldDef_, String> & Serializable)f -> DataToJdbc.fieldName$1(view, f)), data)), Nil$.MODULE$)).$plus$plus((IterableOnce)childViewFields2.flatMap((Function1<FieldDef_, IterableOnce> & Serializable)x$1 -> {
            FieldDef_ fieldDef_ = x$1;
            FieldDef_ f = fieldDef_;
            if (m.apply(f.name()) instanceof List) {
                return ((List)m.apply(f.name())).flatMap((Function1<Map, IterableOnce> & Serializable)childMap -> this.getChild$1(view, id, conn, level, f, (Map)childMap));
            }
            FieldDef_ f2 = fieldDef_;
            return this.getChild$1(view, id, conn, level, f2, (Map)m.apply(f2.name()));
        }));
    }

    private Future<Tuple2<Record, Seq<QueryData>>> parseRecord(Record r, Connection conn) {
        return Future$.MODULE$.apply(() -> this.parseRecord$$anonfun$1(r, conn), this.ec);
    }

    private PreparedStatement bindVars(PreparedStatement st, QueryData queryData) {
        ((IterableOnceOps)queryData.cols().zipWithIndex()).foreach(x$1 -> {
            String string2 = (String)x$1._1();
            int n = BoxesRunTime.unboxToInt(x$1._2());
            DataToJdbc.bindVar$1(st, queryData.data().apply(string2), n + 1);
        });
        return st;
    }

    private void exportData(Seq<QueryData> data, Connection conn) {
        ((IterableOnceOps)data.groupBy((Function1<QueryData, Tuple2> & Serializable)qd -> Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(qd.level()), qd.table())).toSeq().sortBy((Function1<Tuple2, int> & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                int level = BoxesRunTime.unboxToInt(tuple2._1());
                return level;
            }
            throw new MatchError(tuple22);
        }, Ordering$Int$.MODULE$)).foreach((Function1<Tuple2, int[]> & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                int level = BoxesRunTime.unboxToInt(tuple2._1());
                String table = (String)tuple2._2();
                Seq groupData = (Seq)tuple22._2();
                this.logger.debug(new StringBuilder(20).append("   ").append(table).append(" - prep statement").toString());
                PreparedStatement statement = this.preparedStatements.containsKey(table) ? this.preparedStatements.get(table) : (PreparedStatement)groupData.headOption().map((Function1<QueryData, PreparedStatement> & Serializable)qd -> {
                    String insQuery = new StringBuilder(23).append("INSERT INTO ").append(table).append("(").append(qd.cols().mkString(",")).append(")VALUES(").append(((IterableOnceOps)qd.cols().map((Function1<String, String> & Serializable)_$6 -> "?")).mkString(",")).append(");").toString();
                    PreparedStatement st = conn.prepareStatement(insQuery);
                    this.preparedStatements.put(qd.table(), st);
                    return st;
                }).getOrElse(() -> DataToJdbc.$anonfun$12(table));
                groupData.foreach(qd -> this.bindVars(statement, (QueryData)qd).addBatch());
                this.logger.debug(new StringBuilder(39).append("   ").append(table).append(" - ready to execute batch with size ").append(groupData.size()).toString());
                return statement.executeBatch();
            }
            throw new MatchError(tuple22);
        });
        try {
            this.logger.debug("ready to commit data");
            conn.commit();
        }
        catch (Throwable e) {
            this.logger.error("error while commiting data", e);
            conn.rollback();
        }
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        Connection conn = this.dbAccess.getConnection();
        return this.sourceOfMapsFromChangesService(ts, schedulerInfo).map((Function1<Source, Source> & Serializable)_$7 -> (Source)_$7.map((Function1<Map, Record> & Serializable)record -> this.toRecord((Map<String, Object>)record)), this.ec).map((Function1<Source, Source> & Serializable)_$8 -> _$8.mapMaterializedValue((Function1<NotUsed, Function1> & Serializable)_$9 -> _$10 -> {}), this.ec).map((Function1<Source, Option> & Serializable)_$11 -> Option$.MODULE$.apply(_$11).map((Function1<Source, Tuple2> & Serializable)source -> Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply("from-dagr", SourceInfo$.MODULE$.$lessinit$greater$default$2()), ((FlowOpsMat)source.mapAsync(1, (Function1<Record, Future> & Serializable)record -> this.parseRecord((Record)record, conn)).groupedWithin(this.rootElementsBatchSize, new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds()).map((Function1<Seq, Seq> & Serializable)records -> {
            this.exportData((Seq)records.flatMap((Function1<Tuple2, IterableOnce> & Serializable)_$12 -> (IterableOnce)_$12._2()), conn);
            return (Seq)records.map((Function1<Tuple2, Record> & Serializable)_$13 -> (Record)_$13._1());
        }).mapConcat((Function1<Seq, IterableOnce> & Serializable)recs -> recs)).watchTermination((Function2<Function1, Future, Function1> & Serializable)(prevMatValue, futureDone) -> {
            futureDone.onComplete(x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    if (conn != null) {
                        conn.close();
                        return;
                    }
                    return;
                }
                if (try_ instanceof Failure) {
                    if (conn != null) {
                        conn.close();
                        return;
                    }
                    return;
                }
                throw new MatchError(try_);
            }, this.ec);
            return prevMatValue;
        }))), this.ec);
    }

    private static final String childViewName$1(ViewDef_ view$1, FieldDef_ f) {
        return new StringBuilder(1).append(view$1.name()).append("_").append(f.name()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRefField$1(ViewDef_ view$2, FieldDef_ f) {
        String string2 = f.table();
        String string3 = view$2.table();
        if (string2 == null) {
            if (string3 == null) return false;
        } else if (string2.equals(string3)) return false;
        String string4 = f.name();
        String string5 = "id";
        if (string4 != null) {
            if (!string4.equals(string5)) return false;
            return true;
        }
        if (string5 == null) return true;
        return false;
    }

    private static final String fieldName$1(ViewDef_ view$10, FieldDef_ f) {
        FieldDef_ fieldDef_ = f;
        FieldDef_ f2 = fieldDef_;
        if (DataToJdbc.isRefField$1(view$10, f2)) {
            return new StringBuilder(1).append(f2.table()).append("_").append(f2.name()).toString();
        }
        FieldDef_ f3 = fieldDef_;
        return f3.name();
    }

    private static final Map $anonfun$4() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
    }

    private static final PreparedStatement $anonfun$6(ViewDef_ childView$1) {
        throw new Exception(new StringBuilder(40).append("No query defined to obtain id value for ").append(childView$1.table()).toString());
    }

    private final Seq getChild$1(ViewDef_ view$3, long id$1, Connection conn$1, int level$1, FieldDef_ cF, Map cM) {
        ViewDef_ childView = (ViewDef_)this.qe.viewDefOption(DataToJdbc.childViewName$1(view$3, cF)).get();
        Map refM = (Map)childView.fields().find((Function1<FieldDef_, boolean> & Serializable)f -> {
            String string2 = f.name();
            String string3 = new StringBuilder(3).append(view$3.table()).append("_id").toString();
            return !(string2 == null ? string3 != null : !string2.equals(string3)) || DataToJdbc.isRefField$1(view$3, f);
        }).map((Function1<FieldDef_, Map> & Serializable)_$4 -> {
            Tuple2[] tuple2Array = new Tuple2[1];
            String string2 = Predef$.MODULE$.ArrowAssoc(new StringBuilder(3).append(view$3.table()).append("_id").toString());
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToLong(id$1));
            return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        }).getOrElse(DataToJdbc::$anonfun$4);
        String prepStName = new StringBuilder(4).append(childView.table()).append("_seq").toString();
        PreparedStatement nextIdPrepStatememt = this.preparedStatements.containsKey(prepStName) ? this.preparedStatements.get(prepStName) : (PreparedStatement)this.childTableIdSeqQuery.get(childView.table()).map((Function1<String, PreparedStatement> & Serializable)nextIdQuery -> {
            PreparedStatement st = conn$1.prepareStatement((String)nextIdQuery);
            this.preparedStatements.put(prepStName, st);
            return st;
        }).getOrElse(() -> DataToJdbc.$anonfun$6(childView));
        ResultSet rs = nextIdPrepStatememt.executeQuery();
        if (!rs.next()) {
            throw new Exception(new StringBuilder(26).append("Couldn't get id value for ").append(childView.table()).toString());
        }
        long res = rs.getLong(1);
        rs.close();
        long nextId = res;
        return this.getViewAndData(cM, childView, nextId, id$1, level$1 + 1, refM, conn$1);
    }

    private final Tuple2 parseRecord$$anonfun$1(Record r$1, Connection conn$5) {
        Tuple2<Record, Seq<QueryData>> tuple2;
        try {
            Map<String, Object> m = JsonAnyValueDecoder$.MODULE$.decodeToMap(ByteString$.MODULE$.apply(r$1.value()), JsonAnyValueDecoder$.MODULE$.decodeToMap$default$2(), JsonAnyValueDecoder$.MODULE$.decodeToMap$default$3(), ClassTag$.MODULE$.apply(Map.class));
            tuple2 = Tuple2$.MODULE$.apply(r$1, this.getViewAndData(m, this.baseView, r$1.position(), -1L, 0, (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), conn$5));
        }
        catch (Throwable e) {
            this.logger.error("error while parsing data from DAGR", e);
            throw e;
        }
        return tuple2;
    }

    private static final void bindVar$1(PreparedStatement st$1, Object p, int idx) {
        try {
            Object object = p;
            if (object == null) {
                st$1.setNull(idx, 0);
            } else if (object instanceof Integer) {
                int i = BoxesRunTime.unboxToInt(object);
                st$1.setInt(idx, i);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong(object);
                st$1.setLong(idx, l);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble(object);
                st$1.setDouble(idx, d);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat(object);
                st$1.setFloat(idx, f);
            } else if (object instanceof Integer) {
                Integer i = (Integer)object;
                st$1.setInt(idx, Predef$.MODULE$.Integer2int(i));
            } else if (object instanceof Long) {
                Long l = (Long)object;
                st$1.setLong(idx, Predef$.MODULE$.Long2long(l));
            } else if (object instanceof Double) {
                Double d = (Double)object;
                st$1.setDouble(idx, Predef$.MODULE$.Double2double(d));
            } else if (object instanceof Float) {
                Float f = (Float)object;
                st$1.setFloat(idx, Predef$.MODULE$.Float2float(f));
            } else if (object instanceof Timestamp) {
                Timestamp t = (Timestamp)object;
                st$1.setTimestamp(idx, t);
            } else if (object instanceof java.sql.Date) {
                java.sql.Date d = (java.sql.Date)object;
                st$1.setDate(idx, d);
            } else if (object instanceof Time) {
                Time t = (Time)object;
                st$1.setTime(idx, t);
            } else if (object instanceof Date) {
                Date d = (Date)object;
                st$1.setTimestamp(idx, new Timestamp(d.getTime()));
            } else if (object instanceof Calendar) {
                Calendar c = (Calendar)object;
                st$1.setTimestamp(idx, new Timestamp(c.getTime().getTime()));
            } else if (object instanceof LocalDate) {
                LocalDate d = (LocalDate)object;
                st$1.setDate(idx, java.sql.Date.valueOf(d));
            } else if (object instanceof LocalDateTime) {
                LocalDateTime t = (LocalDateTime)object;
                st$1.setTimestamp(idx, Timestamp.valueOf(t));
            } else if (object instanceof LocalTime) {
                LocalTime t = (LocalTime)object;
                st$1.setTime(idx, Time.valueOf(t));
            } else if (object instanceof Boolean) {
                boolean b = BoxesRunTime.unboxToBoolean(object);
                st$1.setBoolean(idx, b);
            } else if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                st$1.setBoolean(idx, Predef$.MODULE$.Boolean2boolean(b));
            } else if (object instanceof String) {
                String s2 = (String)object;
                st$1.setString(idx, s2);
            } else if (object instanceof BigDecimal) {
                BigDecimal bn = (BigDecimal)object;
                st$1.setBigDecimal(idx, bn);
            } else if (object instanceof scala.math.BigDecimal) {
                scala.math.BigDecimal bd = (scala.math.BigDecimal)object;
                st$1.setBigDecimal(idx, bd.bigDecimal());
            } else if (object instanceof BigInteger) {
                BigInteger bi = (BigInteger)object;
                st$1.setBigDecimal(idx, new BigDecimal(bi));
            } else if (object instanceof BigInt) {
                BigInt bi = (BigInt)object;
                st$1.setBigDecimal(idx, new BigDecimal(bi.bigInteger()));
            } else if (object instanceof InputStream) {
                InputStream in = (InputStream)object;
                st$1.setBinaryStream(idx, in);
            } else if (object instanceof Blob) {
                Blob bl = (Blob)object;
                st$1.setBlob(idx, bl);
            } else if (object instanceof Reader) {
                Reader rd = (Reader)object;
                st$1.setCharacterStream(idx, rd);
            } else if (object instanceof Clob) {
                Clob cl = (Clob)object;
                st$1.setClob(idx, cl);
            } else if (object instanceof byte[]) {
                byte[] ab = (byte[])object;
                st$1.setBytes(idx, ab);
            } else if (object instanceof Array) {
                Array ar = (Array)object;
                st$1.setArray(idx, ar);
            } else {
                Object obj = object;
                st$1.setObject(idx, obj);
            }
        }
        catch (Exception e) {
            String x;
            String string2;
            String x2 = string2 = String.valueOf(p);
            throw new RuntimeException(new StringBuilder(52).append("Failed to bind variable at index ").append(idx - 1).append(". Value: ").append(x2.length() > 100 ? new StringBuilder(3).append(x2.substring(0, 100)).append("...").toString() : (x = string2)).append(" of class ").append(p == null ? "null" : p.getClass()).toString(), e);
        }
    }

    private static final PreparedStatement $anonfun$12(String table$2) {
        throw new Exception(new StringBuilder(26).append("no prepared statement for ").append(table$2).toString());
    }

    public class QueryData
    implements Product,
    Serializable {
        private final int level;
        private final String table;
        private final Seq<String> cols;
        private final Map<String, Object> data;
        private final /* synthetic */ DataToJdbc $outer;

        public QueryData(DataToJdbc $outer, int level, String table, Seq<String> cols, Map<String, Object> data) {
            this.level = level;
            this.table = table;
            this.cols = cols;
            this.data = data;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.level());
            n = Statics.mix(n, Statics.anyHash(this.table()));
            n = Statics.mix(n, Statics.anyHash(this.cols()));
            n = Statics.mix(n, Statics.anyHash(this.data()));
            return Statics.finalizeHash(n, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QueryData)) return false;
            if (((QueryData)object).dagr$DataToJdbc$QueryData$$$outer() != this.$outer) return false;
            QueryData queryData = (QueryData)object;
            if (this.level() != queryData.level()) return false;
            String string2 = this.table();
            String string3 = queryData.table();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            Seq<String> seq = this.cols();
            Seq<String> seq2 = queryData.cols();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Map<String, Object> map = this.data();
            Map<String, Object> map2 = queryData.data();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!queryData.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof QueryData;
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "QueryData";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger(this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "level";
                }
                case 1: {
                    return "table";
                }
                case 2: {
                    return "cols";
                }
                case 3: {
                    return "data";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public int level() {
            return this.level;
        }

        public String table() {
            return this.table;
        }

        public Seq<String> cols() {
            return this.cols;
        }

        public Map<String, Object> data() {
            return this.data;
        }

        public QueryData copy(int level, String table, Seq<String> cols, Map<String, Object> data) {
            return new QueryData(this.$outer, level, table, cols, data);
        }

        public int copy$default$1() {
            return this.level();
        }

        public String copy$default$2() {
            return this.table();
        }

        public Seq<String> copy$default$3() {
            return this.cols();
        }

        public Map<String, Object> copy$default$4() {
            return this.data();
        }

        public int _1() {
            return this.level();
        }

        public String _2() {
            return this.table();
        }

        public Seq<String> _3() {
            return this.cols();
        }

        public Map<String, Object> _4() {
            return this.data();
        }

        public final /* synthetic */ DataToJdbc dagr$DataToJdbc$QueryData$$$outer() {
            return this.$outer;
        }
    }
}

