/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import dagr.ApiParvaldnieks$;
import dagr.DataParserUtils$;
import dagr.Record;
import dagr.Record$;
import dagr.Renderer;
import dagr.SchedulerInfo;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.mojoz.metadata.FieldDef_;
import org.mojoz.metadata.Type;
import org.mojoz.querease.Querease;
import org.mojoz.querease.ValueConverter;
import org.mojoz.querease.ValueConverter$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.matching.Regex;
import spray.json.JsBoolean;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsNumber$;
import spray.json.JsObject;
import spray.json.JsString;
import spray.json.JsString$;
import spray.json.JsValue;

public final class DataParserUtils$
implements Serializable {
    private static final DateTimeFormatter DATE_FORMAT_LV;
    private static final Config config;
    private static final ZoneId zoneId;
    private static final ValueConverter valueConverter;
    public static final DataParserUtils$ MODULE$;

    private DataParserUtils$() {
    }

    static {
        MODULE$ = new DataParserUtils$();
        DATE_FORMAT_LV = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        config = ConfigFactory.load();
        zoneId = ZoneId.of(MODULE$.config().getString("data.timezone"));
        valueConverter = new ValueConverter(){
            public static final long OFFSET$1;
            public static final long OFFSET$0;
            private volatile Object config$lzy1;
            private volatile Object zoneId$lzy1;

            static {
                OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(anon.1.class.getDeclaredField("zoneId$lzy1"));
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.1.class.getDeclaredField("config$lzy1"));
            }

            public Config config() {
                Object object = this.config$lzy1;
                if (object instanceof Config) {
                    return (Config)object;
                }
                if (object == LazyVals$NullValue$.MODULE$) {
                    return null;
                }
                return (Config)this.config$lzyINIT1();
            }

            private Object config$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.config$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            Config config = null;
                            try {
                                config = ValueConverter.config$(this);
                                object2 = config == null ? LazyVals$NullValue$.MODULE$ : config;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.config$lzy1;
                                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return config;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals$Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public ZoneId zoneId() {
                Object object = this.zoneId$lzy1;
                if (object instanceof ZoneId) {
                    return (ZoneId)object;
                }
                if (object == LazyVals$NullValue$.MODULE$) {
                    return null;
                }
                return (ZoneId)this.zoneId$lzyINIT1();
            }

            private Object zoneId$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.zoneId$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                            Serializable serializable = null;
                            ZoneId zoneId = null;
                            try {
                                zoneId = ValueConverter.zoneId$(this);
                                serializable = zoneId == null ? LazyVals$NullValue$.MODULE$ : zoneId;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.zoneId$lzy1;
                                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                                    waiting.countDown();
                                }
                            }
                            return zoneId;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals$Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DataParserUtils$.class);
    }

    public DateTimeFormatter DATE_FORMAT_LV() {
        return DATE_FORMAT_LV;
    }

    public Option<Object> getValueByPath(Map<String, Object> map, Seq<String> path) {
        return this.helper$1(map, path);
    }

    public String getStrFromJsValue(Map<String, JsValue> fields, String key2) {
        return (String)fields.get(key2).map((Function1<JsValue, String> & Serializable)x$1 -> {
            JsValue jsValue = x$1;
            if (jsValue instanceof JsString) {
                String string2;
                JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                String v = string2 = jsString._1();
                return v;
            }
            if (jsValue instanceof JsNumber) {
                BigDecimal bigDecimal;
                JsNumber jsNumber = JsNumber$.MODULE$.unapply((JsNumber)jsValue);
                BigDecimal n = bigDecimal = jsNumber._1();
                return n.toString();
            }
            if (JsNull$.MODULE$.equals(jsValue)) {
                return null;
            }
            if (jsValue instanceof JsBoolean) {
                JsBoolean b = (JsBoolean)jsValue;
                return BoxesRunTime.boxToBoolean(b.value()).toString();
            }
            JsValue x = jsValue;
            throw package$.MODULE$.error(new StringBuilder(31).append("Unexpected value type ").append(x.getClass().getName()).append(" for key ").append(key2).toString());
        }).getOrElse(() -> DataParserUtils$.getStrFromJsValue$$anonfun$2(key2));
    }

    public Option<String> getStrFromJsValueOpt(Map<String, JsValue> fields, String key2) {
        return fields.get(key2).map((Function1<JsValue, String> & Serializable)_$1 -> MODULE$.getStrFromJsValue(fields, key2));
    }

    public Config config() {
        return config;
    }

    public ZoneId zoneId() {
        return zoneId;
    }

    public ValueConverter valueConverter() {
        return valueConverter;
    }

    public Instant parseDateTimeAsInstant(String d) {
        Object object = this.valueConverter().convertToType(d, ValueConverter$.MODULE$.ClassOfJavaTimeInstant());
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return instant;
        }
        throw package$.MODULE$.error(new StringBuilder(48).append("Failed to convert string '").append(d).append("' to java.time.Instant").toString());
    }

    public Tuple2<Object, Option<Object>> hasEmbeddedWithTotalPages(Map<String, JsValue> fields) {
        return Tuple2$.MODULE$.apply(BoxesRunTime.boxToBoolean(fields.contains("_embedded")), ((MapOps)((JsValue)fields.getOrElse("page", DataParserUtils$::hasEmbeddedWithTotalPages$$anonfun$1)).asJsObject().fields().map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JsValue v = (JsValue)tuple2._2();
                String string2 = Predef$.MODULE$.ArrowAssoc(k);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToInteger(((JsNumber)v).value().toInt()));
            }
            throw new MatchError(tuple2);
        })).get("totalPages"));
    }

    public Seq<FieldDef_<Type>> getCsvFields(Querease qe, String view_name) {
        return (Seq)qe.viewDef(view_name).fields().filter((Function1<FieldDef_, boolean> & Serializable)_$2 -> !_$2.isExpression());
    }

    public String schedulerNextRunCase(SchedulerInfo si, Option<ZoneId> zoneIdOpt) {
        ZonedDateTime previousRun = si.previousRun().atZone((ZoneId)zoneIdOpt.getOrElse(DataParserUtils$::$anonfun$1));
        ZonedDateTime thisRun = si.thisRun().atZone((ZoneId)zoneIdOpt.getOrElse(DataParserUtils$::$anonfun$2));
        if (previousRun.getMonthValue() != thisRun.getMonthValue()) {
            return "nextMonth";
        }
        if (previousRun.getDayOfWeek().getValue() != thisRun.getDayOfWeek().getValue()) {
            DayOfWeek dayOfWeek = thisRun.getDayOfWeek();
            DayOfWeek dayOfWeek2 = DayOfWeek.MONDAY;
            if (!(dayOfWeek != null ? !dayOfWeek.equals(dayOfWeek2) : dayOfWeek2 != null)) {
                return "nextWeek";
            }
        }
        if (previousRun.getDayOfWeek().getValue() != thisRun.getDayOfWeek().getValue()) {
            return "nextDay";
        }
        return "default";
    }

    public Option<ZoneId> schedulerNextRunCase$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String minusOneTimeUnit(Instant i, String timeAmount) {
        ZonedDateTime zonedDateTime;
        String string2 = timeAmount;
        switch (string2 == null ? 0 : string2.hashCode()) {
            case 99228: {
                if (!"day".equals(string2)) break;
                zonedDateTime = i.atZone(ZoneId.of("UTC")).minusDays(1L);
                return zonedDateTime.toLocalDate().atStartOfDay(ZoneId.of("UTC")).toInstant().toString();
            }
            case 3645428: {
                if (!"week".equals(string2)) break;
                zonedDateTime = i.atZone(ZoneId.of("UTC")).minusWeeks(1L);
                return zonedDateTime.toLocalDate().atStartOfDay(ZoneId.of("UTC")).toInstant().toString();
            }
            case 104080000: {
                if (!"month".equals(string2)) break;
                zonedDateTime = i.atZone(ZoneId.of("UTC")).minusMonths(1L);
                return zonedDateTime.toLocalDate().atStartOfDay(ZoneId.of("UTC")).toInstant().toString();
            }
        }
        zonedDateTime = i.atZone(ZoneId.of("UTC"));
        return zonedDateTime.toLocalDate().atStartOfDay(ZoneId.of("UTC")).toInstant().toString();
    }

    public Tuple2<Record, Option<String>> parseVdeavkRecord(JsValue entityJs, LocalDateTime sLtd, boolean replaceEntityNrInTrackingLogWithHash, List<Regex> validationRegexPatterns, Renderer renderer) {
        String eNrEncoded;
        JsObject entity = entityJs.asJsObject();
        String lastChangedAtStr = sLtd.toInstant(ZoneOffset.UTC).atZone(this.zoneId()).format(DateTimeFormatter.ISO_INSTANT);
        String perPersKods = this.getStrFromJsValue(entity.fields(), "perPersKods");
        String string2 = eNrEncoded = replaceEntityNrInTrackingLogWithHash ? ApiParvaldnieks$.MODULE$.entityNrHash(perPersKods) : perPersKods;
        if (validationRegexPatterns.exists((Function1<Regex, Object>)(Function1<Regex, boolean> & Serializable)_$3 -> _$3.matches(perPersKods))) {
            String key2 = ((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)perPersKods), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((String)Option$.MODULE$.apply(this.getStrFromJsValue(entity.fields(), "perExpNumurs")).map((Function1<Object, String> & Serializable)k -> renderer.renderKeySegment(k)).getOrElse(() -> DataParserUtils$.$anonfun$4(eNrEncoded)))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((String)Option$.MODULE$.apply(this.getStrFromJsValue(entity.fields(), "transpPabDoks")).map((Function1<Object, String> & Serializable)k -> renderer.renderKeySegment(k)).getOrElse(DataParserUtils$::$anonfun$6))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((String)Option$.MODULE$.apply(this.getStrFromJsValue(entity.fields(), "bernaInvKopsDoks")).map((Function1<Object, String> & Serializable)k -> renderer.renderKeySegment(k)).getOrElse(DataParserUtils$::$anonfun$8))), Nil$.MODULE$))))).mkString("/");
            Record record = Predef$.MODULE$.ArrowAssoc(Record$.MODULE$.apply(key2, lastChangedAtStr, entity.compactPrint(), Record$.MODULE$.$lessinit$greater$default$4(), Record$.MODULE$.$lessinit$greater$default$5()));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(record, Option$.MODULE$.empty());
        }
        Record record = Predef$.MODULE$.ArrowAssoc(Record$.MODULE$.apply(null, null, null, Record$.MODULE$.$lessinit$greater$default$4(), Record$.MODULE$.$lessinit$greater$default$5()));
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(record, Some$.MODULE$.apply(new StringBuilder(62).append("Value of field 'perPersKods' encoded (").append(eNrEncoded).append(") doesn't match pattern ").append(validationRegexPatterns).toString()));
    }

    public <T> Tuple2<T, Option<String>> convertLine(String fileName, int idx, String line, Map<String, Object> struct, int expectedRowLength, char fields_delimiter, Function2<Map<String, Object>, String[], Tuple2<T, Option<String>>> lineFun) {
        String lastToken;
        ListBuffer buffer = new ListBuffer();
        int startPosition = 0;
        boolean isInQuotes = false;
        for (int currentPosition = 0; currentPosition < line.length(); ++currentPosition) {
            if (Predef$.MODULE$.char2Character(line.charAt(currentPosition)) == Predef$.MODULE$.char2Character('\"')) {
                isInQuotes = !isInQuotes;
                continue;
            }
            if (!(Predef$.MODULE$.char2Character(line.charAt(currentPosition)) == Predef$.MODULE$.char2Character(fields_delimiter)) || isInQuotes) continue;
            buffer.addOne(line.substring(startPosition, currentPosition));
            startPosition = currentPosition + 1;
        }
        String string2 = lastToken = line.substring(startPosition);
        String string3 = ",";
        Growable growable = !(string2 != null ? !string2.equals(string3) : string3 != null) ? buffer.addOne("") : buffer.addOne(lastToken);
        Object[] l = (String[])((IterableOnceOps)buffer.map((Function1<String, String> & Serializable)x$1 -> {
            String string2 = x$1;
            String el = string2;
            if (el.startsWith("\"") && el.endsWith("\"")) {
                return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(el), 1)), 1).replace("\"\"", "\"");
            }
            String el2 = string2;
            return el2;
        })).toArray(ClassTag$.MODULE$.apply(String.class));
        if (expectedRowLength != l.length) {
            throw new Exception(new StringBuilder(71).append("expected row length of fileName ").append(fileName).append(" is ").append(expectedRowLength).append(", length of parsed line is ").append(l.length).append(" at idx ").append(idx).toString());
        }
        Tuple2<T, Option<String>> tuple2 = lineFun.apply(struct, (String[])l);
        if (tuple2 != null) {
            T t = tuple2._1();
            Option<String> option = tuple2._2();
            T result = t;
            if (option instanceof Some) {
                String e = (String)((Some)option).value();
                Object object = Predef$.MODULE$.refArrayOps(l);
                return Tuple2$.MODULE$.apply(result, Some$.MODULE$.apply(new StringBuilder(46).append(e).append(" [fileName = ").append(fileName).append(" at idx ").append(idx).append("]\nline = ").append(line).append("\nparse result:\n").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<String, String> & Serializable)_$4 -> new StringBuilder(2).append("  ").append((String)_$4).toString(), ClassTag$.MODULE$.apply(String.class))).mkString("\n")).append("\n").toString()));
            }
            T result2 = t;
            if (None$.MODULE$.equals(option)) {
                return Tuple2$.MODULE$.apply(result2, None$.MODULE$);
            }
        }
        throw new MatchError(tuple2);
    }

    private final Option helper$1(Object value, Seq remainingPath) {
        block3: {
            Option option;
            while (true) {
                Object value2;
                if (remainingPath.isEmpty()) {
                    return Some$.MODULE$.apply(value);
                }
                Object object = value;
                if (!(object instanceof Map)) break block3;
                Map m = (Map)object;
                option = m.get(remainingPath.head());
                if (!(option instanceof Some)) break;
                Object a = value2 = ((Some)option).value();
                Seq seq = (Seq)remainingPath.tail();
                value = a;
                remainingPath = seq;
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError(option);
        }
        return None$.MODULE$;
    }

    private static final String getStrFromJsValue$$anonfun$2(String key$2) {
        throw package$.MODULE$.error(new StringBuilder(14).append("Missing field ").append(key$2).toString());
    }

    private static final JsValue hasEmbeddedWithTotalPages$$anonfun$1() {
        return JsNull$.MODULE$;
    }

    private static final ZoneId $anonfun$1() {
        return MODULE$.zoneId();
    }

    private static final ZoneId $anonfun$2() {
        return MODULE$.zoneId();
    }

    private static final String $anonfun$4(String eNrEncoded$1) {
        throw new Exception(new StringBuilder(68).append("Value of field 'perExpNumurs' can't be null (perPersKods encoded - ").append(eNrEncoded$1).append(")").toString());
    }

    private static final String $anonfun$6() {
        return "";
    }

    private static final String $anonfun$8() {
        return "";
    }

    private final boolean hasStartingAndClosingQuotes$1(String s2) {
        String ss = s2.replace("\"\"", "");
        return ss.startsWith("\"") && ss.endsWith("\"");
    }
}

