/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ConnectorData;
import dagr.Record;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.stream.connectors.xml.scaladsl.XmlParsing$;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Source;
import org.mojoz.metadata.FieldDef_;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.ViewDef_;
import org.mojoz.querease.Querease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public class DataFromXml
implements ConnectorData {
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final Querease qe;
    private final ExecutionContext ec;
    private final Logger logger;
    private final ViewDef_<FieldDef_<Type>> viewDef;
    private final String directory;
    private final String filename_pattern;
    private final Vector<String> records_path;
    private final Renderer renderer;

    public DataFromXml(Config config, Querease qe, String view_name, ActorSystem system, ExecutionContext ec) {
        this.config = config;
        this.qe = qe;
        this.ec = ec;
        ConnectorData.$init$(this);
        this.logger = LoggerFactory.getLogger("dagr.xml");
        this.viewDef = qe.viewDef(view_name);
        this.directory = config.getString("xml.files.directory");
        this.filename_pattern = config.getString("xml.files.filename_pattern");
        this.records_path = CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList("xml.files.records_path")).asScala().toVector();
        this.renderer = new Renderer(config, qe, view_name);
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public Seq<Path> getFiles(String dir, Seq<String> patterns) {
        return (Seq)((IterableOps)patterns.map((Function1<String, Regex> & Serializable)_$1 -> new Regex((String)_$1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray(new String[0])))).flatMap((Function1<Regex, IterableOnce> & Serializable)regex -> {
            Object object = Predef$.MODULE$.refArrayOps(Files.list(Paths.get(dir, new String[0])).filter(p -> regex.matches(p.getFileName().toString())).toArray());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<Object, Path> & Serializable)_$2 -> (Path)_$2, ClassTag$.MODULE$.apply(Path.class)));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(object2, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
            return ArrayOps$.MODULE$.toSeq$extension(object3);
        });
    }

    public void moveFile(Path from, Path to, boolean fromFileExists) {
        if (fromFileExists || from.toFile().exists()) {
            if (to.toFile().exists()) {
                Files.delete(to);
            }
            Files.move(from, to, new CopyOption[0]);
            return;
        }
    }

    public boolean moveFile$default$3() {
        return false;
    }

    private void onComplete(Path f, Try<?> result) {
        Try<?> try_ = result;
        if (try_ instanceof Success) {
            this.moveFile(f, f.resolveSibling(new StringBuilder(5).append(f.getFileName()).append(".done").toString()), this.moveFile$default$3());
            return;
        }
        if (try_ instanceof Failure) {
            return;
        }
        throw new MatchError(try_);
    }

    public Map<String, Object> nodeListToMap(NodeList nodeList) {
        Object children = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nodeList.getLength()).map((Function1<Object, Node> & Serializable)x$0 -> nodeList.item(BoxesRunTime.unboxToInt(x$0)));
        String textContent = ((IterableOnceOps)((IterableOps)((IndexedSeqOps)children.filter((Function1<Node, boolean> & Serializable)_$3 -> _$3.getNodeType() == 3)).map((Function1<Node, String> & Serializable)_$4 -> _$4.getTextContent())).filter((Function1<String, boolean> & Serializable)_$5 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$5.trim())))).mkString("").trim();
        IndexedSeq elementChildren = (IndexedSeq)children.filter((Function1<Node, boolean> & Serializable)_$6 -> _$6.getNodeType() == 1);
        Map elementsMap = (Map)elementChildren.foldLeft(Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function2<Map, Node, Map> & Serializable)(acc, node) -> {
            Element elem = (Element)node;
            String name = elem.getTagName();
            Map<String, Object> childMap = this.elementToMap(elem);
            Map<String, Object> childValue = childMap.size() == 1 && childMap.contains("#text") ? childMap.apply("#text") : childMap;
            Option option = acc.get(name);
            if (option instanceof Some) {
                Object existing = ((Some)option).value();
                Object a = existing;
                if (a instanceof Vector) {
                    Vector vector = (Vector)a;
                    return (Map)acc.updated(name, vector.$colon$plus(childValue));
                }
                return (Map)acc.updated(name, package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{existing, childValue})));
            }
            if (None$.MODULE$.equals(option)) {
                String string2 = Predef$.MODULE$.ArrowAssoc(name);
                return (Map)acc.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, childValue));
            }
            throw new MatchError(option);
        });
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(textContent))) {
            String string2 = Predef$.MODULE$.ArrowAssoc("#text");
            return (Map)elementsMap.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, textContent));
        }
        return elementsMap;
    }

    public Map<String, Object> attributesToMap(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap == null) {
            return Predef$.MODULE$.Map().empty();
        }
        NamedNodeMap attrs = namedNodeMap;
        return ((IterableOnceOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), attrs.getLength()).map((Function1<Object, Node> & Serializable)x$0 -> attrs.item(BoxesRunTime.unboxToInt(x$0))).map((Function1<Node, Tuple2> & Serializable)attr -> {
            String string2 = Predef$.MODULE$.ArrowAssoc(attr.getNodeName());
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, attr.getNodeValue());
        })).toMap($less$colon$less$.MODULE$.refl());
    }

    public Map<String, Object> elementToMap(Element element) {
        return (Map)this.attributesToMap(element).$plus$plus(this.nodeListToMap(element.getChildNodes()));
    }

    public Renderer renderer() {
        return this.renderer;
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return Future$.MODULE$.apply(this::source$$anonfun$1, this.ec);
    }

    private final Option source$$anonfun$1() {
        return this.getFiles(this.directory, ScalaRunTime$.MODULE$.wrapRefArray(new String[]{this.filename_pattern})).headOption().map((Function1<Path, Tuple2> & Serializable)f -> {
            this.logger.info(new StringBuilder(11).append("Found file ").append(f.getFileName()).toString());
            return Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply(new StringBuilder(5).append("file ").append(f.getFileName()).toString(), SourceInfo$.MODULE$.$lessinit$greater$default$2()), ((Source)((Source)((Source)FileIO$.MODULE$.fromPath((Path)f, FileIO$.MODULE$.fromPath$default$2()).via(XmlParsing$.MODULE$.parser())).via(XmlParsing$.MODULE$.subtree(this.records_path))).map((Function1<Element, Map> & Serializable)element -> this.elementToMap((Element)element)).map((Function1<Map, Record> & Serializable)m -> {
                Map compatible = this.qe.toCompatibleMap((Map)m, (ViewDef_)this.viewDef);
                return this.renderer().buildRecord(compatible, this.renderer().buildRecord$default$2(), this.renderer().buildRecord$default$3(), this.renderer().buildRecord$default$4());
            })).mapMaterializedValue((Function1<Future, Function1> & Serializable)_$7 -> result -> this.onComplete((Path)f, (Try<?>)result)));
        });
    }
}

