/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.Connector$;
import dagr.Downloader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.stream.IOResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$Long$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public class DataFromVzdOpenData {
    private final Config config;
    private final Logger logger;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private final DateTimeFormatter formatter;
    private final Regex dateTimeRegex;

    public DataFromVzdOpenData(Config config) {
        this.config = config;
        this.logger = LoggerFactory.getLogger("dagr.vzd");
        this.system = Connector$.MODULE$.system();
        this.ec = Connector$.MODULE$.ec();
        this.formatter = DateTimeFormatter.ofPattern("yyyy_MM_dd'T'HH_mm_ss");
        this.dateTimeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\d{4}_\\d{2}_\\d{2}T\\d{2}_\\d{2}_\\d{2}"));
    }

    public Logger logger() {
        return this.logger;
    }

    public ActorSystem system() {
        return this.system;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private String fileNameFromUrl(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    private void deleteOutdated(List<String> urls, String directory, String postfix) {
        ((List)urls.map((Function1<String, String> & Serializable)url -> this.fileNameFromUrl((String)url))).foreach(fileNameInUrl -> {
            Object object = Predef$.MODULE$.refArrayOps(Files.list(Paths.get(directory, new String[0])).filter(p -> p.getFileName().toString().startsWith((String)fileNameInUrl)).toArray());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<Object, Path> & Serializable)_$1 -> (Path)_$1, ClassTag$.MODULE$.apply(Path.class)));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1<Path, Tuple2> & Serializable)p -> {
                String string2 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(p.getFileName().toString()), (String)fileNameInUrl)), postfix);
                if (string2 == null) {
                    Path path = Predef$.MODULE$.ArrowAssoc(p);
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(path, BoxesRunTime.boxToLong(0L));
                }
                String dt = string2;
                if (this.dateTimeRegex.matches(dt)) {
                    Path path = Predef$.MODULE$.ArrowAssoc(p);
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(path, BoxesRunTime.boxToLong(LocalDateTime.parse(dt, this.formatter).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
                }
                String dt2 = string2;
                Path path = Predef$.MODULE$.ArrowAssoc(p);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(path, BoxesRunTime.boxToLong(0L));
            }, ClassTag$.MODULE$.apply(Tuple2.class)));
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(object3, (Function1<Tuple2, long> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    long dt = BoxesRunTime.unboxToLong(tuple2._2());
                    return dt;
                }
                throw new MatchError(tuple2);
            }, Ordering$Long$.MODULE$));
            Object object5 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropRight$extension(object4, 1));
            ArrayOps$.MODULE$.foreach$extension(object5, x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path p = (Path)tuple2._1();
                    if (!p.toFile().delete()) {
                        this.logger().warn(new StringBuilder(23).append("Unable to delete file: ").append(p).toString());
                        return;
                    }
                    this.logger().debug(new StringBuilder(22).append("Outdated file ").append(p).append(" deleted").toString());
                    return;
                }
                throw new MatchError(tuple2);
            });
        });
    }

    private List<Tuple2<String, Path>> getRelatedFiles(List<String> urls, String directory) {
        return ((List)urls.map((Function1<String, String> & Serializable)url -> this.fileNameFromUrl((String)url))).flatMap((Function1<String, IterableOnce> & Serializable)fileNameInUrl -> {
            Object object = Predef$.MODULE$.refArrayOps(Files.list(Paths.get(directory, new String[0])).filter(p -> p.getFileName().toString().startsWith((String)fileNameInUrl)).toArray());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<Object, Path> & Serializable)_$2 -> (Path)_$2, ClassTag$.MODULE$.apply(Path.class)));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1<Path, Tuple2> & Serializable)p -> {
                String string2 = Predef$.MODULE$.ArrowAssoc(fileNameInUrl.toUpperCase());
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, p);
            }, ClassTag$.MODULE$.apply(Tuple2.class)));
        });
    }

    public Future<Tuple3<List<Tuple2<String, Path>>, List<Tuple2<String, Path>>, List<Tuple2<String, Path>>>> getVzdAddressFileNames() {
        List AddressUrls = CollectionConverters$.MODULE$.ListHasAsScala(this.config.getStringList("VZD.open-data.urls")).asScala().toList();
        List AddressHistoryUrls = CollectionConverters$.MODULE$.ListHasAsScala(this.config.getStringList("VZD.open-data.history-urls")).asScala().toList();
        List AddressMdVietaUrls = CollectionConverters$.MODULE$.ListHasAsScala(this.config.getStringList("VZD.open-data.metadata-urls")).asScala().toList();
        String directory = this.config.getString("input-files");
        Downloader downloader = new Downloader();
        return ((LinearSeqOps)((IterableOps)((AbstractIterable)AddressUrls.map((Function1<String, Tuple4> & Serializable)url -> Tuple4$.MODULE$.apply(url, directory, this.fileNameFromUrl((String)url), ".csv"))).$plus$plus((IterableOnce)AddressHistoryUrls.map((Function1<String, Tuple4> & Serializable)url -> Tuple4$.MODULE$.apply(url, directory, this.fileNameFromUrl((String)url), "_his.csv")))).$plus$plus(AddressMdVietaUrls.map((Function1<String, Tuple4> & Serializable)url -> Tuple4$.MODULE$.apply(url, directory, this.fileNameFromUrl((String)url), ".csv")))).foldLeft(Future$.MODULE$.successful((Object)Nil$.MODULE$), (Function2<Future, Tuple4, Future> & Serializable)(x$1, x$2) -> {
            Tuple2<Future, Tuple4> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple4 tuple4 = tuple2._2();
                Future resF = tuple2._1();
                if (tuple4 != null) {
                    String url = (String)tuple4._1();
                    String dir = (String)tuple4._2();
                    String file = (String)tuple4._3();
                    String postfix = (String)tuple4._4();
                    return resF.flatMap((Function1<List, Future> & Serializable)res -> downloader.download(url, dir, file, postfix, this.system(), this.ec()).map((Function1<Option, List> & Serializable)r -> (List)res.$plus$plus((IterableOnce)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)r), Nil$.MODULE$))), this.ec()), this.ec());
                }
            }
            throw new MatchError(tuple2);
        }).map((Function1<List, Tuple3> & Serializable)x$1 -> {
            List list = x$1;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
                return Tuple3$.MODULE$.apply((Object)Nil$.MODULE$, (Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
            }
            List l = list;
            if (l.forall((Function1<Option, boolean> & Serializable)_$3 -> _$3.isEmpty())) {
                return Tuple3$.MODULE$.apply((Object)Nil$.MODULE$, (Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
            }
            List l2 = list;
            if (l2.forall((Function1<Option, boolean> & Serializable)r -> r.exists((Function1<IOResult, boolean> & Serializable)ioResult -> ioResult._1() > 0L))) {
                this.deleteOutdated(AddressUrls, directory, ".csv");
                this.deleteOutdated(AddressHistoryUrls, directory, "_his.csv");
                return Tuple3$.MODULE$.apply(this.getRelatedFiles(AddressUrls, directory), this.getRelatedFiles(AddressHistoryUrls, directory), this.getRelatedFiles(AddressMdVietaUrls, directory));
            }
            List x = list;
            throw scala.sys.package$.MODULE$.error(new StringBuilder(17).append("Download failed: ").append(x).toString());
        }, this.ec());
    }
}

