/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ApiParvaldnieks;
import dagr.ApiParvaldnieksToken;
import dagr.ConnectorData;
import dagr.DataFromVirsis$;
import dagr.DataFromVirsis$JsonToAny$;
import dagr.HttpClient;
import dagr.Record;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.mojoz.querease.Dto;
import org.mojoz.querease.DtoWithId;
import org.mojoz.querease.Querease;
import org.mojoz.querease.QuereaseMetadata;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try;
import spray.json.JsArray;
import spray.json.JsObject;
import spray.json.JsValue;
import spray.json.package$;

public class DataFromVirsis
implements ConnectorData {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DataFromVirsis.class.getDeclaredField("withScope$lzy1"));
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final Querease querease;
    private final ApiParvaldnieks apiParvaldnieks;
    private final HttpClient client;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private volatile Object withScope$lzy1;
    private final String virsisEndpointUri;
    private final boolean virsisUseApiParvaldnieks;
    private final FiniteDuration PreloadInterval;
    private final Set<String> SomeAccess;
    private final ZoneId zoneId;
    private final Renderer renderer;
    private final Querease qe;

    public static access_control_tree optimizeAccessControlTree(access_control_tree access_control_tree2) {
        return DataFromVirsis$.MODULE$.optimizeAccessControlTree(access_control_tree2);
    }

    public DataFromVirsis(Config config, Querease querease, ApiParvaldnieks apiParvaldnieks, HttpClient client, ActorSystem system, ExecutionContext ec) {
        this.config = config;
        this.querease = querease;
        this.apiParvaldnieks = apiParvaldnieks;
        this.client = client;
        this.system = system;
        this.ec = ec;
        ConnectorData.$init$(this);
        this.virsisEndpointUri = config.getString("remote.api-parvaldnieks.virsis.permissions");
        this.virsisUseApiParvaldnieks = config.hasPath("remote.api-parvaldnieks.virsis.scope");
        this.PreloadInterval = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(4)).hours();
        this.SomeAccess = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"full", "partial"}));
        this.zoneId = ZoneId.of(config.getString("data.timezone"));
        this.renderer = new Renderer(config, querease, "data_access_control");
        this.qe = querease;
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public List<Tuple2<String, String>> withScope() {
        Object object = this.withScope$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (List)this.withScope$lzyINIT1();
    }

    private Object withScope$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.withScope$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    List list = null;
                    try {
                        list = (List)Option$.MODULE$.apply("remote.api-parvaldnieks.virsis.scope").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> this.config().hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> this.config().getString((String)x$0)).map((Function1<String, List> & Serializable)s2 -> (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Tuple2$.MODULE$.apply("scope", URLEncoder.encode(s2, StandardCharsets.UTF_8))), Nil$.MODULE$))).getOrElse(DataFromVirsis::withScope$lzyINIT1$$anonfun$4);
                        serializable = list == null ? LazyVals$NullValue$.MODULE$ : list;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.withScope$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String virsisEndpointUri() {
        return this.virsisEndpointUri;
    }

    public boolean virsisUseApiParvaldnieks() {
        return this.virsisUseApiParvaldnieks;
    }

    public FiniteDuration PreloadInterval() {
        return this.PreloadInterval;
    }

    public Set<String> SomeAccess() {
        return this.SomeAccess;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public Renderer renderer() {
        return this.renderer;
    }

    public boolean isSkippable(data_access_control dac) {
        return dac.valid_from() != null && dac.valid_from().toInstant().minus(this.PreloadInterval().toMillis(), ChronoUnit.MILLIS).toEpochMilli() > System.currentTimeMillis();
    }

    public boolean isExpiredOrEmpty(data_access_control dac) {
        return dac.use_count_quota() != null && BoxesRunTime.unboxToLong(Option$.MODULE$.apply(dac.use_count()).map((Function1<Long, long> & Serializable)_$7 -> Predef$.MODULE$.Long2long((Long)_$7)).getOrElse(DataFromVirsis::isExpiredOrEmpty$$anonfun$2)) >= Predef$.MODULE$.Long2long(dac.use_count_quota()) || dac.valid_to() != null && dac.valid_to().toInstant().isBefore(Instant.now()) || !this.SomeAccess().contains(dac.access_control_tree().read_access());
    }

    public OffsetDateTime dateStringToOffsetDateTime(String dateString) {
        return (OffsetDateTime)Option$.MODULE$.apply(dateString).map((Function1<String, OffsetDateTime> & Serializable)_$8 -> ZonedDateTime.of(LocalDate.parse(dateString).atStartOfDay(), this.zoneId()).toOffsetDateTime()).orNull($less$colon$less$.MODULE$.refl());
    }

    public Querease qe() {
        return this.qe;
    }

    public Seq<Record> toAccessControlRecord(virsis_permission permission) {
        virsis_permission_permission src = permission.permission();
        Option accessControlSeqOpt = Option$.MODULE$.apply(src.receiver()).map((Function1<virsis_permission_permission_receiver, String> & Serializable)_$9 -> _$9.registrationNumber()).filter((Function1<String, boolean> & Serializable)_$10 -> _$10 != null).flatMap((Function1<String, Option> & Serializable)receiver_reg_nr -> Option$.MODULE$.apply(src.id()).map((Function1<Long, String> & Serializable)_$11 -> _$11.toString()).flatMap((Function1<String, Option> & Serializable)permission_number -> Option$.MODULE$.apply(src.dagrRigths()).map((Function1<List, List> & Serializable)_$12 -> _$12.filter((Function1<virsis_permission_permission_dagrRigths, boolean> & Serializable)_$13 -> _$13 != null)).map((Function1<List, List> & Serializable)_$14 -> _$14.map((Function1<virsis_permission_permission_dagrRigths, access_control_tree> & Serializable)_$15 -> _$15.tree())).map((Function1<List, List> & Serializable)_$16 -> _$16.filter((Function1<access_control_tree, boolean> & Serializable)_$17 -> _$17 != null)).map((Function1<List, List> & Serializable)_$18 -> _$18.filter((Function1<access_control_tree, boolean> & Serializable)_$19 -> _$19.name() != null)).filter((Function1<List, boolean> & Serializable)_$20 -> _$20.size() > 0).map((Function1<List, List> & Serializable)_$21 -> _$21.map((Function1<access_control_tree, data_access_control> & Serializable)permission -> {
            data_access_control dac = new data_access_control();
            dac.consumer_identity_$eq((String)receiver_reg_nr);
            dac.service_name_$eq(permission.name());
            dac.permission_number_$eq((String)permission_number);
            dac.use_count_$eq(src.informationServiceCountUsed());
            dac.use_count_quota_$eq(src.informationServiceCount());
            dac.purpose_of_use_$eq(src.purposeOfDataUse());
            dac.valid_from_$eq(this.dateStringToOffsetDateTime(src.serviceDateFrom()));
            dac.valid_to_$eq(this.dateStringToOffsetDateTime(src.serviceDateTill()));
            dac.virsis_id_$eq(src.id());
            dac.access_control_tree_$eq(DataFromVirsis$.MODULE$.optimizeAccessControlTree((access_control_tree)permission));
            return dac;
        })).map((Function1<List, List> & Serializable)permissions -> permissions)));
        List accessControlSeq = (List)accessControlSeqOpt.getOrElse(DataFromVirsis::$anonfun$4);
        return accessControlSeq.flatMap((Function1<data_access_control, IterableOnce> & Serializable)accessControl -> {
            if (this.isExpiredOrEmpty((data_access_control)accessControl)) {
                return scala.package$.MODULE$.Nil();
            }
            if (this.isSkippable((data_access_control)accessControl)) {
                return scala.package$.MODULE$.Nil();
            }
            return new $colon$colon<Nothing$>((Nothing$)((Object)this.renderer().renderKeyAndValue((Map)accessControl.toMap(this.qe()).$minus("use_count"))), Nil$.MODULE$);
        });
    }

    private Future<Seq<virsis_permission>> getPermissionsFromVirsis(Uri permissionsEndpointUri, ActorSystem system, ExecutionContext ec) {
        Future future;
        Querease qe = this.querease;
        Unmarshaller<HttpEntity, JsArray> unmarshaller = this.apiParvaldnieks.toJsArrayUnmarshaller();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("isDAGR");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, "true");
        Map queryParams = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        if (this.virsisUseApiParvaldnieks()) {
            future = this.apiParvaldnieks.getToken(this.withScope()).flatMap((Function1<ApiParvaldnieksToken, Future> & Serializable)token -> this.apiParvaldnieks.getData((ApiParvaldnieksToken)token, queryParams, permissionsEndpointUri.toString(), true, this.apiParvaldnieks.getData$default$5(), this.apiParvaldnieks.getData$default$6(), this.apiParvaldnieks.getData$default$7(), system, ec, unmarshaller).map((Function1<JsArray, JsArray> & Serializable)permissionsJsArray -> permissionsJsArray, ec), ec);
        } else {
            Uri uri = permissionsEndpointUri.withQuery(Uri$Query$.MODULE$.apply(queryParams));
            Seq seq = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)RawHeader$.MODULE$.apply("Authorization", "Bearer x")), Nil$.MODULE$));
            HttpMethod httpMethod = HttpRequest$.MODULE$.apply$default$1();
            RequestEntity requestEntity = HttpRequest$.MODULE$.apply$default$4();
            HttpProtocol httpProtocol = HttpRequest$.MODULE$.apply$default$5();
            future = this.client.doRequest(HttpRequest$.MODULE$.apply(httpMethod, uri, seq, requestEntity, httpProtocol), this.client.doRequest$default$2(), this.client.doRequest$default$3(), this.client.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)_$23 -> _$23.entity().toStrict(FiniteDuration$.MODULE$.apply(10L, scala.concurrent.duration.package$.MODULE$.SECONDS()), Materializer$.MODULE$.matFromSystem(system)), ec).map((Function1<HttpEntity.Strict, JsArray> & Serializable)_$24 -> {
                JsValue jsValue = package$.MODULE$.enrichString(_$24.data().utf8String()).parseJson();
                if (jsValue instanceof JsArray) {
                    JsArray arr = (JsArray)jsValue;
                    return arr;
                }
                JsValue x = jsValue;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(35).append("Unexpected permission array class: ").append(Option$.MODULE$.apply(x).map((Function1<JsValue, String> & Serializable)_$25 -> _$25.getClass().getName()).orNull($less$colon$less$.MODULE$.refl())).toString());
            }, ec);
        }
        Future permissionsJsArray = future;
        return permissionsJsArray.map((Function1<JsArray, Vector> & Serializable)_$26 -> (Vector)_$26.elements().map((Function1<JsValue, virsis_permission> & Serializable)jsValue -> DataFromVirsis.jsValueToDtoPermission$1(qe, jsValue)), ec);
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return this.getPermissionsFromVirsis(Uri$.MODULE$.apply(new StringBuilder(12).append(this.virsisEndpointUri()).append("/permissions").toString()), this.system, this.ec).map((Function1<Seq, Some> & Serializable)permissions -> Some$.MODULE$.apply(Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply(null, SourceInfo$.MODULE$.$lessinit$greater$default$2()), ((Source)Source$.MODULE$.fromIterator((Function0<Iterator> & Serializable)() -> permissions.iterator()).flatMapConcat((Function1<virsis_permission, Graph> & Serializable)permission -> Source$.MODULE$.fromIterator((Function0<Iterator> & Serializable)() -> this.toAccessControlRecord((virsis_permission)permission).iterator()))).mapMaterializedValue((Function1<NotUsed, Function1> & Serializable)_$27 -> _$28 -> {}))), this.ec);
    }

    private static final List withScope$lzyINIT1$$anonfun$4() {
        return (List)((Object)Nil$.MODULE$);
    }

    private static final long isExpiredOrEmpty$$anonfun$2() {
        return 0L;
    }

    private static final List $anonfun$4() {
        return scala.package$.MODULE$.Nil();
    }

    private static final virsis_permission jsValueToDtoPermission$1(Querease qe$1, JsValue jsValue) {
        JsValue jsValue2 = jsValue;
        if (jsValue2 instanceof JsObject) {
            JsObject obj = (JsObject)jsValue2;
            virsis_permission permission = new virsis_permission();
            permission.fill((Map)DataFromVirsis$JsonToAny$.MODULE$.apply(obj), (QuereaseMetadata)qe$1);
            return permission;
        }
        JsValue x = jsValue2;
        throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unexpected ").append(Option$.MODULE$.apply(x).map((Function1<JsValue, String> & Serializable)_$22 -> _$22.getClass().getName()).orNull($less$colon$less$.MODULE$.refl())).append(", expecting ").append(JsArray.class.getName()).toString());
    }

    public static class access_control_tree
    extends access_control_tree_property {
        private Option<List<access_control_tree_filters>> filters = None$.MODULE$;
        private Option<List<access_control_tree_search>> search = None$.MODULE$;

        public Option<List<access_control_tree_filters>> filters() {
            return this.filters;
        }

        public void filters_$eq(Option<List<access_control_tree_filters>> x$1) {
            this.filters = x$1;
        }

        public Option<List<access_control_tree_search>> search() {
            return this.search;
        }

        public void search_$eq(Option<List<access_control_tree_search>> x$1) {
            this.search = x$1;
        }
    }

    public static class access_control_tree_filters
    implements Dto {
        private String filter = null;

        public String filter() {
            return this.filter;
        }

        public void filter_$eq(String x$1) {
            this.filter = x$1;
        }
    }

    public static class access_control_tree_property
    implements Dto {
        private String name = null;
        private String read_access = null;
        private List<access_control_tree_property> properties = scala.package$.MODULE$.Nil();

        public String name() {
            return this.name;
        }

        public void name_$eq(String x$1) {
            this.name = x$1;
        }

        public String read_access() {
            return this.read_access;
        }

        public void read_access_$eq(String x$1) {
            this.read_access = x$1;
        }

        public List<access_control_tree_property> properties() {
            return this.properties;
        }

        public void properties_$eq(List<access_control_tree_property> x$1) {
            this.properties = x$1;
        }
    }

    public static class access_control_tree_search
    implements Dto {
        private String name = null;

        public String name() {
            return this.name;
        }

        public void name_$eq(String x$1) {
            this.name = x$1;
        }
    }

    public static class data_access_control
    implements Dto {
        private String consumer_identity = null;
        private String service_name = null;
        private String permission_number = null;
        private String purpose_of_use = null;
        private Long use_count = null;
        private Long use_count_quota = null;
        private OffsetDateTime valid_from = null;
        private OffsetDateTime valid_to = null;
        private Long virsis_id = null;
        private access_control_tree access_control_tree = null;

        public String consumer_identity() {
            return this.consumer_identity;
        }

        public void consumer_identity_$eq(String x$1) {
            this.consumer_identity = x$1;
        }

        public String service_name() {
            return this.service_name;
        }

        public void service_name_$eq(String x$1) {
            this.service_name = x$1;
        }

        public String permission_number() {
            return this.permission_number;
        }

        public void permission_number_$eq(String x$1) {
            this.permission_number = x$1;
        }

        public String purpose_of_use() {
            return this.purpose_of_use;
        }

        public void purpose_of_use_$eq(String x$1) {
            this.purpose_of_use = x$1;
        }

        public Long use_count() {
            return this.use_count;
        }

        public void use_count_$eq(Long x$1) {
            this.use_count = x$1;
        }

        public Long use_count_quota() {
            return this.use_count_quota;
        }

        public void use_count_quota_$eq(Long x$1) {
            this.use_count_quota = x$1;
        }

        public OffsetDateTime valid_from() {
            return this.valid_from;
        }

        public void valid_from_$eq(OffsetDateTime x$1) {
            this.valid_from = x$1;
        }

        public OffsetDateTime valid_to() {
            return this.valid_to;
        }

        public void valid_to_$eq(OffsetDateTime x$1) {
            this.valid_to = x$1;
        }

        public Long virsis_id() {
            return this.virsis_id;
        }

        public void virsis_id_$eq(Long x$1) {
            this.virsis_id = x$1;
        }

        public access_control_tree access_control_tree() {
            return this.access_control_tree;
        }

        public void access_control_tree_$eq(access_control_tree x$1) {
            this.access_control_tree = x$1;
        }
    }

    public static class virsis_permission
    implements Dto {
        private virsis_permission_permission permission = null;

        public virsis_permission_permission permission() {
            return this.permission;
        }

        public void permission_$eq(virsis_permission_permission x$1) {
            this.permission = x$1;
        }
    }

    public static class virsis_permission_permission
    implements Dto,
    DtoWithId {
        private Long id = null;
        private String name = null;
        private String purposeOfDataUse = null;
        private String serviceDateFrom = null;
        private String serviceDateTill = null;
        private Long informationServiceCount = null;
        private Long informationServiceCountUsed = null;
        private String acceptDate = null;
        private virsis_permission_permission_receiver receiver = null;
        private List<virsis_permission_permission_dagrRigths> dagrRigths = scala.package$.MODULE$.Nil();
        private virsis_permission_permission_termination termination = null;

        @Override
        public Long id() {
            return this.id;
        }

        @Override
        public void id_$eq(Long x$1) {
            this.id = x$1;
        }

        public String name() {
            return this.name;
        }

        public void name_$eq(String x$1) {
            this.name = x$1;
        }

        public String purposeOfDataUse() {
            return this.purposeOfDataUse;
        }

        public void purposeOfDataUse_$eq(String x$1) {
            this.purposeOfDataUse = x$1;
        }

        public String serviceDateFrom() {
            return this.serviceDateFrom;
        }

        public void serviceDateFrom_$eq(String x$1) {
            this.serviceDateFrom = x$1;
        }

        public String serviceDateTill() {
            return this.serviceDateTill;
        }

        public void serviceDateTill_$eq(String x$1) {
            this.serviceDateTill = x$1;
        }

        public Long informationServiceCount() {
            return this.informationServiceCount;
        }

        public void informationServiceCount_$eq(Long x$1) {
            this.informationServiceCount = x$1;
        }

        public Long informationServiceCountUsed() {
            return this.informationServiceCountUsed;
        }

        public void informationServiceCountUsed_$eq(Long x$1) {
            this.informationServiceCountUsed = x$1;
        }

        public String acceptDate() {
            return this.acceptDate;
        }

        public void acceptDate_$eq(String x$1) {
            this.acceptDate = x$1;
        }

        public virsis_permission_permission_receiver receiver() {
            return this.receiver;
        }

        public void receiver_$eq(virsis_permission_permission_receiver x$1) {
            this.receiver = x$1;
        }

        public List<virsis_permission_permission_dagrRigths> dagrRigths() {
            return this.dagrRigths;
        }

        public void dagrRigths_$eq(List<virsis_permission_permission_dagrRigths> x$1) {
            this.dagrRigths = x$1;
        }

        public virsis_permission_permission_termination termination() {
            return this.termination;
        }

        public void termination_$eq(virsis_permission_permission_termination x$1) {
            this.termination = x$1;
        }
    }

    public static class virsis_permission_permission_dagrRigths
    implements Dto {
        private access_control_tree tree = null;

        public access_control_tree tree() {
            return this.tree;
        }

        public void tree_$eq(access_control_tree x$1) {
            this.tree = x$1;
        }
    }

    public static class virsis_permission_permission_receiver
    implements Dto {
        private String name = null;
        private String registrationNumber = null;

        public String name() {
            return this.name;
        }

        public void name_$eq(String x$1) {
            this.name = x$1;
        }

        public String registrationNumber() {
            return this.registrationNumber;
        }

        public void registrationNumber_$eq(String x$1) {
            this.registrationNumber = x$1;
        }
    }

    public static class virsis_permission_permission_termination
    implements Dto {
        private String terminationDateFrom = null;
        private String serviceTerminationDateFrom = null;

        public String terminationDateFrom() {
            return this.terminationDateFrom;
        }

        public void terminationDateFrom_$eq(String x$1) {
            this.terminationDateFrom = x$1;
        }

        public String serviceTerminationDateFrom() {
            return this.serviceTerminationDateFrom;
        }

        public void serviceTerminationDateFrom_$eq(String x$1) {
            this.serviceTerminationDateFrom = x$1;
        }
    }
}

