/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ApiParvaldnieks;
import dagr.ApiParvaldnieksToken;
import dagr.ConnectorData;
import dagr.DataParserUtils$;
import dagr.Record;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import dagr.SyncType;
import dagr.SyncTypeDiffAndTimestamps$;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.headers.BasicHttpCredentials$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import spray.json.JsArray;
import spray.json.JsArray$;
import spray.json.JsObject;
import spray.json.JsValue;

public class DataFromVdeavk
implements ConnectorData {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DataFromVdeavk.class.getDeclaredField("extraHeaders$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DataFromVdeavk.class.getDeclaredField("withScope$lzy1"));
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final ApiParvaldnieks apiParvaldnieks;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private final Logger logger;
    private final Logger loggerTracking;
    private final AtomicReference<Option<LocalDateTime>> cachedLastStartLdtOpt;
    private final String configLastChangedAt;
    private final List<Regex> changesValidationPatterns;
    private final boolean replaceEntityNrInTrackingLogWithHash;
    private final boolean forceLastChangedAtOnStartup;
    private volatile Object withScope$lzy1;
    private volatile Object extraHeaders$lzy1;
    private final Renderer renderer;

    public DataFromVdeavk(Config config, String view_name, ApiParvaldnieks apiParvaldnieks, ActorSystem system, ExecutionContext ec) {
        this.config = config;
        this.apiParvaldnieks = apiParvaldnieks;
        this.system = system;
        this.ec = ec;
        ConnectorData.$init$(this);
        this.logger = LoggerFactory.getLogger("DataFromVdeavk");
        this.loggerTracking = LoggerFactory.getLogger("Tracking[Vdeavk]");
        this.cachedLastStartLdtOpt = new AtomicReference<None$>(None$.MODULE$);
        this.configLastChangedAt = config.getString("remote.api-parvaldnieks.changes.params.last_changed_at");
        this.changesValidationPatterns = CollectionConverters$.MODULE$.CollectionHasAsScala(config.getStringList("remote.api-parvaldnieks.changes.entity_validation_patterns")).asScala().toList().map((Function1<String, Regex> & Serializable)_$1 -> new Regex((String)_$1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray(new String[0])));
        this.replaceEntityNrInTrackingLogWithHash = config.getBoolean("remote.api-parvaldnieks.replaceEntityNrInTrackingLogWithHash");
        this.forceLastChangedAtOnStartup = Option$.MODULE$.apply("remote.api-parvaldnieks.changes.force_last_changed_at_on_startup_before").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> config.hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> config.getString((String)x$0)).exists((Function1<String, boolean> & Serializable)d -> {
            Instant instant = Instant.now();
            return Option$.MODULE$.apply(DataParserUtils$.MODULE$.parseDateTimeAsInstant((String)d)).exists((Function1<Instant, Object>)(Function1<Instant, boolean> & Serializable)x$0 -> instant.isBefore((Instant)x$0));
        });
        this.renderer = new Renderer(config);
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    private List<Tuple2<String, String>> withScope() {
        Object object = this.withScope$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (List)this.withScope$lzyINIT1();
    }

    private Object withScope$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.withScope$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    List list = null;
                    try {
                        list = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Tuple2$.MODULE$.apply("scope", URLEncoder.encode(this.config().getString("remote.api-parvaldnieks.changes.scope"), StandardCharsets.UTF_8))), Nil$.MODULE$));
                        serializable = list == null ? LazyVals$NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.withScope$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.withScope$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<RawHeader> extraHeaders() {
        Object object = this.extraHeaders$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (List)this.extraHeaders$lzyINIT1();
    }

    private Object extraHeaders$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.extraHeaders$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    List list = null;
                    try {
                        list = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)RawHeader$.MODULE$.apply(this.config().getString("remote.api-parvaldnieks.changes.extraHeader.name"), BasicHttpCredentials$.MODULE$.apply(this.config().getString("remote.api-parvaldnieks.changes.extraHeader.basic.username"), this.config().getString("remote.api-parvaldnieks.changes.extraHeader.basic.password")).toString())), Nil$.MODULE$));
                        serializable = list == null ? LazyVals$NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.extraHeaders$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.extraHeaders$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public SyncType syncType() {
        return SyncTypeDiffAndTimestamps$.MODULE$;
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return Future$.MODULE$.apply(() -> this.source$$anonfun$1(ts, schedulerInfo), this.ec);
    }

    private final Tuple2 $anonfun$2$$anonfun$3() {
        this.logger.debug(new StringBuilder(35).append("Initiate with configLastChangedAt: ").append(this.configLastChangedAt).toString());
        return Tuple2$.MODULE$.apply(this.configLastChangedAt, BoxesRunTime.boxToBoolean(true));
    }

    private static final Tuple2 $anonfun$2$$anonfun$5() {
        throw package$.MODULE$.error("Couldn't determine start time");
    }

    private final Tuple2 $anonfun$2(Option ts$2, SchedulerInfo schedulerInfo$2) {
        return (Tuple2)Option$.MODULE$.apply(ts$2.map((Function1<RemoteRecordTimestampInfo, Tuple2> & Serializable)t -> {
            this.logger.debug(new StringBuilder(32).append("Retrieved queue last timestamp: ").append(t.timestamp()).toString());
            return Tuple2$.MODULE$.apply(t.timestamp(), BoxesRunTime.boxToBoolean(false));
        }).filterNot((Function1<Tuple2, boolean> & Serializable)_$2 -> schedulerInfo$2.count() == 1 && this.forceLastChangedAtOnStartup).getOrElse(this::$anonfun$2$$anonfun$3)).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            String string2 = (String)x$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean(x$1._2());
            LocalDateTime localDateTime = Predef$.MODULE$.ArrowAssoc(DataParserUtils$.MODULE$.parseDateTimeAsInstant(string2).atZone(ZoneOffset.UTC).toLocalDateTime().minusDays(bl ? 0L : 1L));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(localDateTime, null);
        }).getOrElse(DataFromVdeavk::$anonfun$2$$anonfun$5);
    }

    private static final String source$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "?";
    }

    private static final String source$$anonfun$1$$anonfun$1$$anonfun$2() {
        return "?";
    }

    private final Some source$$anonfun$1(Option ts$1, SchedulerInfo schedulerInfo$1) {
        Tuple2 tuple2 = (Tuple2)this.cachedLastStartLdtOpt.get().map((Function1<LocalDateTime, Tuple2> & Serializable)lldt -> {
            LocalDateTime localDateTime = Predef$.MODULE$.ArrowAssoc(lldt);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(localDateTime, null);
        }).getOrElse(() -> this.$anonfun$2(ts$1, schedulerInfo$1));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LocalDateTime startLtd = (LocalDateTime)tuple2._1();
        Null$ doubleCheckCase = (Null$)tuple2._2();
        Tuple2<LocalDateTime, Object> tuple22 = Tuple2$.MODULE$.apply(startLtd, null);
        LocalDateTime startLtd2 = tuple22._1();
        Null$ doubleCheckCase2 = tuple22._2();
        return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply(null, null), ((Source)Source$.MODULE$.unfoldAsync(startLtd2, (Function1<LocalDateTime, Future> & Serializable)sLtd -> {
            int minusDays = schedulerInfo$1.count() == 1 && this.cachedLastStartLdtOpt.get().isEmpty() ? 1 : 0;
            Tuple2[] tuple2Array = new Tuple2[2];
            String string2 = Predef$.MODULE$.ArrowAssoc("startDate");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, DataParserUtils$.MODULE$.DATE_FORMAT_LV().format(sLtd.minusDays(Int$.MODULE$.int2long(minusDays))));
            String string3 = Predef$.MODULE$.ArrowAssoc("endDate");
            tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, DataParserUtils$.MODULE$.DATE_FORMAT_LV().format((TemporalAccessor)sLtd));
            Map params = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
            this.logger.info(new StringBuilder(43).append("Scheduler counter: ").append(schedulerInfo$1.count()).append("; startDate: ").append(params.getOrElse("startDate", DataFromVdeavk::source$$anonfun$1$$anonfun$1$$anonfun$1)).append("; endDate: ").append(params.getOrElse("endDate", DataFromVdeavk::source$$anonfun$1$$anonfun$1$$anonfun$2)).toString());
            UUID getPageDataUuid = UUID.randomUUID();
            return this.apiParvaldnieks.getToken(this.withScope()).flatMap((Function1<ApiParvaldnieksToken, Future> & Serializable)token -> {
                Unmarshaller<HttpEntity, JsObject> unmarshaller = this.apiParvaldnieks.toJsObjectUnmarshaller();
                List<RawHeader> list = this.extraHeaders();
                String string2 = this.apiParvaldnieks.getData$default$3();
                Option<String> option = this.apiParvaldnieks.getData$default$7();
                return this.apiParvaldnieks.getData((ApiParvaldnieksToken)token, params, string2, true, list, getPageDataUuid, option, this.system, this.ec, unmarshaller).map((Function1<JsObject, Tuple2> & Serializable)jsObj -> Tuple2$.MODULE$.apply(jsObj.fields().get("queryResults"), jsObj.compactPrint()), this.ec).map((Function1<Tuple2, Iterator> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._1();
                        String string2 = (String)tuple2._2();
                        if (None$.MODULE$.equals(option)) {
                            String s2 = string2;
                            throw new Exception(new StringBuilder(62).append("[").append(getPageDataUuid).append("] No queryResults array in retrieved result. Data retrieved: ").append(s2).toString());
                        }
                        if (option instanceof Some) {
                            JsValue jsValue = (JsValue)((Some)option).value();
                            if (jsValue instanceof JsArray) {
                                JsArray jsArray = JsArray$.MODULE$.unapply((JsArray)jsValue);
                                Vector<JsValue> vector = jsArray._1();
                                Vector<JsValue> a = vector;
                                if (a.nonEmpty()) {
                                    this.loggerTracking.info(((IterableOnceOps)((StrictOptimizedIterableOps)a.map((Function1<JsValue, String> & Serializable)e -> {
                                        String string2;
                                        try {
                                            string2 = DataParserUtils$.MODULE$.getStrFromJsValue(e.asJsObject().fields(), "perPersKods");
                                        }
                                        catch (Throwable throwable) {
                                            Option<Throwable> option;
                                            Throwable throwable2 = throwable;
                                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                                Throwable throwable3;
                                                Throwable e2 = throwable3 = option.get();
                                                string2 = "<parse err>";
                                            }
                                            throw throwable;
                                        }
                                        return string2;
                                    })).map((Function1<String, String> & Serializable)entityNr -> {
                                        if (this.replaceEntityNrInTrackingLogWithHash) {
                                            return this.apiParvaldnieks.entityNrHash((String)entityNr);
                                        }
                                        return entityNr;
                                    })).mkString(new StringBuilder(24).append("[").append(getPageDataUuid).append("] pageData records [").append(a.size()).append("]: ").toString(), ",", ""));
                                } else {
                                    this.loggerTracking.info(new StringBuilder(22).append("[").append(getPageDataUuid).append("] no pageData records").toString());
                                }
                                return ((Vector)a.map((Function1<JsValue, Tuple2> & Serializable)el -> Tuple2$.MODULE$.apply(sLtd, el))).iterator();
                            }
                            String s3 = string2;
                            throw new Exception(new StringBuilder(66).append("[").append(getPageDataUuid).append("] QueryResults is not array in retrieved result. Data retrieved: ").append(s3).toString());
                        }
                    }
                    throw new MatchError(tuple2);
                }, this.ec).map((Function1<Iterator, Option> & Serializable)records -> {
                    this.cachedLastStartLdtOpt.set(Some$.MODULE$.apply(sLtd));
                    LocalDateTime nextStartLtd = sLtd.plusDays(1L);
                    if (LocalDateTime.now().isBefore(nextStartLtd)) {
                        return None$.MODULE$;
                    }
                    return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(nextStartLtd, records));
                }, this.ec);
            }, this.ec);
        }).flatMapConcat((Function1<Iterator, Graph> & Serializable)records -> Source$.MODULE$.fromIterator((Function0<Iterator> & Serializable)() -> records)).mapAsync(3, (Function1<Tuple2, Future> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                LocalDateTime sLtd = (LocalDateTime)tuple2._1();
                JsValue entity = (JsValue)tuple2._2();
                Tuple2<Record, Option<String>> tuple22 = DataParserUtils$.MODULE$.parseVdeavkRecord(entity, sLtd, this.replaceEntityNrInTrackingLogWithHash, this.changesValidationPatterns, this.renderer);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Record record = tuple22._1();
                Option<String> logMsgOpt = tuple22._2();
                Tuple2<Record, Option<String>> tuple23 = Tuple2$.MODULE$.apply(record, logMsgOpt);
                Record record2 = tuple23._1();
                Option<String> logMsgOpt2 = tuple23._2();
                logMsgOpt2.foreach(x$0 -> this.logger.warn((String)x$0));
                return Future$.MODULE$.successful(record2);
            }
            throw new MatchError(tuple2);
        }).filter((Function1<Record, boolean> & Serializable)_$3 -> _$3.key() != null)).mapMaterializedValue((Function1<NotUsed, Function1> & Serializable)_$4 -> _$5 -> {})));
    }
}

