/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ApiParvaldnieks;
import dagr.ApiParvaldnieksToken;
import dagr.Connector$;
import dagr.ConnectorData;
import dagr.DataParserUtils$;
import dagr.ExtractFileBaseValues;
import dagr.ExtractFileBaseValues$;
import dagr.Record;
import dagr.Record$;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import dagr.SyncType;
import dagr.SyncTypeCheckTimestamps$;
import dagr.Uploader;
import java.io.Serializable;
import java.time.Year;
import java.util.UUID;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.mojoz.querease.Querease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class DataFromUrWithFileUpload
implements ConnectorData {
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final ApiParvaldnieks apiParvaldnieks;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private final Logger logger;
    private final Logger loggerTracking;
    private final ExtractFileBaseValues valueExtractor;
    private final int maxPageSize;
    private final String dataMinYear;
    private final String filesMinYear;
    private final String configLastChangedAt;
    private final String entityKeyNameInResponse;
    private final boolean replaceEntityNrInTrackingLogWithHash;
    private final Renderer renderer;

    public DataFromUrWithFileUpload(Config config, Querease qe, String view_name, ApiParvaldnieks apiParvaldnieks, Uploader uploader, ActorSystem system, ExecutionContext ec) {
        ExtractFileBaseValues extractFileBaseValues;
        this.config = config;
        this.apiParvaldnieks = apiParvaldnieks;
        this.system = system;
        this.ec = ec;
        ConnectorData.$init$(this);
        this.logger = LoggerFactory.getLogger(new StringBuilder(26).append("DataFromUrWithFileUpload[").append(Connector$.MODULE$.datasource_type()).append("]").toString());
        this.loggerTracking = LoggerFactory.getLogger(new StringBuilder(10).append("Tracking[").append(Connector$.MODULE$.datasource_type()).append("]").toString());
        String string2 = Connector$.MODULE$.datasource_type();
        if ("urAr".equals(string2)) {
            extractFileBaseValues = ExtractFileBaseValues$.MODULE$.apply((Function1<Map<String, Object>, String>)(Function1<Map, String> & Serializable)m -> this.getStringOrNull((Map<String, ?>)m, "fileId"), (Function1<Map<String, Object>, String>)(Function1<Map, String> & Serializable)m -> ((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)this.getStringOrNull((Map<String, ?>)m, "legalEntityRegistrationNumber")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.getStringOrNull((Map<String, ?>)m, "year")), Nil$.MODULE$))).mkString("/"));
        } else if ("urPublicDocument".equals(string2)) {
            extractFileBaseValues = ExtractFileBaseValues$.MODULE$.apply((Function1<Map<String, Object>, String>)(Function1<Map, String> & Serializable)m -> this.getStringOrNull((Map<String, ?>)m, "versionId"), (Function1<Map<String, Object>, String>)(Function1<Map, String> & Serializable)m -> this.getStringOrNull((Map<String, ?>)m, "versionId"));
        } else {
            throw new Exception(new StringBuilder(59).append("Unsupported datasource type '").append(Connector$.MODULE$.datasource_type()).append("' for DataFromUrWithFileUpload").toString());
        }
        this.valueExtractor = extractFileBaseValues;
        this.maxPageSize = 100;
        this.dataMinYear = BoxesRunTime.boxToInteger(config.getInt("remote.api-parvaldnieks.ur.fileReq.data.min.year")).toString();
        this.filesMinYear = BoxesRunTime.boxToInteger(config.getInt("remote.api-parvaldnieks.ur.fileReq.files.min.year")).toString();
        this.configLastChangedAt = new StringBuilder(16).append(scala.math.package$.MODULE$.min(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.dataMinYear)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.filesMinYear)))).append("-01-01T00:00:00Z").toString();
        this.entityKeyNameInResponse = config.getString("remote.api-parvaldnieks.changes.entity_key_name_in_respone");
        this.replaceEntityNrInTrackingLogWithHash = config.getBoolean("remote.api-parvaldnieks.replaceEntityNrInTrackingLogWithHash");
        this.renderer = new Renderer(config, qe, view_name);
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public String getStringOrNull(Map<String, ?> m, String fieldName) {
        Option option = m.get(fieldName);
        if (option instanceof Some) {
            Object a = ((Some)option).value();
            if (a == null) {
                return null;
            }
            Object x = a;
            return x.toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(14).append("Missing field ").append(fieldName).toString());
        }
        throw new MatchError(option);
    }

    public int maxPageSize() {
        return this.maxPageSize;
    }

    public String configLastChangedAt() {
        return this.configLastChangedAt;
    }

    public Renderer renderer() {
        return this.renderer;
    }

    @Override
    public SyncType syncType() {
        return SyncTypeCheckTimestamps$.MODULE$;
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return Future$.MODULE$.apply(() -> this.source$$anonfun$1(ts), this.ec);
    }

    private final String $anonfun$2() {
        return this.configLastChangedAt();
    }

    private final Tuple2 source$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Map pageData$1, UUID getPageDataUuid$2, ByteString pageRaw$1) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToBoolean(DataParserUtils$.MODULE$.getValueByPath(pageData$1, (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)"_embedded"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.entityKeyNameInResponse), Nil$.MODULE$)))).nonEmpty()), DataParserUtils$.MODULE$.getValueByPath(pageData$1, (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)"page"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"totalPages"), Nil$.MODULE$)))).map((Function1<Object, int> & Serializable)_$2 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$2.toString()))));
        if (tuple2 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
            Option option = tuple2._2();
            if (bl) {
                if (option instanceof Some) {
                    int pageCount = BoxesRunTime.unboxToInt(((Some)option).value());
                    Object object = DataParserUtils$.MODULE$.getValueByPath(pageData$1, (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)"_embedded"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.entityKeyNameInResponse), Nil$.MODULE$)))).get();
                    if (object instanceof Seq) {
                        Seq records = (Seq)object;
                        this.loggerTracking.info(((IterableOnceOps)((IterableOps)records.map((Function1<Map, String> & Serializable)e -> {
                            String string2;
                            try {
                                string2 = this.valueExtractor.trackKey().apply((Map<String, Object>)e);
                            }
                            catch (Throwable throwable) {
                                Option<Throwable> option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable e2 = throwable3 = option.get();
                                    string2 = "<parse err>";
                                }
                                throw throwable;
                            }
                            return string2;
                        })).map((Function1<String, String> & Serializable)entityNr -> {
                            if (this.replaceEntityNrInTrackingLogWithHash) {
                                return this.apiParvaldnieks.entityNrHash((String)entityNr);
                            }
                            return entityNr;
                        })).mkString(new StringBuilder(24).append("[").append(getPageDataUuid$2).append("] pageData records [").append(records.size()).append("]: ").toString(), ",", ""));
                        return Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(pageCount), records);
                    }
                    return Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(pageCount), package$.MODULE$.Nil());
                }
                if (None$.MODULE$.equals(option)) {
                    this.logger.debug(pageRaw$1.utf8String());
                    throw scala.sys.package$.MODULE$.error(new StringBuilder(49).append("[").append(getPageDataUuid$2).append("] Sa\u0146emtais JSON objects nesatur page/totalPages").toString());
                }
            }
            if (!bl) {
                if (None$.MODULE$.equals(option)) {
                    this.logger.debug(pageRaw$1.utf8String());
                    throw scala.sys.package$.MODULE$.error(new StringBuilder(67).append("[").append(getPageDataUuid$2).append("] Sa\u0146emtais JSON objects nesatur ne page/totalPages, ne _embedded/").append(this.entityKeyNameInResponse).toString());
                }
                if (option instanceof Some) {
                    int pageCount = BoxesRunTime.unboxToInt(((Some)option).value());
                    this.logger.info(new StringBuilder(57).append("[").append(getPageDataUuid$2).append("] Sa\u0146emtais JSON objects nesatur _embedded/").append(this.entityKeyNameInResponse).append(". pageCount: ").append(pageCount).toString());
                    return Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(pageCount), package$.MODULE$.Nil());
                }
            }
        }
        throw new MatchError(tuple2);
    }

    private final /* synthetic */ Future source$$anonfun$1$$anonfun$1(String lastChangedAt$1, int pageNumber) {
        Tuple2[] tuple2Array = new Tuple2[4];
        String string2 = Predef$.MODULE$.ArrowAssoc("lastChangedAt");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, lastChangedAt$1);
        String string3 = Predef$.MODULE$.ArrowAssoc("order");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, "ASC");
        String string4 = Predef$.MODULE$.ArrowAssoc("size");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, BoxesRunTime.boxToInteger(this.maxPageSize()).toString());
        String string5 = Predef$.MODULE$.ArrowAssoc("page");
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, BoxesRunTime.boxToInteger(pageNumber).toString());
        Map params = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        UUID getPageDataUuid = UUID.randomUUID();
        return this.apiParvaldnieks.getToken(this.apiParvaldnieks.getToken$default$1()).flatMap((Function1<ApiParvaldnieksToken, Future> & Serializable)token -> {
            Unmarshaller<HttpEntity, Tuple2<ByteString, Map<String, Object>>> unmarshaller = this.apiParvaldnieks.toByteStringAndMapUnmarshaller();
            return this.apiParvaldnieks.getData((ApiParvaldnieksToken)token, params, this.apiParvaldnieks.getData$default$3(), this.apiParvaldnieks.getData$default$4(), this.apiParvaldnieks.getData$default$5(), getPageDataUuid, this.apiParvaldnieks.getData$default$7(), this.system, this.ec, unmarshaller).flatMap((Function1<Tuple2, Future> & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    ByteString pageRaw = (ByteString)tuple2._1();
                    Map pageData = (Map)tuple2._2();
                    return Future$.MODULE$.apply(() -> this.source$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(pageData, getPageDataUuid, pageRaw), this.ec).map((Function1<Tuple2, Option> & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            int pageCount = BoxesRunTime.unboxToInt(tuple2._1());
                            Seq records = (Seq)tuple2._2();
                            if (pageNumber < pageCount || records.nonEmpty()) {
                                return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(pageNumber + 1), records));
                            }
                            return None$.MODULE$;
                        }
                        throw new MatchError(tuple2);
                    }, this.ec);
                }
                throw new MatchError(tuple2);
            }, this.ec);
        }, this.ec);
    }

    private final Some source$$anonfun$1(Option ts$1) {
        String lastChangedAt = (String)ts$1.map((Function1<RemoteRecordTimestampInfo, String> & Serializable)_$1 -> _$1.timestamp()).getOrElse(this::$anonfun$2);
        return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply(null, SourceInfo$.MODULE$.$lessinit$greater$default$2()), ((Source)Source$.MODULE$.unfoldAsync(BoxesRunTime.boxToInteger(0), (Function1<Object, Future> & Serializable)pageNumber -> this.source$$anonfun$1$$anonfun$1(lastChangedAt, BoxesRunTime.unboxToInt(pageNumber))).flatMapConcat((Function1<Seq, Graph> & Serializable)records -> Source$.MODULE$.fromIterator((Function0<Iterator> & Serializable)() -> records.iterator())).map((Function1<Map, Record> & Serializable)e -> {
            boolean isFileRelevant;
            Map fields = e;
            String regNr = (String)e.get("legalEntityRegistrationNumber").filter((Function1<Object, boolean> & Serializable)_$3 -> _$3 != null).map((Function1<Object, String> & Serializable)_$4 -> _$4.toString()).orNull($less$colon$less$.MODULE$.refl());
            String year = (String)e.get("year").filter((Function1<Object, boolean> & Serializable)_$5 -> _$5 != null).map((Function1<Object, String> & Serializable)_$6 -> _$6.toString()).orNull($less$colon$less$.MODULE$.refl());
            String filesMaxYear = BoxesRunTime.boxToInteger(Year.now().getValue() + 1).toString();
            String string2 = this.getStringOrNull(fields, "isAnnulled");
            String string3 = "true";
            boolean isAnnulled = !(string2 != null ? !string2.equals(string3) : string3 != null);
            String lastModifiedAt = this.getStringOrNull(fields, "lastModifiedAt");
            boolean isDataRelevant = !"urAr".equals(Connector$.MODULE$.datasource_type()) || regNr != null && year != null && StringOps$.MODULE$.$less$eq$extension(Predef$.MODULE$.augmentString(this.dataMinYear), year);
            boolean bl = isFileRelevant = !"urAr".equals(Connector$.MODULE$.datasource_type()) || !isAnnulled && regNr != null && year != null && StringOps$.MODULE$.$less$eq$extension(Predef$.MODULE$.augmentString(this.filesMinYear), year) && StringOps$.MODULE$.$greater$eq$extension(Predef$.MODULE$.augmentString(filesMaxYear), year);
            if (isDataRelevant || isFileRelevant) {
                return this.renderer().buildRecord((Map<String, Object>)e, lastModifiedAt, isFileRelevant, this.renderer().buildRecord$default$4());
            }
            return Record$.MODULE$.apply(null, null, null, Record$.MODULE$.$lessinit$greater$default$4(), Record$.MODULE$.$lessinit$greater$default$5());
        }).filter((Function1<Record, boolean> & Serializable)_$7 -> _$7.key() != null)).mapMaterializedValue((Function1<NotUsed, Function1> & Serializable)_$8 -> _$9 -> {})));
    }
}

