/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ConnectorData;
import dagr.JsonAnyValueDecoder$;
import dagr.Record;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import io.bullet.borer.Decoder;
import io.bullet.borer.compat.pekkoHttp$;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.common.EntityStreamingSupport;
import org.apache.pekko.http.scaladsl.common.JsonEntityStreamingSupport;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.UniversalEntity;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Source;
import org.mojoz.metadata.FieldDef_;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.ViewDef_;
import org.mojoz.querease.Querease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public class DataFromJson
implements ConnectorData {
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final Querease qe;
    private final String view_name;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private final Logger logger;
    private final ViewDef_<FieldDef_<Type>> viewDef;
    private final String directory;
    private final String filename_pattern;
    private final Decoder<Map<String, Object>> decoder;
    private final Renderer renderer;

    public DataFromJson(Config config, Querease qe, String view_name, ActorSystem system, ExecutionContext ec) {
        this.config = config;
        this.qe = qe;
        this.view_name = view_name;
        this.system = system;
        this.ec = ec;
        ConnectorData.$init$(this);
        this.logger = LoggerFactory.getLogger("dagr.json");
        this.viewDef = qe.viewDef(view_name);
        this.directory = config.getString("json.files.directory");
        this.filename_pattern = config.getString("json.files.filename_pattern");
        this.decoder = JsonAnyValueDecoder$.MODULE$.toMapDecoder((Function0<Map> & Serializable)() -> Predef$.MODULE$.Map().empty(), ClassTag$.MODULE$.apply(Map.class));
        this.renderer = new Renderer(config, qe, view_name);
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public Seq<Path> getFiles(String dir, Seq<String> patterns) {
        return (Seq)((IterableOps)patterns.map((Function1<String, Regex> & Serializable)_$1 -> new Regex((String)_$1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray(new String[0])))).flatMap((Function1<Regex, IterableOnce> & Serializable)regex -> {
            Object object = Predef$.MODULE$.refArrayOps(Files.list(Paths.get(dir, new String[0])).filter(p -> regex.matches(p.getFileName().toString())).toArray());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<Object, Path> & Serializable)_$2 -> (Path)_$2, ClassTag$.MODULE$.apply(Path.class)));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(object2, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
            return ArrayOps$.MODULE$.toSeq$extension(object3);
        });
    }

    public void moveFile(Path from, Path to, boolean fromFileExists) {
        if (fromFileExists || from.toFile().exists()) {
            if (to.toFile().exists()) {
                Files.delete(to);
            }
            Files.move(from, to, new CopyOption[0]);
            return;
        }
    }

    public boolean moveFile$default$3() {
        return false;
    }

    public Decoder<Map<String, Object>> decoder() {
        return this.decoder;
    }

    public <T> Unmarshaller<HttpEntity, Source<T, NotUsed>> largeFrameJsonStreamUnmarshaller(Decoder<T> evidence$1) {
        return pekkoHttp$.MODULE$.borerStreamUnmarshaller((EntityStreamingSupport)new JsonEntityStreamingSupport(0x800000), (Decoder)evidence$1);
    }

    private void onComplete(Path f, Try<?> result) {
        Try<?> try_ = result;
        if (try_ instanceof Success) {
            this.moveFile(f, f.resolveSibling(new StringBuilder(5).append(f.getFileName()).append(".done").toString()), this.moveFile$default$3());
            return;
        }
        if (try_ instanceof Failure) {
            return;
        }
        throw new MatchError(try_);
    }

    public Renderer renderer() {
        return this.renderer;
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return (Future)this.getFiles(this.directory, ScalaRunTime$.MODULE$.wrapRefArray(new String[]{this.filename_pattern})).headOption().map((Function1<Path, Future> & Serializable)f2 -> {
            this.logger.info(new StringBuilder(11).append("Found file ").append(f2.getFileName()).toString());
            Seq fields = this.qe.viewDef(this.view_name).fields();
            Seq jsonFieldNames = (Seq)fields.map((Function1<FieldDef_, String> & Serializable)_$3 -> _$3.fieldName());
            Seq decodableFields = (Seq)fields.filter((Function1<FieldDef_, boolean> & Serializable)f -> f.isExpression() && f.saveTo() != null);
            UniversalEntity entity = HttpEntity$.MODULE$.fromPath(ContentTypes$.MODULE$.application$divjson(), (Path)f2, HttpEntity$.MODULE$.fromPath$default$3());
            return Unmarshal$.MODULE$.apply(entity).to(this.largeFrameJsonStreamUnmarshaller(this.decoder()), Predef$.MODULE$.implicitly(this.ec), Predef$.MODULE$.implicitly(Materializer$.MODULE$.matFromSystem(this.system))).map((Function1<Source, Source> & Serializable)_$4 -> ((Source)_$4.map((Function1<Map, Record> & Serializable)m -> {
                Map compatible = this.qe.toCompatibleMap((Map)m, (ViewDef_)this.viewDef);
                return this.renderer().buildRecord(compatible, this.renderer().buildRecord$default$2(), this.renderer().buildRecord$default$3(), this.renderer().buildRecord$default$4());
            })).mapMaterializedValue((Function1<NotUsed, Function1> & Serializable)_$5 -> result -> this.onComplete((Path)f2, (Try<?>)result)), this.ec).map((Function1<Source, Some> & Serializable)source -> Some$.MODULE$.apply(Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply(new StringBuilder(5).append("file ").append(f2.getFileName()).toString(), SourceInfo$.MODULE$.$lessinit$greater$default$2()), source)), this.ec);
        }).getOrElse(DataFromJson::source$$anonfun$2);
    }

    private static final Future source$$anonfun$2() {
        return Future$.MODULE$.successful(None$.MODULE$);
    }
}

