/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ConnectorData;
import dagr.DataFromJdbc$;
import dagr.DataFromJdbc$ChildCacheMetadata$;
import dagr.DbAccess;
import dagr.Macros$;
import dagr.Record;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.mojoz.metadata.FieldDef_;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.ViewDef_;
import org.mojoz.querease.Querease;
import org.mojoz.querease.TresqlMetadata;
import org.mojoz.querease.TresqlMetadata$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tresql.DynamicResult;
import org.tresql.DynamicRow;
import org.tresql.Expr;
import org.tresql.LogTopic;
import org.tresql.LogTopic$info$;
import org.tresql.LogTopic$ort$;
import org.tresql.LogTopic$params$;
import org.tresql.LogTopic$sql$;
import org.tresql.LogTopic$sql_with_params$;
import org.tresql.LogTopic$tresql$;
import org.tresql.MacroResources;
import org.tresql.Query$;
import org.tresql.Resources;
import org.tresql.Resources$Resources_$;
import org.tresql.ResourcesTemplate;
import org.tresql.Result;
import org.tresql.RowLike;
import org.tresql.Scala3Macro$package$given_Conversion_ResultSet_Result$;
import org.tresql.ThreadLocalResources;
import org.tresql.dialects.package$;
import org.tresql.dialects.package$ANSISQLDialect$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public class DataFromJdbc
implements ConnectorData {
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final Querease qe;
    private final String view_name;
    private final String dataset_name;
    private final DbAccess dbAccess;
    private final Logger logger;
    private final Logger sqlLogger;
    private final Logger tqlLogger;
    private final Logger othLogger;
    private final Regex SimpleJoinPattern;
    private final Function3<String, Seq<Tuple2<String, Object>>, LogTopic, BoxedUnit> TresqlLogger;
    private final ThreadLocalResources Env;
    private final PartialFunction<Expr, String> dialect;
    private final ViewDef_<FieldDef_<Type>> viewDef;
    private final Seq<FieldDef_<Type>> childFields;
    private final Seq<ChildCacheMetadata> childCacheMetadata;
    private final ViewDef_<FieldDef_<Type>> level1_viewDef;
    private final Map<String, Object> params;
    private final Option<String> sqlQueryOpt;
    private final boolean isSqlQuery;
    private final String main_q;
    private final Map<String, Object> main_p;
    private final Seq<String> keyFieldNames;
    public final DataFromJdbc$ChildCacheMetadata$ ChildCacheMetadata$lzy1;
    private final Renderer renderer;
    private final ExecutionContext ec;

    public DataFromJdbc(Config config, Querease qe, String view_name, String dataset_name, DbAccess dbAccess) {
        this.config = config;
        this.qe = qe;
        this.view_name = view_name;
        this.dataset_name = dataset_name;
        this.dbAccess = dbAccess;
        this.ChildCacheMetadata$lzy1 = new DataFromJdbc$ChildCacheMetadata$(this);
        ConnectorData.$init$(this);
        this.logger = LoggerFactory.getLogger("dagr.jdbc");
        this.sqlLogger = LoggerFactory.getLogger("dagr.jdbc.sql");
        this.tqlLogger = LoggerFactory.getLogger("dagr.jdbc.tql");
        this.othLogger = LoggerFactory.getLogger("dagr.jdbc.oth");
        String jdbcUrl = config.getString("jdbc.data.jdbcUrl");
        this.SimpleJoinPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\[ (\\w+)\\.(\\w+) = (\\w+)\\.(\\w+) \\]$".replace(" ", "\\s*")));
        this.TresqlLogger = (msg, _$1, topic) -> {
            LogTopic logTopic = topic;
            if (LogTopic$info$.MODULE$.equals(logTopic)) {
                this.othLogger().debug((String)msg.apply());
                return;
            }
            if (LogTopic$ort$.MODULE$.equals(logTopic)) {
                return;
            }
            if (LogTopic$params$.MODULE$.equals(logTopic)) {
                this.othLogger().debug((String)msg.apply());
                return;
            }
            if (LogTopic$sql$.MODULE$.equals(logTopic)) {
                this.sqlLogger().debug((String)msg.apply());
                return;
            }
            if (LogTopic$tresql$.MODULE$.equals(logTopic)) {
                this.tqlLogger().debug((String)msg.apply());
                return;
            }
            if (LogTopic$sql_with_params$.MODULE$.equals(logTopic)) {
                return;
            }
            throw new MatchError(logTopic);
        };
        this.Env = new MacroResources(this){
            public static final long OFFSET$1;
            public static final long OFFSET$0;
            private volatile Object Resources_$lzy1;
            private volatile Object resourcesTemplate$lzy1;
            private ThreadLocal org$tresql$ThreadLocalResources$$_threadResources;
            private final /* synthetic */ DataFromJdbc $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                ThreadLocalResources.$init$(this);
                Statics.releaseFence();
            }

            static {
                OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("resourcesTemplate$lzy1"));
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("Resources_$lzy1"));
            }

            public final Resources$Resources_$ Resources_() {
                Object object = this.Resources_$lzy1;
                if (object instanceof Resources$Resources_$) {
                    return (Resources$Resources_$)object;
                }
                if (object == LazyVals$NullValue$.MODULE$) {
                    return null;
                }
                return (Resources$Resources_$)this.Resources_$lzyINIT1();
            }

            private Object Resources_$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.Resources_$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                            Serializable serializable = null;
                            Resources$Resources_$ resources$Resources_$ = null;
                            try {
                                resources$Resources_$ = new Resources$Resources_$(this);
                                serializable = resources$Resources_$ == null ? LazyVals$NullValue$.MODULE$ : resources$Resources_$;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.Resources_$lzy1;
                                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                                    waiting.countDown();
                                }
                            }
                            return resources$Resources_$;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals$Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public final ResourcesTemplate resourcesTemplate() {
                Object object = this.resourcesTemplate$lzy1;
                if (object instanceof ResourcesTemplate) {
                    return (ResourcesTemplate)object;
                }
                if (object == LazyVals$NullValue$.MODULE$) {
                    return null;
                }
                return (ResourcesTemplate)this.resourcesTemplate$lzyINIT1();
            }

            private Object resourcesTemplate$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.resourcesTemplate$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                            Serializable serializable = null;
                            ResourcesTemplate resourcesTemplate = null;
                            try {
                                resourcesTemplate = ThreadLocalResources.resourcesTemplate$(this);
                                serializable = resourcesTemplate == null ? LazyVals$NullValue$.MODULE$ : resourcesTemplate;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.resourcesTemplate$lzy1;
                                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                                    waiting.countDown();
                                }
                            }
                            return resourcesTemplate;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals$Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public ThreadLocal org$tresql$ThreadLocalResources$$_threadResources() {
                return this.org$tresql$ThreadLocalResources$$_threadResources;
            }

            public void org$tresql$ThreadLocalResources$_setter_$org$tresql$ThreadLocalResources$$_threadResources_$eq(ThreadLocal x$0) {
                this.org$tresql$ThreadLocalResources$$_threadResources = x$0;
            }

            public Function3 logger() {
                return this.$outer.TresqlLogger();
            }
        };
        this.dialect = jdbcUrl.contains("postgresql") ? package$.MODULE$.PostgresqlDialect() : (jdbcUrl.contains("oracle") ? package$.MODULE$.OracleDialect() : package$ANSISQLDialect$.MODULE$);
        this.viewDef = qe.viewDef(view_name);
        this.childFields = (Seq)this.viewDef().fields().filter((Function1<FieldDef_, boolean> & Serializable)_$2 -> ((Type)_$2.type_()).isComplexType());
        this.childCacheMetadata = (Seq)((IterableOps)((IterableOps)this.childFields().map((Function1<FieldDef_, Option> & Serializable)childField -> this.buildChildCacheMetadata((FieldDef_<Type>)childField))).filter((Function1<Option, boolean> & Serializable)_$3 -> _$3.isDefined())).map((Function1<Option, ChildCacheMetadata> & Serializable)_$4 -> (ChildCacheMetadata)_$4.get());
        Seq seq = (Seq)this.viewDef().fields().filterNot((Function1<FieldDef_, boolean> & Serializable)field2 -> this.childCacheMetadata().exists((Function1<ChildCacheMetadata, boolean> & Serializable)_$5 -> {
            FieldDef_<Type> fieldDef_ = _$5.childField();
            FieldDef_ fieldDef_2 = field2;
            return !(fieldDef_ != null ? !((Object)fieldDef_).equals(fieldDef_2) : fieldDef_2 != null);
        }));
        String string2 = this.viewDef().copy$default$1();
        String string3 = this.viewDef().copy$default$2();
        String string4 = this.viewDef().copy$default$3();
        String string5 = this.viewDef().copy$default$4();
        String string6 = this.viewDef().copy$default$5();
        String string7 = this.viewDef().copy$default$6();
        Seq<String> seq2 = this.viewDef().copy$default$7();
        Seq<String> seq3 = this.viewDef().copy$default$8();
        Seq<String> seq4 = this.viewDef().copy$default$9();
        Seq<String> seq5 = this.viewDef().copy$default$10();
        Seq<String> seq6 = this.viewDef().copy$default$11();
        String string8 = this.viewDef().copy$default$12();
        String string9 = this.viewDef().copy$default$13();
        Seq<String> seq7 = this.viewDef().copy$default$15();
        Map<String, Object> map = this.viewDef().copy$default$16();
        this.level1_viewDef = this.viewDef().copy(string2, string3, string4, string5, string6, string7, seq2, seq3, seq4, seq5, seq6, string8, string9, seq, seq7, map);
        Tuple2[] tuple2Array = new Tuple2[1];
        String string10 = Predef$.MODULE$.ArrowAssoc("dataset_name");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string10, dataset_name);
        this.params = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        this.sqlQueryOpt = Option$.MODULE$.apply(this.viewDef().extras()).flatMap((Function1<Map, Option> & Serializable)_$6 -> _$6.get("query")).filter((Function1<Object, boolean> & Serializable)_$7 -> _$7 != null).map((Function1<Object, String> & Serializable)_$8 -> _$8.toString()).filter((Function1<String, boolean> & Serializable)_$9 -> {
            String string2 = _$9.trim();
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        });
        this.isSqlQuery = this.sqlQueryOpt().nonEmpty();
        Tuple2 tuple2 = (Tuple2)this.sqlQueryOpt().map((Function1<String, Tuple2> & Serializable)sqlQueryString -> Tuple2$.MODULE$.apply(sqlQueryString, null)).getOrElse(() -> this.$init$$$anonfun$11(qe));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String main_q = (String)tuple2._1();
        Map main_p = (Map)tuple2._2();
        Tuple2<String, Map> tuple22 = Tuple2$.MODULE$.apply(main_q, main_p);
        this.main_q = tuple22._1();
        this.main_p = tuple22._2();
        this.keyFieldNames = (Seq)qe.viewNameToKeyFieldNames().apply(view_name);
        this.renderer = new Renderer(config, qe, view_name);
        this.ec = ExecutionContext$.MODULE$.global();
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public Logger logger() {
        return this.logger;
    }

    public Logger sqlLogger() {
        return this.sqlLogger;
    }

    public Logger tqlLogger() {
        return this.tqlLogger;
    }

    public Logger othLogger() {
        return this.othLogger;
    }

    public Function3<String, Seq<Tuple2<String, Object>>, LogTopic, BoxedUnit> TresqlLogger() {
        return this.TresqlLogger;
    }

    public ThreadLocalResources Env() {
        return this.Env;
    }

    public PartialFunction<Expr, String> dialect() {
        return this.dialect;
    }

    public ViewDef_<FieldDef_<Type>> viewDef() {
        return this.viewDef;
    }

    public Seq<FieldDef_<Type>> childFields() {
        return this.childFields;
    }

    public Seq<ChildCacheMetadata> childCacheMetadata() {
        return this.childCacheMetadata;
    }

    public ViewDef_<FieldDef_<Type>> level1_viewDef() {
        return this.level1_viewDef;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public Option<String> sqlQueryOpt() {
        return this.sqlQueryOpt;
    }

    public boolean isSqlQuery() {
        return this.isSqlQuery;
    }

    public String main_q() {
        return this.main_q;
    }

    public Map<String, Object> main_p() {
        return this.main_p;
    }

    public Seq<String> keyFieldNames() {
        return this.keyFieldNames;
    }

    public Resources getEnv(Connection conn) {
        ThreadLocalResources env = this.Env();
        conn.setAutoCommit(false);
        env.dialect_$eq(this.dialect());
        env.metadata_$eq(new TresqlMetadata(this.qe.tableMetadata().tableDefs(), TresqlMetadata$.MODULE$.$lessinit$greater$default$2(), TresqlMetadata$.MODULE$.$lessinit$greater$default$3(), TresqlMetadata$.MODULE$.$lessinit$greater$default$4(), TresqlMetadata$.MODULE$.$lessinit$greater$default$5(), TresqlMetadata$.MODULE$.$lessinit$greater$default$6(), TresqlMetadata$.MODULE$.$lessinit$greater$default$7()));
        return env.withConn(conn).withMacros(Macros$.MODULE$);
    }

    public final DataFromJdbc$ChildCacheMetadata$ ChildCacheMetadata() {
        return this.ChildCacheMetadata$lzy1;
    }

    public Option<ChildCacheMetadata> buildChildCacheMetadata(FieldDef_<Type> childField) {
        Tuple5<Object, Object, Object, Object, Boolean> tuple5;
        List<String> list;
        Option<List<String>> option;
        String string2 = childField.joinToParent();
        if (string2 != null && !(option = this.SimpleJoinPattern.unapplySeq(string2)).isEmpty() && (list = option.get()).lengthCompare(4) == 0) {
            String string3 = list.apply(0);
            String string4 = list.apply(1);
            String string5 = list.apply(2);
            String string6 = list.apply(3);
            String ta1 = string3;
            String c1 = string4;
            String ta2 = string5;
            String c2 = string6;
            tuple5 = Tuple5$.MODULE$.apply(ta1, c1, ta2, c2, BoxesRunTime.boxToBoolean(true));
        } else {
            String x = string2;
            this.logger().debug(new StringBuilder(84).append("Not caching child data for field '").append(childField.name()).append("' - unsupported join to parent expression format: ").append(childField.joinToParent()).toString());
            tuple5 = Tuple5$.MODULE$.apply(null, null, null, null, BoxesRunTime.boxToBoolean(false));
        }
        Tuple5<Object, Object, Object, Object, Boolean> tuple52 = tuple5;
        String parentTableAlias = tuple52._1();
        String parentCol = tuple52._2();
        String tableAlias = tuple52._3();
        String col = tuple52._4();
        boolean isJoinTypeSupported = BoxesRunTime.unboxToBoolean(tuple52._5());
        if (isJoinTypeSupported) {
            ViewDef_ childView = (ViewDef_)this.qe.nameToViewDef().apply(childField.type_().name());
            boolean hasChildJoinProp = childView.fields().exists((Function1<FieldDef_, boolean> & Serializable)_$10 -> {
                String string2 = _$10.name();
                String string3 = col;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            });
            Option<ViewDef_> extendedChildViewOpt = hasChildJoinProp ? Option$.MODULE$.apply(childView) : this.viewDef().fields().find((Function1<FieldDef_, boolean> & Serializable)_$11 -> {
                String string2 = _$11.name();
                String string3 = parentCol;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }).map((Function1<FieldDef_, Type> & Serializable)_$12 -> (Type)_$12.type_()).map((Function1<Type, ViewDef_> & Serializable)colType -> {
                FieldDef_<Type> fieldDef_ = new FieldDef_<Type>(col, (Type)colType);
                Seq seq = (Seq)childView.fields().$colon$plus(fieldDef_.copy(fieldDef_.copy$default$1(), tableAlias, fieldDef_.copy$default$3(), fieldDef_.copy$default$4(), fieldDef_.copy$default$5(), fieldDef_.copy$default$6(), fieldDef_.copy$default$7(), fieldDef_.copy$default$8(), fieldDef_.copy$default$9(), fieldDef_.copy$default$10(), fieldDef_.copy$default$11(), fieldDef_.copy$default$12(), fieldDef_.copy$default$13(), fieldDef_.copy$default$14(), fieldDef_.copy$default$15(), fieldDef_.copy$default$16(), fieldDef_.copy$default$17(), fieldDef_.copy$default$18()));
                String string2 = childView.copy$default$1();
                String string3 = childView.copy$default$2();
                String string4 = childView.copy$default$3();
                String string5 = childView.copy$default$4();
                String string6 = childView.copy$default$5();
                String string7 = childView.copy$default$6();
                Seq<String> seq2 = childView.copy$default$7();
                Seq<String> seq3 = childView.copy$default$8();
                Seq<String> seq4 = childView.copy$default$9();
                Seq<String> seq5 = childView.copy$default$10();
                Seq<String> seq6 = childView.copy$default$11();
                String string8 = childView.copy$default$12();
                String string9 = childView.copy$default$13();
                Seq<String> seq7 = childView.copy$default$15();
                Map<String, Object> map = childView.copy$default$16();
                return childView.copy(string2, string3, string4, string5, string6, string7, seq2, seq3, seq4, seq5, seq6, string8, string9, seq, seq7, map);
            }).orElse(() -> this.$anonfun$6(childField, parentCol));
            return extendedChildViewOpt.map((Function1<ViewDef_, ChildCacheMetadata> & Serializable)extendedChildView -> {
                Tuple2 tuple2 = this.qe.queryStringAndParams((ViewDef_)extendedChildView, (Map)this.params(), this.qe.queryStringAndParams$default$3(), this.qe.queryStringAndParams$default$4(), this.qe.queryStringAndParams$default$5(), this.qe.queryStringAndParams$default$6(), this.qe.queryStringAndParams$default$7(), this.qe.queryStringAndParams$default$8(), this.qe.queryStringAndParams$default$9(), this.qe.queryStringAndParams$default$10());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String q = (String)tuple2._1();
                Map p = (Map)tuple2._2();
                Tuple2<String, Map> tuple22 = Tuple2$.MODULE$.apply(q, p);
                String q2 = tuple22._1();
                Map p2 = tuple22._2();
                return this.ChildCacheMetadata().apply(childField, parentTableAlias, parentCol, tableAlias, col, hasChildJoinProp, (ViewDef_<FieldDef_<Type>>)extendedChildView, q2, p2);
            });
        }
        return None$.MODULE$;
    }

    public Tuple2<ChildCacheMetadata, Map<Object, Seq<Map<String, Object>>>> loadChildCache(ChildCacheMetadata childCacheMetadata, Resources resources) {
        this.logger().debug(new StringBuilder(31).append("Caching data for child field '").append(childCacheMetadata.childField().fieldName()).append("'").toString());
        ChildCacheMetadata childCacheMetadata2 = Predef$.MODULE$.ArrowAssoc(childCacheMetadata);
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(childCacheMetadata2, Query$.MODULE$.apply(childCacheMetadata.child_q(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{childCacheMetadata.child_p()}), resources).map((Function1<DynamicRow, Map> & Serializable)row -> this.qe.toCompatibleMap((RowLike)row, (ViewDef_)childCacheMetadata.extendedChildView())).toSeq().groupMap((Function1<Map, Object> & Serializable)_$13 -> _$13.apply(childCacheMetadata.col()), (Function1<Map, Map> & Serializable)m -> {
            if (childCacheMetadata.hasChildJoinProp()) {
                return m;
            }
            return (Map)m.$minus(childCacheMetadata.col());
        }));
    }

    public Renderer renderer() {
        return this.renderer;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return Future$.MODULE$.apply(this::source$$anonfun$1, this.ec());
    }

    private final Tuple2 $init$$$anonfun$11(Querease qe$1) {
        return qe$1.queryStringAndParams((ViewDef_)this.level1_viewDef(), (Map)this.params(), qe$1.queryStringAndParams$default$3(), qe$1.queryStringAndParams$default$4(), qe$1.queryStringAndParams$default$5(), qe$1.queryStringAndParams$default$6(), qe$1.queryStringAndParams$default$7(), qe$1.queryStringAndParams$default$8(), qe$1.queryStringAndParams$default$9(), qe$1.queryStringAndParams$default$10());
    }

    private final Option $anonfun$6(FieldDef_ childField$1, String parentCol$2) {
        this.logger().debug(new StringBuilder(61).append("Not caching child data for field '").append(childField$1.name()).append("' - Parent field ").append(parentCol$2).append(" not found").toString());
        return None$.MODULE$;
    }

    private static final Seq $anonfun$8() {
        return scala.package$.MODULE$.Nil();
    }

    private final Iterator keyValueIterator$1(Connection conn) {
        DynamicResult rowsResult;
        Result<DynamicRow> result;
        Resources env = this.getEnv(conn);
        Seq childCaches = (Seq)this.childCacheMetadata().map((Function1<ChildCacheMetadata, Tuple2> & Serializable)childCacheMetadata -> this.loadChildCache((ChildCacheMetadata)childCacheMetadata, env));
        this.logger().debug(new StringBuilder(25).append("Executing main query for ").append(this.dataset_name).toString());
        if (this.isSqlQuery()) {
            this.sqlLogger().debug(this.main_q());
            PreparedStatement st = conn.prepareStatement(this.main_q(), 1003, 1007);
            if (env.queryTimeout() > 0) {
                st.setQueryTimeout(env.queryTimeout());
            }
            if (env.fetchSize() > 0) {
                st.setFetchSize(env.fetchSize());
            }
            result = Scala3Macro$package$given_Conversion_ResultSet_Result$.MODULE$.apply(st.executeQuery());
        } else {
            result = rowsResult = Query$.MODULE$.apply(this.main_q(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.main_p()}), env);
        }
        if (childCaches.isEmpty()) {
            return rowsResult.map((Function1<RowLike, Map> & Serializable)row -> this.qe.toCompatibleMap((RowLike)row, (ViewDef_)this.viewDef())).iterator();
        }
        return rowsResult.map((Function1<RowLike, Map> & Serializable)row -> {
            Map parent = this.qe.toCompatibleMap((RowLike)row, (ViewDef_)this.viewDef());
            return (Map)parent.$plus$plus((IterableOnce)childCaches.map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
                PartialFunction partialFunction;
                ChildCacheMetadata childCacheMetadata = (ChildCacheMetadata)x$1._1();
                Map map = (Map)x$1._2();
                Object key2 = parent.apply(childCacheMetadata.parentCol());
                Seq children = (Seq)map.getOrElse(key2, DataFromJdbc::$anonfun$8);
                if (childCacheMetadata.childField().isCollection()) {
                    partialFunction = children;
                } else if (children.isEmpty()) {
                    partialFunction = null;
                } else {
                    int n = children.lengthCompare(1);
                    if (0 == n) {
                        partialFunction = (Map)children.apply(false);
                    } else {
                        throw scala.sys.package$.MODULE$.error(new StringBuilder(34).append("Too many children for view ").append(this.view_name).append(" field ").append(childCacheMetadata.childField().fieldName()).toString());
                    }
                }
                Seq value = partialFunction;
                return Tuple2$.MODULE$.apply(childCacheMetadata.childField().fieldName(), value);
            }));
        }).iterator();
    }

    private final Record source$$anonfun$1$$anonfun$2$$anonfun$1(Map m$1) {
        return this.renderer().buildRecord(m$1, this.renderer().buildRecord$default$2(), this.renderer().buildRecord$default$3(), this.renderer().buildRecord$default$4());
    }

    private final Some source$$anonfun$1() {
        this.logger().info(new StringBuilder(29).append("Preparing data from jdbc for ").append(this.dataset_name).toString());
        Connection conn = this.dbAccess.getConnection();
        return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply(null, SourceInfo$.MODULE$.$lessinit$greater$default$2()), ((Source)((Source)Source$.MODULE$.fromIterator((Function0<Iterator> & Serializable)() -> this.keyValueIterator$1(conn)).mapAsync(3, (Function1<Map, Future> & Serializable)m -> Future$.MODULE$.apply(() -> this.source$$anonfun$1$$anonfun$2$$anonfun$1(m), this.ec()))).mapMaterializedValue((Function1<NotUsed, Function1> & Serializable)_$14 -> _$15 -> {})).watchTermination((Function2<Function1, Future, Function1> & Serializable)(prevMatValue, futureDone) -> {
            futureDone.onComplete(x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    conn.close();
                    return;
                }
                if (try_ instanceof Failure) {
                    conn.close();
                    return;
                }
                throw new MatchError(try_);
            }, this.ec());
            return prevMatValue;
        })));
    }

    public class ChildCacheMetadata
    implements Product,
    Serializable {
        private final FieldDef_<Type> childField;
        private final String parentTableAlias;
        private final String parentCol;
        private final String tableAlias;
        private final String col;
        private final boolean hasChildJoinProp;
        private final ViewDef_<FieldDef_<Type>> extendedChildView;
        private final String child_q;
        private final Map<String, Object> child_p;
        private final /* synthetic */ DataFromJdbc $outer;

        public ChildCacheMetadata(DataFromJdbc $outer, FieldDef_<Type> childField, String parentTableAlias, String parentCol, String tableAlias, String col, boolean hasChildJoinProp, ViewDef_<FieldDef_<Type>> extendedChildView, String child_q, Map<String, Object> child_p) {
            this.childField = childField;
            this.parentTableAlias = parentTableAlias;
            this.parentCol = parentCol;
            this.tableAlias = tableAlias;
            this.col = col;
            this.hasChildJoinProp = hasChildJoinProp;
            this.extendedChildView = extendedChildView;
            this.child_q = child_q;
            this.child_p = child_p;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.childField()));
            n = Statics.mix(n, Statics.anyHash(this.parentTableAlias()));
            n = Statics.mix(n, Statics.anyHash(this.parentCol()));
            n = Statics.mix(n, Statics.anyHash(this.tableAlias()));
            n = Statics.mix(n, Statics.anyHash(this.col()));
            n = Statics.mix(n, this.hasChildJoinProp() ? 1231 : 1237);
            n = Statics.mix(n, Statics.anyHash(this.extendedChildView()));
            n = Statics.mix(n, Statics.anyHash(this.child_q()));
            n = Statics.mix(n, Statics.anyHash(this.child_p()));
            return Statics.finalizeHash(n, 9);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChildCacheMetadata)) return false;
            if (((ChildCacheMetadata)object).dagr$DataFromJdbc$ChildCacheMetadata$$$outer() != this.$outer) return false;
            ChildCacheMetadata childCacheMetadata = (ChildCacheMetadata)object;
            if (this.hasChildJoinProp() != childCacheMetadata.hasChildJoinProp()) return false;
            FieldDef_<Type> fieldDef_ = this.childField();
            FieldDef_<Type> fieldDef_2 = childCacheMetadata.childField();
            if (fieldDef_ == null) {
                if (fieldDef_2 != null) {
                    return false;
                }
            } else if (!((Object)fieldDef_).equals(fieldDef_2)) return false;
            String string2 = this.parentTableAlias();
            String string3 = childCacheMetadata.parentTableAlias();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            String string4 = this.parentCol();
            String string5 = childCacheMetadata.parentCol();
            if (string4 == null) {
                if (string5 != null) {
                    return false;
                }
            } else if (!string4.equals(string5)) return false;
            String string6 = this.tableAlias();
            String string7 = childCacheMetadata.tableAlias();
            if (string6 == null) {
                if (string7 != null) {
                    return false;
                }
            } else if (!string6.equals(string7)) return false;
            String string8 = this.col();
            String string9 = childCacheMetadata.col();
            if (string8 == null) {
                if (string9 != null) {
                    return false;
                }
            } else if (!string8.equals(string9)) return false;
            ViewDef_<FieldDef_<Type>> viewDef_ = this.extendedChildView();
            ViewDef_<FieldDef_<Type>> viewDef_2 = childCacheMetadata.extendedChildView();
            if (viewDef_ == null) {
                if (viewDef_2 != null) {
                    return false;
                }
            } else if (!((Object)viewDef_).equals(viewDef_2)) return false;
            String string10 = this.child_q();
            String string11 = childCacheMetadata.child_q();
            if (string10 == null) {
                if (string11 != null) {
                    return false;
                }
            } else if (!string10.equals(string11)) return false;
            Map<String, Object> map = this.child_p();
            Map<String, Object> map2 = childCacheMetadata.child_p();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!childCacheMetadata.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ChildCacheMetadata;
        }

        @Override
        public int productArity() {
            return 9;
        }

        @Override
        public String productPrefix() {
            return "ChildCacheMetadata";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean(this._6());
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "childField";
                }
                case 1: {
                    return "parentTableAlias";
                }
                case 2: {
                    return "parentCol";
                }
                case 3: {
                    return "tableAlias";
                }
                case 4: {
                    return "col";
                }
                case 5: {
                    return "hasChildJoinProp";
                }
                case 6: {
                    return "extendedChildView";
                }
                case 7: {
                    return "child_q";
                }
                case 8: {
                    return "child_p";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public FieldDef_<Type> childField() {
            return this.childField;
        }

        public String parentTableAlias() {
            return this.parentTableAlias;
        }

        public String parentCol() {
            return this.parentCol;
        }

        public String tableAlias() {
            return this.tableAlias;
        }

        public String col() {
            return this.col;
        }

        public boolean hasChildJoinProp() {
            return this.hasChildJoinProp;
        }

        public ViewDef_<FieldDef_<Type>> extendedChildView() {
            return this.extendedChildView;
        }

        public String child_q() {
            return this.child_q;
        }

        public Map<String, Object> child_p() {
            return this.child_p;
        }

        public ChildCacheMetadata copy(FieldDef_<Type> childField, String parentTableAlias, String parentCol, String tableAlias, String col, boolean hasChildJoinProp, ViewDef_<FieldDef_<Type>> extendedChildView, String child_q, Map<String, Object> child_p) {
            return new ChildCacheMetadata(this.$outer, childField, parentTableAlias, parentCol, tableAlias, col, hasChildJoinProp, extendedChildView, child_q, child_p);
        }

        public FieldDef_<Type> copy$default$1() {
            return this.childField();
        }

        public String copy$default$2() {
            return this.parentTableAlias();
        }

        public String copy$default$3() {
            return this.parentCol();
        }

        public String copy$default$4() {
            return this.tableAlias();
        }

        public String copy$default$5() {
            return this.col();
        }

        public boolean copy$default$6() {
            return this.hasChildJoinProp();
        }

        public ViewDef_<FieldDef_<Type>> copy$default$7() {
            return this.extendedChildView();
        }

        public String copy$default$8() {
            return this.child_q();
        }

        public Map<String, Object> copy$default$9() {
            return this.child_p();
        }

        public FieldDef_<Type> _1() {
            return this.childField();
        }

        public String _2() {
            return this.parentTableAlias();
        }

        public String _3() {
            return this.parentCol();
        }

        public String _4() {
            return this.tableAlias();
        }

        public String _5() {
            return this.col();
        }

        public boolean _6() {
            return this.hasChildJoinProp();
        }

        public ViewDef_<FieldDef_<Type>> _7() {
            return this.extendedChildView();
        }

        public String _8() {
            return this.child_q();
        }

        public Map<String, Object> _9() {
            return this.child_p();
        }

        public final /* synthetic */ DataFromJdbc dagr$DataFromJdbc$ChildCacheMetadata$$$outer() {
            return this.$outer;
        }
    }
}

