/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.CodesFromFile$;
import dagr.Connector$;
import dagr.ConnectorData;
import dagr.DataFromFprAnalyzer$;
import dagr.NextRownumPersistence;
import dagr.PMLP;
import dagr.PMLP$;
import dagr.Record;
import dagr.RemoteDataStatus;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import dagr.SyncType;
import dagr.SyncTypeCheckHasValue$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.connectors.csv.scaladsl.CsvParsing$;
import org.apache.pekko.stream.connectors.csv.scaladsl.CsvToMap$;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapView;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public class DataFromFpr
implements ConnectorData {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DataFromFpr.class.getDeclaredField("remoteDataStatus$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DataFromFpr.class.getDeclaredField("positionPersister$lzy1"));
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final ExecutionContext ec;
    private final String workingDir;
    private final ZoneId zoneId;
    private final Logger logger;
    private final boolean isMonitoringEnabled;
    private final AtomicReference<Object> yieldedToMonitoring;
    private volatile Object positionPersister$lzy1;
    private final Renderer valueRenderer;
    private final Regex PersonCodeRegex;
    private volatile Object remoteDataStatus$lzy1;

    public DataFromFpr(Config config) {
        this.config = config;
        ConnectorData.$init$(this);
        this.ec = ExecutionContext$.MODULE$.global();
        this.workingDir = config.getString("input-files");
        this.zoneId = ZoneId.of(config.getString("data.timezone"));
        this.logger = LoggerFactory.getLogger("dagr.fpr");
        PMLP$.MODULE$.reportFprWarning("Notiek FPR konektora inicializ\u0101cija. Konektors ir visu aizmirsis.", PMLP$.MODULE$.reportFprWarning$default$2(), PMLP$.MODULE$.reportFprWarning$default$3());
        boolean bl = this.isMonitoringEnabled = PMLP$.MODULE$.client_code() != null;
        if (!this.isMonitoringEnabled) {
            PMLP$.MODULE$.reportFprWarning("Izmai\u0146u iel\u0101de ir atsl\u0113gta, jo nav nor\u0101d\u012bts klienta kods!", PMLP$.MODULE$.reportFprWarning$default$2(), PMLP$.MODULE$.reportFprWarning$default$3());
        }
        this.yieldedToMonitoring = new AtomicReference<Boolean>(BoxesRunTime.boxToBoolean(false));
        this.valueRenderer = new Renderer(config);
        this.PersonCodeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\d{11}$"));
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public String workingDir() {
        return this.workingDir;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    private Path personDataFile() {
        return FileSystems.getDefault().getPath(this.workingDir(), "persons-to-refresh.txt");
    }

    private Path nextRowFile() {
        return this.personDataFile().resolveSibling(new StringBuilder(9).append(this.personDataFile().getFileName().toString()).append(".next-row").toString());
    }

    private NextRownumPersistence positionPersister() {
        Object object = this.positionPersister$lzy1;
        if (object instanceof NextRownumPersistence) {
            return (NextRownumPersistence)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (NextRownumPersistence)this.positionPersister$lzyINIT1();
    }

    private Object positionPersister$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.positionPersister$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    NextRownumPersistence nextRownumPersistence = null;
                    try {
                        nextRownumPersistence = new NextRownumPersistence(this.nextRowFile().toFile(), this.logger);
                        object2 = nextRownumPersistence == null ? LazyVals$NullValue$.MODULE$ : nextRownumPersistence;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.positionPersister$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return nextRownumPersistence;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void moveFile(Path from, Path to, boolean fromFileExists) {
        if (fromFileExists || from.toFile().exists()) {
            if (to.toFile().exists()) {
                Files.delete(to);
            }
            Files.move(from, to, new CopyOption[0]);
            return;
        }
    }

    public boolean moveFile$default$3() {
        return false;
    }

    public Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>> personStatusSourceFromFile(String statusName) {
        Path f = FileSystems.getDefault().getPath(this.workingDir(), new StringBuilder(4).append(statusName).append(".csv").toString());
        return Option$.MODULE$.apply(f).filter((Function1<Path, Object>)(Function1<Path, boolean> & Serializable)_$1 -> _$1.toFile().exists()).map((Function1<Path, Tuple2> & Serializable)_$2 -> {
            this.logger.info(new StringBuilder(11).append("Found file ").append(f.getFileName()).toString());
            Seq fieldNames = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)"PersonCode"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"StatusValueCode"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"StatusValueTitle"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"StatusValidFrom"), Nil$.MODULE$)))));
            String encoding = "Cp1257";
            DateTimeFormatter date_format = DateTimeFormatter.ISO_LOCAL_DATE;
            byte by = CsvParsing$.MODULE$.Comma();
            byte by2 = CsvParsing$.MODULE$.lineScanner$default$2();
            byte by3 = CsvParsing$.MODULE$.lineScanner$default$3();
            return Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply(new StringBuilder(5).append("file ").append(f.getFileName()).toString(), SourceInfo$.MODULE$.$lessinit$greater$default$2()), ((Source)((Source)((Source)FileIO$.MODULE$.fromPath(f, FileIO$.MODULE$.fromPath$default$2()).via(CsvParsing$.MODULE$.lineScanner(by, by2, by3, 128))).via(CsvToMap$.MODULE$.withHeaders(fieldNames))).map((Function1<Map, MapView> & Serializable)_$3 -> _$3.view().mapValues((Function1<ByteString, String> & Serializable)_$4 -> _$4.decodeString(encoding))).zipWithIndex().filter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    long idx = BoxesRunTime.unboxToLong(tuple2._2());
                    return idx > 0L;
                }
                throw new MatchError(tuple2);
            }).mapAsync(3, (Function1<Tuple2, Future> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    MapView m = (MapView)tuple2._1();
                    long idx = BoxesRunTime.unboxToLong(tuple2._2());
                    return Future$.MODULE$.apply(() -> this.personStatusSourceFromFile$$anonfun$2$$anonfun$3$$anonfun$1(m, date_format, statusName), this.ec());
                }
                throw new MatchError(tuple2);
            })).mapMaterializedValue((Function1<Future, Function1> & Serializable)_$5 -> _$6 -> {
                Try try_ = _$6;
                if (try_ instanceof Success) {
                    this.moveFile(f, f.resolveSibling(new StringBuilder(5).append(f.getFileName()).append(".done").toString()), this.moveFile$default$3());
                    return;
                }
                if (try_ instanceof Failure) {
                    return;
                }
                throw new MatchError(try_);
            }));
        });
    }

    public Option<Tuple2<SourceInfo, Source<Tuple3<Object, String, Object>, Function1<Try<?>, BoxedUnit>>>> personEventsSourceFromFile() {
        long maxRowsFromPersonFile = 5000L;
        return CodesFromFile$.MODULE$.source(this.logger, this.personDataFile(), this.nextRowFile(), this.positionPersister(), maxRowsFromPersonFile, this.yieldedToMonitoring).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SourceInfo sourceInfo = (SourceInfo)tuple2._1();
                Source source = (Source)tuple2._2();
                return Tuple2$.MODULE$.apply(sourceInfo, source.map((Function1<Record, Record> & Serializable)record -> record.copy(record.key().replace("-", "").replace("\"", ""), record.copy$default$2(), record.copy$default$3(), record.copy$default$4(), record.copy$default$5())).filter((Function1<Record, boolean> & Serializable)record -> this.PersonCodeRegex.matches(record.key())).map((Function1<Record, Tuple3> & Serializable)record -> Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(PMLP$.MODULE$.PersonCodeEventRequestCode()), record.key(), BoxesRunTime.boxToLong(record.position()))));
            }
            throw new MatchError(tuple2);
        });
    }

    public Future<Source<Tuple3<Object, String, Object>, Function1<Try<?>, BoxedUnit>>> personEventsSourceFromMonitoringFlags() {
        Path fSince = FileSystems.getDefault().getPath(this.workingDir(), "reload-changed-since.txt");
        None$ fromFileSince = fSince.toFile().exists() ? Option$.MODULE$.apply(Files.readString(fSince, StandardCharsets.UTF_8).trim()) : None$.MODULE$;
        None$ fromRequestHistorySince = PMLP$.MODULE$.monitoringOrUnknownRequestFailed() ? Option$.MODULE$.apply(PMLP$.MODULE$.lastSuccessfulMonitoringStartTime()).map((Function1<Instant, String> & Serializable)_$7 -> _$7.minus(3L, ChronoUnit.HOURS).minus(5L, ChronoUnit.MINUTES).truncatedTo(ChronoUnit.HOURS).atZone(this.zoneId()).toOffsetDateTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)) : None$.MODULE$;
        Option<String> since2 = fromRequestHistorySince.orElse(() -> DataFromFpr.$anonfun$2(fromFileSince));
        if (PMLP$.MODULE$.monitoringOrUnknownRequestFailed() && since2.isEmpty()) {
            throw package$.MODULE$.error("Ir paman\u012bts, ka monitoringa (vai nezin\u0101ms) piepras\u012bjums FPRIS pus\u0113 ir pabeidzies ar k\u013c\u016bdu, bet p\u0113d\u0113jo sekm\u012bgi iekrauto izmai\u0146u laiks nav zin\u0101ms. Lai, FPRIS k\u013c\u016bdu d\u0113\u013c, DAGR nepazaud\u0113tu izmai\u0146as, autom\u0101tiski turpin\u0101t izmai\u0146u iel\u0101di nav iesp\u0113jams. L\u016bdzu, konfigur\u0113jiet savienot\u0101ja datni 'reload-changed-since.txt', atbild\u012bgi nor\u0101dot taj\u0101 t\u0101du iel\u0101d\u0113jamo izmai\u0146u s\u0101kuma laiku, l\u012bdz kuram visas(!) veikt\u0101s izmai\u0146as no FPRIS ir sekm\u012bgi iekrautas DAGR.");
        }
        since2.foreach((Function1<String, Future> & Serializable)since -> {
            String sourceDescription = ((IterableOnceOps)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Option$.MODULE$.option2Iterable(fromFileSince.filter((Function1<String, boolean> & Serializable)_$8 -> {
                String string2 = _$8;
                String string3 = since;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }).map((Function1<String, String> & Serializable)_$9 -> "from config file")).toSeq()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Option$.MODULE$.option2Iterable(fromRequestHistorySince.filter((Function1<String, boolean> & Serializable)_$10 -> {
                String string2 = _$10;
                String string3 = since;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }).map((Function1<String, String> & Serializable)_$11 -> "from request history")).toSeq()), Nil$.MODULE$))).flatMap((Function1<Seq, IterableOnce> & Serializable)x -> Predef$.MODULE$.identity(x))).mkString(", ");
            return PMLP$.MODULE$.reportFprWarning(new StringBuilder(43).append("About to load fpr changes since ").append((String)since).append(" (derived ").append(sourceDescription).append(")").toString(), PMLP$.MODULE$.reportFprWarning$default$2(), PMLP$.MODULE$.reportFprWarning$default$3());
        });
        return PMLP$.MODULE$.doAsyncRequest(PMLP$.MODULE$.monitoringFlagsRequest(since2)).transformWith((Function1<Try, Future> & Serializable)x$12 -> {
            Tuple2 tuple2;
            Try try_ = x$12;
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                Throwable throwable = ex;
                if (throwable instanceof PMLP.UnconfirmedMonitoringResponseException) {
                    PMLP$.MODULE$.reportFprWarning("Previous monitoring response not consumed, trying to consume it first", ex, PMLP$.MODULE$.reportFprWarning$default$3());
                    return PMLP$.MODULE$.doAsyncRequest(PMLP$.MODULE$.monitoringFlagsRequest(None$.MODULE$)).map((Function1<Tuple2, Tuple3> & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String monitoringMessage = (String)tuple2._1();
                            Function1 confirm = (Function1)tuple2._2();
                            return Tuple3$.MODULE$.apply(monitoringMessage, confirm, None$.MODULE$);
                        }
                        throw new MatchError(tuple2);
                    }, this.ec());
                }
                return Future$.MODULE$.failed(ex);
            }
            if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                String monitoringMessage = (String)tuple2._1();
                Function1 confirm = (Function1)tuple2._2();
                return Future$.MODULE$.successful(Tuple3$.MODULE$.apply(monitoringMessage, confirm, since2));
            }
            throw new MatchError(try_);
        }, this.ec()).map((Function1<Tuple3, Source> & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String monitoringMessage = (String)tuple3._1();
                Function1 confirm = (Function1)tuple3._2();
                Option since = (Option)tuple3._3();
                return PMLP$.MODULE$.personEventsSourceFromMonitoringMessage(monitoringMessage).mapMaterializedValue((Function1<NotUsed, Function1> & Serializable)_$12 -> _$13 -> {
                    Try try_ = _$13;
                    if (try_ instanceof Success) {
                        Success succ = (Success)try_;
                        this.yieldedToMonitoring.set(BoxesRunTime.boxToBoolean(false));
                        since.filter((Function1<String, boolean> & Serializable)elem -> fromFileSince.contains(elem)).foreach(_$14 -> this.moveFile(fSince, fSince.resolveSibling(new StringBuilder(5).append(fSince.getFileName().toString()).append(".done").toString()), this.moveFile$default$3()));
                        confirm.apply(succ);
                        return;
                    }
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        Failure fail = failure;
                        this.logger.error(new StringBuilder(33).append("Failed to process fpr input file ").append(fSince).toString(), e);
                        confirm.apply(fail);
                        return;
                    }
                    throw new MatchError(try_);
                });
            }
            throw new MatchError(tuple3);
        }, this.ec());
    }

    private RemoteDataStatus remoteDataStatus() {
        Object object = this.remoteDataStatus$lzy1;
        if (object instanceof RemoteDataStatus) {
            return (RemoteDataStatus)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (RemoteDataStatus)this.remoteDataStatus$lzyINIT1();
    }

    private Object remoteDataStatus$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.remoteDataStatus$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RemoteDataStatus remoteDataStatus = null;
                    try {
                        remoteDataStatus = (RemoteDataStatus)Connector$.MODULE$.mainConnector().datasetNameToRemoteDataStatus().apply("fpr_person");
                        object2 = remoteDataStatus == null ? LazyVals$NullValue$.MODULE$ : remoteDataStatus;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.remoteDataStatus$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return remoteDataStatus;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>> sourceFromCsv() {
        return this.personStatusSourceFromFile("PersonsPoliticallyRepressedStatus").orElse(this::sourceFromCsv$$anonfun$1);
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return (Future)this.sourceFromCsv().map((Function1<Tuple2, Future> & Serializable)s2 -> Future$.MODULE$.apply(() -> DataFromFpr.source$$anonfun$1$$anonfun$1(s2), this.ec())).getOrElse(this::source$$anonfun$2);
    }

    @Override
    public SyncType syncType() {
        return SyncTypeCheckHasValue$.MODULE$;
    }

    @Override
    public void onBatchSuccess(Record lastRecord) {
        if (lastRecord.position() > 0L) {
            this.positionPersister().saveNextReadPos(lastRecord.position());
            return;
        }
    }

    private final Record personStatusSourceFromFile$$anonfun$2$$anonfun$3$$anonfun$1(MapView m$1, DateTimeFormatter date_format$1, String statusName$2) {
        String code = (String)m$1.apply("PersonCode");
        LocalDateTime statusValidFromDateTime = LocalDate.parse((CharSequence)m$1.apply("StatusValidFrom"), date_format$1).atStartOfDay();
        Tuple2[] tuple2Array = new Tuple2[2];
        String string2 = Predef$.MODULE$.ArrowAssoc("PersonCode");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, code);
        String string3 = Predef$.MODULE$.ArrowAssoc(statusName$2);
        String string4 = Predef$.MODULE$.ArrowAssoc("StatusValidFrom");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, m$1.toMap($less$colon$less$.MODULE$.refl()).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, statusValidFromDateTime)));
        return new Record(new StringBuilder(1).append(code).append("/").append(statusName$2).toString(), this.valueRenderer.renderValue(ListMap$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))));
    }

    private static final Option $anonfun$2(Option fromFileSince$1) {
        return fromFileSince$1;
    }

    private final Option sourceFromCsv$$anonfun$1() {
        return this.personStatusSourceFromFile("PersonsResistanceMemberStatus");
    }

    private static final Some source$$anonfun$1$$anonfun$1(Tuple2 s$1) {
        return Some$.MODULE$.apply(s$1);
    }

    private final Tuple2 analyze$1(Set pks, String personInfoMessage, long minRownum) {
        Tuple2<Seq<Record>, Seq<Tuple2<Object, String>>> tuple2 = DataFromFprAnalyzer$.MODULE$.analyzePersonInfoMessage(pks, personInfoMessage, this.remoteDataStatus());
        if (tuple2 != null) {
            Seq<Record> records = tuple2._1();
            Seq<Tuple2<Object, String>> explorable = tuple2._2();
            return Tuple2$.MODULE$.apply(records.map((Function1<Record, Record> & Serializable)_$15 -> _$15.copy(_$15.copy$default$1(), _$15.copy$default$2(), _$15.copy$default$3(), minRownum, _$15.copy$default$5())), explorable);
        }
        throw new MatchError(tuple2);
    }

    private final /* synthetic */ Tuple2 source$$anonfun$2$$anonfun$1(Set pks, String personInfoMessage, long minRownum) {
        return this.analyze$1(pks, personInfoMessage, minRownum);
    }

    private final Tuple2 analyze$2(Set pks, String personInfoMessage, long minRownum) {
        return DataFromFprAnalyzer$.MODULE$.analyzePersonInfoMessage(pks, personInfoMessage, this.remoteDataStatus());
    }

    private final /* synthetic */ Tuple2 source$$anonfun$2$$anonfun$2$$anonfun$1(Set pks, String personInfoMessage, long minRownum) {
        return this.analyze$2(pks, personInfoMessage, minRownum);
    }

    private final Future source$$anonfun$2() {
        Tuple2 tuple2;
        None$ maybePersonEventsSourceFromFile = this.isMonitoringEnabled && BoxesRunTime.unboxToBoolean(this.yieldedToMonitoring.get()) ? None$.MODULE$ : this.personEventsSourceFromFile();
        None$ none$ = maybePersonEventsSourceFromFile;
        if (none$ instanceof Some && (tuple2 = (Tuple2)((Some)((Object)none$)).value()) != null) {
            SourceInfo sourceInfo = (SourceInfo)tuple2._1();
            Source source2 = (Source)tuple2._2();
            return Future$.MODULE$.successful(Some$.MODULE$.apply(Tuple2$.MODULE$.apply(sourceInfo, source2.via((Graph)PMLP$.MODULE$.personEventsFlow((Function3<Object, Object, Object, Tuple2> & Serializable)(pks, personInfoMessage, minRownum) -> this.source$$anonfun$2$$anonfun$1((Set)pks, (String)personInfoMessage, BoxesRunTime.unboxToLong(minRownum)), true)))));
        }
        if (None$.MODULE$.equals(none$) && this.isMonitoringEnabled) {
            return this.personEventsSourceFromMonitoringFlags().map((Function1<Source, Some> & Serializable)source -> Some$.MODULE$.apply(Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply("izmai\u0146u iel\u0101de", SourceInfo$.MODULE$.$lessinit$greater$default$2()), source.via((Graph)PMLP$.MODULE$.personEventsFlow((Function3<Object, Object, Object, Tuple2> & Serializable)(pks, personInfoMessage, minRownum) -> this.source$$anonfun$2$$anonfun$2$$anonfun$1((Set)pks, (String)personInfoMessage, BoxesRunTime.unboxToLong(minRownum)), false)))), this.ec());
        }
        return Future$.MODULE$.successful(None$.MODULE$);
    }
}

