/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ConnectorData;
import dagr.HttpClient;
import dagr.JsonAnyValueDecoder$;
import dagr.Record;
import dagr.Record$;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SecurityTokenServiceClient;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import dagr.SyncType;
import dagr.SyncTypeDiffAll$;
import dagr.Token;
import io.bullet.borer.Decoder;
import io.bullet.borer.compat.pekkoHttp$;
import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.common.EntityStreamingSupport;
import org.apache.pekko.http.scaladsl.common.JsonEntityStreamingSupport;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Accept$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Source;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try;

public class DataFromDagr
implements ConnectorData {
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final String view_name;
    private final HttpClient http;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private final String target_server_uri;
    private final Config stsConfig;
    private final SecurityTokenServiceClient stsClient;
    private final String consumer_service_uri;
    private final Seq<RawHeader> permission_number_headers;
    private final Renderer valueRenderer;

    public DataFromDagr(Config config, String view_name, HttpClient http, ActorSystem system, ExecutionContext ec) {
        this.config = config;
        this.view_name = view_name;
        this.http = http;
        this.system = system;
        this.ec = ec;
        ConnectorData.$init$(this);
        this.target_server_uri = config.getString("target_server_uri");
        this.stsConfig = config.hasPath("consumer") ? config.getConfig("consumer").withFallback(config) : config;
        this.stsClient = new SecurityTokenServiceClient(this.stsConfig(), "consumer", http, system, ec);
        this.consumer_service_uri = (String)Option$.MODULE$.apply("consumer_service_uri").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> config.hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> config.getString((String)x$0)).getOrElse(() -> this.$init$$$anonfun$3(view_name));
        this.permission_number_headers = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply("consumer_permission_number").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> config.hasPath((String)x$0)).map((Function1<String, String> & Serializable)x$0 -> config.getString((String)x$0)).map((Function1<String, RawHeader> & Serializable)_$1 -> RawHeader$.MODULE$.apply("X-DAGR-Permission", (String)_$1))).toSeq();
        this.valueRenderer = new Renderer(config);
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public Config stsConfig() {
        return this.stsConfig;
    }

    public SecurityTokenServiceClient stsClient() {
        return this.stsClient;
    }

    public String consumer_service_uri() {
        return this.consumer_service_uri;
    }

    public Seq<RawHeader> permission_number_headers() {
        return this.permission_number_headers;
    }

    @Override
    public SyncType syncType() {
        return SyncTypeDiffAll$.MODULE$;
    }

    public <T> Unmarshaller<HttpEntity, Source<T, NotUsed>> largeFrameJsonStreamUnmarshaller(Decoder<T> evidence$1) {
        return pekkoHttp$.MODULE$.borerStreamUnmarshaller((EntityStreamingSupport)new JsonEntityStreamingSupport(0x800000), (Decoder)evidence$1);
    }

    public Future<Source<Map<String, Object>, NotUsed>> sourceOfMapsFromChangesService(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        Decoder decoder = JsonAnyValueDecoder$.MODULE$.toMapDecoder((Function0<Map> & Serializable)() -> Predef$.MODULE$.Map().empty(), ClassTag$.MODULE$.apply(Map.class));
        return this.stsClient().getToken().flatMap((Function1<Token, Future> & Serializable)token -> this.http.doRequest(HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(this.consumer_service_uri()), (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Accept$.MODULE$.apply(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), ScalaRunTime$.MODULE$.wrapRefArray(new MediaRange[0]))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Authorization$.MODULE$.apply(OAuth2BearerToken$.MODULE$.apply(token.access_token()))), Nil$.MODULE$))).$plus$plus(this.permission_number_headers()), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()), this.http.doRequest$default$2(), this.http.doRequest$default$3(), this.http.doRequest$default$4()).flatMap((Function1<HttpResponse, Future> & Serializable)request -> Unmarshal$.MODULE$.apply(request.entity()).to(this.largeFrameJsonStreamUnmarshaller(decoder), Predef$.MODULE$.implicitly(this.ec), Predef$.MODULE$.implicitly(Materializer$.MODULE$.matFromSystem(this.system))).map((Function1<Source, Source> & Serializable)maps -> ((Source)maps.recover((PartialFunction)((Object)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    throw e;
                }
                return function1.apply(x);
            }
        }))).named(new StringBuilder(14).append("from-dagr-for-").append(this.view_name).toString()), this.ec), this.ec), this.ec);
    }

    public Record toRecord(Map<String, Object> record) {
        return Record$.MODULE$.apply(record.apply("key").toString(), (String)record.get("timestamp").filter((Function1<Object, boolean> & Serializable)_$2 -> _$2 != null).map((Function1<Object, String> & Serializable)_$3 -> _$3.toString()).orNull($less$colon$less$.MODULE$.refl()), (String)Option$.MODULE$.apply(record.apply("value")).map((Function1<Object, String> & Serializable)v -> this.valueRenderer.renderValue(v)).orNull($less$colon$less$.MODULE$.refl()), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(record.apply("offset").toString())), Record$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return this.sourceOfMapsFromChangesService(ts, schedulerInfo).map((Function1<Source, Source> & Serializable)_$4 -> (Source)_$4.map((Function1<Map, Record> & Serializable)record -> this.toRecord((Map<String, Object>)record)), this.ec).map((Function1<Source, Source> & Serializable)_$5 -> _$5.mapMaterializedValue((Function1<NotUsed, Function1> & Serializable)_$6 -> _$7 -> {}), this.ec).map((Function1<Source, Option> & Serializable)_$8 -> Option$.MODULE$.apply(_$8).map((Function1<Source, Tuple2> & Serializable)_$9 -> Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply("from-dagr", SourceInfo$.MODULE$.$lessinit$greater$default$2()), _$9)), this.ec);
    }

    private final String $init$$$anonfun$3(String view_name$1) {
        return new StringBuilder(10).append(this.target_server_uri).append("/").append(view_name$1).append("?offset=0").toString();
    }
}

