/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ConnectorData;
import dagr.DataFromCsv$;
import dagr.DataParserUtils$;
import dagr.Record;
import dagr.RemoteRecordTimestampInfo;
import dagr.Renderer;
import dagr.SchedulerInfo;
import dagr.SourceInfo;
import dagr.SourceInfo$;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.pekko.stream.connectors.csv.scaladsl.CsvParsing$;
import org.apache.pekko.stream.connectors.csv.scaladsl.CsvToMap$;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.mojoz.metadata.FieldDef_;
import org.mojoz.metadata.Type;
import org.mojoz.querease.Querease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.MapView;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import spray.json.DefaultJsonProtocol$;
import spray.json.JsonFormat;
import spray.json.package$;

public class DataFromCsv
implements ConnectorData {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DataFromCsv.class.getDeclaredField("codifs$lzy1"));
    private boolean dry_run;
    private String syncOrFake;
    private boolean report_duplicates;
    private boolean delete_unpaired_records;
    private boolean target_data_validate_on_startup;
    private long batch_interval_ms;
    private final Config config;
    private final Querease qe;
    private final String view_name;
    private final Option<Tuple2<String, String>> renderValueFrom;
    private final Logger logger;
    private final String directory;
    private final String filename_pattern;
    private final String encoding;
    private final boolean has_header;
    private final DateTimeFormatter date_format;
    private final DateTimeFormatter datetime_format;
    private volatile Object codifs$lzy1;
    private final byte fields_delimiter;
    private final Map<String, Object> mapZero;
    private final ExecutionContext ec;
    private final Regex CodifCall;
    private final Renderer renderer;

    public static Option<Tuple2<String, String>> $lessinit$greater$default$4() {
        return DataFromCsv$.MODULE$.$lessinit$greater$default$4();
    }

    /*
     * Enabled aggressive block sorting
     */
    public DataFromCsv(Config config, Querease qe, String view_name, Option<Tuple2<String, String>> renderValueFrom) {
        byte by;
        block7: {
            this.config = config;
            this.qe = qe;
            this.view_name = view_name;
            this.renderValueFrom = renderValueFrom;
            ConnectorData.$init$(this);
            this.logger = LoggerFactory.getLogger("dagr.csv");
            this.directory = config.getString("csv.files.directory");
            this.filename_pattern = config.getString("csv.files.filename_pattern");
            this.encoding = config.getString("csv.files.encoding");
            this.has_header = config.getBoolean("csv.files.has_header");
            this.date_format = DateTimeFormatter.ofPattern(config.getString("csv.files.date_format"));
            this.datetime_format = DateTimeFormatter.ofPattern(config.getString("csv.files.datetime_format"));
            String string2 = config.getString("csv.files.fields_delimiter");
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 9: {
                    if (!"\t".equals(string2)) break;
                    by = CsvParsing$.MODULE$.Tab();
                    break block7;
                }
                case 44: {
                    if (!",".equals(string2)) break;
                    by = CsvParsing$.MODULE$.Comma();
                    break block7;
                }
                case 58: {
                    if (!":".equals(string2)) break;
                    by = CsvParsing$.MODULE$.Colon();
                    break block7;
                }
                case 59: {
                    if (!";".equals(string2)) break;
                    by = CsvParsing$.MODULE$.SemiColon();
                    break block7;
                }
            }
            String d = string2;
            if (d.length() != 1) {
                String x = string2;
                throw new RuntimeException(new StringBuilder(30).append("Unsupported fields delimiter: ").append(x).toString());
            }
            Object object = Predef$.MODULE$.charArrayOps(d.toCharArray());
            by = (byte)BoxesRunTime.unboxToChar(ArrayOps$.MODULE$.head$extension(object));
        }
        this.fields_delimiter = by;
        this.mapZero = (Map)qe.viewNameToMapZero().apply(view_name);
        this.ec = ExecutionContext$.MODULE$.global();
        this.CodifCall = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^codif\\s*\\(\\s*(\\w+)\\s*,\\s*(\\w+)\\s*\\)$"));
        this.renderer = new Renderer(config, qe, view_name);
        Statics.releaseFence();
    }

    @Override
    public boolean dry_run() {
        return this.dry_run;
    }

    @Override
    public String syncOrFake() {
        return this.syncOrFake;
    }

    @Override
    public boolean report_duplicates() {
        return this.report_duplicates;
    }

    @Override
    public boolean delete_unpaired_records() {
        return this.delete_unpaired_records;
    }

    @Override
    public boolean target_data_validate_on_startup() {
        return this.target_data_validate_on_startup;
    }

    @Override
    public long batch_interval_ms() {
        return this.batch_interval_ms;
    }

    @Override
    public void dagr$ConnectorData$_setter_$dry_run_$eq(boolean x$0) {
        this.dry_run = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$syncOrFake_$eq(String x$0) {
        this.syncOrFake = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$report_duplicates_$eq(boolean x$0) {
        this.report_duplicates = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$delete_unpaired_records_$eq(boolean x$0) {
        this.delete_unpaired_records = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$target_data_validate_on_startup_$eq(boolean x$0) {
        this.target_data_validate_on_startup = x$0;
    }

    @Override
    public void dagr$ConnectorData$_setter_$batch_interval_ms_$eq(long x$0) {
        this.batch_interval_ms = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public Logger logger() {
        return this.logger;
    }

    private Map<String, Map<String, String>> codifs() {
        Object object = this.codifs$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.codifs$lzyINIT1();
    }

    private Object codifs$lzyINIT1() {
        Object object;
        block12: {
            while (true) {
                if ((object = this.codifs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        Map map2;
                        File f = new File(this.config().getString("csv.codifs_file"));
                        if (!f.exists() || !f.isFile()) {
                            throw scala.sys.package$.MODULE$.error(new StringBuilder(25).append("Codifs file ").append(f.getName()).append(" is not found").toString());
                        }
                        try (BufferedSource source = Source$.MODULE$.fromFile(f, Codec$.MODULE$.fallbackSystemCodec());){
                            map2 = (Map)package$.MODULE$.enrichString(source.mkString()).parseJson().convertTo(DefaultJsonProtocol$.MODULE$.mapFormat((JsonFormat)DefaultJsonProtocol$.MODULE$.StringJsonFormat(), (JsonFormat)DefaultJsonProtocol$.MODULE$.mapFormat((JsonFormat)DefaultJsonProtocol$.MODULE$.StringJsonFormat(), (JsonFormat)DefaultJsonProtocol$.MODULE$.StringJsonFormat())));
                        }
                        map = map2;
                        object2 = map == null ? LazyVals$NullValue$.MODULE$ : map;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codifs$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.codifs$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                        waiting.countDown();
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block12;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<Path> getFiles(String dir, Seq<String> patterns) {
        return (Seq)((IterableOps)patterns.map((Function1<String, Regex> & Serializable)_$1 -> new Regex((String)_$1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray(new String[0])))).flatMap((Function1<Regex, IterableOnce> & Serializable)regex -> {
            Object object = Predef$.MODULE$.refArrayOps(Files.list(Paths.get(dir, new String[0])).filter(p -> regex.matches(p.getFileName().toString())).toArray());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<Object, Path> & Serializable)_$2 -> (Path)_$2, ClassTag$.MODULE$.apply(Path.class)));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(object2, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
            return ArrayOps$.MODULE$.toSeq$extension(object3);
        });
    }

    public Map<String, Object> mapZero() {
        return this.mapZero;
    }

    public void moveFile(Path from, Path to, boolean fromFileExists) {
        if (fromFileExists || from.toFile().exists()) {
            if (to.toFile().exists()) {
                Files.delete(to);
            }
            Files.move(from, to, new CopyOption[0]);
            return;
        }
    }

    public boolean moveFile$default$3() {
        return false;
    }

    public Object parseValue(FieldDef_<Type> f, String v) {
        block18: {
            block17: {
                String string2 = f.type_().name();
                String string3 = "string";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block17;
                String string4 = f.type_().name();
                String string5 = "json";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block18;
            }
            return v;
        }
        String string6 = v;
        String string7 = "";
        if (!(string6 == null ? string7 != null : !string6.equals(string7)) || v == null) {
            return null;
        }
        String string8 = f.type_().name();
        switch (string8 == null ? 0 : string8.hashCode()) {
            case -1325958191: {
                if (!"double".equals(string8)) break;
                return Double.valueOf(v);
            }
            case -734768633: {
                if (!"filename".equals(string8)) break;
                return v;
            }
            case 104431: {
                if (!"int".equals(string8)) break;
                return Integer.valueOf(v);
            }
            case 3076014: {
                if (!"date".equals(string8)) break;
                return LocalDate.parse(v, this.date_format);
            }
            case 3327612: {
                if (!"long".equals(string8)) break;
                return Long.valueOf(v);
            }
            case 64711720: {
                if (!"boolean".equals(string8)) break;
                return Boolean.valueOf(v);
            }
            case 97526364: {
                if (!"float".equals(string8)) break;
                return Float.valueOf(v);
            }
            case 109413500: {
                if (!"short".equals(string8)) break;
                return Short.valueOf(v);
            }
            case 1542263633: {
                if (!"decimal".equals(string8)) break;
                return new BigDecimal(v);
            }
            case 1792749467: {
                if (!"dateTime".equals(string8)) break;
                return LocalDateTime.parse(v, this.datetime_format);
            }
            case 1958052158: {
                if (!"integer".equals(string8)) break;
                return new BigInteger(v);
            }
        }
        String x = string8;
        throw scala.sys.package$.MODULE$.error(new StringBuilder(17).append("Unsupported type ").append(x).toString());
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public Renderer renderer() {
        return this.renderer;
    }

    @Override
    public Future<Option<Tuple2<SourceInfo, Source<Record, Function1<Try<?>, BoxedUnit>>>>> source(Option<RemoteRecordTimestampInfo> ts, SchedulerInfo schedulerInfo) {
        return Future$.MODULE$.apply(this::source$$anonfun$1, this.ec());
    }

    private static final String $anonfun$4$$anonfun$1() {
        return null;
    }

    private final Record source$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$2(Seq fromFileFields$3, MapView m$3, long idx$2, Seq decodableFields$3) {
        Seq parsed = (Seq)fromFileFields$3.map((Function1<FieldDef_, Tuple2> & Serializable)f -> {
            Object object;
            String v = (String)m$3.apply(f.name());
            try {
                object = this.parseValue((FieldDef_<Type>)f, (String)m$3.apply(f.fieldName()));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = option.get();
                    throw new RuntimeException(new StringBuilder(42).append("Failed to parse field ").append(f.name()).append(" type ").append(((Type)f.type_()).name()).append(" row ").append(idx$2).append(" (value ").append(v).append(")").toString(), ex);
                }
                throw throwable;
            }
            Object parsedV = object;
            String string2 = Predef$.MODULE$.ArrowAssoc(f.fieldName());
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, parsedV);
        });
        Seq decoded = (Seq)decodableFields$3.map((Function1<FieldDef_, Tuple2> & Serializable)f -> {
            List<String> list;
            Option<List<String>> option;
            String string2 = f.saveTo();
            if (string2 != null && !(option = this.CodifCall.unapplySeq(string2)).isEmpty() && (list = option.get()).lengthCompare(2) == 0) {
                String string3 = list.apply(0);
                String string4 = list.apply(1);
                String codif = string3;
                String field2 = string4;
                String string5 = Predef$.MODULE$.ArrowAssoc(f.fieldName());
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, ((MapOps)this.codifs().apply(codif)).getOrElse(m$3.apply(field2), DataFromCsv::$anonfun$4$$anonfun$1));
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(40).append("Unexpected expression type for field ").append(f.fieldName()).append(" - ").append(f.saveTo()).toString());
        });
        return this.renderer().buildRecord((Map)((MapOps)this.mapZero().$plus$plus(parsed)).$plus$plus(decoded), this.renderer().buildRecord$default$2(), this.renderer().buildRecord$default$3(), this.renderer().buildRecord$default$4());
    }

    private final Record source$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(MapView m$1, Seq fromFileFields$1, long idx$1, Seq decodableFields$1) {
        return (Record)this.renderValueFrom.map((Function1<Tuple2, Record> & Serializable)x$1 -> {
            String string2 = (String)x$1._1();
            String string3 = (String)x$1._2();
            return new Record((String)m$1.apply(string2), (String)m$1.apply(string3));
        }).getOrElse(() -> this.source$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$2(fromFileFields$1, m$1, idx$1, decodableFields$1));
    }

    private final Option source$$anonfun$1() {
        return this.getFiles(this.directory, ScalaRunTime$.MODULE$.wrapRefArray(new String[]{this.filename_pattern})).headOption().map((Function1<Path, Tuple2> & Serializable)f2 -> {
            this.logger().info(new StringBuilder(11).append("Found file ").append(f2.getFileName()).toString());
            Seq fields = this.qe.viewDef(this.view_name).fields();
            Seq<FieldDef_<Type>> fromFileFields = DataParserUtils$.MODULE$.getCsvFields(this.qe, this.view_name);
            Seq csvFieldNames = (Seq)fromFileFields.map((Function1<FieldDef_, String> & Serializable)_$3 -> _$3.fieldName());
            Seq decodableFields = (Seq)fields.filter((Function1<FieldDef_, boolean> & Serializable)f -> f.isExpression() && f.saveTo() != null);
            return Tuple2$.MODULE$.apply(SourceInfo$.MODULE$.apply(new StringBuilder(5).append("file ").append(f2.getFileName()).toString(), SourceInfo$.MODULE$.$lessinit$greater$default$2()), ((Source)((Source)((Source)FileIO$.MODULE$.fromPath((Path)f2, FileIO$.MODULE$.fromPath$default$2()).via(CsvParsing$.MODULE$.lineScanner(this.fields_delimiter, CsvParsing$.MODULE$.lineScanner$default$2(), CsvParsing$.MODULE$.lineScanner$default$3(), 0x100000))).via(CsvToMap$.MODULE$.withHeaders(csvFieldNames))).map((Function1<Map, MapView> & Serializable)_$4 -> _$4.view().mapValues((Function1<ByteString, String> & Serializable)_$5 -> _$5.decodeString(this.encoding))).zipWithIndex().filter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    long idx = BoxesRunTime.unboxToLong(tuple2._2());
                    return idx > 0L || !this.has_header;
                }
                throw new MatchError(tuple2);
            }).mapAsync(3, (Function1<Tuple2, Future> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    MapView m = (MapView)tuple2._1();
                    long idx = BoxesRunTime.unboxToLong(tuple2._2());
                    return Future$.MODULE$.apply(() -> this.source$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(m, fromFileFields, idx, decodableFields), this.ec());
                }
                throw new MatchError(tuple2);
            })).mapMaterializedValue((Function1<Future, Function1> & Serializable)_$6 -> _$7 -> {
                Try try_ = _$7;
                if (try_ instanceof Success) {
                    this.moveFile((Path)f2, f2.resolveSibling(new StringBuilder(5).append(f2.getFileName()).append(".done").toString()), this.moveFile$default$3());
                    return;
                }
                if (try_ instanceof Failure) {
                    return;
                }
                throw new MatchError(try_);
            }));
        });
    }
}

