/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.DataAnonymizer;
import dagr.DataAnonymizer$ChooseRandomly$;
import dagr.DataAnonymizer$GeneratePersonCode$;
import dagr.DataAnonymizer$Mask$;
import dagr.DataAnonymizer$Noise$;
import dagr.DataAnonymizer$Round$;
import dagr.DataAnonymizer$Rules$;
import dagr.DataAnonymizer$Shuffle$;
import dagr.JsonAnyValueDecoder$;
import dagr.Record;
import dagr.Renderer;
import io.bullet.borer.Target;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.mojoz.querease.Querease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractMap;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.TreeSeqMap;
import scala.collection.immutable.TreeSeqMap$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigDecimal$RoundingMode$;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;
import scala.util.matching.Regex;

public final class DataAnonymizer$
implements Serializable {
    public static final DataAnonymizer$Rules$ Rules;
    public static final DataAnonymizer$Shuffle$ Shuffle;
    public static final DataAnonymizer$Noise$ Noise;
    public static final DataAnonymizer$Round$ Round;
    public static final DataAnonymizer$ChooseRandomly$ ChooseRandomly;
    public static final DataAnonymizer$GeneratePersonCode$ GeneratePersonCode;
    public static final DataAnonymizer$Mask$ Mask;
    private static final Logger logger;
    private static final JsonAnyValueDecoder$ decoder;
    private static final Regex intStrR;
    public static final DataAnonymizer$ MODULE$;

    private DataAnonymizer$() {
    }

    static {
        MODULE$ = new DataAnonymizer$();
        logger = LoggerFactory.getLogger("dagr.anonymizer");
        decoder = JsonAnyValueDecoder$.MODULE$;
        intStrR = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\d+$"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DataAnonymizer$.class);
    }

    private Nothing$ throwUnexpectedType(Object x, Seq<String> fullPath) {
        return scala.sys.package$.MODULE$.error(new StringBuilder(73).append("Unexpected type for anonymization on path [").append(fullPath.mkString(", ")).append("]: ").append(x.getClass().getName()).append(".").append(" Expecting object or array").toString());
    }

    public Seq<Option<Object>> listByPath(Map<String, Object> map, Seq<String> fullPath) {
        return this.listIt$1(fullPath, map, fullPath);
    }

    public TreeSeqMap<String, Object> applyRule(Map<String, Object> map, Seq<String> fullPath, Function1<Option<Object>, Option<Object>> newValue) {
        Object object = this.applyIt$1(newValue, fullPath, map, fullPath);
        if (object instanceof TreeSeqMap) {
            TreeSeqMap map2 = (TreeSeqMap)object;
            return map2;
        }
        Object x = object;
        throw scala.sys.package$.MODULE$.error(new StringBuilder(25).append("Unexpected return class: ").append(x.getClass().getName()).toString());
    }

    public Option<Object> applySimpleRule(DataAnonymizer.SimpleRule simpleRule, Option<Object> value, Random random) {
        DataAnonymizer.SimpleRule simpleRule2 = simpleRule;
        if (simpleRule2 instanceof DataAnonymizer.Noise) {
            DataAnonymizer.Noise noise = DataAnonymizer$Noise$.MODULE$.unapply((DataAnonymizer.Noise)simpleRule2);
            Seq<String> seq = noise._1();
            BigDecimal bigDecimal = noise._2();
            BigDecimal bigDecimal2 = noise._3();
            BigDecimal nFrom = bigDecimal;
            BigDecimal nTo = bigDecimal2;
            return value.map((Function1<Object, Object> & Serializable)x$1 -> {
                Object object = x$1;
                if (object == null) {
                    return null;
                }
                if (object instanceof Double) {
                    Double d = (Double)object;
                    return BoxesRunTime.boxToDouble(this.noise$1(random, nFrom, nTo, package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Double2double(d))).toDouble());
                }
                if (object instanceof Float) {
                    Float f = (Float)object;
                    return BoxesRunTime.boxToFloat(this.noise$1(random, nFrom, nTo, package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Float2float(f))).toFloat());
                }
                if (object instanceof Integer) {
                    Integer d = (Integer)object;
                    return BoxesRunTime.boxToLong(package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Integer2int(d)).$plus(BigDecimal$.MODULE$.int2bigDecimal(random.between(nFrom.toInt(), nTo.toInt() + 1))).toLong());
                }
                if (object instanceof Long) {
                    Long d = (Long)object;
                    return package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Long2long(d)).$plus(BigDecimal$.MODULE$.long2bigDecimal(random.between(nFrom.toLong(), nTo.toLong() + 1L))).bigDecimal();
                }
                if (object instanceof java.math.BigDecimal) {
                    java.math.BigDecimal d = (java.math.BigDecimal)object;
                    return this.noise$1(random, nFrom, nTo, package$.MODULE$.BigDecimal().apply(d)).bigDecimal();
                }
                if (object instanceof BigInteger) {
                    BigInteger i = (BigInteger)object;
                    return package$.MODULE$.BigInt().apply(i).$plus(BigInt$.MODULE$.long2bigInt(random.between(nFrom.toLong(), nTo.toLong() + 1L))).bigInteger();
                }
                if (object instanceof LocalDate) {
                    LocalDate d = (LocalDate)object;
                    return LocalDate.ofEpochDay(d.toEpochDay() + random.between(nFrom.toLong(), nTo.toLong() + 1L));
                }
                if (object instanceof OffsetDateTime) {
                    OffsetDateTime t = (OffsetDateTime)object;
                    return Instant.ofEpochSecond(t.toEpochSecond() + random.between(nFrom.toLong(), nTo.toLong() + 1L)).atOffset(t.getOffset());
                }
                if (object instanceof String) {
                    String s2 = (String)object;
                    if (s2.length() == 10 && s2.charAt(4) == '-') {
                        return this.applySimpleRule(simpleRule, Some$.MODULE$.apply(LocalDate.parse(s2)), random).get();
                    }
                    if (s2.length() > 11 && s2.charAt(10) == 'T') {
                        return this.applySimpleRule(simpleRule, Some$.MODULE$.apply(OffsetDateTime.parse(s2)), random).get();
                    }
                    if (intStrR.matches(s2)) {
                        return package$.MODULE$.BigInt().apply(s2).$plus(BigInt$.MODULE$.long2bigInt(random.between(nFrom.toLong(), nTo.toLong()))).toString();
                    }
                    return this.noise$1(random, nFrom, nTo, package$.MODULE$.BigDecimal().apply(s2)).toString();
                }
                Object x = object;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(46).append("Unexpected class for rule ").append(simpleRule).append(", can not apply to: ").append(x.getClass().getName()).toString());
            });
        }
        if (simpleRule2 instanceof DataAnonymizer.Round) {
            BigDecimal bigDecimal;
            DataAnonymizer.Round round = DataAnonymizer$Round$.MODULE$.unapply((DataAnonymizer.Round)simpleRule2);
            Seq<String> seq = round._1();
            BigDecimal roundTo = bigDecimal = round._2();
            return value.map((Function1<Object, Object> & Serializable)x$1 -> {
                Object object = x$1;
                if (object == null) {
                    return null;
                }
                if (object instanceof Double) {
                    Double d = (Double)object;
                    return BoxesRunTime.boxToDouble(this.round$1(roundTo, package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Double2double(d))).toDouble());
                }
                if (object instanceof Float) {
                    Float d = (Float)object;
                    return BoxesRunTime.boxToDouble(this.round$1(roundTo, package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Float2float(d))).toDouble());
                }
                if (object instanceof Integer) {
                    Integer d = (Integer)object;
                    return BoxesRunTime.boxToLong(this.round$1(roundTo, package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Integer2int(d))).toLong());
                }
                if (object instanceof Long) {
                    Long d = (Long)object;
                    return this.round$1(roundTo, package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Long2long(d))).bigDecimal();
                }
                if (object instanceof java.math.BigDecimal) {
                    java.math.BigDecimal d = (java.math.BigDecimal)object;
                    return this.round$1(roundTo, BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(d)).bigDecimal();
                }
                if (object instanceof BigInteger) {
                    BigInteger i = (BigInteger)object;
                    return this.round$1(roundTo, package$.MODULE$.BigDecimal().apply(package$.MODULE$.BigInt().apply(i))).toBigInt().bigInteger();
                }
                if (object instanceof LocalDate) {
                    LocalDate d = (LocalDate)object;
                    BigDecimal bigDecimal = this.round$1(roundTo, package$.MODULE$.BigDecimal().apply(d.toEpochDay()));
                    package$.MODULE$.BigDecimal();
                    return LocalDate.ofEpochDay(bigDecimal.setScale(0, BigDecimal$RoundingMode$.MODULE$.HALF_UP()).toLong());
                }
                if (object instanceof OffsetDateTime) {
                    OffsetDateTime t = (OffsetDateTime)object;
                    BigDecimal bigDecimal = this.round$1(roundTo, package$.MODULE$.BigDecimal().apply(t.toEpochSecond()));
                    package$.MODULE$.BigDecimal();
                    return Instant.ofEpochSecond(bigDecimal.setScale(0, BigDecimal$RoundingMode$.MODULE$.HALF_UP()).toLong()).atOffset(t.getOffset());
                }
                if (object instanceof String) {
                    String s2 = (String)object;
                    if (s2.length() == 10 && s2.charAt(4) == '-') {
                        return this.applySimpleRule(simpleRule, Some$.MODULE$.apply(LocalDate.parse(s2)), random).get();
                    }
                    if (s2.length() > 11 && s2.charAt(10) == 'T') {
                        return this.applySimpleRule(simpleRule, Some$.MODULE$.apply(OffsetDateTime.parse(s2)), random).get();
                    }
                    return this.round$1(roundTo, package$.MODULE$.BigDecimal().apply(s2)).toString();
                }
                Object x = object;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(54).append("Unexpected class for rule ").append(simpleRule).append(", can not apply to: ").append(x.getClass().getName()).append(", value ").append(value).toString());
            });
        }
        if (simpleRule2 instanceof DataAnonymizer.ChooseRandomly) {
            Seq<String> seq;
            DataAnonymizer.ChooseRandomly chooseRandomly = DataAnonymizer$ChooseRandomly$.MODULE$.unapply((DataAnonymizer.ChooseRandomly)simpleRule2);
            Seq<String> seq2 = chooseRandomly._1();
            Seq<String> valuePool = seq = chooseRandomly._2();
            return value.map((Function1<Object, Object> & Serializable)x$1 -> {
                Object object = x$1;
                if (object == null) {
                    return null;
                }
                if (object instanceof Double) {
                    Double d = (Double)object;
                    return Double.valueOf(this.pick$1(valuePool, random));
                }
                if (object instanceof Float) {
                    Float d = (Float)object;
                    return Float.valueOf(this.pick$1(valuePool, random));
                }
                if (object instanceof Integer) {
                    Integer d = (Integer)object;
                    return Integer.valueOf(this.pick$1(valuePool, random));
                }
                if (object instanceof Long) {
                    Long d = (Long)object;
                    return Long.valueOf(this.pick$1(valuePool, random));
                }
                if (object instanceof java.math.BigDecimal) {
                    java.math.BigDecimal d = (java.math.BigDecimal)object;
                    return package$.MODULE$.BigDecimal().apply(this.pick$1(valuePool, random)).bigDecimal();
                }
                if (object instanceof BigInteger) {
                    BigInteger i = (BigInteger)object;
                    return package$.MODULE$.BigInt().apply(this.pick$1(valuePool, random)).bigInteger();
                }
                if (object instanceof LocalDate) {
                    LocalDate d = (LocalDate)object;
                    return LocalDate.parse(this.pick$1(valuePool, random));
                }
                if (object instanceof OffsetDateTime) {
                    OffsetDateTime t = (OffsetDateTime)object;
                    return OffsetDateTime.parse(this.pick$1(valuePool, random));
                }
                if (object instanceof String) {
                    return this.pick$1(valuePool, random);
                }
                Object x = object;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(46).append("Unexpected class for rule ").append(simpleRule).append(", can not apply to: ").append(x.getClass().getName()).toString());
            });
        }
        if (simpleRule2 instanceof DataAnonymizer.Mask) {
            String string2;
            DataAnonymizer.Mask mask = DataAnonymizer$Mask$.MODULE$.unapply((DataAnonymizer.Mask)simpleRule2);
            Seq<String> seq = mask._1();
            String pattern = string2 = mask._2();
            return value.map((Function1<Object, String> & Serializable)x$12 -> {
                Object object = x$12;
                if (object == null) {
                    return null;
                }
                if (object instanceof String) {
                    String s2 = (String)object;
                    return ((IterableOnceOps)((IndexedSeqOps)Predef$.MODULE$.wrapString(s2).zip((IterableOnce)Predef$.MODULE$.wrapString(pattern))).map((Function1<Tuple2, char> & Serializable)x$1 -> {
                        char c = x$1._1$mcC$sp();
                        char c2 = x$1._2$mcC$sp();
                        if (c2 == '*') {
                            return c;
                        }
                        return c2;
                    })).mkString();
                }
                Object x = object;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(46).append("Unexpected class for rule ").append(simpleRule).append(", can not apply to: ").append(x.getClass().getName()).toString());
            });
        }
        throw new MatchError(simpleRule2);
    }

    public Random applySimpleRule$default$3() {
        return null;
    }

    public <T> Flow<T, Seq<T>, NotUsed> splitToMinBatchSize(int min_batch_size) {
        Source nilSource = Source$.MODULE$.apply((Iterable)((Object)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Nil$.MODULE$), Nil$.MODULE$))));
        Flow flow = (Flow)Flow$.MODULE$.apply().grouped(min_batch_size).concat(nilSource);
        return (Flow)flow.sliding(2, flow.sliding$default$2()).map((Function1<Seq, Seq> & Serializable)x$1 -> {
            Seq seq = x$1;
            if (seq != null) {
                SeqOps seqOps = Seq$.MODULE$.unapplySeq(seq);
                if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 2) == 0) {
                    Seq seq2 = (Seq)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Seq seq3 = (Seq)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                    Seq a = seq2;
                    Seq b = seq3;
                    if (b.size() == min_batch_size) {
                        return a;
                    }
                    return (Seq)a.$plus$plus(b);
                }
                if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0) {
                    Seq seq4;
                    Seq a = seq4 = (Seq)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    return a;
                }
            }
            throw new MatchError(seq);
        }).filter((Function1<Seq, boolean> & Serializable)q -> {
            int size = q.size();
            if (size < min_batch_size) {
                if (size > 0) {
                    logger.debug(new StringBuilder(105).append("Skipping batch of size ").append(size).append(" because it is less than").append(new StringBuilder(31).append(" configured minimum batch size ").append(min_batch_size).toString()).append(" and therefore not suitable for anonymization by shuffling").toString());
                }
                return false;
            }
            return true;
        });
    }

    public Flow<Record, Record, NotUsed> flow(Config config, Querease qe, String view_name, DataAnonymizer.Rules rules) {
        return this.flow(view_name, rules, new Renderer(config, qe, view_name), new Random());
    }

    public Flow<Record, Record, NotUsed> flow(String view_name, DataAnonymizer.Rules rules, Renderer renderer, Random random) {
        int min_batch_size = rules.min_batch_size();
        boolean hasShuffle = rules.rules().exists((Function1<DataAnonymizer.Rule, boolean> & Serializable)x$1 -> {
            DataAnonymizer.Rule rule = x$1;
            if (rule instanceof DataAnonymizer.Shuffle) {
                DataAnonymizer.Shuffle sh = (DataAnonymizer.Shuffle)rule;
                return true;
            }
            return false;
        });
        Random pkRandom = new Random(42);
        if (hasShuffle && rules.min_batch_size() < 2) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(51).append("Unable to shuffle records of ").append(view_name).append(" if min-batch-size is ").append(rules.min_batch_size()).toString());
        }
        Seq<String> keyFieldNames = renderer.keyFieldNames();
        return (Flow)((Flow)((Flow)Flow$.MODULE$.apply().filterNot((Function1<Record, boolean> & Serializable)_$3 -> _$3.value() == null)).via((Graph)this.splitToMinBatchSize(min_batch_size))).map((Function1<Seq, Seq> & Serializable)records -> {
            int batchSize = records.size();
            logger.debug(new StringBuilder(26).append("Anonymizing batch of size ").append(batchSize).toString());
            Object ruleGroups = ((List)rules.rules().foldLeft((Object)Nil$.MODULE$, (Function2<List, DataAnonymizer.Rule, List> & Serializable)(x$1, x$2) -> {
                Tuple2<List, DataAnonymizer.Rule> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    List groups = tuple2._1();
                    DataAnonymizer.Rule rule = tuple2._2();
                    if (groups.isEmpty() || rule instanceof DataAnonymizer.Shuffle || ((Vector)groups.head()).head() instanceof DataAnonymizer.Shuffle) {
                        Vector vector = (Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new DataAnonymizer.Rule[]{rule}));
                        return groups.$colon$colon(vector);
                    }
                    Vector vector = (Vector)((SeqOps)groups.head()).$colon$plus(rule);
                    return ((List)groups.tail()).$colon$colon(vector);
                }
                throw new MatchError(tuple2);
            })).reverse();
            logger.debug("parsing records");
            Seq parsedRecords = (Seq)records.map((Function1<Record, TreeSeqMap> & Serializable)r -> {
                ByteString byteString = ByteString$.MODULE$.apply(r.value());
                Function0<TreeSeqMap> & Serializable intersect = (Function0<TreeSeqMap> & Serializable)() -> TreeSeqMap$.MODULE$.empty();
                Target target = decoder.decodeToMap$default$2();
                return (TreeSeqMap)decoder.decodeToMap(byteString, target, intersect, ClassTag$.MODULE$.apply(TreeSeqMap.class));
            });
            logger.debug("applying rules");
            return (Seq)((IterableOps)((List)ruleGroups).foldLeft(parsedRecords, (Function2<Seq, Vector, Seq> & Serializable)(x$1, x$2) -> {
                Tuple2<Seq, Vector> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    DataAnonymizer.Rule rule;
                    SeqOps seqOps;
                    Seq parsedRecords = tuple2._1();
                    Vector ruleGroup = tuple2._2();
                    Vector vector = ruleGroup;
                    if (vector != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq(vector), 1) == 0 && (rule = (DataAnonymizer.Rule)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) instanceof DataAnonymizer.Shuffle) {
                        DataAnonymizer.Shuffle shuffle = (DataAnonymizer.Shuffle)rule;
                        logger.debug("shuffling");
                        Seq<String> shufflePath = shuffle.path();
                        Object[] shuffleProcessingArray = (Option[])((IterableOnceOps)parsedRecords.flatMap((Function1<TreeSeqMap, IterableOnce> & Serializable)_$4 -> MODULE$.listByPath((Map<String, Object>)_$4, shufflePath))).toArray(ClassTag$.MODULE$.apply(Option.class));
                        int shuffleSize = shuffleProcessingArray.length;
                        if (shuffleSize == 1) {
                            throw scala.sys.package$.MODULE$.error(new StringBuilder(55).append("Unable to shuffle single element - path '").append(shufflePath).append("', batch size ").append(batchSize).toString());
                        }
                        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), shuffleSize - 2).foreach(arg_0 -> DataAnonymizer$.flow$$anonfun$2$$anonfun$1$$anonfun$1(random, shuffleSize, (Option[])shuffleProcessingArray, arg_0));
                        Object object = Predef$.MODULE$.refArrayOps(shuffleProcessingArray);
                        Iterator iterator = ArrayOps$.MODULE$.iterator$extension(object);
                        return (Seq)parsedRecords.map((Function1<TreeSeqMap, TreeSeqMap> & Serializable)_$5 -> MODULE$.applyRule((Map<String, Object>)_$5, shufflePath, (Function1<Option<Object>, Option<Object>>)(Function1<Option, Option> & Serializable)_$6 -> (Option)iterator.next()));
                    }
                    Vector otherRules = vector;
                    logger.debug("applying simple rules");
                    return (Seq)parsedRecords.map((Function1<TreeSeqMap, TreeSeqMap> & Serializable)record -> ruleGroup.foldLeft(record, (Function2<TreeSeqMap, DataAnonymizer.Rule, TreeSeqMap> & Serializable)(x$1, x$2) -> {
                        Tuple2<TreeSeqMap, DataAnonymizer.Rule> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                        if (tuple2 != null) {
                            TreeSeqMap v = tuple2._1();
                            DataAnonymizer.Rule rule = tuple2._2();
                            DataAnonymizer.Rule rule2 = rule;
                            if (rule2 instanceof DataAnonymizer.Shuffle) {
                                DataAnonymizer.Shuffle shuffle = (DataAnonymizer.Shuffle)rule2;
                                throw new IllegalStateException("Unexpected state");
                            }
                            if (rule2 instanceof DataAnonymizer.GeneratePersonCode) {
                                DataAnonymizer.GeneratePersonCode genPk = (DataAnonymizer.GeneratePersonCode)rule2;
                                return this.applyRule(v, rule.path(), (Function1<Option<Object>, Option<Object>>)(Function1<Option, Option> & Serializable)_$7 -> _$7.map((Function1<Object, String> & Serializable)old -> {
                                    if (old == null) {
                                        return null;
                                    }
                                    return this.generatePersonCode$1(pkRandom, genPk.shortFormat());
                                }));
                            }
                            if (rule2 instanceof DataAnonymizer.SimpleRule) {
                                DataAnonymizer.SimpleRule simpleRule = (DataAnonymizer.SimpleRule)rule2;
                                return this.applyRule(v, rule.path(), (Function1<Option<Object>, Option<Object>>)(Function1<Option, Option> & Serializable)_$8 -> MODULE$.applySimpleRule(simpleRule, (Option<Object>)_$8, random));
                            }
                            throw new MatchError(rule2);
                        }
                        throw new MatchError(tuple2);
                    }));
                }
                throw new MatchError(tuple2);
            })).map((Function1<Map, Record> & Serializable)record -> renderer.renderKeyAndValue((Map<String, Object>)record));
        }).mapConcat((Function1<Seq, IterableOnce> & Serializable)x -> Predef$.MODULE$.identity(x)).take(rules.limit());
    }

    public Random flow$default$4() {
        return new Random();
    }

    private static final Vector listIt$1$$anonfun$2() {
        return (Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new None$[]{None$.MODULE$}));
    }

    private static final Vector listIt$1$$anonfun$5() {
        return Vector$.MODULE$.empty();
    }

    private final Vector listIt$1(Seq fullPath$3, Object obj, Seq path) {
        Object object = obj;
        if (object == null) {
            if (path.isEmpty()) {
                return (Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Some[]{Some$.MODULE$.apply(null)}));
            }
            return Vector$.MODULE$.empty();
        }
        if (object instanceof Map) {
            SeqOps seqOps;
            Map map = (Map)object;
            Seq seq = path;
            if (((Object)Nil$.MODULE$).equals(seq)) {
                return (Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Some[]{Some$.MODULE$.apply(map)}));
            }
            if (seq != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq(seq), 1) == 0) {
                String string2;
                String step = string2 = (String)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                return (Vector)map.get(step).map((Function1<Object, Vector> & Serializable)v -> (Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Some[]{Some$.MODULE$.apply(v)}))).getOrElse(DataAnonymizer$::listIt$1$$anonfun$2);
            }
            return (Vector)map.get(path.head()).filter((Function1<Object, boolean> & Serializable)_$1 -> _$1 != null).map((Function1<Object, Vector> & Serializable)x -> this.listIt$1(fullPath$3, x, (Seq)path.tail())).getOrElse(DataAnonymizer$::listIt$1$$anonfun$5);
        }
        if (object instanceof Seq) {
            Seq s2 = (Seq)object;
            return ((IterableOnceOps)s2.flatMap((Function1<Object, IterableOnce> & Serializable)el -> this.listIt$1(fullPath$3, el, path))).toVector();
        }
        Object x2 = object;
        throw this.throwUnexpectedType(x2, fullPath$3);
    }

    private static final TreeSeqMap applyIt$1$$anonfun$3(TreeSeqMap map$2) {
        return map$2;
    }

    private final Object applyIt$1(Function1 newValue$1, Seq fullPath$4, Object obj, Seq path) {
        Object object;
        while (true) {
            if ((object = obj) == null) {
                if (path.isEmpty()) {
                    return newValue$1.apply(Some$.MODULE$.apply(null));
                }
                return null;
            }
            if (object instanceof TreeSeqMap) {
                SeqOps seqOps;
                TreeSeqMap map = (TreeSeqMap)object;
                Seq seq = path;
                if (((Object)Nil$.MODULE$).equals(seq)) {
                    throw scala.sys.package$.MODULE$.error("Unexpected empty path");
                }
                if (seq != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq(seq), 1) == 0) {
                    Option newV;
                    String string2 = (String)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    String step = string2;
                    Option oldV = map.get(step);
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(oldV, newV = (Option)newValue$1.apply(oldV));
                    if (tuple2 != null) {
                        Option option = tuple2._1();
                        Option option2 = tuple2._2();
                        if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                            return map;
                        }
                        if (option instanceof Some && ((Some)option).value() == null && option2 instanceof Some && ((Some)option2).value() == null) {
                            return map;
                        }
                        if (None$.MODULE$.equals(option2)) {
                            return (TreeSeqMap)map.$minus(step);
                        }
                        if (option2 instanceof Some) {
                            Object v = ((Some)option2).value();
                            return map.updated(step, v);
                        }
                    }
                    throw new MatchError(tuple2);
                }
                return (TreeSeqMap)map.get(path.head()).filter((Function1<Object, boolean> & Serializable)_$2 -> _$2 != null).map((Function1<Object, TreeSeqMap> & Serializable)x -> map.updated(path.head(), this.applyIt$1(newValue$1, fullPath$4, x, (Seq)path.tail()))).getOrElse(() -> DataAnonymizer$.applyIt$1$$anonfun$3(map));
            }
            if (!(object instanceof Map)) break;
            Map map = (Map)object;
            obj = ((AbstractMap)TreeSeqMap$.MODULE$.empty()).$plus$plus((IterableOnce)map);
        }
        if (object instanceof Seq) {
            Seq s2 = (Seq)object;
            return s2.map((Function1<Object, Object> & Serializable)el -> this.applyIt$1(newValue$1, fullPath$4, el, path));
        }
        Object x2 = object;
        throw this.throwUnexpectedType(x2, fullPath$4);
    }

    private final BigDecimal noise$1(Random random$1, BigDecimal nFrom$1, BigDecimal nTo$1, BigDecimal n) {
        BigDecimal bigDecimal = n.$plus(BigDecimal$.MODULE$.double2bigDecimal(random$1.between(nFrom$1.toDouble(), nTo$1.toDouble())));
        int n2 = n.scale();
        package$.MODULE$.BigDecimal();
        return bigDecimal.setScale(n2, BigDecimal$RoundingMode$.MODULE$.FLOOR());
    }

    private final BigDecimal round$1(BigDecimal roundTo$1, BigDecimal n) {
        BigDecimal bigDecimal = n.$div(roundTo$1);
        package$.MODULE$.BigDecimal();
        return bigDecimal.setScale(0, BigDecimal$RoundingMode$.MODULE$.HALF_UP()).$times(roundTo$1);
    }

    private final String pick$1(Seq valuePool$1, Random random$4) {
        return (String)valuePool$1.apply(random$4.nextInt(valuePool$1.size()));
    }

    private final String generatePersonCode$1(Random pkRandom$1, boolean shortFormat) {
        String pkDelim = shortFormat ? "" : "-";
        return new StringBuilder(2).append("32").append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%04d"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(pkRandom$1.nextInt(10000))}))).append(pkDelim).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%05d"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(pkRandom$1.nextInt(100000))}))).toString();
    }

    private static final /* synthetic */ void flow$$anonfun$2$$anonfun$1$$anonfun$1(Random random$8, int shuffleSize$1, Option[] shuffleProcessingArray$1, int index) {
        Option swapWith;
        int swapIndex = random$8.between(index + 1, shuffleSize$1);
        Option current = shuffleProcessingArray$1[index];
        shuffleProcessingArray$1[index] = swapWith = shuffleProcessingArray$1[swapIndex];
        shuffleProcessingArray$1[swapIndex] = current;
    }
}

