/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import dagr.DagrLogbackEvents;
import dagr.DagrLogbackEvents$LogToDagrPackage$;
import dagr.DatasetHistory$;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.StringContext$;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import spray.json.JsString$;

public final class DagrLogbackEvents$
implements Serializable {
    public static final DagrLogbackEvents$LogToDagrPackage$ LogToDagrPackage;
    private static final String infoToDagrLoggerName;
    private static final AtomicReference<Set<String>> classNamesForInfoLevelLogging;
    private static final AtomicReference<Option<File>> inputFilesDirOpt;
    private static final CopyOnWriteArrayList<String> events;
    private static final int maxEventsCacheSize;
    private static final boolean onCacheOverflowMoveItemsToFile;
    public static final DagrLogbackEvents$ MODULE$;

    private DagrLogbackEvents$() {
    }

    static {
        MODULE$ = new DagrLogbackEvents$();
        infoToDagrLoggerName = "dagr.problemUpdater";
        classNamesForInfoLevelLogging = new AtomicReference<Object>(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[0])));
        inputFilesDirOpt = new AtomicReference<None$>(None$.MODULE$);
        events = new CopyOnWriteArrayList();
        maxEventsCacheSize = 500;
        onCacheOverflowMoveItemsToFile = true;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DagrLogbackEvents$.class);
    }

    public String infoToDagrLoggerName() {
        return infoToDagrLoggerName;
    }

    private String jsStr(String s2) {
        if (s2 == null) {
            return "null";
        }
        return JsString$.MODULE$.apply(s2).compactPrint();
    }

    private String logMsgToJsObjStr(String dataset, long ts, String clazz, String lvl, String msg) {
        return new StringBuilder(48).append("{\"dataset\":").append(this.jsStr(dataset)).append(",\"ts\":").append(ts).append(",\"logger\":\"").append(clazz).append("\",\"level\":\"").append(lvl).append("\",\"msg\":").append(this.jsStr(msg)).append("}").toString();
    }

    public void init(Set<String> logClassNames, String dir) {
        if (logClassNames.nonEmpty()) {
            classNamesForInfoLevelLogging.set(logClassNames);
        }
        Try$.MODULE$.apply(() -> DagrLogbackEvents$.init$$anonfun$1(dir)).toOption().foreach(x$1 -> {
            File file = x$1;
            File f = file;
            if (f.isDirectory()) {
                inputFilesDirOpt.set(Some$.MODULE$.apply(f));
                return;
            }
            throw new MatchError(file);
        });
    }

    public void add(ILoggingEvent e) {
        String dataset = DatasetHistory$.MODULE$.getDataset(e.getTimeStamp());
        String event = this.logMsgToJsObjStr(dataset, e.getTimeStamp(), e.getLoggerName(), e.getLevel().levelStr, e.getMessage());
        String string2 = e.getLoggerName();
        String string3 = this.infoToDagrLoggerName();
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            Level level = e.getLevel();
            Level level2 = Level.ERROR;
            Level level3 = level;
            if (!(level2 != null ? !level2.equals(level3) : level3 != null)) {
                this.addToCache(event, this.addToCache$default$2(), this.addToCache$default$3());
                return;
            }
            Level level4 = Level.WARN;
            Level level5 = level;
            if (!(level4 != null ? !level4.equals(level5) : level5 != null)) {
                this.addToCache(event, this.addToCache$default$2(), this.addToCache$default$3());
                return;
            }
            Level level6 = Level.INFO;
            Level level7 = level;
            if (!(level6 != null ? !level6.equals(level7) : level7 != null) && ((SetOps)classNamesForInfoLevelLogging.get()).contains(e.getLoggerName())) {
                this.addToCache(event, this.addToCache$default$2(), this.addToCache$default$3());
                return;
            }
            return;
        }
    }

    public void addToCache(String event, int maxSize, boolean moveToFile) {
        events.add(event);
        if (events.size() > maxSize) {
            if (moveToFile && inputFilesDirOpt.get().nonEmpty()) {
                Predef$.MODULE$.println(new StringBuilder(73).append("reached max allowed event's cache size ").append(maxSize).append(", moving cached events to tmp file").toString());
                this.storeEventsToTmpFile(CollectionConverters$.MODULE$.ListHasAsScala(events).asScala().toSeq());
                return;
            }
            while (events.size() > maxSize) {
                String discardEvent = events.remove(0);
                Predef$.MODULE$.println(new StringBuilder(77).append("reached max allowed event's cache size ").append(events.size() + 1).append("/").append(maxSize).append(", the oldest events will be discarded").toString());
            }
            return;
        }
    }

    public int addToCache$default$2() {
        return maxEventsCacheSize;
    }

    public boolean addToCache$default$3() {
        return onCacheOverflowMoveItemsToFile;
    }

    private void storeEventsToTmpFile(Seq<String> items) {
        try {
            File tmpFile = File.createTempFile(new StringBuilder(16).append("events-to-dagr-").append(System.currentTimeMillis()).append("-").toString(), ".tmp", inputFilesDirOpt.get().get());
            try (FileWriter writer = new FileWriter(tmpFile);){
                writer.write(items.mkString("\n"));
                this.clean(DagrLogbackEvents$LogToDagrPackage$.MODULE$.apply(items, None$.MODULE$));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            Predef$.MODULE$.println("error while moving cached events to file! Further usage of storing events into tmp files disabled till connector restart");
            inputFilesDirOpt.set(None$.MODULE$);
        }
    }

    public Seq<File> getEventsToDagrFiles() {
        return (Seq)inputFilesDirOpt.get().map((Function1<File, Seq> & Serializable)dir -> {
            Object object = Predef$.MODULE$.refArrayOps(dir.listFiles());
            return (Seq)((SeqOps)ArrayOps$.MODULE$.toSeq$extension(object).filter((Function1<File, boolean> & Serializable)f -> {
                Seq<String> seq;
                Option<Seq<String>> option;
                String string2 = f.getName();
                if (string2 != null && !(option = StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"events-to-dagr-", "-", ".tmp"})).s().unapplySeq(string2)).isEmpty() && (seq = option.get()).lengthCompare(2) == 0) {
                    String string3 = (String)seq.apply(false);
                    String string4 = (String)seq.apply(true);
                    String systemTimeInMillis = string3;
                    String random = string4;
                    return true;
                }
                return false;
            })).sortBy((Function1<File, String> & Serializable)_$1 -> _$1.getName(), Ordering$String$.MODULE$);
        }).getOrElse(DagrLogbackEvents$::getEventsToDagrFiles$$anonfun$2);
    }

    public Seq<DagrLogbackEvents.LogToDagrPackage> getData() {
        Seq<String> items = CollectionConverters$.MODULE$.ListHasAsScala(events).asScala().toSeq();
        if (onCacheOverflowMoveItemsToFile && inputFilesDirOpt.get().nonEmpty()) {
            if (items.nonEmpty()) {
                this.storeEventsToTmpFile(items);
            }
            return (Seq)this.getEventsToDagrFiles().map((Function1<File, DagrLogbackEvents.LogToDagrPackage> & Serializable)f -> {
                Seq eventsFromFile = (Seq)Using$.MODULE$.apply(() -> DagrLogbackEvents$.$anonfun$1(f), (Function1<BufferedSource, Seq> & Serializable)s2 -> s2.getLines().toSeq(), Using$Releasable$AutoCloseableIsReleasable$.MODULE$).get();
                return DagrLogbackEvents$LogToDagrPackage$.MODULE$.apply(eventsFromFile, Some$.MODULE$.apply(f));
            });
        }
        if (items.isEmpty()) {
            return (Seq)((SeqOps)Nil$.MODULE$);
        }
        return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)DagrLogbackEvents$LogToDagrPackage$.MODULE$.apply(items, None$.MODULE$)), Nil$.MODULE$));
    }

    public void clean(DagrLogbackEvents.LogToDagrPackage p) {
        p.fileOpt().map(x$1 -> {
            File file = x$1;
            File f = file;
            if (f.exists()) {
                Predef$.MODULE$.println(new StringBuilder(12).append("delete file ").append(f.getName()).toString());
                if (f.exists()) {
                    f.delete();
                    return;
                }
                return;
            }
            throw new MatchError(file);
        }).getOrElse((Function0<Object> & Serializable)() -> {
            DagrLogbackEvents$.clean$$anonfun$2(p);
            return BoxedUnit.UNIT;
        });
    }

    private static final File init$$anonfun$1(String dir$1) {
        return new File(dir$1);
    }

    private static final Seq getEventsToDagrFiles$$anonfun$2() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final BufferedSource $anonfun$1(File f$1) {
        return Source$.MODULE$.fromFile(f$1, Codec$.MODULE$.fallbackSystemCodec());
    }

    private static final void clean$$anonfun$2(DagrLogbackEvents.LogToDagrPackage p$1) {
        if (p$1.events().nonEmpty()) {
            Predef$.MODULE$.println("cleaning events cache");
            events.removeIf(e -> p$1.events().contains(e));
            return;
        }
    }
}

