/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import dagr.ApiParvaldnieks;
import dagr.Connector$;
import dagr.Connector$AfterDataRecords$;
import dagr.Connector$ConnectorStreamElement$;
import dagr.Connector$DataRecord$;
import dagr.Connector$Differs$;
import dagr.Connector$Excess$;
import dagr.Connector$Missing$;
import dagr.Connector$Same$;
import dagr.ConnectorData;
import dagr.ConnectorQuerease;
import dagr.DatasetHistory$;
import dagr.DbAccess;
import dagr.FileHandler$;
import dagr.FileHandlerTools;
import dagr.HttpClient;
import dagr.InfoToDagr;
import dagr.Record;
import dagr.Record$;
import dagr.RemoteAnonymizerTask;
import dagr.RemoteDataImportTask;
import dagr.RemoteDataStatus;
import dagr.RemoteRecordTimestampInfo;
import dagr.RemoteRecordTimestampInfo$;
import dagr.RemoteTaskDetails;
import dagr.Reporter$;
import dagr.SchedulerInfo;
import dagr.SecurityTokenServiceClient;
import dagr.SourceInfo;
import dagr.SyncTypeDiffAllApplied$;
import dagr.UpdateInfo;
import dagr.UpdateInfo$;
import dagr.Updater;
import dagr.Uploader;
import dagr.Validator;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.FlowOps;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.RunnableGraph;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.SubFlow;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class Connector {
    private final Seq<String> dataset_names;
    private final Map<String, ConnectorData> datasetNameToDataSource;
    private final Function1<String, Option<Flow<Record, Record, NotUsed>>> anonymizerFactory;
    private final Option<RemoteTaskDetails> remoteTaskDetailsOpt;
    private final Map<String, RemoteDataStatus> datasetNameToRemoteDataStatus;
    private final Map<String, RemoteDataStatus> datasetNameToRemoteAppliedDataStatus;
    public static final long OFFSET$_m_5 = LazyVals$.MODULE$.getOffsetStatic(Connector$.class.getDeclaredField("fileHandlerTools$lzy1"));
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(Connector$.class.getDeclaredField("dbAccess$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(Connector$.class.getDeclaredField("apiParvaldnieks$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(Connector$.class.getDeclaredField("uploader$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Connector$.class.getDeclaredField("remoteDataImportTask$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Connector$.class.getDeclaredField("remoteAnonymizerTask$lzy1"));

    public static ConnectorStreamElement BatchEndElement() {
        return Connector$.MODULE$.BatchEndElement();
    }

    public static String CfgDs() {
        return Connector$.MODULE$.CfgDs();
    }

    public static Seq<String> all_dataset_names() {
        return Connector$.MODULE$.all_dataset_names();
    }

    public static ApiParvaldnieks apiParvaldnieks() {
        return Connector$.MODULE$.apiParvaldnieks();
    }

    public static String datasource_type() {
        return Connector$.MODULE$.datasource_type();
    }

    public static DbAccess dbAccess() {
        return Connector$.MODULE$.dbAccess();
    }

    public static ExecutionContext ec() {
        return Connector$.MODULE$.ec();
    }

    public static FileHandlerTools fileHandlerTools() {
        return Connector$.MODULE$.fileHandlerTools();
    }

    public static HttpClient httpClient() {
        return Connector$.MODULE$.httpClient();
    }

    public static FiniteDuration http_conn_max_idle_timeout() {
        return Connector$.MODULE$.http_conn_max_idle_timeout();
    }

    public static InfoToDagr infoToDagr() {
        return Connector$.MODULE$.infoToDagr();
    }

    public static boolean isRemoteAnonymizer() {
        return Connector$.MODULE$.isRemoteAnonymizer();
    }

    public static boolean isRemoteDataImport() {
        return Connector$.MODULE$.isRemoteDataImport();
    }

    public static boolean logToDagrPrintDebug() {
        return Connector$.MODULE$.logToDagrPrintDebug();
    }

    public static void main(String[] stringArray) {
        Connector$.MODULE$.main(stringArray);
    }

    public static Connector mainConnector() {
        return Connector$.MODULE$.mainConnector();
    }

    public static long nextReportAt(long l) {
        return Connector$.MODULE$.nextReportAt(l);
    }

    public static long progress_report_interval_ms() {
        return Connector$.MODULE$.progress_report_interval_ms();
    }

    public static ConnectorQuerease querease() {
        return Connector$.MODULE$.querease();
    }

    public static RemoteAnonymizerTask remoteAnonymizerTask() {
        return Connector$.MODULE$.remoteAnonymizerTask();
    }

    public static RemoteDataImportTask remoteDataImportTask() {
        return Connector$.MODULE$.remoteDataImportTask();
    }

    public static SecurityTokenServiceClient stsClient() {
        return Connector$.MODULE$.stsClient();
    }

    public static ActorSystem system() {
        return Connector$.MODULE$.system();
    }

    public static Uploader uploader() {
        return Connector$.MODULE$.uploader();
    }

    public static long nextReportAt$default$1() {
        return Connector$.MODULE$.nextReportAt$default$1();
    }

    public Connector(Seq<String> dataset_names, Map<String, ConnectorData> datasetNameToDataSource, Function1<String, Option<Flow<Record, Record, NotUsed>>> anonymizerFactory, Option<RemoteTaskDetails> remoteTaskDetailsOpt) {
        this.dataset_names = dataset_names;
        this.datasetNameToDataSource = datasetNameToDataSource;
        this.anonymizerFactory = anonymizerFactory;
        this.remoteTaskDetailsOpt = remoteTaskDetailsOpt;
        this.datasetNameToRemoteDataStatus = ((IterableOnceOps)dataset_names.map((Function1<String, Tuple2> & Serializable)dataset_name -> {
            Config config = ((ConnectorData)datasetNameToDataSource.apply((String)dataset_name)).config();
            String string2 = Predef$.MODULE$.ArrowAssoc(dataset_name);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, new RemoteDataStatus(config, (String)dataset_name, ((ConnectorData)datasetNameToDataSource.apply((String)dataset_name)).syncType()));
        })).toMap($less$colon$less$.MODULE$.refl());
        this.datasetNameToRemoteAppliedDataStatus = ((IterableOnceOps)((IterableOps)((IterableOps)dataset_names.filter((Function1<String, boolean> & Serializable)dataset_name -> ((ConnectorData)datasetNameToDataSource.apply((String)dataset_name)).target_data_validate_on_startup())).filter((Function1<String, boolean> & Serializable)dataset_name -> ((ConnectorData)datasetNameToDataSource.apply((String)dataset_name)).syncType().doDiff())).map((Function1<String, Tuple2> & Serializable)dataset_name -> {
            Config config = ((ConnectorData)datasetNameToDataSource.apply((String)dataset_name)).config();
            String string2 = Predef$.MODULE$.ArrowAssoc(dataset_name);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, new RemoteDataStatus(config, (String)dataset_name, SyncTypeDiffAllApplied$.MODULE$));
        })).toMap($less$colon$less$.MODULE$.refl());
    }

    public Map<String, RemoteDataStatus> datasetNameToRemoteDataStatus() {
        return this.datasetNameToRemoteDataStatus;
    }

    public Map<String, RemoteDataStatus> datasetNameToRemoteAppliedDataStatus() {
        return this.datasetNameToRemoteAppliedDataStatus;
    }

    public void reportDataConsistencyProblems(String dataset_name, Map<String, byte[]> remoteStatusHashes, Map<String, byte[]> remoteStatusAppliedHashes, int maxSampleSize) {
        Set missingDeletes;
        Set remoteStatusAppliedKeys;
        Set remoteStatusKeys = remoteStatusHashes.keysIterator().toSet();
        Set missingInserts = (Set)remoteStatusKeys.$minus$minus(remoteStatusAppliedKeys = remoteStatusAppliedHashes.keysIterator().toSet());
        if (missingInserts.size() > 0) {
            Connector$.dagr$Connector$$$logger.error(new StringBuilder(60).append("Inserts not applied or other data consistency problem for ").append(dataset_name).append(": ").append(missingInserts.size()).toString());
            ((IterableOnceOps)missingInserts.take(maxSampleSize)).foreach(key2 -> Connector$.dagr$Connector$$$logger.error(new StringBuilder(14).append("  key to ins: ").append((String)key2).toString()));
        }
        if ((missingDeletes = (Set)remoteStatusAppliedKeys.$minus$minus(remoteStatusKeys)).size() > 0) {
            Connector$.dagr$Connector$$$logger.error(new StringBuilder(60).append("Deletes not applied or other data consistency problem for ").append(dataset_name).append(": ").append(missingDeletes.size()).toString());
            ((IterableOnceOps)missingDeletes.take(maxSampleSize)).foreach(key2 -> Connector$.dagr$Connector$$$logger.error(new StringBuilder(14).append("  key to del: ").append((String)key2).toString()));
        }
        IntRef missingUpdatesCount = IntRef.create(0);
        ObjectRef<Nil$> missingUpdatesSample = ObjectRef.create(package$.MODULE$.Nil());
        remoteStatusKeys.foreach(k -> {
            Option h1 = remoteStatusHashes.get((String)k);
            Option h2 = remoteStatusAppliedHashes.get((String)k);
            if (h1.nonEmpty() && h2.nonEmpty() && !Arrays.equals((byte[])h1.get(), (byte[])h2.get())) {
                ++missingUpdatesCount$1.elem;
                if (missingUpdatesCount$1.elem < maxSampleSize) {
                    missingUpdatesSample$1.elem = ((List)missingUpdatesSample$1.elem).$colon$colon(k);
                    return;
                }
                return;
            }
        });
        if (missingUpdatesCount.elem > 0) {
            Connector$.dagr$Connector$$$logger.error(new StringBuilder(60).append("Updates not applied or other data consistency problem for ").append(dataset_name).append(": ").append(missingUpdatesCount.elem).toString());
            ((List)((List)missingUpdatesSample.elem).reverse()).foreach(key2 -> Connector$.dagr$Connector$$$logger.error(new StringBuilder(14).append("  key to upd: ").append((String)key2).toString()));
        }
        if (missingInserts.isEmpty() && missingUpdatesCount.elem == 0 && missingDeletes.isEmpty()) {
            Connector$.dagr$Connector$$$logger.info(new StringBuilder(56).append("Data on target server is consistent with changelist for ").append(dataset_name).toString());
            return;
        }
    }

    public Future<Option<Tuple2<String, UpdateInfo>>> syncAndReportAll(SchedulerInfo schedulerInfo) {
        return this.dataset_names.foldLeft(Future$.MODULE$.successful(None$.MODULE$), (Function2<Future, String, Future> & Serializable)(prevF, dataset_name) -> prevF.flatMap((Function1<Option, Future> & Serializable)_$18 -> {
            DatasetHistory$.MODULE$.setDataset((String)dataset_name);
            return this.report((String)dataset_name, this.syncData((String)dataset_name, schedulerInfo)).andThen(new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    return true;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    DatasetHistory$.MODULE$.setDataset(null);
                    return BoxedUnit.UNIT;
                }
            }, Connector$.MODULE$.ec());
        }, Connector$.MODULE$.ec())).recover(new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                x.printStackTrace();
                throw x;
            }
        }, Connector$.MODULE$.ec());
    }

    public Future<Option<Tuple2<String, UpdateInfo>>> syncData(String dataset_name, SchedulerInfo schedulerInfo) {
        long initialReportAt = Connector$.MODULE$.nextReportAt(Connector$.MODULE$.nextReportAt$default$1());
        ConnectorData connectorData = (ConnectorData)this.datasetNameToDataSource.apply(dataset_name);
        Validator validator = new Validator(connectorData.config(), Connector$.MODULE$.querease());
        boolean isDiffing = connectorData.syncType().doDiff();
        boolean isCheckingTs = connectorData.syncType().checkTs();
        boolean isValidationEnabled = validator.isValidationEnabled(dataset_name);
        Promise finalInfoPromise = Promise$.MODULE$.apply();
        Future finalInfoFuture = finalInfoPromise.future();
        RemoteDataStatus remoteDataStatus = (RemoteDataStatus)this.datasetNameToRemoteDataStatus().apply(dataset_name);
        Option remoteDataStatusAppliedOpt = this.datasetNameToRemoteAppliedDataStatus().get(dataset_name);
        return Future$.MODULE$.apply(() -> this.syncData$$anonfun$1(dataset_name), Connector$.MODULE$.ec()).flatMap((Function1<Flow, Future> & Serializable)maybeAnonymizer -> remoteDataStatus.apply(Connector$.MODULE$.httpClient(), Connector$.MODULE$.stsClient(), Connector$.MODULE$.system(), Connector$.MODULE$.ec()).recover(new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = option.get();
                    throw new RuntimeException("Failed to load remote data status", ex);
                }
                return function1.apply(x);
            }
        }, Connector$.MODULE$.ec()).flatMap((Function1<RemoteDataStatus.Status, Future> & Serializable)remoteStatus -> ((Future)remoteDataStatusAppliedOpt.filter((Function1<RemoteDataStatus, boolean> & Serializable)_$20 -> schedulerInfo.count() == 1).map((Function1<RemoteDataStatus, Future> & Serializable)_$21 -> _$21.apply(Connector$.MODULE$.httpClient(), Connector$.MODULE$.stsClient(), Connector$.MODULE$.system(), Connector$.MODULE$.ec()).recover(new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = option.get();
                    Connector$.dagr$Connector$$$logger.error("Failed to load remote status of applied data", ex);
                    return null;
                }
                return function1.apply(x);
            }
        }, Connector$.MODULE$.ec())).filter((Function1<Future, boolean> & Serializable)_$22 -> _$22 != null).map((Function1<Future, Future> & Serializable)_$23 -> _$23.map(remoteStatusApplied -> this.reportDataConsistencyProblems(dataset_name, remoteStatus.hashes(), remoteStatusApplied.hashes(), 20), Connector$.MODULE$.ec())).getOrElse(Connector::syncData$$anonfun$2$$anonfun$1$$anonfun$5)).flatMap((Function1<BoxedUnit, Future> & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Updater updater = new Updater(connectorData.config(), Connector$.MODULE$.httpClient(), Connector$.MODULE$.stsClient(), dataset_name, lastRecord -> connectorData.onBatchSuccess((Record)lastRecord), Connector$.MODULE$.system(), Connector$.MODULE$.ec());
            UpdateInfo updateInfo2 = UpdateInfo$.MODULE$.apply(UpdateInfo$.MODULE$.$lessinit$greater$default$1(), UpdateInfo$.MODULE$.$lessinit$greater$default$2(), UpdateInfo$.MODULE$.$lessinit$greater$default$3(), UpdateInfo$.MODULE$.$lessinit$greater$default$4(), UpdateInfo$.MODULE$.$lessinit$greater$default$5(), UpdateInfo$.MODULE$.$lessinit$greater$default$6(), UpdateInfo$.MODULE$.$lessinit$greater$default$7());
            Map<String, byte[]> map = remoteStatus.hashes();
            long l = updateInfo2.copy$default$1();
            long l2 = updateInfo2.copy$default$2();
            long l3 = updateInfo2.copy$default$3();
            long l4 = updateInfo2.copy$default$4();
            Map<String, byte[]> map2 = updateInfo2.copy$default$6();
            Record record = updateInfo2.copy$default$7();
            UpdateInfo initialUpdatesState = updateInfo2.copy(l, l2, l3, l4, map, map2, record);
            return connectorData.source(remoteStatus.timestampInfo(), schedulerInfo).flatMap((Function1<Option, Future> & Serializable)_$24 -> (Future)_$24.map((Function1<Tuple2, Future> & Serializable)x$12 -> {
                SourceInfo sourceInfo = (SourceInfo)x$12._1();
                Source source = (Source)x$12._2();
                String fullName = new StringBuilder(0).append(dataset_name).append(Option$.MODULE$.apply(sourceInfo.name()).map((Function1<String, String> & Serializable)n -> new StringBuilder(3).append(" (").append((String)n).append(")").toString()).getOrElse(Connector::$anonfun$3)).append(Option$.MODULE$.apply(sourceInfo.doubleCheckCase()).map((Function1<String, String> & Serializable)dcc -> new StringBuilder(22).append(" [double check case: ").append((String)dcc).append("]").toString()).getOrElse(Connector::$anonfun$5)).toString();
                Tuple2 tuple2 = (Tuple2)((RunnableGraph)((Source)((FlowOps)((SubFlow)((Source)source.via((Graph)maybeAnonymizer)).statefulMap((Function0<UpdateInfo> & Serializable)() -> initialUpdatesState, (Function2<UpdateInfo, Record, Tuple2> & Serializable)(updateInfo, record) -> {
                    if (isValidationEnabled) {
                        validator.validateAndReport(dataset_name, (Record)record);
                    }
                    if (isDiffing) {
                        UpdateInfo updateInfo2;
                        byte[] prev;
                        byte[] byArray;
                        RecordStatus recordStatus;
                        RecordStatus recordStatus2;
                        byte[] hash;
                        byte[] byArray2 = hash = record.value() == null ? (byte[])null : MessageDigest.getInstance("SHA-256").digest(record.value().getBytes("UTF-8"));
                        if (connectorData.report_duplicates()) {
                            updateInfo.sourceHashes().get(record.key()).foreach(previousHash -> {
                                if (Arrays.equals(previousHash, hash)) {
                                    Connector$.dagr$Connector$$$logger.warn(new StringBuilder(35).append("Duplicate identical record for key ").append(record.key()).toString());
                                    return;
                                }
                                Connector$.dagr$Connector$$$logger.warn(new StringBuilder(25).append("Duplicate record for key ").append(record.key()).toString());
                            });
                        }
                        if (Connector$Same$.MODULE$.equals(recordStatus2 = (recordStatus = (RecordStatus)((Object)((byArray = (byte[])updateInfo.remoteHashes().getOrElse(record.key(), Connector::$anonfun$8)) == null ? Connector$Missing$.MODULE$ : (Arrays.equals(prev = byArray, hash) ? Connector$Same$.MODULE$ : Connector$Differs$.MODULE$)))))) {
                            long l = updateInfo.skippedCount() + 1L;
                            String string2 = Predef$.MODULE$.ArrowAssoc(record.key());
                            Map map = (Map)updateInfo.sourceHashes().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, hash));
                            long l2 = updateInfo.copy$default$2();
                            long l3 = updateInfo.copy$default$3();
                            long l4 = updateInfo.copy$default$4();
                            Map<String, byte[]> map2 = updateInfo.copy$default$5();
                            updateInfo2 = updateInfo.copy(l, l2, l3, l4, map2, map, (Record)record);
                        } else {
                            RecordStatus status = recordStatus2;
                            RecordStatus recordStatus3 = status;
                            Connector$Missing$ connector$Missing$ = Connector$Missing$.MODULE$;
                            long l = updateInfo.updatedCount() + (long)(!(recordStatus3 != null ? !recordStatus3.equals(connector$Missing$) : connector$Missing$ != null) ? 0 : 1);
                            RecordStatus recordStatus4 = status;
                            Connector$Missing$ connector$Missing$2 = Connector$Missing$.MODULE$;
                            long l5 = updateInfo.insertedCount() + (long)(!(recordStatus4 != null ? !recordStatus4.equals(connector$Missing$2) : connector$Missing$2 != null) ? 1 : 0);
                            String string3 = Predef$.MODULE$.ArrowAssoc(record.key());
                            Map map = (Map)updateInfo.remoteHashes().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, hash));
                            String string4 = Predef$.MODULE$.ArrowAssoc(record.key());
                            Map map3 = (Map)updateInfo.sourceHashes().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, hash));
                            long l6 = updateInfo.copy$default$1();
                            long l7 = updateInfo.copy$default$4();
                            updateInfo2 = updateInfo.copy(l6, l5, l, l7, map, map3, (Record)record);
                        }
                        UpdateInfo newUpdateInfo = updateInfo2;
                        return Tuple2$.MODULE$.apply(newUpdateInfo, Connector$ConnectorStreamElement$.MODULE$.apply(Connector$DataRecord$.MODULE$, recordStatus, (Record)record, newUpdateInfo));
                    }
                    Connector$Missing$ recordStatus = Connector$Missing$.MODULE$;
                    long l = updateInfo.insertedCount() + (long)(record.value() == null ? 0 : 1);
                    long l8 = updateInfo.deletedCount() + (long)(record.value() == null ? 1 : 0);
                    Map<String, byte[]> map = remoteDataStatus.updatedHashes(updateInfo.remoteHashes(), record.key(), record.value());
                    Map<String, byte[]> map4 = remoteDataStatus.updatedHashes(updateInfo.sourceHashes(), record.key(), record.value());
                    long l9 = updateInfo.copy$default$1();
                    long l10 = updateInfo.copy$default$3();
                    UpdateInfo newUpdateInfo = updateInfo.copy(l9, l, l10, l8, map, map4, (Record)record);
                    return Tuple2$.MODULE$.apply(newUpdateInfo, Connector$ConnectorStreamElement$.MODULE$.apply(Connector$DataRecord$.MODULE$, recordStatus, (Record)record, newUpdateInfo));
                }, (Function1<UpdateInfo, Option> & Serializable)updateInfo -> Some$.MODULE$.apply(Connector$ConnectorStreamElement$.MODULE$.apply(Connector$AfterDataRecords$.MODULE$, null, null, (UpdateInfo)updateInfo))).mapConcat((Function1<ConnectorStreamElement, IterableOnce> & Serializable)element -> {
                    IterableOnce<Object> iterableOnce;
                    ConnectorStreamEvent connectorStreamEvent = element.event();
                    if (Connector$DataRecord$.MODULE$.equals(connectorStreamEvent)) {
                        iterableOnce = new $colon$colon<Nothing$>((Nothing$)((Object)element), Nil$.MODULE$);
                    } else if (Connector$AfterDataRecords$.MODULE$.equals(connectorStreamEvent)) {
                        if (isDiffing && !isCheckingTs) {
                            ObjectRef<UpdateInfo> newUpdateInfo = ObjectRef.create(element.updateInfo());
                            Set<String> unpaired = remoteStatus.keysNotIn(element.updateInfo().sourceHashes().keySet());
                            if (unpaired.nonEmpty() && !connectorData.delete_unpaired_records()) {
                                Connector$.dagr$Connector$$$logger.info(new StringBuilder(41).append("Automatic deletes disabled. Not deleted: ").append(unpaired.size()).toString());
                                iterableOnce = package$.MODULE$.Nil();
                            } else {
                                String string2 = dataset_name;
                                String string3 = "config";
                                iterableOnce = !(string2 != null ? !string2.equals(string3) : string3 != null) ? package$.MODULE$.Nil() : unpaired.iterator().map((Function1<String, ConnectorStreamElement> & Serializable)unpairedKey -> {
                                    UpdateInfo updateInfo = (UpdateInfo)newUpdateInfo$1.elem;
                                    Map map = (Map)((UpdateInfo)newUpdateInfo$1.elem).remoteHashes().$minus((String)unpairedKey);
                                    long l = ((UpdateInfo)newUpdateInfo$1.elem).deletedCount() + 1L;
                                    long l2 = updateInfo.copy$default$1();
                                    long l3 = updateInfo.copy$default$2();
                                    long l4 = updateInfo.copy$default$3();
                                    Map<String, byte[]> map2 = updateInfo.copy$default$6();
                                    Record record = updateInfo.copy$default$7();
                                    newUpdateInfo$1.elem = updateInfo.copy(l2, l3, l4, l, map, map2, record);
                                    return Connector$ConnectorStreamElement$.MODULE$.apply(Connector$DataRecord$.MODULE$, Connector$Excess$.MODULE$, Record$.MODULE$.apply((String)unpairedKey, null, null, Record$.MODULE$.$lessinit$greater$default$4(), Record$.MODULE$.$lessinit$greater$default$5()), (UpdateInfo)newUpdateInfo$1.elem);
                                });
                            }
                        } else {
                            iterableOnce = package$.MODULE$.Nil();
                        }
                    } else {
                        ConnectorStreamEvent x = connectorStreamEvent;
                        throw scala.sys.package$.MODULE$.error(new StringBuilder(25).append("Unexpected element type: ").append(x).toString());
                    }
                    return iterableOnce;
                }).alsoTo(Sink$.MODULE$.fold(BoxesRunTime.boxToLong(initialReportAt), (Function2<Object, Object, long> & Serializable)(reportAt, record) -> Connector.reportProgress$1(sourceInfo, connectorData, fullName, isDiffing, BoxesRunTime.unboxToLong(reportAt), ((ConnectorStreamElement)record).updateInfo()))).alsoTo(((Flow)Flow$.MODULE$.apply().statefulMap((Function0<UpdateInfo> & Serializable)() -> initialUpdatesState, (Function2<UpdateInfo, ConnectorStreamElement, Tuple2> & Serializable)(updateInfo, record) -> Tuple2$.MODULE$.apply(record.updateInfo(), record), (Function1<UpdateInfo, Option> & Serializable)updateInfo -> {
                    finalInfoPromise.complete(Success$.MODULE$.apply(Some$.MODULE$.apply(updateInfo)));
                    return None$.MODULE$;
                }).recover(new Serializable(finalInfoPromise){
                    private final Promise finalInfoPromise$7;
                    {
                        this.finalInfoPromise$7 = finalInfoPromise$8;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        if (throwable != null) {
                            Throwable e = throwable;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable != null) {
                            Throwable e = throwable;
                            return this.finalInfoPromise$7.complete(Failure$.MODULE$.apply(e));
                        }
                        return function1.apply(x);
                    }
                })).to(Sink$.MODULE$.ignore())).filter((Function1<ConnectorStreamElement, boolean> & Serializable)_$27 -> {
                    RecordStatus recordStatus = _$27.status();
                    Connector$Same$ connector$Same$ = Connector$Same$.MODULE$;
                    return recordStatus == null ? connector$Same$ != null : !recordStatus.equals(connector$Same$);
                }).mapAsync(1, (Function1<ConnectorStreamElement, Future> & Serializable)element -> FileHandler$.MODULE$.uploadAttachments(Connector$.MODULE$.fileHandlerTools(), dataset_name, element.record(), connectorData.dry_run(), Connector$.MODULE$.system(), Connector$.MODULE$.ec()).map((Function1<Seq, ConnectorStreamElement> & Serializable)_$28 -> element, Connector$.MODULE$.ec())).keepAlive(Connector$.MODULE$.http_conn_max_idle_timeout(), (Function0<ConnectorStreamElement> & Serializable)() -> Connector$.MODULE$.BatchEndElement()).statefulMapConcat((Function0<Function1> & Serializable)() -> {
                    BooleanRef inBatch = BooleanRef.create(false);
                    LongRef nextBatchTime = LongRef.create(0L);
                    return (Function1<ConnectorStreamElement, IterableOnce> & Serializable)element -> {
                        ConnectorStreamElement connectorStreamElement = element;
                        ConnectorStreamElement connectorStreamElement2 = Connector$.MODULE$.BatchEndElement();
                        if (!(connectorStreamElement != null ? !((Object)connectorStreamElement).equals(connectorStreamElement2) : connectorStreamElement2 != null)) {
                            inBatch$1.elem = false;
                            return package$.MODULE$.Nil().$colon$colon(Connector$.MODULE$.BatchEndElement());
                        }
                        if (inBatch$1.elem) {
                            if (nextBatchTime$1.elem <= System.currentTimeMillis()) {
                                inBatch$1.elem = false;
                                return package$.MODULE$.Nil().$colon$colon(Connector$.MODULE$.BatchEndElement()).$colon$colon(element);
                            }
                            return package$.MODULE$.Nil().$colon$colon(element);
                        }
                        inBatch$1.elem = true;
                        nextBatchTime$1.elem = System.currentTimeMillis() + connectorData.batch_interval_ms();
                        return package$.MODULE$.Nil().$colon$colon(element);
                    };
                }).splitWhen((Function1<ConnectorStreamElement, boolean> & Serializable)_$29 -> {
                    ConnectorStreamElement connectorStreamElement = _$29;
                    ConnectorStreamElement connectorStreamElement2 = Connector$.MODULE$.BatchEndElement();
                    return !(connectorStreamElement != null ? !((Object)connectorStreamElement).equals(connectorStreamElement2) : connectorStreamElement2 != null);
                }).filter((Function1<ConnectorStreamElement, boolean> & Serializable)_$30 -> {
                    ConnectorStreamElement connectorStreamElement = _$30;
                    ConnectorStreamElement connectorStreamElement2 = Connector$.MODULE$.BatchEndElement();
                    return connectorStreamElement == null ? connectorStreamElement2 != null : !((Object)connectorStreamElement).equals(connectorStreamElement2);
                }).prefixAndTail(1).mapAsync(1, (Function1<Tuple2, Future> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Seq prefix = (Seq)tuple2._1();
                        Source tail = (Source)tuple2._2();
                        if (prefix.size() > 0) {
                            ObjectRef<Object> lastEl = ObjectRef.create(null);
                            Source subSource = (Source)Source$.MODULE$.apply(prefix).concat((Graph)tail).concat(Source$.MODULE$.apply(package$.MODULE$.Nil().$colon$colon(Connector$.MODULE$.BatchEndElement()))).statefulMapConcat((Function0<Function1> & Serializable)() -> {
                                ObjectRef<Object> last = ObjectRef.create(null);
                                return (Function1<ConnectorStreamElement, IterableOnce> & Serializable)element -> {
                                    ConnectorStreamElement connectorStreamElement = element;
                                    ConnectorStreamElement connectorStreamElement2 = Connector$.MODULE$.BatchEndElement();
                                    if (!(connectorStreamElement != null ? !((Object)connectorStreamElement).equals(connectorStreamElement2) : connectorStreamElement2 != null)) {
                                        Connector.setLast$1(prefix, lastEl, (ConnectorStreamElement)last$1.elem);
                                        return package$.MODULE$.Nil();
                                    }
                                    last$1.elem = element;
                                    return package$.MODULE$.Nil().$colon$colon(element);
                                };
                            }).map((Function1<ConnectorStreamElement, Record> & Serializable)element -> {
                                Record record = element.record();
                                Connector$.dagr$Connector$$$dataLogger.debug(Connector.dataMessage$1(record));
                                return record;
                            });
                            if (!connectorData.dry_run()) {
                                return updater.update(subSource).andThen(new Serializable((RemoteDataStatus.Status)remoteStatus, updater, remoteDataStatus, prefix, lastEl, this){
                                    private final RemoteDataStatus.Status remoteStatus$8;
                                    private final Updater updater$4;
                                    private final RemoteDataStatus remoteDataStatus$8;
                                    private final Seq prefix$4;
                                    private final ObjectRef lastEl$4;
                                    {
                                        this.remoteStatus$8 = remoteStatus$9;
                                        this.updater$4 = updater$5;
                                        this.remoteDataStatus$8 = remoteDataStatus$9;
                                        this.prefix$4 = prefix$6;
                                        this.lastEl$4 = lastEl$6;
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                    }

                                    public final boolean isDefinedAt(Try x) {
                                        Try try_ = x;
                                        if (try_ instanceof Success) {
                                            return true;
                                        }
                                        return try_ instanceof Failure;
                                    }

                                    public final Object applyOrElse(Try x, Function1 function1) {
                                        Try try_ = x;
                                        if (try_ instanceof Success) {
                                            ConnectorStreamElement last = Connector.dagr$Connector$$_$getLast$1(this.prefix$4, this.lastEl$4);
                                            this.remoteStatus$8.setStatus(last.updateInfo().remoteHashes(), Option$.MODULE$.apply(last.updateInfo().srcLastRecord()).map(Connector::dagr$Connector$$anon$6$$_$applyOrElse$$anonfun$1));
                                            return BoxedUnit.UNIT;
                                        }
                                        if (try_ instanceof Failure) {
                                            if (this.updater$4.incompleteOrFailedUpdates()) {
                                                this.remoteDataStatus$8.clear();
                                                return BoxedUnit.UNIT;
                                            }
                                            return BoxedUnit.UNIT;
                                        }
                                        return function1.apply(x);
                                    }

                                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{dagr$Connector$$anon$6$$_$applyOrElse$$anonfun$1(dagr.Record )}, serializedLambda);
                                    }
                                }, Connector$.MODULE$.ec());
                            }
                            return subSource.runWith(Sink$.MODULE$.ignore(), Materializer$.MODULE$.matFromSystem(Connector$.MODULE$.system()));
                        }
                        return tail.runWith(Sink$.MODULE$.ignore(), Materializer$.MODULE$.matFromSystem(Connector$.MODULE$.system()));
                    }
                    throw new MatchError(tuple2);
                })).mergeSubstreams()).recover(new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        if (throwable != null) {
                            Throwable e = throwable;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable != null) {
                            Throwable e = throwable;
                            throw e;
                        }
                        return function1.apply(x);
                    }
                })).toMat(Sink$.MODULE$.ignore(), Keep$.MODULE$.both())).run(Materializer$.MODULE$.matFromSystem(Connector$.MODULE$.system()));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Function1 sourceCallback = (Function1)tuple2._1();
                Future doneF = (Future)tuple2._2();
                Tuple2<Function1, Future> tuple22 = Tuple2$.MODULE$.apply(sourceCallback, doneF);
                ObjectRef<Function1> sourceCallback2 = ObjectRef.create(tuple22._1());
                Future doneF2 = tuple22._2();
                return doneF2.flatMap((Function1<Done, Future> & Serializable)_$31 -> finalInfoFuture, Connector$.MODULE$.ec()).map((Function1<Option, Option> & Serializable)_$32 -> _$32.map((Function1<UpdateInfo, Tuple2> & Serializable)_$33 -> Tuple2$.MODULE$.apply(sourceInfo.name(), _$33)), Connector$.MODULE$.ec()).andThen(new Serializable(sourceCallback2){
                    private final ObjectRef sourceCallback$1;
                    {
                        this.sourceCallback$1 = sourceCallback$2;
                    }

                    public final boolean isDefinedAt(Try x) {
                        Try try_ = x;
                        if (try_ instanceof Success) {
                            Success succ = (Success)try_;
                            return true;
                        }
                        if (try_ instanceof Failure) {
                            Failure fail = (Failure)try_;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Try x, Function1 function1) {
                        Try try_ = x;
                        if (try_ instanceof Success) {
                            Success succ = (Success)try_;
                            return ((Function1)this.sourceCallback$1.elem).apply(succ);
                        }
                        if (try_ instanceof Failure) {
                            Failure fail = (Failure)try_;
                            return ((Function1)this.sourceCallback$1.elem).apply(fail);
                        }
                        return function1.apply(x);
                    }
                }, Connector$.MODULE$.ec());
            }).getOrElse(Connector::syncData$$anonfun$2$$anonfun$1$$anonfun$6$$anonfun$1$$anonfun$2), Connector$.MODULE$.ec()).map((Function1<Option, Option> & Serializable)updateInfo -> updateInfo, Connector$.MODULE$.ec());
        }, Connector$.MODULE$.ec()), Connector$.MODULE$.ec()), Connector$.MODULE$.ec());
    }

    private Future<Option<Tuple2<String, UpdateInfo>>> report(String dataset_name, Future<Option<Tuple2<String, UpdateInfo>>> resultF) {
        return resultF.transformWith((Function1<Try, Future> & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Option option;
                Option option2 = (Option)((Success)try_).value();
                if (option2 instanceof Some && !(option = Some$.MODULE$.unapply((Some)option2)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option.get();
                    String sourceName = (String)tuple2._1();
                    UpdateInfo result = (UpdateInfo)tuple2._2();
                    ConnectorData connectorData = (ConnectorData)this.datasetNameToDataSource.apply(dataset_name);
                    boolean isDiffing = connectorData.syncType().doDiff();
                    String syncOrFake = connectorData.syncOrFake();
                    String fullName = new StringBuilder(0).append(dataset_name).append(Option$.MODULE$.apply(sourceName).map((Function1<String, String> & Serializable)n -> new StringBuilder(3).append(" (").append((String)n).append(")").toString()).getOrElse(Connector::$anonfun$25)).toString();
                    String message = new StringBuilder(16).append(syncOrFake).append(" done ").append(fullName).append(": ").append(result.render(isDiffing)).append(" (ver. ").append(Connector$.dagr$Connector$$$version).append(")").toString();
                    Connector$.dagr$Connector$$$logger.info(message);
                    return Connector.completeAll$1(this.reportRemoteTaskStatus$1("izpild\u012bts", message), Reporter$.MODULE$.reportSuccess(dataset_name, message)).transformWith((Function1<Try, Future> & Serializable)_$34 -> resultF, Connector$.MODULE$.ec());
                }
                if (None$.MODULE$.equals(option2)) {
                    String message = new StringBuilder(24).append("No new data to sync for ").append(dataset_name).toString();
                    Connector$.dagr$Connector$$$logger.debug(message);
                    return Connector.completeAll$1(this.reportRemoteTaskStatus$1("izpild\u012bts", message), Reporter$.MODULE$.reportSuccess(dataset_name, message)).transformWith((Function1<Try, Future> & Serializable)_$35 -> resultF, Connector$.MODULE$.ec());
                }
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                Connector$.dagr$Connector$$$logger.error(ex.getMessage(), ex);
                return Connector.completeAll$1(this.reportRemoteTaskStatus$1("k\u013c\u016bda", ex.getMessage()), Reporter$.MODULE$.reportFailure(dataset_name, ex.getMessage(), false)).transformWith((Function1<Try, Future> & Serializable)_$36 -> resultF, Connector$.MODULE$.ec());
            }
            throw new MatchError(try_);
        }, Connector$.MODULE$.ec());
    }

    private static final Flow syncData$$anonfun$1$$anonfun$1() {
        return Flow$.MODULE$.apply();
    }

    private final Flow syncData$$anonfun$1(String dataset_name$2) {
        return (Flow)this.anonymizerFactory.apply(dataset_name$2).getOrElse(Connector::syncData$$anonfun$1$$anonfun$1);
    }

    private static final void syncData$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1() {
    }

    private static final Future syncData$$anonfun$2$$anonfun$1$$anonfun$5() {
        return Future$.MODULE$.apply((Function0<Object> & Serializable)() -> {
            Connector.syncData$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1();
            return BoxedUnit.UNIT;
        }, Connector$.MODULE$.ec());
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final void reportProgress$1$$anonfun$3(ConnectorData connectorData$9, String fullName$3, UpdateInfo updateInfo$3, boolean isDiffing$8) {
        Connector$.dagr$Connector$$$progress.info(new StringBuilder(16).append(connectorData$9.syncOrFake()).append(" progress for ").append(fullName$3).append(": ").append(updateInfo$3.render(isDiffing$8)).toString());
    }

    private static final long reportProgress$1(SourceInfo sourceInfo$1, ConnectorData connectorData$7, String fullName$1, boolean isDiffing$6, long reportAt, UpdateInfo updateInfo) {
        if (reportAt <= System.currentTimeMillis()) {
            Option$.MODULE$.apply(sourceInfo$1.doubleCheckCase()).filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)_$25 -> updateInfo.insertedCount() + updateInfo.updatedCount() + updateInfo.deletedCount() > 0L).map(_$26 -> Connector$.dagr$Connector$$$progress.warn(new StringBuilder(16).append(connectorData$7.syncOrFake()).append(" progress for ").append(fullName$1).append(": ").append(updateInfo.render(isDiffing$6)).toString())).getOrElse((Function0<Object> & Serializable)() -> {
                Connector.reportProgress$1$$anonfun$3(connectorData$7, fullName$1, updateInfo, isDiffing$6);
                return BoxedUnit.UNIT;
            });
            return Connector$.MODULE$.nextReportAt(reportAt);
        }
        return reportAt;
    }

    private static final byte[] $anonfun$8() {
        return null;
    }

    private static final void setLast$1(Seq prefix$1, ObjectRef lastEl$1, ConnectorStreamElement el) {
        Object a = prefix$1.head();
        synchronized (a) {
            lastEl$1.elem = el;
        }
    }

    public static final ConnectorStreamElement dagr$Connector$$_$getLast$1(Seq prefix$2, ObjectRef lastEl$2) {
        ConnectorStreamElement connectorStreamElement;
        Object a = prefix$2.head();
        synchronized (a) {
            connectorStreamElement = (ConnectorStreamElement)lastEl$2.elem;
        }
        return connectorStreamElement;
    }

    private static final String dataMessage$1(Record record$2) {
        if (record$2.timestamp() == null) {
            return new StringBuilder(10).append("k = ").append(record$2.key()).append(", v = ").append(record$2.value()).toString();
        }
        return new StringBuilder(16).append("t = ").append(record$2.timestamp()).append(", k = ").append(record$2.key()).append(", v = ").append(record$2.value()).toString();
    }

    public static final /* synthetic */ RemoteRecordTimestampInfo dagr$Connector$$anon$6$$_$applyOrElse$$anonfun$1(Record srcLastRecord) {
        return RemoteRecordTimestampInfo$.MODULE$.apply(srcLastRecord.key(), -1L, srcLastRecord.timestamp());
    }

    private static final Future syncData$$anonfun$2$$anonfun$1$$anonfun$6$$anonfun$1$$anonfun$2() {
        return Future$.MODULE$.successful(None$.MODULE$);
    }

    private static final Future reportRemoteTaskStatus$1$$anonfun$2() {
        return Future$.MODULE$.successful(BoxedUnit.UNIT);
    }

    private final Future reportRemoteTaskStatus$1(String status, String message) {
        return (Future)this.remoteTaskDetailsOpt.map((Function1<RemoteTaskDetails, Future> & Serializable)rt -> {
            if (Connector$.MODULE$.isRemoteAnonymizer()) {
                return Connector$.MODULE$.remoteAnonymizerTask().setStatus(Connector$.MODULE$.httpClient(), Connector$.MODULE$.stsClient(), rt.taskKey(), status, message, Connector$.MODULE$.system(), Connector$.MODULE$.ec());
            }
            if (Connector$.MODULE$.isRemoteDataImport()) {
                return Connector$.MODULE$.remoteDataImportTask().setStatus(Connector$.MODULE$.httpClient(), Connector$.MODULE$.stsClient(), rt.taskKey(), status, message, Connector$.MODULE$.system(), Connector$.MODULE$.ec());
            }
            return Future$.MODULE$.successful(BoxedUnit.UNIT);
        }).getOrElse(Connector::reportRemoteTaskStatus$1$$anonfun$2);
    }

    private static final Future completeAll$1(Future f1, Future f2) {
        Future<Object> recovered1 = f1.recover(new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return BoxedUnit.UNIT;
            }
        }, Connector$.MODULE$.ec());
        Future<Object> recovered2 = f2.recover(new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return BoxedUnit.UNIT;
            }
        }, Connector$.MODULE$.ec());
        return recovered1.flatMap((Function1<Object, Future> & Serializable)x$12 -> {
            Object object = x$12;
            return recovered2.map(x$1 -> {
                Object object = x$1;
            }, Connector$.MODULE$.ec());
        }, Connector$.MODULE$.ec());
    }

    private static final String $anonfun$25() {
        return "";
    }

    public static final class ConnectorStreamElement
    implements Product,
    Serializable {
        private final ConnectorStreamEvent event;
        private final RecordStatus status;
        private final Record record;
        private final UpdateInfo updateInfo;

        public static ConnectorStreamElement apply(ConnectorStreamEvent connectorStreamEvent, RecordStatus recordStatus, Record record, UpdateInfo updateInfo) {
            return Connector$ConnectorStreamElement$.MODULE$.apply(connectorStreamEvent, recordStatus, record, updateInfo);
        }

        public static ConnectorStreamElement fromProduct(Product product) {
            return Connector$ConnectorStreamElement$.MODULE$.fromProduct(product);
        }

        public static ConnectorStreamElement unapply(ConnectorStreamElement connectorStreamElement) {
            return Connector$ConnectorStreamElement$.MODULE$.unapply(connectorStreamElement);
        }

        public ConnectorStreamElement(ConnectorStreamEvent event, RecordStatus status, Record record, UpdateInfo updateInfo) {
            this.event = event;
            this.status = status;
            this.record = record;
            this.updateInfo = updateInfo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConnectorStreamElement)) return false;
            ConnectorStreamElement connectorStreamElement = (ConnectorStreamElement)object;
            ConnectorStreamEvent connectorStreamEvent = this.event();
            ConnectorStreamEvent connectorStreamEvent2 = connectorStreamElement.event();
            if (connectorStreamEvent == null) {
                if (connectorStreamEvent2 != null) {
                    return false;
                }
            } else if (!connectorStreamEvent.equals(connectorStreamEvent2)) return false;
            RecordStatus recordStatus = this.status();
            RecordStatus recordStatus2 = connectorStreamElement.status();
            if (recordStatus == null) {
                if (recordStatus2 != null) {
                    return false;
                }
            } else if (!recordStatus.equals(recordStatus2)) return false;
            Record record = this.record();
            Record record2 = connectorStreamElement.record();
            if (record == null) {
                if (record2 != null) {
                    return false;
                }
            } else if (!((Object)record).equals(record2)) return false;
            UpdateInfo updateInfo = this.updateInfo();
            UpdateInfo updateInfo2 = connectorStreamElement.updateInfo();
            if (updateInfo == null) {
                if (updateInfo2 == null) return true;
                return false;
            } else {
                if (!((Object)updateInfo).equals(updateInfo2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ConnectorStreamElement;
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "ConnectorStreamElement";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "event";
                }
                case 1: {
                    return "status";
                }
                case 2: {
                    return "record";
                }
                case 3: {
                    return "updateInfo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ConnectorStreamEvent event() {
            return this.event;
        }

        public RecordStatus status() {
            return this.status;
        }

        public Record record() {
            return this.record;
        }

        public UpdateInfo updateInfo() {
            return this.updateInfo;
        }

        public ConnectorStreamElement copy(ConnectorStreamEvent event, RecordStatus status, Record record, UpdateInfo updateInfo) {
            return new ConnectorStreamElement(event, status, record, updateInfo);
        }

        public ConnectorStreamEvent copy$default$1() {
            return this.event();
        }

        public RecordStatus copy$default$2() {
            return this.status();
        }

        public Record copy$default$3() {
            return this.record();
        }

        public UpdateInfo copy$default$4() {
            return this.updateInfo();
        }

        public ConnectorStreamEvent _1() {
            return this.event();
        }

        public RecordStatus _2() {
            return this.status();
        }

        public Record _3() {
            return this.record();
        }

        public UpdateInfo _4() {
            return this.updateInfo();
        }
    }

    public static interface ConnectorStreamEvent {
    }

    public static interface RecordStatus {
    }
}

