/*
 * Decompiled with CFR 0.152.
 */
package dagr;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueType;
import dagr.ApiParvaldnieks;
import dagr.Connector;
import dagr.Connector$;
import dagr.Connector$AfterDataRecords$;
import dagr.Connector$BatchEnd$;
import dagr.Connector$ConnectorStreamElement$;
import dagr.Connector$DataRecord$;
import dagr.Connector$Differs$;
import dagr.Connector$Excess$;
import dagr.Connector$Missing$;
import dagr.Connector$Same$;
import dagr.Connector$Tick$;
import dagr.ConnectorData;
import dagr.ConnectorQuerease;
import dagr.DagrLogbackEvents$;
import dagr.DataAnonymizer;
import dagr.DataAnonymizer$;
import dagr.DataFromConfig;
import dagr.DataFromCsv;
import dagr.DataFromCsv$;
import dagr.DataFromDagr;
import dagr.DataFromDagrDataImportFile;
import dagr.DataFromFpr;
import dagr.DataFromFprClassifiers;
import dagr.DataFromJdbc;
import dagr.DataFromJson;
import dagr.DataFromRandom;
import dagr.DataFromUr;
import dagr.DataFromUrWithFileUpload;
import dagr.DataFromVdeavk;
import dagr.DataFromVirsis;
import dagr.DataFromVirsisAttr;
import dagr.DataFromVzd;
import dagr.DataFromXml;
import dagr.DataImportTaskQuerease;
import dagr.DataToJdbc;
import dagr.DbAccess;
import dagr.FileHandlerTools;
import dagr.HttpClient;
import dagr.InfoToDagr;
import dagr.Record;
import dagr.RemoteAnonymizerTask;
import dagr.RemoteAnonymizerTaskDetails;
import dagr.RemoteDataImportTask;
import dagr.RemoteDataImportTaskByStatus;
import dagr.RemoteDataImportTaskDetails;
import dagr.Renderer;
import dagr.Renderer$;
import dagr.ResourceAccessGuard$;
import dagr.SchedulerInfo;
import dagr.SchedulerInfo$;
import dagr.SecurityTokenServiceClient;
import dagr.Uploader;
import dagr.YamlAnonymizerRulesLoader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.util.Date;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.extension.quartz.MessageRequireFireTime$;
import org.apache.pekko.extension.quartz.MessageWithFireTime;
import org.apache.pekko.extension.quartz.MessageWithFireTime$;
import org.apache.pekko.extension.quartz.QuartzSchedulerExtension;
import org.apache.pekko.extension.quartz.QuartzSchedulerExtension$;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.mojoz.metadata.in.YamlMd$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.Try$;
import scala.util.boundary;
import scala.util.boundary$;
import scala.util.control.NonFatal$;

public final class Connector$
implements Serializable {
    public static final Connector$Tick$ Tick;
    public static final Connector$DataRecord$ DataRecord;
    public static final Connector$AfterDataRecords$ AfterDataRecords;
    public static final Connector$BatchEnd$ BatchEnd;
    public static final Connector$Same$ Same;
    public static final Connector$Missing$ Missing;
    public static final Connector$Differs$ Differs;
    public static final Connector$Excess$ Excess;
    public static final Connector$ConnectorStreamElement$ ConnectorStreamElement;
    private static final Connector.ConnectorStreamElement BatchEndElement;
    public static final Logger dagr$Connector$$$logger;
    public static final String dagr$Connector$$$version;
    private static final Config mainConfig;
    public static final Logger dagr$Connector$$$dataLogger;
    public static final Logger dagr$Connector$$$progress;
    private static final ActorSystem system;
    private static final ExecutionContext ec;
    private static final long progress_report_interval_ms;
    private static final String datasource_type;
    private static final FiniteDuration http_conn_max_idle_timeout;
    private static final boolean logToDagrPrintDebug;
    private static final HttpClient httpClient;
    private static final SecurityTokenServiceClient stsClient;
    private static final InfoToDagr infoToDagr;
    private static final ConnectorQuerease querease;
    private static final boolean isRemoteAnonymizer;
    private static final boolean isRemoteDataImport;
    private static final String CfgDs;
    private static final Seq<String> all_dataset_names;
    private volatile Object remoteAnonymizerTask$lzy1;
    private volatile Object remoteDataImportTask$lzy1;
    private volatile Object uploader$lzy1;
    private volatile Object apiParvaldnieks$lzy1;
    private volatile Object dbAccess$lzy1;
    private volatile Object fileHandlerTools$lzy1;
    private static final Map<String, ConnectorData> mainDatasetNameToDataSource;
    private static final YamlAnonymizerRulesLoader yamlAnonymizerRulesLoader;
    private static final Connector mainConnector;
    public static final Connector$ MODULE$;

    private Connector$() {
    }

    static {
        Seq seq;
        MODULE$ = new Connector$();
        BatchEndElement = Connector$ConnectorStreamElement$.MODULE$.apply(Connector$BatchEnd$.MODULE$, null, null, null);
        String dagrConnectorLoggerName = "dagr.connector";
        dagr$Connector$$$logger = LoggerFactory.getLogger(dagrConnectorLoggerName);
        dagr$Connector$$$version = (String)Try$.MODULE$.apply(MODULE$::$init$$$anonfun$9).toOption().map((Function1<String, String> & Serializable)_$2 -> _$2.trim()).filter((Function1<String, boolean> & Serializable)_$3 -> {
            String string2 = _$3;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        }).map((Function1<String, String> & Serializable)version -> {
            Seq<String> seq;
            Option<Seq<String>> option;
            dagr$Connector$$$logger.info(new StringBuilder(24).append("DAGR connector version: ").append((String)version).toString());
            String string2 = version;
            if (string2 != null && !(option = StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"", " (", ")"})).s().unapplySeq(string2)).isEmpty() && (seq = option.get()).lengthCompare(2) == 0) {
                String string3 = (String)seq.apply(false);
                String string4 = (String)seq.apply(true);
                String ver = string3;
                return ver;
            }
            return "?.?.?";
        }).getOrElse(MODULE$::$init$$$anonfun$13);
        mainConfig = ConfigFactory.load();
        dagr$Connector$$$dataLogger = LoggerFactory.getLogger("dagr.data");
        String progressLoggerName = "dagr.progress";
        DagrLogbackEvents$.MODULE$.init((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{dagrConnectorLoggerName, progressLoggerName})), mainConfig.getString("input-files"));
        dagr$Connector$$$progress = LoggerFactory.getLogger(progressLoggerName);
        system = ActorSystem$.MODULE$.apply("connector");
        ec = MODULE$.system().dispatcher();
        progress_report_interval_ms = mainConfig.getDuration("progress_report_interval").toMillis();
        ConfigValueType configValueType = mainConfig.getValue("dataset_names").valueType();
        ConfigValueType configValueType2 = ConfigValueType.STRING;
        if (!(configValueType != null ? !((Object)((Object)configValueType)).equals((Object)configValueType2) : configValueType2 != null)) {
            Object object = Predef$.MODULE$.refArrayOps(mainConfig.getString("dataset_names").split("[\\s,]"));
            seq = (Seq)ArrayOps$.MODULE$.toSeq$extension(object).filter((Function1<String, boolean> & Serializable)_$4 -> {
                String string2 = _$4;
                String string3 = "";
                return string2 == null ? string3 != null : !string2.equals(string3);
            });
        } else {
            seq = CollectionConverters$.MODULE$.ListHasAsScala(mainConfig.getStringList("dataset_names")).asScala().toList();
        }
        List main_dataset_names = seq;
        datasource_type = mainConfig.getString("datasource_type");
        http_conn_max_idle_timeout = Duration$.MODULE$.fromNanos(mainConfig.getDuration("pekko.http.client.idle-timeout").toNanos()).$minus(Duration$.MODULE$.apply(100L, package$.MODULE$.MILLISECONDS()));
        logToDagrPrintDebug = Option$.MODULE$.apply("pekko.quartz.schedules.logToDagr.printDebug").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> mainConfig.hasPath((String)x$0)).exists((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> mainConfig.getBoolean((String)x$0));
        httpClient = new HttpClient(MODULE$.system(), MODULE$.ec());
        stsClient = new SecurityTokenServiceClient(mainConfig, "provider", MODULE$.httpClient(), MODULE$.system(), MODULE$.ec());
        infoToDagr = new InfoToDagr(mainConfig, MODULE$.httpClient(), MODULE$.stsClient(), MODULE$.system(), MODULE$.ec());
        querease = new ConnectorQuerease(mainConfig);
        if (main_dataset_names.isEmpty()) {
            throw new RuntimeException("No dataset_names configured");
        }
        isRemoteAnonymizer = main_dataset_names.contains("[remote_anonymizer_task]");
        if (MODULE$.isRemoteAnonymizer() && main_dataset_names.sizeCompare(1) > 0) {
            throw new RuntimeException("No other dataset names should be configured for remote anonymizer");
        }
        isRemoteDataImport = main_dataset_names.contains("[remote_data_import_task]");
        if (MODULE$.isRemoteDataImport() && main_dataset_names.sizeCompare(1) > 0) {
            throw new RuntimeException("No other dataset names should be configured for remote data import");
        }
        CfgDs = "connector_config";
        all_dataset_names = (Seq)((IterableOps)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.CfgDs()), Nil$.MODULE$)).filter((Function1<String, boolean> & Serializable)_$5 -> mainConfig.getBoolean("report_status.connector_config"))).$plus$plus(main_dataset_names);
        mainDatasetNameToDataSource = ((IterableOnceOps)MODULE$.all_dataset_names().map((Function1<String, Tuple2> & Serializable)dataset_name -> {
            ConnectorData connectorData;
            block30: {
                String string2;
                String view_name;
                Config config;
                block31: {
                    String string3;
                    config = this.datasetConfig(mainConfig, (String)dataset_name);
                    if (dataset_name.startsWith("sandbox/")) {
                        Object object = Predef$.MODULE$.refArrayOps(dataset_name.split("/"));
                        string3 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.drop$extension(object, 2)).mkString("/");
                    } else {
                        string3 = dataset_name.split("/")[0];
                    }
                    view_name = string3;
                    string2 = config.getString("datasource_type");
                    String string4 = dataset_name;
                    String string5 = this.CfgDs();
                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block31;
                    connectorData = new DataFromConfig(config, this.system(), this.ec());
                    break block30;
                }
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1908232785: {
                        if (!"urSpousalPropertyRelation".equals(string2)) break;
                        connectorData = new DataFromUr(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                    case -1419061424: {
                        if (!"urForeignLe".equals(string2)) break;
                        connectorData = new DataFromUr(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                    case -938285885: {
                        if (!"random".equals(string2)) break;
                        connectorData = new DataFromRandom(config, view_name);
                        break block30;
                    }
                    case -837641448: {
                        if (!"urNpLe".equals(string2)) break;
                        connectorData = new DataFromUr(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                    case -821269505: {
                        if (!"vdeavk".equals(string2)) break;
                        connectorData = new DataFromVdeavk(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                    case -816247714: {
                        if (!"virsis".equals(string2)) break;
                        String string6 = dataset_name;
                        if ("data_access_control".equals(string6)) {
                            connectorData = new DataFromVirsis(config, this.querease(), this.apiParvaldnieks(), this.httpClient(), this.system(), this.ec());
                            break block30;
                        } else {
                            if (!"virsis_dagr_dataset".equals(string6)) {
                                throw new MatchError((Object)string6);
                            }
                            connectorData = new DataFromVirsisAttr(config, this.querease(), this.apiParvaldnieks(), this.httpClient(), this.system(), this.ec());
                        }
                        break block30;
                    }
                    case -516103365: {
                        if (!"urInsolvencyProceeding".equals(string2)) break;
                        connectorData = new DataFromUr(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                    case -445742127: {
                        if (!"data_import_task_file".equals(string2)) break;
                        connectorData = new DataFromDagrDataImportFile(config, null, null, null, null, null, this.system(), this.ec());
                        break block30;
                    }
                    case -186367528: {
                        if (!"fpr_classifier".equals(string2)) break;
                        connectorData = new DataFromFprClassifiers(config);
                        break block30;
                    }
                    case 98822: {
                        if (!"csv".equals(string2)) break;
                        connectorData = new DataFromCsv(config, this.querease(), view_name, DataFromCsv$.MODULE$.$lessinit$greater$default$4());
                        break block30;
                    }
                    case 101608: {
                        if (!"fpr".equals(string2)) break;
                        connectorData = new DataFromFpr(config);
                        break block30;
                    }
                    case 117280: {
                        if (!"vzd".equals(string2)) break;
                        connectorData = new DataFromVzd(config, this.querease(), view_name);
                        break block30;
                    }
                    case 118807: {
                        if (!"xml".equals(string2)) break;
                        connectorData = new DataFromXml(config, this.querease(), view_name, this.system(), this.ec());
                        break block30;
                    }
                    case 0x2EEE28: {
                        if (!"dagr".equals(string2)) break;
                        connectorData = new DataFromDagr(config, view_name, this.httpClient(), this.system(), this.ec());
                        break block30;
                    }
                    case 3257083: {
                        if (!"jdbc".equals(string2)) break;
                        connectorData = new DataFromJdbc(config, this.querease(), view_name, (String)dataset_name, this.dbAccess());
                        break block30;
                    }
                    case 3271912: {
                        if (!"json".equals(string2)) break;
                        connectorData = new DataFromJson(config, this.querease(), view_name, this.system(), this.ec());
                        break block30;
                    }
                    case 3597230: {
                        if (!"urAr".equals(string2)) break;
                        connectorData = new DataFromUrWithFileUpload(config, this.querease(), view_name, this.apiParvaldnieks(), this.uploader(), this.system(), this.ec());
                        break block30;
                    }
                    case 3597558: {
                        if (!"urLe".equals(string2)) break;
                        connectorData = new DataFromUr(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                    case 782599201: {
                        if (!"urInsolvencyPractitioner".equals(string2)) break;
                        connectorData = new DataFromUr(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                    case 886764193: {
                        if (!"urPublicDocument".equals(string2)) break;
                        connectorData = new DataFromUrWithFileUpload(config, this.querease(), view_name, this.apiParvaldnieks(), this.uploader(), this.system(), this.ec());
                        break block30;
                    }
                    case 1447173496: {
                        if (!"jdbc_export".equals(string2)) break;
                        connectorData = new DataToJdbc(config, this.querease(), (String)dataset_name, this.dbAccess(), this.httpClient(), this.system(), this.ec());
                        break block30;
                    }
                    case 1448615520: {
                        if (!"urCommercialPledge".equals(string2)) break;
                        connectorData = new DataFromUr(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                    case 1891927558: {
                        if (!"urMassMedium".equals(string2)) break;
                        connectorData = new DataFromUr(config, view_name, this.apiParvaldnieks(), this.system(), this.ec());
                        break block30;
                    }
                }
                String x = string2;
                throw new RuntimeException(new StringBuilder(28).append("Unexpected datasource_type: ").append(x).toString());
            }
            DataFromConfig datasource = connectorData;
            String string7 = Predef$.MODULE$.ArrowAssoc(dataset_name);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string7, datasource);
        })).toMap($less$colon$less$.MODULE$.refl());
        yamlAnonymizerRulesLoader = new YamlAnonymizerRulesLoader(MODULE$.querease().yamlMetadata());
        mainConnector = new Connector(MODULE$.all_dataset_names(), mainDatasetNameToDataSource, (Function1<String, Option<Flow<Record, Record, NotUsed>>>)(Function1<String, Option> & Serializable)dataset_name -> this.fromConfigAnonymizerFactory((String)dataset_name), None$.MODULE$);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Connector$.class);
    }

    public Connector.ConnectorStreamElement BatchEndElement() {
        return BatchEndElement;
    }

    public ActorSystem system() {
        return system;
    }

    public ExecutionContext ec() {
        return ec;
    }

    public long progress_report_interval_ms() {
        return progress_report_interval_ms;
    }

    public String datasource_type() {
        return datasource_type;
    }

    public FiniteDuration http_conn_max_idle_timeout() {
        return http_conn_max_idle_timeout;
    }

    public boolean logToDagrPrintDebug() {
        return logToDagrPrintDebug;
    }

    public HttpClient httpClient() {
        return httpClient;
    }

    public SecurityTokenServiceClient stsClient() {
        return stsClient;
    }

    public InfoToDagr infoToDagr() {
        return infoToDagr;
    }

    public ConnectorQuerease querease() {
        return querease;
    }

    public boolean isRemoteAnonymizer() {
        return isRemoteAnonymizer;
    }

    public boolean isRemoteDataImport() {
        return isRemoteDataImport;
    }

    public String CfgDs() {
        return CfgDs;
    }

    public Seq<String> all_dataset_names() {
        return all_dataset_names;
    }

    public RemoteAnonymizerTask remoteAnonymizerTask() {
        Object object = this.remoteAnonymizerTask$lzy1;
        if (object instanceof RemoteAnonymizerTask) {
            return (RemoteAnonymizerTask)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (RemoteAnonymizerTask)this.remoteAnonymizerTask$lzyINIT1();
    }

    private Object remoteAnonymizerTask$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.remoteAnonymizerTask$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RemoteAnonymizerTask remoteAnonymizerTask = null;
                    try {
                        remoteAnonymizerTask = new RemoteAnonymizerTask(mainConfig);
                        object2 = remoteAnonymizerTask == null ? LazyVals$NullValue$.MODULE$ : remoteAnonymizerTask;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.remoteAnonymizerTask$lzy1;
                            LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return remoteAnonymizerTask;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RemoteDataImportTask remoteDataImportTask() {
        Object object = this.remoteDataImportTask$lzy1;
        if (object instanceof RemoteDataImportTask) {
            return (RemoteDataImportTask)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (RemoteDataImportTask)this.remoteDataImportTask$lzyINIT1();
    }

    private Object remoteDataImportTask$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.remoteDataImportTask$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RemoteDataImportTask remoteDataImportTask = null;
                    try {
                        remoteDataImportTask = new RemoteDataImportTask(mainConfig);
                        object2 = remoteDataImportTask == null ? LazyVals$NullValue$.MODULE$ : remoteDataImportTask;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_1, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.remoteDataImportTask$lzy1;
                            LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_1, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return remoteDataImportTask;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Uploader uploader() {
        Object object = this.uploader$lzy1;
        if (object instanceof Uploader) {
            return (Uploader)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Uploader)this.uploader$lzyINIT1();
    }

    private Object uploader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.uploader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_2, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Uploader uploader = null;
                    try {
                        uploader = new Uploader(mainConfig, this.httpClient(), this.stsClient(), this.system(), this.ec());
                        object2 = uploader == null ? LazyVals$NullValue$.MODULE$ : uploader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_2, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.uploader$lzy1;
                            LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_2, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uploader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_2, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ApiParvaldnieks apiParvaldnieks() {
        Object object = this.apiParvaldnieks$lzy1;
        if (object instanceof ApiParvaldnieks) {
            return (ApiParvaldnieks)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (ApiParvaldnieks)this.apiParvaldnieks$lzyINIT1();
    }

    private Object apiParvaldnieks$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.apiParvaldnieks$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_3, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ApiParvaldnieks apiParvaldnieks = null;
                    try {
                        apiParvaldnieks = new ApiParvaldnieks(mainConfig, this.httpClient(), this.system(), this.ec());
                        object2 = apiParvaldnieks == null ? LazyVals$NullValue$.MODULE$ : apiParvaldnieks;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_3, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.apiParvaldnieks$lzy1;
                            LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_3, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return apiParvaldnieks;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_3, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DbAccess dbAccess() {
        Object object = this.dbAccess$lzy1;
        if (object instanceof DbAccess) {
            return (DbAccess)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (DbAccess)this.dbAccess$lzyINIT1();
    }

    private Object dbAccess$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dbAccess$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_4, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DbAccess dbAccess = null;
                    try {
                        dbAccess = new DbAccess(mainConfig);
                        object2 = dbAccess == null ? LazyVals$NullValue$.MODULE$ : dbAccess;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_4, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dbAccess$lzy1;
                            LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_4, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return dbAccess;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_4, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public FileHandlerTools fileHandlerTools() {
        Object object = this.fileHandlerTools$lzy1;
        if (object instanceof FileHandlerTools) {
            return (FileHandlerTools)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (FileHandlerTools)this.fileHandlerTools$lzyINIT1();
    }

    private Object fileHandlerTools$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.fileHandlerTools$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_5, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FileHandlerTools fileHandlerTools = null;
                    try {
                        fileHandlerTools = new FileHandlerTools(){
                            public static final long OFFSET$3;
                            public static final long OFFSET$2;
                            public static final long OFFSET$1;
                            public static final long OFFSET$0;
                            private volatile Object apiParvaldnieks$lzy2;
                            private volatile Object dbAccess$lzy2;
                            private volatile Object httpClient$lzy1;
                            private volatile Object uploader$lzy2;

                            static {
                                OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(anon.11.class.getDeclaredField("uploader$lzy2"));
                                OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(anon.11.class.getDeclaredField("httpClient$lzy1"));
                                OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(anon.11.class.getDeclaredField("dbAccess$lzy2"));
                                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.11.class.getDeclaredField("apiParvaldnieks$lzy2"));
                            }

                            public ApiParvaldnieks apiParvaldnieks() {
                                Object object = this.apiParvaldnieks$lzy2;
                                if (object instanceof ApiParvaldnieks) {
                                    return (ApiParvaldnieks)object;
                                }
                                if (object == LazyVals$NullValue$.MODULE$) {
                                    return null;
                                }
                                return (ApiParvaldnieks)this.apiParvaldnieks$lzyINIT2();
                            }

                            private Object apiParvaldnieks$lzyINIT2() {
                                Object object;
                                block8: {
                                    while (true) {
                                        if ((object = this.apiParvaldnieks$lzy2) == null) {
                                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                                            Object object2 = null;
                                            ApiParvaldnieks apiParvaldnieks = null;
                                            try {
                                                apiParvaldnieks = Connector$.MODULE$.apiParvaldnieks();
                                                object2 = apiParvaldnieks == null ? LazyVals$NullValue$.MODULE$ : apiParvaldnieks;
                                            }
                                            finally {
                                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.apiParvaldnieks$lzy2;
                                                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                                                    waiting.countDown();
                                                }
                                            }
                                            return apiParvaldnieks;
                                        }
                                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                                        if (object == LazyVals$Evaluating$.MODULE$) {
                                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                                            continue;
                                        }
                                        if (!(object instanceof LazyVals.Waiting)) break;
                                        ((LazyVals.Waiting)object).await();
                                    }
                                    return null;
                                }
                                return object;
                            }

                            public DbAccess dbAccess() {
                                Object object = this.dbAccess$lzy2;
                                if (object instanceof DbAccess) {
                                    return (DbAccess)object;
                                }
                                if (object == LazyVals$NullValue$.MODULE$) {
                                    return null;
                                }
                                return (DbAccess)this.dbAccess$lzyINIT2();
                            }

                            private Object dbAccess$lzyINIT2() {
                                Object object;
                                block8: {
                                    while (true) {
                                        if ((object = this.dbAccess$lzy2) == null) {
                                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                                            Object object2 = null;
                                            DbAccess dbAccess = null;
                                            try {
                                                dbAccess = Connector$.MODULE$.dbAccess();
                                                object2 = dbAccess == null ? LazyVals$NullValue$.MODULE$ : dbAccess;
                                            }
                                            finally {
                                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, object2)) {
                                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.dbAccess$lzy2;
                                                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, object2);
                                                    waiting.countDown();
                                                }
                                            }
                                            return dbAccess;
                                        }
                                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                                        if (object == LazyVals$Evaluating$.MODULE$) {
                                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                                            continue;
                                        }
                                        if (!(object instanceof LazyVals.Waiting)) break;
                                        ((LazyVals.Waiting)object).await();
                                    }
                                    return null;
                                }
                                return object;
                            }

                            public HttpClient httpClient() {
                                Object object = this.httpClient$lzy1;
                                if (object instanceof HttpClient) {
                                    return (HttpClient)object;
                                }
                                if (object == LazyVals$NullValue$.MODULE$) {
                                    return null;
                                }
                                return (HttpClient)this.httpClient$lzyINIT1();
                            }

                            private Object httpClient$lzyINIT1() {
                                Object object;
                                block8: {
                                    while (true) {
                                        if ((object = this.httpClient$lzy1) == null) {
                                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, null, LazyVals$Evaluating$.MODULE$)) continue;
                                            Object object2 = null;
                                            HttpClient httpClient = null;
                                            try {
                                                httpClient = Connector$.MODULE$.httpClient();
                                                object2 = httpClient == null ? LazyVals$NullValue$.MODULE$ : httpClient;
                                            }
                                            finally {
                                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, LazyVals$Evaluating$.MODULE$, object2)) {
                                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.httpClient$lzy1;
                                                    LazyVals$.MODULE$.objCAS(this, OFFSET$2, waiting, object2);
                                                    waiting.countDown();
                                                }
                                            }
                                            return httpClient;
                                        }
                                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                                        if (object == LazyVals$Evaluating$.MODULE$) {
                                            LazyVals$.MODULE$.objCAS(this, OFFSET$2, object, new LazyVals.Waiting());
                                            continue;
                                        }
                                        if (!(object instanceof LazyVals.Waiting)) break;
                                        ((LazyVals.Waiting)object).await();
                                    }
                                    return null;
                                }
                                return object;
                            }

                            public Uploader uploader() {
                                Object object = this.uploader$lzy2;
                                if (object instanceof Uploader) {
                                    return (Uploader)object;
                                }
                                if (object == LazyVals$NullValue$.MODULE$) {
                                    return null;
                                }
                                return (Uploader)this.uploader$lzyINIT2();
                            }

                            private Object uploader$lzyINIT2() {
                                Object object;
                                block8: {
                                    while (true) {
                                        if ((object = this.uploader$lzy2) == null) {
                                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$3, null, LazyVals$Evaluating$.MODULE$)) continue;
                                            Object object2 = null;
                                            Uploader uploader = null;
                                            try {
                                                uploader = Connector$.MODULE$.uploader();
                                                object2 = uploader == null ? LazyVals$NullValue$.MODULE$ : uploader;
                                            }
                                            finally {
                                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$3, LazyVals$Evaluating$.MODULE$, object2)) {
                                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.uploader$lzy2;
                                                    LazyVals$.MODULE$.objCAS(this, OFFSET$3, waiting, object2);
                                                    waiting.countDown();
                                                }
                                            }
                                            return uploader;
                                        }
                                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                                        if (object == LazyVals$Evaluating$.MODULE$) {
                                            LazyVals$.MODULE$.objCAS(this, OFFSET$3, object, new LazyVals.Waiting());
                                            continue;
                                        }
                                        if (!(object instanceof LazyVals.Waiting)) break;
                                        ((LazyVals.Waiting)object).await();
                                    }
                                    return null;
                                }
                                return object;
                            }
                        };
                        object2 = fileHandlerTools == null ? LazyVals$NullValue$.MODULE$ : fileHandlerTools;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_5, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.fileHandlerTools$lzy1;
                            LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_5, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return fileHandlerTools;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, Connector.OFFSET$_m_5, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Config datasetConfig(Config mainConfig, String dataset_name) {
        Object object = Predef$.MODULE$.refArrayOps(dataset_name.split("/"));
        Object[] parts = (String[])ArrayOps$.MODULE$.filterNot$extension(object, (Function1<String, boolean> & Serializable)_$6 -> _$6.isEmpty());
        ObjectRef<List> chain = ObjectRef.create((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)mainConfig), Nil$.MODULE$)));
        ObjectRef<Config> current = ObjectRef.create(mainConfig);
        boundary.Label local = new boundary.Label();
        try {
            Object object2 = Predef$.MODULE$.refArrayOps(parts);
            if (!ArrayOps$.MODULE$.exists$extension(object2, (Function1<String, boolean> & Serializable)p -> !p.matches("\\w+"))) {
                Object object3 = Predef$.MODULE$.refArrayOps(parts);
                ArrayOps$.MODULE$.foreach$extension(object3, part -> {
                    if (((Config)current$1.elem).hasPath((String)part)) {
                        ConfigValueType configValueType = ((Config)current$1.elem).getValue((String)part).valueType();
                        ConfigValueType configValueType2 = ConfigValueType.OBJECT;
                        if (!(configValueType != null ? !((Object)((Object)configValueType)).equals((Object)configValueType2) : configValueType2 != null)) {
                            current$1.elem = ((Config)current$1.elem).getConfig((String)part);
                            Config config = (Config)current$1.elem;
                            chain$1.elem = ((List)chain$1.elem).$colon$colon(config);
                            return;
                        }
                    }
                    throw boundary$.MODULE$.break(local);
                });
            }
        }
        catch (boundary.Break ex) {
            if (ex.label() == local) {
                ex.value();
            }
            throw ex;
        }
        return (Config)((LinearSeqOps)((List)chain.elem).tail()).foldLeft(((List)chain.elem).head(), (Function2<Config, Config, Config> & Serializable)(acc, fb) -> acc.withFallback((ConfigMergeable)fb));
    }

    public long nextReportAt(long lastReportAt) {
        long now = System.currentTimeMillis();
        long next = lastReportAt + this.progress_report_interval_ms();
        if (next > now) {
            return next;
        }
        return now / 1000L * 1000L + this.progress_report_interval_ms();
    }

    public long nextReportAt$default$1() {
        return 0L;
    }

    private Option<Flow<Record, Record, NotUsed>> fromConfigAnonymizerFactory(String dataset_name) {
        return yamlAnonymizerRulesLoader.nameToRules().get(dataset_name).map((Function1<DataAnonymizer.Rules, Flow> & Serializable)rules -> DataAnonymizer$.MODULE$.flow(mainConfig, MODULE$.querease(), dataset_name, (DataAnonymizer.Rules)rules));
    }

    public Connector mainConnector() {
        return mainConnector;
    }

    public Future<Option<Connector>> dagr$Connector$$$getConnector() {
        if (this.isRemoteAnonymizer()) {
            return this.remoteAnonymizerTask().getNextTask(this.httpClient(), this.stsClient(), this.system(), this.ec()).map((Function1<Option, Option> & Serializable)_$7 -> _$7.map((Function1<RemoteAnonymizerTaskDetails, Connector> & Serializable)rt -> {
                Seq dataset_names = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)rt.target_dataset()), Nil$.MODULE$));
                Tuple2[] tuple2Array = new Tuple2[1];
                String string2 = Predef$.MODULE$.ArrowAssoc(rt.target_dataset());
                tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, new DataFromDagr(mainConfig, rt.source_dataset(), this.httpClient(), this.system(), this.ec()));
                Map datasetNameToDataSource = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
                Object object = Predef$.MODULE$.refArrayOps(rt.key_field_names().split(",\\s*"));
                Seq keyFieldNames = (Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(object).map((Function1<String, String> & Serializable)_$8 -> _$8.trim())).filter((Function1<String, boolean> & Serializable)_$9 -> {
                    String string2 = _$9;
                    String string3 = "";
                    return string2 == null ? string3 != null : !string2.equals(string3);
                });
                Set nullableKeyFieldNames = keyFieldNames.isEmpty() ? Predef$.MODULE$.Set().empty() : ((IterableOnceOps)keyFieldNames.tail()).toSet();
                YamlAnonymizerRulesLoader rulesLoader = new YamlAnonymizerRulesLoader(YamlMd$.MODULE$.fromString(rt.anonymizer_template()));
                Nil$ filenameFieldPaths = scala.package$.MODULE$.Nil();
                this.remoteAnonymizerTask().setStatus(this.httpClient(), this.stsClient(), rt.taskKey(), "izpild\u0113", "", this.system(), this.ec());
                return new Connector(dataset_names, datasetNameToDataSource, (Function1<String, Option<Flow<Record, Record, NotUsed>>>)(Function1<String, Option> & Serializable)dataset_name -> this.remoteTaskAnonymizerFactory$1(rulesLoader, keyFieldNames, nullableKeyFieldNames, filenameFieldPaths, (String)dataset_name), Option$.MODULE$.apply(rt));
            }), this.ec()).recover(new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Option<Throwable> option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = option.get();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Option<Throwable> option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = option.get();
                        Connector$.dagr$Connector$$$logger.error("Failed to initialize connector for anonymizer", ex);
                        return None$.MODULE$;
                    }
                    return function1.apply(x);
                }
            }, this.ec());
        }
        if (this.isRemoteDataImport()) {
            return this.remoteDataImportTask().getNextTask(this.httpClient(), this.stsClient(), this.system(), this.ec()).flatMap((Function1<Option, Future> & Serializable)remoteDataImportTaskOpt -> ((Future)remoteDataImportTaskOpt.map((Function1<RemoteDataImportTaskByStatus, Future> & Serializable)rt -> MODULE$.remoteDataImportTask().getTaskDetails(MODULE$.httpClient(), MODULE$.stsClient(), (RemoteDataImportTaskByStatus)rt, MODULE$.system(), MODULE$.ec())).getOrElse(Connector$::getConnector$$anonfun$2$$anonfun$2)).recover(new Serializable((Option)remoteDataImportTaskOpt){
                private final Option remoteDataImportTaskOpt$1;
                {
                    this.remoteDataImportTaskOpt$1 = remoteDataImportTaskOpt$4;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Option<Throwable> option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = option.get();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Option<Throwable> option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = option.get();
                        Connector$.dagr$Connector$$$logger.error("Failed to get task details for remote data import", ex);
                        Vector<Object> taskKey = ((RemoteDataImportTaskByStatus)this.remoteDataImportTaskOpt$1.get()).taskKey();
                        Connector$.MODULE$.remoteDataImportTask().setStatus(Connector$.MODULE$.httpClient(), Connector$.MODULE$.stsClient(), taskKey, "k\u013c\u016bda", ex.getMessage(), Connector$.MODULE$.system(), Connector$.MODULE$.ec());
                        return None$.MODULE$;
                    }
                    return function1.apply(x);
                }
            }, this.ec()).map((Function1<Option, Option> & Serializable)taskDetailsOpt -> taskDetailsOpt.map((Function1<RemoteDataImportTaskDetails, Connector> & Serializable)taskDetails -> {
                RemoteDataImportTaskByStatus rt = (RemoteDataImportTaskByStatus)remoteDataImportTaskOpt.get();
                Seq dataset_names = (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)rt.target_dataset()), Nil$.MODULE$));
                DataImportTaskQuerease qe = new DataImportTaskQuerease(taskDetails.structure());
                Config taskConfig = taskDetails.conf().toConfig().withFallback(mainConfig);
                Tuple2[] tuple2Array = new Tuple2[1];
                String string2 = Predef$.MODULE$.ArrowAssoc(rt.target_dataset());
                tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, new DataFromDagrDataImportFile(taskConfig, rt.target_dataset(), qe, rt.uid(), this.httpClient(), this.stsClient(), this.system(), this.ec()));
                Map datasetNameToDataSource = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
                this.remoteDataImportTask().setStatus(this.httpClient(), this.stsClient(), rt.taskKey(), "izpild\u0113", "", this.system(), this.ec());
                return new Connector(dataset_names, datasetNameToDataSource, (Function1<String, Option<Flow<Record, Record, NotUsed>>>)(Function1<String, Option> & Serializable)dataset_name -> this.remoteTaskAnonymizerFactory$2((String)dataset_name), Option$.MODULE$.apply(rt));
            }), this.ec()), this.ec());
        }
        return Future$.MODULE$.successful(Some$.MODULE$.apply(this.mainConnector()));
    }

    public void main(String[] args) {
        ResourceAccessGuard$.MODULE$.check(mainDatasetNameToDataSource, mainConfig, this.ec(), Materializer$.MODULE$.matFromSystem(this.system()));
        Option$.MODULE$.apply("pekko.quartz.schedules.logToDagr").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> mainConfig.hasPath((String)x$0)).foreach((Function1<String, Date> & Serializable)confPath -> {
            QuartzSchedulerExtension scheduler = (QuartzSchedulerExtension)QuartzSchedulerExtension$.MODULE$.apply(this.system());
            return scheduler.schedule("logToDagr", this.system().actorOf(Props$.MODULE$.apply(this::main$$anonfun$2$$anonfun$1, ClassTag$.MODULE$.apply(Actor.class))), (Object)MessageRequireFireTime$.MODULE$.apply(Connector$Tick$.MODULE$));
        });
        Option$.MODULE$.apply("pekko.quartz.schedules.connector").filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)x$0 -> mainConfig.hasPath((String)x$0)).map(confPath -> {
            QuartzSchedulerExtension scheduler = (QuartzSchedulerExtension)QuartzSchedulerExtension$.MODULE$.apply(this.system());
            scheduler.schedule("connector", this.system().actorOf(Props$.MODULE$.apply(this::main$$anonfun$4$$anonfun$1, ClassTag$.MODULE$.apply(Actor.class))), (Object)MessageRequireFireTime$.MODULE$.apply(Connector$Tick$.MODULE$));
            dagr$Connector$$$logger.info("Connector scheduled");
        }).getOrElse((Function0<Object> & Serializable)() -> {
            Connector$.main$$anonfun$5();
            return BoxedUnit.UNIT;
        });
    }

    private final String $init$$$anonfun$9() {
        return Source$.MODULE$.fromResource("version.txt", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private final String $init$$$anonfun$13() {
        return "?.?.?";
    }

    private final Option remoteTaskAnonymizerFactory$1(YamlAnonymizerRulesLoader rulesLoader$1, Seq keyFieldNames$1, Set nullableKeyFieldNames$1, Nil$ filenameFieldPaths$1, String dataset_name) {
        return rulesLoader$1.nameToRules().get(dataset_name).map((Function1<DataAnonymizer.Rules, Flow> & Serializable)rules -> DataAnonymizer$.MODULE$.flow(dataset_name, (DataAnonymizer.Rules)rules, new Renderer(mainConfig, keyFieldNames$1, nullableKeyFieldNames$1, filenameFieldPaths$1, Renderer$.MODULE$.$lessinit$greater$default$5()), DataAnonymizer$.MODULE$.flow$default$4()));
    }

    private static final Future getConnector$$anonfun$2$$anonfun$2() {
        return Future$.MODULE$.successful(None$.MODULE$);
    }

    private final None$ remoteTaskAnonymizerFactory$2(String dataset_name) {
        return None$.MODULE$;
    }

    private final Actor main$$anonfun$2$$anonfun$1() {
        return new Actor(){
            private ActorContext context;
            private ActorRef self;
            public boolean dagr$Connector$$anon$14$$isRunning;
            {
                Actor.$init$(this);
                this.dagr$Connector$$anon$14$$isRunning = false;
                Statics.releaseFence();
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
                this.context = x$0;
            }

            public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
                this.self = x$0;
            }

            public PartialFunction receive() {
                return new Serializable(this){
                    private final /* synthetic */ anon.14 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        Object object = x;
                        if (object instanceof MessageWithFireTime) {
                            MessageWithFireTime messageWithFireTime = MessageWithFireTime$.MODULE$.unapply((MessageWithFireTime)object);
                            Object object2 = messageWithFireTime._1();
                            Date date = messageWithFireTime._2();
                            Option<Date> option = messageWithFireTime._3();
                            Option<Date> option2 = messageWithFireTime._4();
                            if (Connector$Tick$.MODULE$.equals(object2)) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object = x;
                        if (object instanceof MessageWithFireTime) {
                            MessageWithFireTime messageWithFireTime = MessageWithFireTime$.MODULE$.unapply((MessageWithFireTime)object);
                            Object object2 = messageWithFireTime._1();
                            Date date = messageWithFireTime._2();
                            Option<Date> option = messageWithFireTime._3();
                            Option<Date> option2 = messageWithFireTime._4();
                            if (Connector$Tick$.MODULE$.equals(object2)) {
                                boolean bl;
                                anon.14 var9_9 = this.$outer;
                                synchronized (var9_9) {
                                    bl = this.$outer.dagr$Connector$$anon$14$$isRunning;
                                }
                                if (!bl) {
                                    BoxedUnit boxedUnit;
                                    anon.14 var11_11 = this.$outer;
                                    synchronized (var11_11) {
                                        this.$outer.dagr$Connector$$anon$14$$isRunning = true;
                                    }
                                    try {
                                        Connector$.MODULE$.infoToDagr().sendLog(Connector$.MODULE$.logToDagrPrintDebug());
                                        this.$outer.dagr$Connector$$anon$14$$isRunning = false;
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.$outer.dagr$Connector$$anon$14$$isRunning = false;
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return boxedUnit;
                                }
                                return BoxedUnit.UNIT;
                            }
                        }
                        return function1.apply(x);
                    }
                };
            }
        };
    }

    public static final /* synthetic */ Instant dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$2(Date _$10) {
        return _$10.toInstant();
    }

    public static final Instant dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$3() {
        return Instant.now();
    }

    public static final Future dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$4$$anonfun$2() {
        return Future$.MODULE$.successful(None$.MODULE$);
    }

    private final Actor main$$anonfun$4$$anonfun$1() {
        return new Actor(){
            private ActorContext context;
            private ActorRef self;
            public boolean dagr$Connector$$anon$16$$isRunning;
            public SchedulerInfo dagr$Connector$$anon$16$$schedulerInfo;
            {
                Actor.$init$(this);
                this.dagr$Connector$$anon$16$$isRunning = false;
                this.dagr$Connector$$anon$16$$schedulerInfo = SchedulerInfo$.MODULE$.apply(0, Instant.now(), Instant.now());
                Statics.releaseFence();
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
                this.context = x$0;
            }

            public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
                this.self = x$0;
            }

            public PartialFunction receive() {
                return new Serializable(this){
                    private final /* synthetic */ anon.16 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        Object object = x;
                        if (object instanceof MessageWithFireTime) {
                            MessageWithFireTime messageWithFireTime = MessageWithFireTime$.MODULE$.unapply((MessageWithFireTime)object);
                            Object object2 = messageWithFireTime._1();
                            Date date = messageWithFireTime._2();
                            Option<Date> option = messageWithFireTime._3();
                            Option<Date> option2 = messageWithFireTime._4();
                            if (Connector$Tick$.MODULE$.equals(object2)) {
                                Option<Date> scheduledFireTimeOpt = option;
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object = x;
                        if (object instanceof MessageWithFireTime) {
                            MessageWithFireTime messageWithFireTime = MessageWithFireTime$.MODULE$.unapply((MessageWithFireTime)object);
                            Object object2 = messageWithFireTime._1();
                            Date date = messageWithFireTime._2();
                            Option<Date> option = messageWithFireTime._3();
                            Option<Date> option2 = messageWithFireTime._4();
                            if (Connector$Tick$.MODULE$.equals(object2)) {
                                boolean bl;
                                Option<Date> scheduledFireTimeOpt = option;
                                anon.16 var10_10 = this.$outer;
                                synchronized (var10_10) {
                                    bl = this.$outer.dagr$Connector$$anon$16$$isRunning;
                                }
                                if (!bl) {
                                    anon.16 var12_12 = this.$outer;
                                    synchronized (var12_12) {
                                        this.$outer.dagr$Connector$$anon$16$$isRunning = true;
                                        this.$outer.dagr$Connector$$anon$16$$schedulerInfo = SchedulerInfo$.MODULE$.apply(this.$outer.dagr$Connector$$anon$16$$schedulerInfo.count() + 1, this.$outer.dagr$Connector$$anon$16$$schedulerInfo.thisRun(), (Instant)scheduledFireTimeOpt.map(Connector$::dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$2).getOrElse(Connector$::dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$3));
                                    }
                                    Connector$.MODULE$.dagr$Connector$$$getConnector().flatMap((Function1<Option, Future> & Serializable)_$11 -> (Future)_$11.map((Function1<Connector, Future> & Serializable)_$12 -> _$12.syncAndReportAll(this.$outer.dagr$Connector$$anon$16$$schedulerInfo)).getOrElse(Connector$::dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$4$$anonfun$2), Connector$.MODULE$.ec()).onComplete(_$13 -> {
                                        anon.16 var2_2 = this.$outer;
                                        synchronized (var2_2) {
                                            this.$outer.dagr$Connector$$anon$16$$isRunning = false;
                                        }
                                    }, Connector$.MODULE$.ec());
                                    return BoxedUnit.UNIT;
                                }
                                return BoxedUnit.UNIT;
                            }
                        }
                        return function1.apply(x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$2(java.util.Date ), dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$3(), applyOrElse$$anonfun$4(scala.Option ), applyOrElse$$anonfun$5(scala.util.Try ), applyOrElse$$anonfun$4$$anonfun$1(dagr.Connector ), dagr$Connector$$anon$17$$_$applyOrElse$$anonfun$4$$anonfun$2()}, serializedLambda);
                    }
                };
            }
        };
    }

    private static final Future main$$anonfun$5$$anonfun$1$$anonfun$2() {
        return Future$.MODULE$.successful(None$.MODULE$);
    }

    private static final void main$$anonfun$5() {
        MODULE$.dagr$Connector$$$getConnector().flatMap((Function1<Option, Future> & Serializable)_$14 -> (Future)_$14.map((Function1<Connector, Future> & Serializable)_$15 -> _$15.syncAndReportAll(SchedulerInfo$.MODULE$.apply(1, Instant.now(), Instant.now()))).getOrElse(Connector$::main$$anonfun$5$$anonfun$1$$anonfun$2), MODULE$.ec()).onComplete(_$16 -> (mainConfig.hasPath("pekko.quartz.schedules.logToDagr") ? MODULE$.infoToDagr().sendLog(MODULE$.logToDagrPrintDebug()) : Future$.MODULE$.successful(BoxedUnit.UNIT)).onComplete((Function1<Try, Future> & Serializable)_$17 -> MODULE$.system().terminate(), MODULE$.ec()), MODULE$.ec());
    }
}

