/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.sslconfig.util.ConfigLoader;
import com.typesafe.sslconfig.util.ConfigLoader$;
import com.typesafe.sslconfig.util.EnrichedConfig$;
import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;

public class EnrichedConfig {
    private final Config underlying;

    public static EnrichedConfig apply(Config config) {
        return EnrichedConfig$.MODULE$.apply(config);
    }

    public EnrichedConfig(Config underlying) {
        this.underlying = underlying;
    }

    public Config underlying() {
        return this.underlying;
    }

    public <A> A get(String path, ConfigLoader<A> loader) {
        return loader.load(this.underlying(), path);
    }

    public <A> Seq<A> getSeq(String path, ConfigLoader<Seq<A>> loader) {
        return loader.load(this.underlying(), path);
    }

    public <A> Option<A> getOptional(String path, ConfigLoader<A> evidence$1) {
        Option option;
        try {
            option = Option$.MODULE$.apply(this.get(path, evidence$1));
        }
        catch (ConfigException.Missing e) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Seq<EnrichedConfig> getPrototypedSeq(String path, String prototypePath) {
        Config prototype = this.underlying().getConfig(prototypePath.replace("$path", path));
        return ((IterableOnceOps)((IterableOps)this.get(path, ConfigLoader$.MODULE$.seqConfigLoader())).map((Function1<Config, EnrichedConfig> & Serializable)config -> new EnrichedConfig(config.withFallback(prototype)))).toList();
    }

    public String getPrototypedSeq$default$2() {
        return "prototype.$path";
    }

    public Map<String, EnrichedConfig> getPrototypedMap(String path, String prototypePath) {
        Config prototype = prototypePath.isEmpty() ? this.underlying() : this.underlying().getConfig(prototypePath.replace("$path", path));
        return ((Map)((MapOps)this.get(path, ConfigLoader$.MODULE$.mapLoader(ConfigLoader$.MODULE$.configLoader()))).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String key2 = (String)tuple2._1();
            Config config = (Config)tuple2._2();
            String string2 = Predef$.MODULE$.ArrowAssoc(key2);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, new EnrichedConfig(config.withFallback(prototype)));
        })).toMap($less$colon$less$.MODULE$.refl());
    }

    public String getPrototypedMap$default$2() {
        return "prototype.$path";
    }

    public <A> Option<A> getOptionalDeprecated(String path, String deprecated2, ConfigLoader<A> evidence$2) {
        Option<A> option;
        if (this.underlying().hasPath(deprecated2)) {
            this.reportDeprecation(path, deprecated2);
            option = this.getOptional(deprecated2, evidence$2);
        } else {
            option = this.getOptional(path, evidence$2);
        }
        return option;
    }

    public <A> A getDeprecated(String path, String deprecated2, ConfigLoader<A> evidence$3) {
        A a;
        if (this.underlying().hasPath(deprecated2)) {
            this.reportDeprecation(path, deprecated2);
            a = this.get(deprecated2, evidence$3);
        } else {
            a = this.get(path, evidence$3);
        }
        return a;
    }

    public EnrichedConfig getDeprecatedWithFallback(String path, String deprecated2, String parent) {
        Config config;
        Config config2 = this.get(path, ConfigLoader$.MODULE$.configLoader());
        if (this.underlying().hasPath(deprecated2)) {
            this.reportDeprecation(path, deprecated2);
            config = this.get(deprecated2, ConfigLoader$.MODULE$.configLoader()).withFallback(config2);
        } else {
            config = config2;
        }
        Config merged = config;
        return new EnrichedConfig(merged);
    }

    public String getDeprecatedWithFallback$default$3() {
        return "";
    }

    public Throwable reportError(String path, String message, Option<Throwable> e) {
        return e.get();
    }

    public Option<Throwable> reportError$default$3() {
        return None$.MODULE$;
    }

    public Set<String> subKeys() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.underlying().root().keySet()).asScala()).toSet();
    }

    public void reportDeprecation(String path, String deprecated2) {
        ConfigOrigin configOrigin = this.underlying().getValue(deprecated2).origin();
    }
}

