/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl.tracing;

import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.tracing.TraceLogger;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import scala.Function0;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TracingSSLSocketFactory
extends SSLSocketFactory
implements TraceLogger {
    private final SSLSocketFactory factory;
    private final SSLDebugConfig debug;
    private final LoggerFactory loggerFactory;

    public TracingSSLSocketFactory(SSLSocketFactory factory, SSLDebugConfig debug, LoggerFactory loggerFactory) {
        this.factory = factory;
        this.debug = debug;
        this.loggerFactory = loggerFactory;
    }

    @Override
    public Socket createSocket(String host, int port) {
        Tuple2[] tuple2Array = new Tuple2[2];
        String string2 = Predef$.MODULE$.ArrowAssoc("host");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, host);
        String string3 = Predef$.MODULE$.ArrowAssoc("port");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToInteger(port));
        return (Socket)this.tracer("createSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<Socket> & Serializable)() -> this.factory.createSocket(host, port), this.loggerFactory);
    }

    @Override
    public Socket createSocket() {
        return (Socket)this.tracer("createSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<Socket> & Serializable)() -> this.factory.createSocket(), this.loggerFactory);
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) {
        Tuple2[] tuple2Array = new Tuple2[4];
        String string2 = Predef$.MODULE$.ArrowAssoc("s");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, s2);
        String string3 = Predef$.MODULE$.ArrowAssoc("host");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, host);
        String string4 = Predef$.MODULE$.ArrowAssoc("port");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, BoxesRunTime.boxToInteger(port));
        String string5 = Predef$.MODULE$.ArrowAssoc("autoClose");
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, BoxesRunTime.boxToBoolean(autoClose));
        return (Socket)this.tracer("createSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<Socket> & Serializable)() -> this.factory.createSocket(s2, host, port, autoClose), this.loggerFactory);
    }

    @Override
    public Socket createSocket(Socket s2, InputStream consumed, boolean autoClose) {
        Tuple2[] tuple2Array = new Tuple2[3];
        String string2 = Predef$.MODULE$.ArrowAssoc("s");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, s2);
        String string3 = Predef$.MODULE$.ArrowAssoc("consumed");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, consumed);
        String string4 = Predef$.MODULE$.ArrowAssoc("autoClose");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, BoxesRunTime.boxToBoolean(autoClose));
        return (Socket)this.tracer("createSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<Socket> & Serializable)() -> this.factory.createSocket(s2, consumed, autoClose), this.loggerFactory);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
        Tuple2[] tuple2Array = new Tuple2[4];
        String string2 = Predef$.MODULE$.ArrowAssoc("host");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, host);
        String string3 = Predef$.MODULE$.ArrowAssoc("port");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToInteger(port));
        String string4 = Predef$.MODULE$.ArrowAssoc("localHost");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, localHost);
        String string5 = Predef$.MODULE$.ArrowAssoc("localPort");
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, BoxesRunTime.boxToInteger(localPort));
        return (Socket)this.tracer("createSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<Socket> & Serializable)() -> this.factory.createSocket(host, port, localHost, localPort), this.loggerFactory);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) {
        Tuple2[] tuple2Array = new Tuple2[2];
        String string2 = Predef$.MODULE$.ArrowAssoc("host");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, host);
        String string3 = Predef$.MODULE$.ArrowAssoc("port");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToInteger(port));
        return (Socket)this.tracer("createSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<Socket> & Serializable)() -> this.factory.createSocket(host, port), this.loggerFactory);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
        Tuple2[] tuple2Array = new Tuple2[4];
        String string2 = Predef$.MODULE$.ArrowAssoc("address");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, address);
        String string3 = Predef$.MODULE$.ArrowAssoc("port");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToInteger(port));
        String string4 = Predef$.MODULE$.ArrowAssoc("localAddress");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, localAddress);
        String string5 = Predef$.MODULE$.ArrowAssoc("localPort");
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, BoxesRunTime.boxToInteger(localPort));
        return (Socket)this.tracer("createSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<Socket> & Serializable)() -> this.factory.createSocket(address, port, localAddress, localPort), this.loggerFactory);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return (String[])this.tracer("getDefaultCipherSuites", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<String[]> & Serializable)() -> this.factory.getDefaultCipherSuites(), this.loggerFactory);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return (String[])this.tracer("getSupportedCipherSuites", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<String[]> & Serializable)() -> this.factory.getSupportedCipherSuites(), this.loggerFactory);
    }

    @Override
    public boolean isLogEnabled(String methodName, Map<String, Object> parameters) {
        return this.debug.all() || this.debug.ssl();
    }
}

