/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl.tracing;

import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.tracing.TraceLogger;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import scala.Function0;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TracingSSLServerSocketFactory
extends SSLServerSocketFactory
implements TraceLogger {
    private final Function0<SSLServerSocketFactory> factory;
    private final SSLDebugConfig debug;
    private final LoggerFactory lf;

    public TracingSSLServerSocketFactory(Function0 factory, SSLDebugConfig debug, LoggerFactory lf) {
        this.factory = factory;
        this.debug = debug;
        this.lf = lf;
    }

    @Override
    public ServerSocket createServerSocket() {
        return (ServerSocket)this.tracer("createServerSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<ServerSocket> & Serializable)() -> ((ServerSocketFactory)this.factory.apply()).createServerSocket(), this.lf);
    }

    @Override
    public ServerSocket createServerSocket(int port) {
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("port");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToInteger(port));
        return (ServerSocket)this.tracer("createServerSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<ServerSocket> & Serializable)() -> ((ServerSocketFactory)this.factory.apply()).createServerSocket(port), this.lf);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) {
        Tuple2[] tuple2Array = new Tuple2[2];
        String string2 = Predef$.MODULE$.ArrowAssoc("port");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToInteger(port));
        String string3 = Predef$.MODULE$.ArrowAssoc("backlog");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToInteger(backlog));
        return (ServerSocket)this.tracer("createServerSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<ServerSocket> & Serializable)() -> ((ServerSocketFactory)this.factory.apply()).createServerSocket(port, backlog), this.lf);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) {
        Tuple2[] tuple2Array = new Tuple2[3];
        String string2 = Predef$.MODULE$.ArrowAssoc("port");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToInteger(port));
        String string3 = Predef$.MODULE$.ArrowAssoc("backlog");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToInteger(backlog));
        String string4 = Predef$.MODULE$.ArrowAssoc("ifAddress");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, ifAddress);
        return (ServerSocket)this.tracer("createServerSocket", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<ServerSocket> & Serializable)() -> ((ServerSocketFactory)this.factory.apply()).createServerSocket(port, backlog, ifAddress), this.lf);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return (String[])this.tracer("getDefaultCipherSuites", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<String[]> & Serializable)() -> this.factory.apply().getDefaultCipherSuites(), this.lf);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return (String[])this.tracer("getSupportedCipherSuites", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<String[]> & Serializable)() -> this.factory.apply().getSupportedCipherSuites(), this.lf);
    }

    @Override
    public boolean isLogEnabled(String methodName, Map<String, Object> parameters) {
        return this.debug.all() || this.debug.ssl();
    }
}

