/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl.tracing;

import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.tracing.TraceLogger;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TracingSSLEngine
extends SSLEngine
implements TraceLogger {
    private final Function0<SSLEngine> engine;
    private final SSLDebugConfig debug;
    private final LoggerFactory loggerFactory;

    public TracingSSLEngine(Function0 engine, SSLDebugConfig debug, LoggerFactory loggerFactory) {
        this.engine = engine;
        this.debug = debug;
        this.loggerFactory = loggerFactory;
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) {
        Tuple2[] tuple2Array = new Tuple2[4];
        String string2 = Predef$.MODULE$.ArrowAssoc("srcs");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, srcs);
        String string3 = Predef$.MODULE$.ArrowAssoc("offset");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToInteger(offset));
        String string4 = Predef$.MODULE$.ArrowAssoc("length");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, BoxesRunTime.boxToInteger(length));
        String string5 = Predef$.MODULE$.ArrowAssoc("dst");
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, dst);
        return (SSLEngineResult)this.tracer("wrap", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<SSLEngineResult> & Serializable)() -> this.engine.apply().wrap(srcs, offset, length, dst), this.loggerFactory);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) {
        Tuple2[] tuple2Array = new Tuple2[4];
        String string2 = Predef$.MODULE$.ArrowAssoc("src");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, src);
        String string3 = Predef$.MODULE$.ArrowAssoc("dsts");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, dsts);
        String string4 = Predef$.MODULE$.ArrowAssoc("offset");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, BoxesRunTime.boxToInteger(offset));
        String string5 = Predef$.MODULE$.ArrowAssoc("length");
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, BoxesRunTime.boxToInteger(length));
        return (SSLEngineResult)this.tracer("wrap", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), (Function0<SSLEngineResult> & Serializable)() -> this.engine.apply().unwrap(src, dsts, offset, length), this.loggerFactory);
    }

    @Override
    public Runnable getDelegatedTask() {
        return (Runnable)this.tracer("getDelegatedTask", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<Runnable> & Serializable)() -> this.engine.apply().getDelegatedTask(), this.loggerFactory);
    }

    @Override
    public void closeInbound() {
        this.tracer("closeInbound", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), () -> this.engine.apply().closeInbound(), this.loggerFactory);
    }

    @Override
    public boolean isInboundDone() {
        return BoxesRunTime.unboxToBoolean(this.tracer("isInboundDone", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<boolean> & Serializable)() -> this.engine.apply().isInboundDone(), this.loggerFactory));
    }

    @Override
    public void closeOutbound() {
        this.tracer("isInboundDone", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), () -> this.engine.apply().closeOutbound(), this.loggerFactory);
    }

    @Override
    public boolean isOutboundDone() {
        return BoxesRunTime.unboxToBoolean(this.tracer("isOutboundDone", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<boolean> & Serializable)() -> this.engine.apply().isOutboundDone(), this.loggerFactory));
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return (String[])this.tracer("getSupportedCipherSuites", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<String[]> & Serializable)() -> this.engine.apply().getSupportedCipherSuites(), this.loggerFactory);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return (String[])this.tracer("getEnabledCipherSuites", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<String[]> & Serializable)() -> this.engine.apply().getEnabledCipherSuites(), this.loggerFactory);
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("suites");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, suites);
        this.tracer("setEnabledCipherSuites", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), () -> this.engine.apply().setEnabledCipherSuites(suites), this.loggerFactory);
    }

    @Override
    public String[] getSupportedProtocols() {
        return (String[])this.tracer("getSupportedProtocols", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<String[]> & Serializable)() -> this.engine.apply().getSupportedProtocols(), this.loggerFactory);
    }

    @Override
    public String[] getEnabledProtocols() {
        return (String[])this.tracer("getEnabledProtocols", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<String[]> & Serializable)() -> this.engine.apply().getEnabledProtocols(), this.loggerFactory);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("protocols");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, protocols);
        this.tracer("setEnabledProtocols", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), () -> this.engine.apply().setEnabledProtocols(protocols), this.loggerFactory);
    }

    @Override
    public SSLSession getSession() {
        return (SSLSession)this.tracer("getSession", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<SSLSession> & Serializable)() -> this.engine.apply().getSession(), this.loggerFactory);
    }

    @Override
    public void beginHandshake() {
        this.tracer("beginHandshake", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), () -> this.engine.apply().beginHandshake(), this.loggerFactory);
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return (SSLEngineResult.HandshakeStatus)((Object)this.tracer("getHandshakeStatus", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<SSLEngineResult.HandshakeStatus> & Serializable)() -> this.engine.apply().getHandshakeStatus(), this.loggerFactory));
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("clientMode");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToBoolean(clientMode));
        this.tracer("setUseClientMode", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), () -> this.engine.apply().setUseClientMode(clientMode), this.loggerFactory);
    }

    @Override
    public boolean getUseClientMode() {
        return BoxesRunTime.unboxToBoolean(this.tracer("getUseClientMode", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<boolean> & Serializable)() -> this.engine.apply().getUseClientMode(), this.loggerFactory));
    }

    @Override
    public void setNeedClientAuth(boolean needClientAuth) {
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("needClientAuth");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToBoolean(needClientAuth));
        this.tracer("setNeedClientAuth", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), () -> this.engine.apply().setNeedClientAuth(needClientAuth), this.loggerFactory);
    }

    @Override
    public boolean getNeedClientAuth() {
        return BoxesRunTime.unboxToBoolean(this.tracer("getNeedClientAuth", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<boolean> & Serializable)() -> this.engine.apply().getNeedClientAuth(), this.loggerFactory));
    }

    @Override
    public void setWantClientAuth(boolean wantClientAuth) {
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("wantClientAuth");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToBoolean(wantClientAuth));
        this.tracer("setWantClientAuth", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), () -> this.engine.apply().setWantClientAuth(wantClientAuth), this.loggerFactory);
    }

    @Override
    public boolean getWantClientAuth() {
        return BoxesRunTime.unboxToBoolean(this.tracer("getWantClientAuth", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<boolean> & Serializable)() -> this.engine.apply().getWantClientAuth(), this.loggerFactory));
    }

    @Override
    public void setEnableSessionCreation(boolean enableSessionCreation) {
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("enableSessionCreation");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToBoolean(enableSessionCreation));
        this.tracer("setEnableSessionCreation", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array)), () -> this.engine.apply().setEnableSessionCreation(enableSessionCreation), this.loggerFactory);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return BoxesRunTime.unboxToBoolean(this.tracer("getEnableSessionCreation", (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0])), (Function0<boolean> & Serializable)() -> this.engine.apply().getEnableSessionCreation(), this.loggerFactory));
    }

    @Override
    public boolean isLogEnabled(String methodName, Map<String, Object> parameters) {
        return this.debug.all() || this.debug.ssl();
    }
}

