/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.security.Security;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class SystemConfiguration {
    private final NoDepsLogger logger;

    public SystemConfiguration(LoggerFactory mkLogger) {
        this.logger = mkLogger.apply(this.getClass());
    }

    public NoDepsLogger logger() {
        return this.logger;
    }

    public void configure(SSLConfigSettings config) {
        config.loose().allowUnsafeRenegotiation().foreach((Function1<Object, Object> & Serializable)v1 -> {
            this.configure$$anonfun$1(BoxesRunTime.unboxToBoolean(v1));
            return BoxedUnit.UNIT;
        });
        config.loose().allowLegacyHelloMessages().foreach((Function1<Object, Object> & Serializable)v1 -> {
            this.configure$$anonfun$2(BoxesRunTime.unboxToBoolean(v1));
            return BoxedUnit.UNIT;
        });
        config.checkRevocation().foreach((Function1<Object, Object> & Serializable)v1 -> {
            this.configure$$anonfun$3(BoxesRunTime.unboxToBoolean(v1));
            return BoxedUnit.UNIT;
        });
    }

    public void configureUnsafeRenegotiation(boolean allowUnsafeRenegotiation) {
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", BoxesRunTime.boxToBoolean(allowUnsafeRenegotiation).toString());
        this.logger().debug("configureUnsafeRenegotiation: sun.security.ssl.allowUnsafeRenegotiation = " + BoxesRunTime.boxToBoolean(allowUnsafeRenegotiation).toString());
    }

    public void configureAllowLegacyHelloMessages(boolean allowLegacyHelloMessages) {
        System.setProperty("sun.security.ssl.allowLegacyHelloMessages", BoxesRunTime.boxToBoolean(allowLegacyHelloMessages).toString());
        this.logger().debug("configureAllowLegacyHelloMessages: sun.security.ssl.allowLegacyHelloMessages = " + BoxesRunTime.boxToBoolean(allowLegacyHelloMessages).toString());
    }

    public void configureCheckRevocation(boolean checkRevocation) {
        Security.setProperty("ocsp.enable", BoxesRunTime.boxToBoolean(checkRevocation).toString());
        this.logger().debug("configureCheckRevocation: ocsp.enable = " + BoxesRunTime.boxToBoolean(checkRevocation).toString());
        System.setProperty("com.sun.security.enableCRLDP", BoxesRunTime.boxToBoolean(checkRevocation).toString());
        this.logger().debug("configureCheckRevocation: com.sun.security.enableCRLDP = " + BoxesRunTime.boxToBoolean(checkRevocation).toString());
        System.setProperty("com.sun.net.ssl.checkRevocation", BoxesRunTime.boxToBoolean(checkRevocation).toString());
    }

    public void clearProperties() {
        Security.setProperty("ocsp.enable", "false");
        System.clearProperty("com.sun.security.enableCRLDP");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("sun.security.ssl.allowLegacyHelloMessages");
        System.clearProperty("sun.security.ssl.allowUnsafeRenegotiation");
    }

    private final /* synthetic */ void configure$$anonfun$1(boolean allowUnsafeRenegotiation) {
        this.configureUnsafeRenegotiation(allowUnsafeRenegotiation);
    }

    private final /* synthetic */ void configure$$anonfun$2(boolean allowLegacyHelloMessages) {
        this.configureAllowLegacyHelloMessages(allowLegacyHelloMessages);
    }

    private final /* synthetic */ void configure$$anonfun$3(boolean checkRevocation) {
        this.configureCheckRevocation(checkRevocation);
    }
}

