/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.ClientAuth$Default$;
import com.typesafe.sslconfig.ssl.ClientAuth$Need$;
import com.typesafe.sslconfig.ssl.ClientAuth$None$;
import com.typesafe.sslconfig.ssl.ClientAuth$Want$;
import com.typesafe.sslconfig.ssl.KeyManagerConfig;
import com.typesafe.sslconfig.ssl.KeyStoreConfig;
import com.typesafe.sslconfig.ssl.NoopHostnameVerifier;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.SSLConfigSettings$;
import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.SSLDebugConfig$;
import com.typesafe.sslconfig.ssl.SSLLooseConfig;
import com.typesafe.sslconfig.ssl.SSLLooseConfig$;
import com.typesafe.sslconfig.ssl.SSLParametersConfig;
import com.typesafe.sslconfig.ssl.TrustManagerConfig;
import com.typesafe.sslconfig.ssl.TrustStoreConfig;
import com.typesafe.sslconfig.util.ConfigLoader$;
import com.typesafe.sslconfig.util.EnrichedConfig;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class SSLConfigParser {
    private final EnrichedConfig c;
    private final ClassLoader classLoader;
    private final Option<LoggerFactory> loggerFactory;

    public SSLConfigParser(EnrichedConfig c, ClassLoader classLoader, Option<LoggerFactory> loggerFactory) {
        this.c = c;
        this.classLoader = classLoader;
        this.loggerFactory = loggerFactory;
    }

    public SSLConfigParser(EnrichedConfig c, ClassLoader classLoader) {
        this(c, classLoader, None$.MODULE$);
    }

    public SSLConfigSettings parse() {
        Class clazz;
        boolean bl = BoxesRunTime.unboxToBoolean(this.c.get("default", ConfigLoader$.MODULE$.booleanLoader()));
        String protocol = this.c.get("protocol", ConfigLoader$.MODULE$.stringLoader());
        Option<Object> checkRevocation = this.c.getOptional("checkRevocation", ConfigLoader$.MODULE$.booleanLoader());
        Option<Seq<URL>> revocationLists = Some$.MODULE$.apply(this.c.getSeq("revocationLists", ConfigLoader$.MODULE$.seqStringLoader()).map((Function1<String, URL> & Serializable)_$1 -> new URL((String)_$1))).filter((Function1<Seq, boolean> & Serializable)_$2 -> _$2.nonEmpty());
        SSLDebugConfig debug = this.parseDebug(this.c.get("debug", ConfigLoader$.MODULE$.playConfigLoader()));
        SSLLooseConfig looseOptions = this.parseLooseOptions(this.c.get("loose", ConfigLoader$.MODULE$.playConfigLoader()));
        Option<Seq<String>> ciphers = Some$.MODULE$.apply(this.c.getSeq("enabledCipherSuites", ConfigLoader$.MODULE$.seqStringLoader())).filter((Function1<Seq, boolean> & Serializable)_$3 -> _$3.nonEmpty());
        Option<Seq<String>> protocols = Some$.MODULE$.apply(this.c.getSeq("enabledProtocols", ConfigLoader$.MODULE$.seqStringLoader())).filter((Function1<Seq, boolean> & Serializable)_$4 -> _$4.nonEmpty());
        Option<String> option = this.c.getOptional("hostnameVerifierClass", ConfigLoader$.MODULE$.stringLoader());
        if (None$.MODULE$.equals(option)) {
            clazz = NoopHostnameVerifier.class;
        } else if (option instanceof Some) {
            String fqcn = (String)((Some)option).value();
            clazz = this.classLoader.loadClass(fqcn).asSubclass(HostnameVerifier.class);
        } else {
            throw new MatchError(option);
        }
        Class<NoopHostnameVerifier> hostnameVerifierClass = clazz;
        KeyManagerConfig keyManagers = this.parseKeyManager(this.c.get("keyManager", ConfigLoader$.MODULE$.playConfigLoader()));
        TrustManagerConfig trustManagers = this.parseTrustManager(this.c.get("trustManager", ConfigLoader$.MODULE$.playConfigLoader()));
        SSLParametersConfig sslParametersConfig = this.parseSSLParameters(this.c.get("sslParameters", ConfigLoader$.MODULE$.playConfigLoader()));
        None$ none$ = None$.MODULE$;
        Seq<String> seq = SSLConfigSettings$.MODULE$.$lessinit$greater$default$7();
        return new SSLConfigSettings(bl, protocol, checkRevocation, revocationLists, ciphers, protocols, seq, sslParametersConfig, keyManagers, trustManagers, hostnameVerifierClass, none$, debug, looseOptions);
    }

    public SSLLooseConfig parseLooseOptions(EnrichedConfig config) {
        Option<Object> allowMessages = config.getOptional("allowLegacyHelloMessages", ConfigLoader$.MODULE$.booleanLoader());
        Option<Object> allowUnsafeRenegotiation = config.getOptional("allowUnsafeRenegotiation", ConfigLoader$.MODULE$.booleanLoader());
        boolean disableHostnameVerification = BoxesRunTime.unboxToBoolean(config.get("disableHostnameVerification", ConfigLoader$.MODULE$.booleanLoader()));
        boolean disableSNI = BoxesRunTime.unboxToBoolean(config.get("disableSNI", ConfigLoader$.MODULE$.booleanLoader()));
        boolean acceptAnyCertificate = BoxesRunTime.unboxToBoolean(config.get("acceptAnyCertificate", ConfigLoader$.MODULE$.booleanLoader()));
        return new SSLLooseConfig(acceptAnyCertificate, allowMessages, allowUnsafeRenegotiation, SSLLooseConfig$.MODULE$.$lessinit$greater$default$4(), SSLLooseConfig$.MODULE$.$lessinit$greater$default$5(), disableHostnameVerification, disableSNI);
    }

    public SSLDebugConfig parseDebug(EnrichedConfig config) {
        SSLDebugConfig sSLDebugConfig;
        if (BoxesRunTime.unboxToBoolean(config.get("all", ConfigLoader$.MODULE$.booleanLoader()))) {
            sSLDebugConfig = new SSLDebugConfig(true, SSLDebugConfig$.MODULE$.$lessinit$greater$default$2(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$3(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$4(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$5(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$6(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$7(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$8(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$9(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$10(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$11(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$12(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$13(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$14());
        } else {
            boolean ssl = BoxesRunTime.unboxToBoolean(config.get("ssl", ConfigLoader$.MODULE$.booleanLoader()));
            boolean sslctx = BoxesRunTime.unboxToBoolean(config.get("sslctx", ConfigLoader$.MODULE$.booleanLoader()));
            boolean keymanager = BoxesRunTime.unboxToBoolean(config.get("keymanager", ConfigLoader$.MODULE$.booleanLoader()));
            boolean trustmanager = BoxesRunTime.unboxToBoolean(config.get("trustmanager", ConfigLoader$.MODULE$.booleanLoader()));
            this.loggerFactory.foreach(lf -> {
                NoDepsLogger logger = lf.apply(this.getClass());
                Seq deprecatedSettings = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"plaintext", "packet", "handshake", "data", "verbose", "keygen", "session", "defaultctx", "sessioncache", "pluggability"}));
                deprecatedSettings.foreach(setting -> {
                    if (BoxesRunTime.unboxToBoolean(config.get((String)setting, ConfigLoader$.MODULE$.booleanLoader()))) {
                        logger.warn("" + setting + " is a deprecated debug setting and has no effect!");
                    }
                });
            });
            sSLDebugConfig = new SSLDebugConfig(SSLDebugConfig$.MODULE$.$lessinit$greater$default$1(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$2(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$3(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$4(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$5(), keymanager, SSLDebugConfig$.MODULE$.$lessinit$greater$default$7(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$8(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$9(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$10(), SSLDebugConfig$.MODULE$.$lessinit$greater$default$11(), ssl, sslctx, trustmanager);
        }
        return sSLDebugConfig;
    }

    public KeyStoreConfig parseKeyStoreInfo(EnrichedConfig config) {
        String storeType = (String)config.getOptional("type", ConfigLoader$.MODULE$.stringLoader()).getOrElse(SSLConfigParser::$anonfun$5);
        Option<String> path = config.getOptional("path", ConfigLoader$.MODULE$.stringLoader());
        boolean classPath = BoxesRunTime.unboxToBoolean(config.getOptional("classpath", ConfigLoader$.MODULE$.booleanLoader()).getOrElse(SSLConfigParser::$anonfun$6));
        Option<String> data = config.getOptional("data", ConfigLoader$.MODULE$.stringLoader());
        Option<String> password = config.getOptional("password", ConfigLoader$.MODULE$.stringLoader());
        return new KeyStoreConfig(data, path, classPath, password, storeType);
    }

    public TrustStoreConfig parseTrustStoreInfo(EnrichedConfig config) {
        String storeType = (String)config.getOptional("type", ConfigLoader$.MODULE$.stringLoader()).getOrElse(SSLConfigParser::$anonfun$7);
        Option<String> path = config.getOptional("path", ConfigLoader$.MODULE$.stringLoader());
        boolean classPath = BoxesRunTime.unboxToBoolean(config.getOptional("classpath", ConfigLoader$.MODULE$.booleanLoader()).getOrElse(SSLConfigParser::$anonfun$8));
        Option<String> data = config.getOptional("data", ConfigLoader$.MODULE$.stringLoader());
        Option<String> password = config.getOptional("password", ConfigLoader$.MODULE$.stringLoader());
        return new TrustStoreConfig(data, path, password, classPath, storeType);
    }

    public KeyManagerConfig parseKeyManager(EnrichedConfig config) {
        String string2;
        Option<String> option = config.getOptional("algorithm", ConfigLoader$.MODULE$.stringLoader());
        if (None$.MODULE$.equals(option)) {
            string2 = KeyManagerFactory.getDefaultAlgorithm();
        } else if (option instanceof Some) {
            String other;
            string2 = other = (String)((Some)option).value();
        } else {
            throw new MatchError(option);
        }
        String algorithm = string2;
        Seq keyStoreInfos = (Seq)config.getPrototypedSeq("stores", config.getPrototypedSeq$default$2()).map((Function1<EnrichedConfig, KeyStoreConfig> & Serializable)store -> this.parseKeyStoreInfo((EnrichedConfig)store));
        return new KeyManagerConfig(algorithm, keyStoreInfos);
    }

    public TrustManagerConfig parseTrustManager(EnrichedConfig config) {
        String string2;
        Option<String> option = config.getOptional("algorithm", ConfigLoader$.MODULE$.stringLoader());
        if (None$.MODULE$.equals(option)) {
            string2 = TrustManagerFactory.getDefaultAlgorithm();
        } else if (option instanceof Some) {
            String other;
            string2 = other = (String)((Some)option).value();
        } else {
            throw new MatchError(option);
        }
        String algorithm = string2;
        Seq trustStoreInfos = (Seq)config.getPrototypedSeq("stores", config.getPrototypedSeq$default$2()).map((Function1<EnrichedConfig, TrustStoreConfig> & Serializable)store -> this.parseTrustStoreInfo((EnrichedConfig)store));
        return new TrustManagerConfig(algorithm, trustStoreInfos);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public SSLParametersConfig parseSSLParameters(EnrichedConfig config) {
        var3_2 = config.getOptional("clientAuth", ConfigLoader$.MODULE$.stringLoader());
        if (!(var3_2 instanceof Some)) ** GOTO lbl-1000
        var4_3 = (String)((Some)var3_2).value();
        if ("none".equals(var4_3)) {
            v0 /* !! */  = ClientAuth$None$.MODULE$;
        } else if ("want".equals(var4_3)) {
            v0 /* !! */  = ClientAuth$Want$.MODULE$;
        } else if ("need".equals(var4_3)) {
            v0 /* !! */  = ClientAuth$Need$.MODULE$;
        } else if (None$.MODULE$.equals(var3_2) || var3_2 instanceof Some) {
            v0 /* !! */  = ClientAuth$Default$.MODULE$;
        } else {
            throw new MatchError(var3_2);
        }
        clientAuth = v0 /* !! */ ;
        protocols = config.getSeq("protocols", ConfigLoader$.MODULE$.seqStringLoader());
        return new SSLParametersConfig(clientAuth, protocols);
    }

    private static final String $anonfun$5() {
        return KeyStore.getDefaultType();
    }

    private static final boolean $anonfun$6() {
        return false;
    }

    private static final String $anonfun$7() {
        return KeyStore.getDefaultType();
    }

    private static final boolean $anonfun$8() {
        return false;
    }
}

