/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.FakeKeyStore$;
import com.typesafe.sslconfig.ssl.FakeKeyStore$KeystoreSettings$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import sun.security.x509.X509CertImpl;

public final class FakeKeyStore {
    private final NoDepsLogger logger;

    public static X509Certificate createSelfSignedCertificate(KeyPair keyPair) {
        return FakeKeyStore$.MODULE$.createSelfSignedCertificate(keyPair);
    }

    public static KeyStore generateKeyStore() {
        return FakeKeyStore$.MODULE$.generateKeyStore();
    }

    public FakeKeyStore(LoggerFactory mkLogger) {
        this.logger = mkLogger.apply(this.getClass());
    }

    public File getKeyStoreFilePath(File appPath) {
        return new File(appPath, FakeKeyStore$KeystoreSettings$.MODULE$.GeneratedKeyStore());
    }

    public boolean shouldGenerate(File keyStoreFile) {
        if (!keyStoreFile.exists()) {
            return true;
        }
        KeyStore store = this.loadKeyStore(keyStoreFile);
        return ((IterableOnceOps)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(store.aliases()).asScala()).exists((Function1<String, boolean> & Serializable)alias -> Option$.MODULE$.apply(store.getCertificate((String)alias)).exists((Function1<Certificate, Object>)(Function1<Certificate, boolean> & Serializable)c -> this.certificateTooWeak((Certificate)c)));
    }

    /*
     * WARNING - void declaration
     */
    private KeyStore loadKeyStore(File file) {
        void var2_2;
        KeyStore keyStore = KeyStore.getInstance(FakeKeyStore$KeystoreSettings$.MODULE$.KeystoreType());
        InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        try {
            keyStore.load(in, "".toCharArray());
        }
        finally {
            this.closeQuietly(in);
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean certificateTooWeak(Certificate c) {
        RSAPublicKey key2 = (RSAPublicKey)c.getPublicKey();
        if (key2.getModulus().bitLength() < FakeKeyStore$KeystoreSettings$.MODULE$.KeyPairKeyLength()) return true;
        String string2 = ((X509CertImpl)c).getSigAlgName();
        String string3 = FakeKeyStore$KeystoreSettings$.MODULE$.SignatureAlgorithmName();
        if (string2 == null) {
            if (string3 == null) return false;
            return true;
        } else if (string2.equals(string3)) return false;
        return true;
    }

    public KeyStore createKeyStore(File appPath) {
        KeyStore keyStore;
        File keyStoreFile = this.getKeyStoreFilePath(appPath);
        File keyStoreDir = keyStoreFile.getParentFile();
        this.createKeystoreParentDirectory(keyStoreDir);
        FakeKeyStore fakeKeyStore = this;
        synchronized (fakeKeyStore) {
            KeyStore keyStore2;
            if (this.shouldGenerate(keyStoreFile)) {
                this.logger.info("Generating HTTPS key pair in " + keyStoreFile.getAbsolutePath() + " - this may take some time. If nothing happens, try moving the mouse/typing on the keyboard to generate some entropy.");
                KeyStore freshKeyStore = FakeKeyStore$.MODULE$.generateKeyStore();
                OutputStream out = Files.newOutputStream(keyStoreFile.toPath(), new OpenOption[0]);
                try {
                    freshKeyStore.store(out, FakeKeyStore$KeystoreSettings$.MODULE$.keystorePassword());
                }
                finally {
                    this.closeQuietly(out);
                }
                keyStore2 = freshKeyStore;
            } else {
                KeyStore loadedKeyStore = this.loadKeyStore(keyStoreFile);
                this.logger.info("HTTPS key pair generated in " + keyStoreFile.getAbsolutePath() + ".");
                keyStore2 = loadedKeyStore;
            }
            keyStore = keyStore2;
        }
        KeyStore keyStore3 = keyStore;
        return keyStore3;
    }

    private void createKeystoreParentDirectory(File keyStoreDir) {
        if (keyStoreDir.mkdirs()) {
            this.logger.debug("Parent directory for keystore successfully created at " + keyStoreDir.getAbsolutePath());
        } else if (keyStoreDir.exists() && keyStoreDir.isDirectory()) {
            this.logger.debug("No need to create " + keyStoreDir + " since it already exists.");
        } else {
            if (keyStoreDir.exists() && keyStoreDir.isFile()) {
                throw new IllegalStateException("" + keyStoreDir + " exists, but it is NOT a directory, making it not possible to generate a key store file.");
            }
            throw new IllegalStateException("Failed to create " + keyStoreDir + ". Check if there is permission to create such folder.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public KeyManagerFactory keyManagerFactory(File appPath) {
        void var3_3;
        KeyStore keyStore = this.createKeyStore(appPath);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, FakeKeyStore$KeystoreSettings$.MODULE$.keystorePassword());
        return var3_3;
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            this.logger.warn("Error closing stream. Cause: " + e);
        }
    }
}

