/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.CompositeX509KeyManager;
import com.typesafe.sslconfig.ssl.CompositeX509TrustManager;
import com.typesafe.sslconfig.ssl.FileBasedKeyStoreBuilder;
import com.typesafe.sslconfig.ssl.FileOnClasspathBasedKeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeyManagerConfig;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.KeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeyStoreConfig;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.SSLContextBuilder;
import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.SimpleSSLContextBuilder;
import com.typesafe.sslconfig.ssl.StringBasedKeyStoreBuilder;
import com.typesafe.sslconfig.ssl.TrustManagerConfig;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.TrustStoreConfig;
import com.typesafe.sslconfig.ssl.tracing.TracingSSLContext;
import com.typesafe.sslconfig.ssl.tracing.TracingX509ExtendedKeyManager;
import com.typesafe.sslconfig.ssl.tracing.TracingX509ExtendedTrustManager;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import javax.crypto.BadPaddingException;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ConfigSSLContextBuilder
implements SSLContextBuilder {
    private final LoggerFactory mkLogger;
    private final SSLConfigSettings info;
    private final KeyManagerFactoryWrapper keyManagerFactory;
    private final TrustManagerFactoryWrapper trustManagerFactory;
    private final NoDepsLogger logger;

    public ConfigSSLContextBuilder(LoggerFactory mkLogger, SSLConfigSettings info, KeyManagerFactoryWrapper keyManagerFactory, TrustManagerFactoryWrapper trustManagerFactory) {
        this.mkLogger = mkLogger;
        this.info = info;
        this.keyManagerFactory = keyManagerFactory;
        this.trustManagerFactory = trustManagerFactory;
        this.logger = mkLogger.apply(this.getClass());
    }

    public NoDepsLogger logger() {
        return this.logger;
    }

    @Override
    public SSLContext build() {
        Option<Seq<CRL>> revocationLists = this.certificateRevocationList(this.info);
        Nil$ keyManagers = this.info.keyManagerConfig().keyStoreConfigs().nonEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CompositeX509KeyManager[]{this.buildCompositeKeyManager(this.info.keyManagerConfig(), this.info.debug())})) : package$.MODULE$.Nil();
        Nil$ trustManagers = this.info.trustManagerConfig().trustStoreConfigs().nonEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CompositeX509TrustManager[]{this.buildCompositeTrustManager(this.info.trustManagerConfig(), BoxesRunTime.unboxToBoolean(this.info.checkRevocation().getOrElse(ConfigSSLContextBuilder::$anonfun$1)), revocationLists, this.info.debug())})) : package$.MODULE$.Nil();
        SSLContext context = this.buildSSLContext(this.info.protocol(), keyManagers, trustManagers, this.info.secureRandom());
        return this.info.debug().enabled() ? new TracingSSLContext(context, this.info.debug(), this.mkLogger) : context;
    }

    public SSLContext buildSSLContext(String protocol, Seq<KeyManager> keyManagers, Seq<TrustManager> trustManagers, Option<SecureRandom> secureRandom) {
        SimpleSSLContextBuilder builder = new SimpleSSLContextBuilder(protocol, keyManagers, trustManagers, secureRandom);
        return builder.build();
    }

    public CompositeX509KeyManager buildCompositeKeyManager(KeyManagerConfig keyManagerConfig, SSLDebugConfig debug) {
        Seq keyManagers = (Seq)keyManagerConfig.keyStoreConfigs().map((Function1<KeyStoreConfig, X509KeyManager> & Serializable)ksc -> this.buildKeyManager((KeyStoreConfig)ksc, debug));
        return new CompositeX509KeyManager(this.mkLogger, keyManagers);
    }

    public CompositeX509TrustManager buildCompositeTrustManager(TrustManagerConfig trustManagerInfo, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, SSLDebugConfig debug) {
        Seq trustManagers = (Seq)trustManagerInfo.trustStoreConfigs().map((Function1<TrustStoreConfig, X509TrustManager> & Serializable)tsc -> this.buildTrustManager((TrustStoreConfig)tsc, revocationEnabled, revocationLists, debug));
        return new CompositeX509TrustManager(this.mkLogger, trustManagers);
    }

    public KeyStoreBuilder keyStoreBuilder(KeyStoreConfig ksc) {
        Option password = ksc.password().map((Function1<String, char[]> & Serializable)_$1 -> _$1.toCharArray());
        return (KeyStoreBuilder)ksc.filePath().map((Function1<String, KeyStoreBuilder> & Serializable)f -> ksc.isFileOnClasspath() ? this.fileOnClasspathBuilder(ksc.storeType(), (String)f, password) : this.fileBuilder(ksc.storeType(), (String)f, password)).getOrElse(() -> this.keyStoreBuilder$$anonfun$2(ksc));
    }

    public KeyStoreBuilder trustStoreBuilder(TrustStoreConfig tsc) {
        return (KeyStoreBuilder)tsc.filePath().map((Function1<String, KeyStoreBuilder> & Serializable)f -> {
            Option<char[]> password = tsc.password().map((Function1<String, char[]> & Serializable)_$2 -> _$2.toCharArray());
            return tsc.isFileOnClasspath() ? this.fileOnClasspathBuilder(tsc.storeType(), (String)f, password) : this.fileBuilder(tsc.storeType(), (String)f, password);
        }).getOrElse(() -> this.trustStoreBuilder$$anonfun$2(tsc));
    }

    public KeyStoreBuilder fileBuilder(String storeType, String filePath, Option<char[]> password) {
        return new FileBasedKeyStoreBuilder(storeType, filePath, password);
    }

    public KeyStoreBuilder fileOnClasspathBuilder(String storeType, String filePath, Option<char[]> password) {
        return new FileOnClasspathBasedKeyStoreBuilder(storeType, filePath, password);
    }

    public KeyStoreBuilder stringBuilder(String data) {
        return new StringBasedKeyStoreBuilder(data);
    }

    public boolean warnOnPKCS12EmptyPasswordBug(KeyStoreConfig ksc) {
        return ksc.storeType().equalsIgnoreCase("pkcs12") && !ksc.password().exists((Function1<String, Object>)(Function1<String, boolean> & Serializable)_$3 -> !_$3.isEmpty());
    }

    public X509KeyManager buildKeyManager(KeyStoreConfig ksc, SSLDebugConfig debug) {
        KeyStore keyStore;
        try {
            keyStore = this.keyStoreBuilder(ksc).build();
        }
        catch (BadPaddingException bpe) {
            throw new SecurityException("Mac verify error: invalid password?", bpe);
        }
        KeyStore keyStore2 = keyStore;
        if (!this.validateStoreContainsPrivateKeys(ksc, keyStore2)) {
            this.logger().warn("Client authentication is not possible as there are no private keys found in " + ksc.filePath());
        }
        KeyManagerFactoryWrapper factory = this.keyManagerFactory;
        try {
            Option password = ksc.password().map((Function1<String, char[]> & Serializable)_$4 -> _$4.toCharArray());
            factory.init(keyStore2, (char[])password.orNull($less$colon$less$.MODULE$.refl()));
        }
        catch (UnrecoverableKeyException e) {
            this.logger().error("Unrecoverable key in keystore " + ksc);
            throw new IllegalStateException(e);
        }
        Object[] keyManagers = factory.getKeyManagers();
        if (keyManagers == null) {
            String msg = "Cannot create key manager with configuration " + ksc;
            throw new IllegalStateException(msg);
        }
        Object object = Predef$.MODULE$.refArrayOps(keyManagers);
        X509ExtendedKeyManager keyManager = (X509ExtendedKeyManager)((KeyManager)ArrayOps$.MODULE$.head$extension(object));
        return new TracingX509ExtendedKeyManager(() -> ConfigSSLContextBuilder.buildKeyManager$$anonfun$1(keyManager), debug, this.mkLogger);
    }

    public Option<Seq<CRL>> certificateRevocationList(SSLConfigSettings sslConfig) {
        return sslConfig.revocationLists().map((Function1<Seq, Seq> & Serializable)urls -> (Seq)urls.map((Function1<URL, CRL> & Serializable)url -> this.generateCRLFromURL((URL)url)));
    }

    /*
     * WARNING - void declaration
     */
    public CRL generateCRL(InputStream inputStream) {
        void var3_3;
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509CRL crl = (X509CRL)cf.generateCRL(inputStream);
        return var3_3;
    }

    public CRL generateCRLFromURL(URL url) {
        CRL cRL;
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        connection.setUseCaches(false);
        try (DataInputStream inStream = new DataInputStream(connection.getInputStream());){
            cRL = this.generateCRL(inStream);
        }
        return cRL;
    }

    public CRL generateCRLFromFile(File file) {
        CRL cRL;
        BufferedInputStream fileStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        try (DataInputStream inStream = new DataInputStream(fileStream);){
            cRL = this.generateCRL(inStream);
        }
        return cRL;
    }

    public CertPathTrustManagerParameters buildTrustManagerParameters(KeyStore trustStore, boolean revocationEnabled, Option<Seq<CRL>> revocationLists) {
        X509CertSelector certSelect = new X509CertSelector();
        PKIXBuilderParameters pkixParameters = new PKIXBuilderParameters(trustStore, (CertSelector)certSelect);
        pkixParameters.setRevocationEnabled(revocationEnabled);
        revocationLists.map(crlList -> pkixParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(JavaConverters$.MODULE$.asJavaCollectionConverter(crlList).asJavaCollection()))));
        return new CertPathTrustManagerParameters(pkixParameters);
    }

    public X509TrustManager buildTrustManager(TrustStoreConfig tsc, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, SSLDebugConfig debug) {
        TrustManagerFactoryWrapper factory = this.trustManagerFactory;
        KeyStore trustStore = this.trustStoreBuilder(tsc).build();
        CertPathTrustManagerParameters trustManagerParameters = this.buildTrustManagerParameters(trustStore, revocationEnabled, revocationLists);
        factory.init(trustManagerParameters);
        Object[] trustManagers = factory.getTrustManagers();
        if (trustManagers == null) {
            String msg = "Cannot create trust manager with configuration " + tsc;
            throw new IllegalStateException(msg);
        }
        Object object = Predef$.MODULE$.refArrayOps(trustManagers);
        X509ExtendedTrustManager manager = (X509ExtendedTrustManager)((TrustManager)ArrayOps$.MODULE$.head$extension(object));
        return new TracingX509ExtendedTrustManager(() -> ConfigSSLContextBuilder.buildTrustManager$$anonfun$1(manager), debug, this.mkLogger);
    }

    public boolean validateStoreContainsPrivateKeys(KeyStoreConfig ksc, KeyStore keyStore) {
        char[] password = (char[])ksc.password().map((Function1<String, char[]> & Serializable)_$5 -> _$5.toCharArray()).orNull($less$colon$less$.MODULE$.refl());
        BooleanRef containsPrivateKeys = BooleanRef.create(false);
        ((IterableOnceOps)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(keyStore.aliases()).asScala()).foreach(keyAlias -> {
            Key key2 = keyStore.getKey((String)keyAlias, password);
            Key key3 = key2;
            if (key3 instanceof PrivateKey) {
                boolean bl;
                PrivateKey privateKey = (PrivateKey)key3;
                this.logger().debug("validateStoreContainsPrivateKeys: private key found for alias " + keyAlias);
                containsPrivateKeys$1.elem = bl = true;
            } else {
                Key otherKey = key3;
                String msg = "validateStoreContainsPrivateKeys: No private key found for alias " + keyAlias + ", it cannot be used for client authentication";
                this.logger().warn(msg);
            }
        });
        return containsPrivateKeys.elem;
    }

    private static final boolean $anonfun$1() {
        return false;
    }

    private static final String $anonfun$7() {
        throw new IllegalStateException("No keystore builder found!");
    }

    private final KeyStoreBuilder keyStoreBuilder$$anonfun$2(KeyStoreConfig ksc$2) {
        String data = (String)ksc$2.data().getOrElse(ConfigSSLContextBuilder::$anonfun$7);
        return this.stringBuilder(data);
    }

    private static final String $anonfun$9() {
        throw new IllegalStateException("No truststore builder found!");
    }

    private final KeyStoreBuilder trustStoreBuilder$$anonfun$2(TrustStoreConfig tsc$2) {
        String data = (String)tsc$2.data().getOrElse(ConfigSSLContextBuilder::$anonfun$9);
        return this.stringBuilder(data);
    }

    private static final X509ExtendedKeyManager buildKeyManager$$anonfun$1(X509ExtendedKeyManager keyManager$1) {
        return keyManager$1;
    }

    private static final X509ExtendedTrustManager buildTrustManager$$anonfun$1(X509ExtendedTrustManager manager$1) {
        return manager$1;
    }
}

