/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.CompositeCertificateException;
import com.typesafe.sslconfig.ssl.package$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class CompositeX509TrustManager
implements X509TrustManager {
    private final Seq<X509TrustManager> trustManagers;
    private final NoDepsLogger logger;

    public CompositeX509TrustManager(LoggerFactory mkLogger, Seq<X509TrustManager> trustManagers) {
        this.trustManagers = trustManagers;
        this.logger = mkLogger.apply(this.getClass());
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        this.logger.debug("getAcceptedIssuers: ");
        ArrayBuffer certificates = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new X509Certificate[0]));
        Seq<Throwable> exceptionList = this.withTrustManagers(trustManager -> certificates.$plus$plus$eq(Predef$.MODULE$.wrapRefArray(trustManager.getAcceptedIssuers())));
        if (!exceptionList.isEmpty()) {
            String msg = ((Throwable)exceptionList.apply(false)).getMessage();
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
        return (X509Certificate[])certificates.toArray(ClassTag$.MODULE$.apply(X509Certificate.class));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
        this.logger.debug("checkClientTrusted: chain = " + package$.MODULE$.debugChain(chain));
        TrustAnchor anchor2 = new TrustAnchor(chain[chain.length - 1], null);
        BooleanRef trusted = BooleanRef.create(false);
        Seq<Throwable> exceptionList = this.withTrustManagers(trustManager -> {
            boolean bl;
            trustManager.checkClientTrusted(chain, authType);
            this.logger.debug("checkClientTrusted: trustManager " + trustManager + " found a match for " + package$.MODULE$.debugChain(chain));
            trusted$1.elem = bl = true;
        });
        if (!trusted.elem) {
            String msg = "No trust manager was able to validate this certificate chain.";
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
        this.logger.debug("checkServerTrusted: chain = " + package$.MODULE$.debugChain(chain) + ", authType = " + authType);
        BooleanRef trusted = BooleanRef.create(false);
        Seq<Throwable> exceptionList = this.withTrustManagers(trustManager -> {
            boolean bl;
            trustManager.checkServerTrusted(chain, authType);
            this.logger.debug("checkServerTrusted: trustManager " + trustManager + " using authType " + authType + " found a match for " + package$.MODULE$.debugChain(chain).toSeq());
            trusted$2.elem = bl = true;
        });
        if (!trusted.elem) {
            String msg = "No trust manager was able to validate this certificate chain: # of exceptions = " + exceptionList.size();
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
    }

    private Seq<Throwable> withTrustManagers(Function1<X509TrustManager, BoxedUnit> block) {
        ArrayBuffer exceptionList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Throwable[0]));
        this.trustManagers.foreach((Function1<X509TrustManager, Object> & Serializable)trustManager -> this.liftedTree1$1(block, exceptionList, (X509TrustManager)trustManager));
        return exceptionList.toSeq();
    }

    public String toString() {
        return "CompositeX509TrustManager(trustManagers = [" + this.trustManagers + "])";
    }

    private final Object liftedTree1$1(Function1 block$2, ArrayBuffer exceptionList$2, X509TrustManager trustManager$1) {
        Object object;
        try {
            object = block$2.apply(trustManager$1);
        }
        catch (CertPathBuilderException e) {
            this.logger.debug("No path found to certificate: this usually means the CA is not in the trust store. Cause: " + e);
            object = exceptionList$2.append(e);
        }
        catch (GeneralSecurityException e) {
            this.logger.debug("General security exception. Cause: " + e);
            object = exceptionList$2.append(e);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                this.logger.debug("Unexpected exception! Cause: " + e);
                object = (ArrayBuffer)exceptionList$2.append(e);
            }
            throw throwable;
        }
        return object;
    }
}

