/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.pekko.util;

import com.typesafe.sslconfig.util.NoDepsLogger;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$Debug$;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.event.Logging$Info$;
import org.apache.pekko.event.Logging$Warning$;

public class PekkoLoggerBridge
extends NoDepsLogger {
    private final EventStream bus;
    private final String logSource;
    private final Class<?> logClass;

    public PekkoLoggerBridge(EventStream bus, String logSource, Class<?> logClass) {
        this.bus = bus;
        this.logSource = logSource;
        this.logClass = logClass;
    }

    public PekkoLoggerBridge(EventStream bus, Class<?> clazz) {
        this(bus, clazz.getCanonicalName(), clazz);
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public void debug(String msg) {
        this.bus.publish(Logging$Debug$.MODULE$.apply(this.logSource, this.logClass, msg));
    }

    @Override
    public void info(String msg) {
        this.bus.publish(Logging$Info$.MODULE$.apply(this.logSource, this.logClass, msg));
    }

    @Override
    public void warn(String msg) {
        this.bus.publish(Logging$Warning$.MODULE$.apply(this.logSource, this.logClass, msg));
    }

    @Override
    public void error(String msg) {
        this.bus.publish(Logging$Error$.MODULE$.apply(this.logSource, this.logClass, msg));
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.bus.publish(Logging$Error$.MODULE$.apply(this.logSource, this.logClass, msg));
    }
}

