/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public final class PropertiesUtils {
    public static int getIntProperty(Properties properties, String string2, int n) throws NumberFormatException {
        String string3 = properties.getProperty(string2);
        return string3 != null ? Integer.parseInt(string3) : n;
    }

    public static Properties fromString(String string2, String string3) throws UnsupportedEncodingException {
        try {
            Properties properties = new Properties();
            if (string2 != null) {
                byte[] byArray = string2.getBytes(string3);
                properties.load(new ByteArrayInputStream(byArray));
            }
            return properties;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw new Error("Huh? An IOException while working with byte array streams?!", iOException);
        }
    }

    public static Properties fromString(String string2) {
        try {
            return PropertiesUtils.fromString(string2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Huh? An ISO-8859-1 is an unsupported encoding?!", unsupportedEncodingException);
        }
    }

    public static String toString(Properties properties, String string2, String string3) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, string2);
            byteArrayOutputStream.flush();
            return new String(byteArrayOutputStream.toByteArray(), string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw new Error("Huh? An IOException while working with byte array streams?!", iOException);
        }
    }

    public static String toString(Properties properties, String string2) {
        try {
            return PropertiesUtils.toString(properties, string2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Huh? An ISO-8859-1 is an unsupported encoding?!", unsupportedEncodingException);
        }
    }

    private PropertiesUtils() {
    }
}

