/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogConfig;
import com.mchange.v2.log.MLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class FallbackMLog
extends MLog {
    static final MLevel DEFAULT_CUTOFF_LEVEL;
    static final String SEP;
    MLogger logger = new FallbackMLogger();

    @Override
    public MLogger getMLogger(String string2) {
        return this.logger;
    }

    @Override
    public MLogger getMLogger() {
        return this.logger;
    }

    static {
        MLevel mLevel = null;
        String string2 = MLogConfig.getProperty("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL");
        if (string2 != null) {
            mLevel = MLevel.fromSeverity(string2);
        }
        if (mLevel == null) {
            mLevel = MLevel.INFO;
        }
        DEFAULT_CUTOFF_LEVEL = mLevel;
        SEP = System.getProperty("line.separator");
    }

    private static final class FallbackMLogger
    implements MLogger {
        MLevel cutoffLevel = DEFAULT_CUTOFF_LEVEL;

        private FallbackMLogger() {
        }

        private void formatrb(MLevel mLevel, String string2, String string3, String string4, String string5, Object[] objectArray, Throwable throwable) {
            String string6;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string4);
            if (string5 != null && resourceBundle != null && (string6 = resourceBundle.getString(string5)) != null) {
                string5 = string6;
            }
            this.format(mLevel, string2, string3, string5, objectArray, throwable);
        }

        private void format(MLevel mLevel, String string2, String string3, String string4, Object[] objectArray, Throwable throwable) {
            System.err.println(this.formatString(mLevel, string2, string3, string4, objectArray, throwable));
        }

        private String formatString(MLevel mLevel, String string2, String string3, String string4, Object[] objectArray, Throwable throwable) {
            boolean bl = string3 != null && !string3.endsWith(")");
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(mLevel.getLineHeader());
            stringBuffer.append(' ');
            if (string2 != null && string3 != null) {
                stringBuffer.append('[');
                stringBuffer.append(string2);
                stringBuffer.append('.');
                stringBuffer.append(string3);
                if (bl) {
                    stringBuffer.append("()");
                }
                stringBuffer.append(']');
            } else if (string2 != null) {
                stringBuffer.append('[');
                stringBuffer.append(string2);
                stringBuffer.append(']');
            } else if (string3 != null) {
                stringBuffer.append('[');
                stringBuffer.append(string3);
                if (bl) {
                    stringBuffer.append("()");
                }
                stringBuffer.append(']');
            }
            if (string4 == null) {
                if (objectArray != null) {
                    stringBuffer.append("params: ");
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        if (i != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(objectArray[i]);
                    }
                }
            } else if (objectArray == null) {
                stringBuffer.append(string4);
            } else {
                MessageFormat messageFormat = new MessageFormat(string4);
                stringBuffer.append(messageFormat.format(objectArray));
            }
            if (throwable != null) {
                stringBuffer.append(SEP);
                stringBuffer.append(ThrowableUtils.extractStackTrace(throwable));
            }
            return stringBuffer.toString();
        }

        @Override
        public ResourceBundle getResourceBundle() {
            return null;
        }

        @Override
        public String getResourceBundleName() {
            return null;
        }

        @Override
        public void setFilter(Object object) throws SecurityException {
            this.warning("Using FallbackMLog -- Filters not supported!");
        }

        @Override
        public Object getFilter() {
            return null;
        }

        @Override
        public void log(MLevel mLevel, String string2) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, null, null, string2, null, null);
            }
        }

        @Override
        public void log(MLevel mLevel, String string2, Object object) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, null, null, string2, new Object[]{object}, null);
            }
        }

        @Override
        public void log(MLevel mLevel, String string2, Object[] objectArray) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, null, null, string2, objectArray, null);
            }
        }

        @Override
        public void log(MLevel mLevel, String string2, Throwable throwable) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, null, null, string2, null, throwable);
            }
        }

        @Override
        public void logp(MLevel mLevel, String string2, String string3, String string4) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, string2, string3, string4, null, null);
            }
        }

        @Override
        public void logp(MLevel mLevel, String string2, String string3, String string4, Object object) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, string2, string3, string4, new Object[]{object}, null);
            }
        }

        @Override
        public void logp(MLevel mLevel, String string2, String string3, String string4, Object[] objectArray) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, string2, string3, string4, objectArray, null);
            }
        }

        @Override
        public void logp(MLevel mLevel, String string2, String string3, String string4, Throwable throwable) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, string2, string3, string4, null, throwable);
            }
        }

        @Override
        public void logrb(MLevel mLevel, String string2, String string3, String string4, String string5) {
            if (this.isLoggable(mLevel)) {
                this.formatrb(mLevel, string2, string3, string4, string5, null, null);
            }
        }

        @Override
        public void logrb(MLevel mLevel, String string2, String string3, String string4, String string5, Object object) {
            if (this.isLoggable(mLevel)) {
                this.formatrb(mLevel, string2, string3, string4, string5, new Object[]{object}, null);
            }
        }

        @Override
        public void logrb(MLevel mLevel, String string2, String string3, String string4, String string5, Object[] objectArray) {
            if (this.isLoggable(mLevel)) {
                this.formatrb(mLevel, string2, string3, string4, string5, objectArray, null);
            }
        }

        @Override
        public void logrb(MLevel mLevel, String string2, String string3, String string4, String string5, Throwable throwable) {
            if (this.isLoggable(mLevel)) {
                this.formatrb(mLevel, string2, string3, string4, string5, null, throwable);
            }
        }

        @Override
        public void entering(String string2, String string3) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, string2, string3, "Entering method.", null, null);
            }
        }

        @Override
        public void entering(String string2, String string3, Object object) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, string2, string3, "Entering method with argument " + object, null, null);
            }
        }

        @Override
        public void entering(String string2, String string3, Object[] objectArray) {
            if (this.isLoggable(MLevel.FINER)) {
                if (objectArray == null) {
                    this.entering(string2, string3);
                } else {
                    StringBuffer stringBuffer = new StringBuffer(128);
                    stringBuffer.append("( ");
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        if (i != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(objectArray[i]);
                    }
                    stringBuffer.append(" )");
                    this.format(MLevel.FINER, string2, string3, "Entering method with arguments " + stringBuffer.toString(), null, null);
                }
            }
        }

        @Override
        public void exiting(String string2, String string3) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, string2, string3, "Exiting method.", null, null);
            }
        }

        @Override
        public void exiting(String string2, String string3, Object object) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, string2, string3, "Exiting method with result " + object, null, null);
            }
        }

        @Override
        public void throwing(String string2, String string3, Throwable throwable) {
            if (this.isLoggable(MLevel.FINE)) {
                this.format(MLevel.FINE, string2, string3, "Throwing exception.", null, throwable);
            }
        }

        @Override
        public void severe(String string2) {
            if (this.isLoggable(MLevel.SEVERE)) {
                this.format(MLevel.SEVERE, null, null, string2, null, null);
            }
        }

        @Override
        public void warning(String string2) {
            if (this.isLoggable(MLevel.WARNING)) {
                this.format(MLevel.WARNING, null, null, string2, null, null);
            }
        }

        @Override
        public void info(String string2) {
            if (this.isLoggable(MLevel.INFO)) {
                this.format(MLevel.INFO, null, null, string2, null, null);
            }
        }

        @Override
        public void config(String string2) {
            if (this.isLoggable(MLevel.CONFIG)) {
                this.format(MLevel.CONFIG, null, null, string2, null, null);
            }
        }

        @Override
        public void fine(String string2) {
            if (this.isLoggable(MLevel.FINE)) {
                this.format(MLevel.FINE, null, null, string2, null, null);
            }
        }

        @Override
        public void finer(String string2) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, null, null, string2, null, null);
            }
        }

        @Override
        public void finest(String string2) {
            if (this.isLoggable(MLevel.FINEST)) {
                this.format(MLevel.FINEST, null, null, string2, null, null);
            }
        }

        @Override
        public void setLevel(MLevel mLevel) throws SecurityException {
            this.cutoffLevel = mLevel;
        }

        @Override
        public synchronized MLevel getLevel() {
            return this.cutoffLevel;
        }

        @Override
        public synchronized boolean isLoggable(MLevel mLevel) {
            return mLevel.intValue() >= this.cutoffLevel.intValue();
        }

        @Override
        public String getName() {
            return "global";
        }

        @Override
        public void addHandler(Object object) throws SecurityException {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        @Override
        public void removeHandler(Object object) throws SecurityException {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        @Override
        public Object[] getHandlers() {
            this.warning("Using FallbackMLog -- Handlers not supported.");
            return new Object[0];
        }

        @Override
        public void setUseParentHandlers(boolean bl) {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        @Override
        public boolean getUseParentHandlers() {
            return false;
        }
    }
}

