/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Comparator;

public final class BeangenUtils {
    public static final Comparator PROPERTY_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            Property property = (Property)object;
            Property property2 = (Property)object2;
            return String.CASE_INSENSITIVE_ORDER.compare(property.getName(), property2.getName());
        }
    };

    public static String capitalize(String string2) {
        char c = string2.charAt(0);
        return Character.toUpperCase(c) + string2.substring(1);
    }

    public static void writeExplicitDefaultConstructor(int n, ClassInfo classInfo, IndentedWriter indentedWriter) throws IOException {
        indentedWriter.print(CodegenUtils.getModifierString(n));
        indentedWriter.println(' ' + classInfo.getClassName() + "()");
        indentedWriter.println("{}");
    }

    public static void writeArgList(Property[] propertyArray, boolean bl, IndentedWriter indentedWriter) throws IOException {
        int n = propertyArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                indentedWriter.print(", ");
            }
            if (bl) {
                indentedWriter.print(propertyArray[i].getSimpleTypeName() + ' ');
            }
            indentedWriter.print(propertyArray[i].getName());
        }
    }

    public static void writePropertyMember(Property property, IndentedWriter indentedWriter) throws IOException {
        BeangenUtils.writePropertyVariable(property, indentedWriter);
    }

    public static void writePropertyVariable(Property property, IndentedWriter indentedWriter) throws IOException {
        BeangenUtils.writePropertyVariable(property, property.getDefaultValueExpression(), indentedWriter);
    }

    public static void writePropertyMember(Property property, String string2, IndentedWriter indentedWriter) throws IOException {
        BeangenUtils.writePropertyVariable(property, string2, indentedWriter);
    }

    public static void writePropertyVariable(Property property, String string2, IndentedWriter indentedWriter) throws IOException {
        indentedWriter.print(CodegenUtils.getModifierString(property.getVariableModifiers()));
        indentedWriter.print(' ' + property.getSimpleTypeName() + ' ' + property.getName());
        String string3 = string2;
        if (string3 != null) {
            indentedWriter.print(" = " + string3);
        }
        indentedWriter.println(';');
    }

    public static void writePropertyGetter(Property property, IndentedWriter indentedWriter) throws IOException {
        BeangenUtils.writePropertyGetter(property, property.getDefensiveCopyExpression(), indentedWriter);
    }

    public static void writePropertyGetter(Property property, String string2, IndentedWriter indentedWriter) throws IOException {
        String string3 = "boolean".equals(property.getSimpleTypeName()) ? "is" : "get";
        indentedWriter.print(CodegenUtils.getModifierString(property.getGetterModifiers()));
        indentedWriter.println(' ' + property.getSimpleTypeName() + ' ' + string3 + BeangenUtils.capitalize(property.getName()) + "()");
        String string4 = string2;
        if (string4 == null) {
            string4 = property.getName();
        }
        indentedWriter.println("{ return " + string4 + "; }");
    }

    public static void writePropertySetter(Property property, IndentedWriter indentedWriter) throws IOException {
        BeangenUtils.writePropertySetter(property, property.getDefensiveCopyExpression(), indentedWriter);
    }

    public static void writePropertySetter(Property property, String string2, IndentedWriter indentedWriter) throws IOException {
        String string3 = string2;
        if (string3 == null) {
            string3 = property.getName();
        }
        String string4 = "this." + property.getName();
        String string5 = "this." + property.getName() + " = " + string3 + ';';
        BeangenUtils.writePropertySetterWithGetExpressionSetStatement(property, string4, string5, indentedWriter);
    }

    public static void writePropertySetterWithGetExpressionSetStatement(Property property, String string2, String string3, IndentedWriter indentedWriter) throws IOException {
        indentedWriter.print(CodegenUtils.getModifierString(property.getSetterModifiers()));
        indentedWriter.print(" void set" + BeangenUtils.capitalize(property.getName()) + "( " + property.getSimpleTypeName() + ' ' + property.getName() + " )");
        if (property.isConstrained()) {
            indentedWriter.println(" throws PropertyVetoException");
        } else {
            indentedWriter.println();
        }
        indentedWriter.println('{');
        indentedWriter.upIndent();
        if (BeangenUtils.changeMarked(property)) {
            String string4;
            indentedWriter.println(property.getSimpleTypeName() + " oldVal = " + string2 + ';');
            String string5 = "oldVal";
            String string6 = property.getName();
            String string7 = property.getSimpleTypeName();
            if (ClassUtils.isPrimitive(string7)) {
                Class clazz = ClassUtils.classForPrimitive(string7);
                if (clazz == Byte.TYPE) {
                    string5 = "new Byte( " + string5 + " )";
                    string6 = "new Byte( " + string6 + " )";
                } else if (clazz == Character.TYPE) {
                    string5 = "new Character( " + string5 + " )";
                    string6 = "new Character( " + string6 + " )";
                } else if (clazz == Short.TYPE) {
                    string5 = "new Short( " + string5 + " )";
                    string6 = "new Short( " + string6 + " )";
                } else if (clazz == Float.TYPE) {
                    string5 = "new Float( " + string5 + " )";
                    string6 = "new Float( " + string6 + " )";
                } else if (clazz == Double.TYPE) {
                    string5 = "new Double( " + string5 + " )";
                    string6 = "new Double( " + string6 + " )";
                }
                string4 = "oldVal != " + property.getName();
            } else {
                string4 = "! eqOrBothNull( oldVal, " + property.getName() + " )";
            }
            if (property.isConstrained()) {
                indentedWriter.println("if ( " + string4 + " )");
                indentedWriter.upIndent();
                indentedWriter.println("vcs.fireVetoableChange( \"" + property.getName() + "\", " + string5 + ", " + string6 + " );");
                indentedWriter.downIndent();
            }
            indentedWriter.println(string3);
            if (property.isBound()) {
                indentedWriter.println("if ( " + string4 + " )");
                indentedWriter.upIndent();
                indentedWriter.println("pcs.firePropertyChange( \"" + property.getName() + "\", " + string5 + ", " + string6 + " );");
                indentedWriter.downIndent();
            }
        } else {
            indentedWriter.println(string3);
        }
        indentedWriter.downIndent();
        indentedWriter.println('}');
    }

    public static boolean hasBoundProperties(Property[] propertyArray) {
        int n = propertyArray.length;
        for (int i = 0; i < n; ++i) {
            if (!propertyArray[i].isBound()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConstrainedProperties(Property[] propertyArray) {
        int n = propertyArray.length;
        for (int i = 0; i < n; ++i) {
            if (!propertyArray[i].isConstrained()) continue;
            return true;
        }
        return false;
    }

    private static boolean changeMarked(Property property) {
        return property.isBound() || property.isConstrained();
    }

    private BeangenUtils() {
    }
}

